import { Grant, IGrantable } from '@aws-cdk/aws-iam';
import { ISecret } from '@aws-cdk/aws-secretsmanager';
import { IParameter } from '@aws-cdk/aws-ssm';
import { KeyType } from './key-type';
export declare abstract class SecretKey {
    readonly secretKeyType: KeyType;
    static fromPlainText(value: string): SecretKey;
    static fromSSMParameter(secretKeyParameter: IParameter): SecretKey;
    static fromSecretsManager(secretKeySecret: ISecret, fieldName?: string): SecretKey;
    constructor(secretKeyType: KeyType);
    abstract grantRead?(grantee: IGrantable): Grant;
    abstract serialize(): string;
}
