import os
from unittest import TestCase

from pykotor.common.stream import BinaryReader

from pykotor.extract.capsule import Capsule
from pykotor.resource.formats.tpc import load_tpc, write_tpc

from pykotor.resource.type import ResourceType, FileFormat

from pykotor.extract.installation import Installation
from pykotor.tools import model


class TestInstallation(TestCase):
    def setUp(self) -> None:
        self.path = os.environ.get('K1_PATH')
        self.installation = Installation(self.path)

    def test_other(self):
        path = "C:/Users/hugin/Desktop/ext/clone/hoth01_01a.mdl"
        data = BinaryReader.load_file(path)
        data2 = model.rename(data, "WOLOLOOLOLOLOLOLOOLOLOLO")
        print(data2)

    def test_resource(self):
        # testing capsules param
        path, res = self.installation.resource("m13aa", ResourceType.ARE, capsules=[Capsule(self.path + "modules/danm13.rim")], skip_modules=True)
        self.assertIsNotNone(res)

        # testing installation modules
        path, res = self.installation.resource("m01aa", ResourceType.ARE, skip_chitin=True, skip_override=True)
        self.assertIsNotNone(res)
        path, res = self.installation.resource("m13aa", ResourceType.ARE, skip_modules=True)
        self.assertIsNone(res)

        # testing folders param
        path, res = self.installation.resource("biowarelogo", ResourceType.TGA, folders=["C:/Users/hugin/Desktop/ext"])
        self.assertIsNotNone(res)
        path, res = self.installation.resource("biowarelogo", ResourceType.TGA)
        self.assertIsNone(res)

        # testing chitin
        path, res = self.installation.resource("nwscript", ResourceType.NSS, skip_override=True, skip_modules=True)
        self.assertIsNotNone(res)

        # testing installation override
        path, res = self.installation.resource("nwscript", ResourceType.NSS, skip_chitin=True, skip_modules=True)

    def test_locate(self):
        print(self.installation.locate("nwscript", ResourceType.NSS))
        print(self.installation.locate("m13aa", ResourceType.ARE))
        print(self.installation.locate("c_bantha", ResourceType.UTC, folders=["C:/Users/hugin/Desktop/ext"]))
        print(self.installation.locate("C_Gammorean01", ResourceType.TPC))
        #print(self.installation.locate("new", ResourceType.GFF, capsules=[Capsule("C:/Users/hugin/Desktop/ext/blank.erf")]))

