import sys
from typing import Mapping, List

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal

_Keys = Literal[
    'MultiMolecule', 'FrozenSettings', 'PRMContainer', 'PSFContainer', 'MonteCarloABC', 'ARMC',
    'PackageManagerABC', 'PackageManager', 'PhiUpdaterABC', 'PhiUpdater', 'ParamMappingABC',
    'ParamMapping', 'PathLike', 'KFReader', 'Job', 'SingleJob', 'Settings', 'Molecule',
    'Results', 'Figure', 'File', 'NDFrame', 'Result', 'Package', 'Registry', 'PromisedObject'
]

__all__: List[str] = ...
TYPE_ALIAS: Mapping[_Keys, str] = ...

MultiMolecule: str = ...
FrozenSettings: str = ...
PRMContainer: str = ...
PSFContainer: str = ...
MonteCarloABC: str = ...
ARMC: str = ...
PackageManagerABC: str = ...
PackageManager: str = ...
PhiUpdaterABC: str = ...
PhiUpdater: str = ...
ParamMappingABC: str = ...
ParamMapping: str = ...
PathLike: str = ...
KFReader: str = ...
Job: str = ...
SingleJob: str = ...
Settings: str = ...
Molecule: str = ...
Results: str = ...
Figure: str = ...
File: str = ...
NDFrame: str = ...
Result: str = ...
Package: str = ...
Registry: str = ...
PromisedObject: str = ...
