import { Eslint, EslintOptions } from './eslint';
import { NodeProject, NodeProjectOptions } from './node-project';
import { Task } from './tasks';
import { TypescriptConfig, TypescriptConfigOptions } from './typescript-config';
import { ProjenrcOptions as ProjenrcTsOptions } from './typescript/projenrc';
/**
 * @experimental
 */
export interface TypeScriptProjectOptions extends NodeProjectOptions {
    /**
     * (experimental) Typescript  artifacts output directory.
     *
     * @default "lib"
     * @experimental
     */
    readonly libdir?: string;
    /**
     * (experimental) Typescript sources directory.
     *
     * @default "src"
     * @experimental
     */
    readonly srcdir?: string;
    /**
     * (experimental) Jest tests directory. Tests files should be named `xxx.test.ts`.
     *
     * If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
     * then tests are going to be compiled into `lib/` and executed as javascript.
     * If the test directory is outside of `src`, then we configure jest to
     * compile the code in-memory.
     *
     * @default "test"
     * @experimental
     */
    readonly testdir?: string;
    /**
     * (experimental) Setup eslint.
     *
     * @default true
     * @experimental
     */
    readonly eslint?: boolean;
    /**
     * (experimental) Eslint options.
     *
     * @default - opinionated default options
     * @experimental
     */
    readonly eslintOptions?: EslintOptions;
    /**
     * (experimental) TypeScript version to use.
     *
     * NOTE: Typescript is not semantically versioned and should remain on the
     * same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).
     *
     * @default "latest"
     * @experimental
     */
    readonly typescriptVersion?: string;
    /**
     * (experimental) Docgen by Typedoc.
     *
     * @default false
     * @experimental
     */
    readonly docgen?: boolean;
    /**
     * (experimental) Docs directory.
     *
     * @default "docs"
     * @experimental
     */
    readonly docsDirectory?: string;
    /**
     * (experimental) Custom TSConfig.
     *
     * @experimental
     */
    readonly tsconfig?: TypescriptConfigOptions;
    /**
     * (experimental) Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).
     *
     * @default false
     * @experimental
     */
    readonly disableTsconfig?: boolean;
    /**
     * (experimental) Compile the code before running tests.
     *
     * @default - if `testdir` is under `src/**`, the default is `true`, otherwise the default is `false.
     * @experimental
     */
    readonly compileBeforeTest?: boolean;
    /**
     * (experimental) Generate one-time sample in `src/` and `test/` if there are no files there.
     *
     * @default true
     * @experimental
     */
    readonly sampleCode?: boolean;
    /**
     * (experimental) The .d.ts file that includes the type declarations for this module.
     *
     * @default - .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)
     * @experimental
     */
    readonly entrypointTypes?: string;
    /**
     * (experimental) Defines a `yarn package` command that will produce a tarball and place it under `dist/js`.
     *
     * @default true
     * @experimental
     */
    readonly package?: boolean;
    /**
     * (experimental) Use TypeScript for your projenrc file (`.projenrc.ts`).
     *
     * @default false
     * @experimental
     */
    readonly projenrcTs?: boolean;
    /**
     * (experimental) Options for .projenrc.ts.
     *
     * @experimental
     */
    readonly projenrcTsOptions?: ProjenrcTsOptions;
}
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
export declare class TypeScriptProject extends NodeProject {
    /**
     * @experimental
     */
    readonly docgen?: boolean;
    /**
     * @experimental
     */
    readonly docsDirectory: string;
    /**
     * @experimental
     */
    readonly eslint?: Eslint;
    /**
     * @experimental
     */
    readonly tsconfigEslint?: TypescriptConfig;
    /**
     * @experimental
     */
    readonly tsconfig?: TypescriptConfig;
    /**
     * (experimental) The directory in which the .ts sources reside.
     *
     * @experimental
     */
    readonly srcdir: string;
    /**
     * (experimental) The directory in which compiled .js files reside.
     *
     * @experimental
     */
    readonly libdir: string;
    /**
     * (experimental) The directory in which tests reside.
     *
     * @experimental
     */
    readonly testdir: string;
    /**
     * (experimental) The "watch" task.
     *
     * @experimental
     */
    readonly watchTask: Task;
    /**
     * (experimental) The "package" task (or undefined if `package` is set to `false`).
     *
     * @experimental
     */
    readonly packageTask?: Task;
    /**
     * @experimental
     */
    constructor(options: TypeScriptProjectOptions);
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
export declare class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options: TypeScriptProjectOptions);
}
/**
 * @deprecated use `TypeScriptProject`
 */
export declare class TypeScriptLibraryProject extends TypeScriptProject {
}
/**
 * @deprecated use TypeScriptProjectOptions
 */
export interface TypeScriptLibraryProjectOptions extends TypeScriptProjectOptions {
}
/**
 * @internal
 */
export declare function mergeTsconfigOptions(options: (TypescriptConfigOptions | undefined)[]): TypescriptConfigOptions;
