"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.printStartMenu = exports.showStartMenu = void 0;
const chalk = require("chalk");
const inquirer = require("inquirer");
const tasks_1 = require("../../tasks");
const EXIT_MARKER = '$exit';
async function showStartMenu(tasks) {
    const { command } = await inquirer.prompt([
        {
            type: 'list',
            name: 'command',
            message: 'Scripts:',
            choices: renderChoices(tasks),
            pageSize: 100,
            loop: false,
        },
    ]);
    if (command === EXIT_MARKER) {
        return;
    }
    tasks.runTask(command);
}
exports.showStartMenu = showStartMenu;
function printStartMenu(tasks, root) {
    if (root && root !== '.') {
        console.error(chalk.cyanBright.bold(`Project: ${root}`));
    }
    console.error(chalk.cyanBright.underline('Commands:'));
    for (const entry of renderChoices(tasks)) {
        if (entry.type === 'separator') {
            console.error(entry.line);
        }
        else if (entry.name && entry.value !== '$exit') {
            console.error(entry.name);
        }
    }
}
exports.printStartMenu = printStartMenu;
function renderChoices(tasksrt) {
    var _a, _b;
    const tasks = tasksrt.tasks;
    const taskNames = tasks.map(t => t.name);
    const result = new Array();
    let category;
    const width = Math.max(...taskNames.map(k => k.length));
    for (const task of tasks.sort(sortByPriority)) {
        const cat = (_a = task.category) !== null && _a !== void 0 ? _a : tasks_1.TaskCategory.MISC;
        if (cat !== category) {
            result.push(new inquirer.Separator('  '));
            result.push(new inquirer.Separator(headingForCategory(cat)));
        }
        category = cat;
        result.push({
            name: `${task.name.padEnd(width)}   ${(_b = task.description) !== null && _b !== void 0 ? _b : ''}`,
            value: task.name,
            short: task.description,
        });
    }
    result.push(new inquirer.Separator('  '));
    result.push({
        name: 'EXIT',
        value: EXIT_MARKER,
    });
    return result;
}
function headingForCategory(category) {
    switch (category) {
        case tasks_1.TaskCategory.BUILD: return 'BUILD';
        case tasks_1.TaskCategory.TEST: return 'TEST';
        case tasks_1.TaskCategory.RELEASE: return 'RELEASE';
        case tasks_1.TaskCategory.MAINTAIN: return 'MAINTAIN';
        case tasks_1.TaskCategory.MISC:
        default:
            return 'MISC';
    }
}
function sortByPriority(e1, e2) {
    var _a, _b;
    const p1 = (_a = e1.category) !== null && _a !== void 0 ? _a : tasks_1.TaskCategory.MISC;
    const p2 = (_b = e2.category) !== null && _b !== void 0 ? _b : tasks_1.TaskCategory.MISC;
    if (p1 > p2)
        return 1;
    if (p1 < p2)
        return -1;
    return 0;
}
//# sourceMappingURL=data:application/json;base64,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