from setuptools import find_packages, setup

setup(
    name="django-email-bandit",
    version=__import__("bandit").__version__,
    author="Caktus Consulting Group",
    author_email="solutions@caktusgroup.com",
    packages=find_packages(),
    include_package_data=True,
    url="https://github.com/caktus/django-email-bandit",
    license="BSD",
    description=" ".join(__import__("bandit").__doc__.splitlines()).strip(),
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: Web Environment",
        "Framework :: Django",
        "Framework :: Django :: 2.2",
        "Framework :: Django :: 3.0",
        "Framework :: Django :: 3.1",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Internet :: WWW/HTTP :: Dynamic Content",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    long_description=open("README.rst").read(),
    test_suite="runtests.runtests",
    zip_safe=False,
)
