#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['KEGGDecoder']

package_data = \
{'': ['*'],
 'KEGGDecoder': ['Amphibactin/*',
                 'DMSPLyase/*',
                 'DMSPSynthase/*',
                 'DesferrioxamineBiosynthesis/*',
                 'HMM_Models/*',
                 'HMM_Models/PreviousExpanderDB_versions/*',
                 'MethylphosphonateSynthase/*',
                 'PreviousKEGGDecoderVersions/*',
                 'images/*']}

install_requires = \
['matplotlib==3.0.3',
 'seaborn==0.9.0',
 'pandas==0.25.2',
 'numpy==1.17.3',
 'plotly==4.2.1',
 'tanglegram==0.1.0',
 'biopython==1.74',
 'scipy==1.3.1']

entry_points = \
{'console_scripts': ['KEGG-decoder = KEGGDecoder.KEGG_decoder:main']}

setup(name='KEGGDecoder',
      version='1.2.2',
      description='Designed to parse through a blastKoala or ghostKoala output to determine',
      author='Benjamin Tully',
      author_email='tully.bj@gmail.com',
      url='https://github.com/bjtully/BioData/KEGGDecoder',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      entry_points=entry_points,
     )
