"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const assertions_1 = require("./assertions");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.assert = new assertions_1.DeployAssert(this);
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: core_1.Stack.of(this.assert).artifactId,
            stacks: props.stacks.map(s => s.artifactId),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests.IntegTestCase", version: "1.157.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assert = new assertions_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests.IntegTestCaseStack", version: "1.157.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
        });
        this.assert = defaultTestCase.assert;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
    }
    onPrepare() {
        core_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases);
                synthesizer.synthesize(session);
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests.IntegTest", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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