import { IntegManifest, TestOptions } from '@aws-cdk/cloud-assembly-schema';
import { Stack, StackProps } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { DeployAssert } from './assertions';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Properties of an integration test case
 */
export interface IntegTestCaseProps extends TestOptions {
    /**
     * Stacks to be deployed during the test
     */
    readonly stacks: Stack[];
}
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
export declare class IntegTestCase extends CoreConstruct {
    private readonly props;
    /**
     * Make assertions on resources in this test case
     */
    readonly assert: DeployAssert;
    constructor(scope: Construct, id: string, props: IntegTestCaseProps);
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest(): IntegManifest;
    private toTestCase;
}
/**
 * Properties of an integration test case stack
 */
export interface IntegTestCaseStackProps extends TestOptions, StackProps {
}
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
export declare class IntegTestCaseStack extends Stack {
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x: any): x is IntegTestCaseStack;
    /**
     * Make assertions on resources in this test case
     */
    readonly assert: DeployAssert;
    /**
     * The underlying IntegTestCase that is created
     * @internal
     */
    readonly _testCase: IntegTestCase;
    constructor(scope: Construct, id: string, props?: IntegTestCaseStackProps);
}
/**
 * Integration test properties
 */
export interface IntegTestProps extends TestOptions {
    /**
     * List of test cases that make up this test
     */
    readonly testCases: Stack[];
}
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
export declare class IntegTest extends CoreConstruct {
    /**
     * Make assertions on resources in this test case
     */
    readonly assert: DeployAssert;
    private readonly testCases;
    constructor(scope: Construct, id: string, props: IntegTestProps);
    protected onPrepare(): void;
}
