"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeFunction = exports.InvocationType = exports.LogType = exports.AwsApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const assertions_1 = require("./assertions");
const common_1 = require("./common");
const providers_1 = require("./providers");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that creates a custom resource that will perform
 * a query using the AWS SDK
 */
class AwsApiCall extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.flattenResponse = 'false';
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_AwsApiCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.provider = new providers_1.AssertionsProvider(this, 'SdkProvider');
        this.provider.addPolicyStatementFromSdkCall(props.service, props.api);
        this.name = `${props.service}${props.api}`;
        this.sdkCallResource = new core_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                service: props.service,
                api: props.api,
                parameters: this.provider.encode(props.parameters),
                flattenResponse: core_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.SDK_RESOURCE_TYPE_PREFIX}${this.name}`,
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.sdkCallResource.node.addDependency(this.provider);
    }
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName) {
        this.flattenResponse = 'true';
        return this.sdkCallResource.getAtt(`apiCallResponse.${attributeName}`);
    }
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName) {
        this.flattenResponse = 'true';
        return this.sdkCallResource.getAttString(`apiCallResponse.${attributeName}`);
    }
    /**
     * Assert that the ExpectedResult is equal
     * to the result of the AwsApiCall
     *
     * @example
     * declare const assert: DeployAssert;
     * const invoke = new LambdaInvokeFunction(assert, 'Invoke', {
     *   functionName: 'my-func',
     * });
     * invoke.assert(ExpectedResult.objectLike({ Payload: 'OK' }));
     */
    assert(expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assert);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromCustomResource(this.sdkCallResource, 'apiCallResponse'),
        });
    }
    /**
     * Assert that the ExpectedResult is equal
     * to the result of the AwsApiCall at the given path.
     *
     * For example the SQS.receiveMessage api response would look
     * like:
     *
     * If you wanted to assert the value of `Body` you could do
     *
     * @example
     * const actual = {
     *   Messages: [{
     *     MessageId: '',
     *     ReceiptHandle: '',
     *     MD5OfBody: '',
     *     Body: 'hello',
     *     Attributes: {},
     *     MD5OfMessageAttributes: {},
     *     MessageAttributes: {}
     *   }]
     * };
     *
     *
     * declare const assert: DeployAssert;
     * const message = new AwsApiCall(assert, 'ReceiveMessage', {
     *   service:  'SQS',
     *   api: 'receiveMessage'
     * });
     *
     * message.assertAtPath('Messages.0.Body', ExpectedResult.stringLikeRegexp('hello'));
     */
    assertAtPath(path, expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `AssertEquals${this.name}`, {
            expected,
            actual: common_1.ActualResult.fromAwsApiCall(this, path),
        });
    }
}
exports.AwsApiCall = AwsApiCall;
_a = JSII_RTTI_SYMBOL_1;
AwsApiCall[_a] = { fqn: "@aws-cdk/integ-tests.AwsApiCall", version: "1.157.0" };
/**
 * Set to Tail to include the execution log in the response.
 * Applies to synchronously invoked functions only.
 */
var LogType;
(function (LogType) {
    /**
     * The log messages are not returned in the response
     */
    LogType["NONE"] = "None";
    /**
     * The log messages are returned in the response
     */
    LogType["TAIL"] = "Tail";
})(LogType = exports.LogType || (exports.LogType = {}));
/**
 * The type of invocation. Default is REQUEST_RESPONE
 */
var InvocationType;
(function (InvocationType) {
    /**
     * Invoke the function asynchronously.
     * Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    InvocationType["EVENT"] = "Event";
    /**
     * Invoke the function synchronously.
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    InvocationType["REQUEST_RESPONE"] = "RequestResponse";
    /**
     * Validate parameter values and verify that the user
     * or role has permission to invoke the function.
     */
    InvocationType["DRY_RUN"] = "DryRun";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
/**
 * An AWS Lambda Invoke function API call.
 * Use this istead of the generic AwsApiCall in order to
 * invoke a lambda function. This will automatically create
 * the correct permissions to invoke the function
 */
class LambdaInvokeFunction extends AwsApiCall {
    constructor(scope, id, props) {
        super(scope, id, {
            api: 'invoke',
            service: 'Lambda',
            parameters: {
                FunctionName: props.functionName,
                InvocationType: props.invocationType,
                LogType: props.logType,
                Payload: props.payload,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_LambdaInvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        // need to give the assertion lambda permission to invoke
        new core_1.CfnResource(this, 'Invoke', {
            type: 'AWS::Lambda::Permission',
            properties: {
                Action: 'lambda:InvokeFunction',
                FunctionName: props.functionName,
                Principal: this.provider.handlerRoleArn,
            },
        });
        // the api call is 'invoke', but the permission is 'invokeFunction'
        // so need to handle it specially
        this.provider.addPolicyStatementFromSdkCall('Lambda', 'invokeFunction', [stack.formatArn({
                service: 'lambda',
                resource: 'function',
                arnFormat: core_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: props.functionName,
            })]);
    }
}
exports.LambdaInvokeFunction = LambdaInvokeFunction;
_b = JSII_RTTI_SYMBOL_1;
LambdaInvokeFunction[_b] = { fqn: "@aws-cdk/integ-tests.LambdaInvokeFunction", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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