"use strict";
// This file contains the input and output types for the providers.
// Kept in a separate file for sharing between the handler and the provider constructs.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.AssertionType = exports.SDK_RESOURCE_TYPE_PREFIX = exports.RESULTS_RESOURCE_TYPE = exports.ASSERT_RESOURCE_TYPE = void 0;
exports.ASSERT_RESOURCE_TYPE = 'Custom::DeployAssert@AssertEquals';
exports.RESULTS_RESOURCE_TYPE = 'Custom::DeployAssert@ResultsCollection';
exports.SDK_RESOURCE_TYPE_PREFIX = 'Custom::DeployAssert@SdkCall';
/**
 * The type of assertion to perform
 */
var AssertionType;
(function (AssertionType) {
    /**
     * Assert that two values are equal
     */
    AssertionType["EQUALS"] = "equals";
    /**
     * The keys and their values must be present in the target but the target
     * can be a superset.
     */
    AssertionType["OBJECT_LIKE"] = "objectLike";
    /**
     * Matches the specified pattern with the array
     * The set of elements must be in the same order as would be found
     */
    AssertionType["ARRAY_WITH"] = "arrayWith";
})(AssertionType = exports.AssertionType || (exports.AssertionType = {}));
/**
 * The status of the assertion
 */
var Status;
(function (Status) {
    /**
     * The assertion passed
     */
    Status["PASS"] = "pass";
    /**
     * The assertion failed
     */
    Status["FAIL"] = "fail";
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0eXBlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsbUVBQW1FO0FBQ25FLHVGQUF1Rjs7O0FBRTFFLFFBQUEsb0JBQW9CLEdBQUcsbUNBQW1DLENBQUM7QUFDM0QsUUFBQSxxQkFBcUIsR0FBRyx3Q0FBd0MsQ0FBQztBQUNqRSxRQUFBLHdCQUF3QixHQUFHLDhCQUE4QixDQUFDO0FBb0R2RTs7R0FFRztBQUNILElBQVksYUFpQlg7QUFqQkQsV0FBWSxhQUFhO0lBQ3ZCOztPQUVHO0lBQ0gsa0NBQWlCLENBQUE7SUFFakI7OztPQUdHO0lBQ0gsMkNBQTBCLENBQUE7SUFFMUI7OztPQUdHO0lBQ0gseUNBQXdCLENBQUE7QUFDMUIsQ0FBQyxFQWpCVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQWlCeEI7QUErQ0Q7O0dBRUc7QUFDSCxJQUFZLE1BVVg7QUFWRCxXQUFZLE1BQU07SUFDaEI7O09BRUc7SUFDSCx1QkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCx1QkFBYSxDQUFBO0FBQ2YsQ0FBQyxFQVZXLE1BQU0sR0FBTixjQUFNLEtBQU4sY0FBTSxRQVVqQiIsInNvdXJjZXNDb250ZW50IjpbIi8vIFRoaXMgZmlsZSBjb250YWlucyB0aGUgaW5wdXQgYW5kIG91dHB1dCB0eXBlcyBmb3IgdGhlIHByb3ZpZGVycy5cbi8vIEtlcHQgaW4gYSBzZXBhcmF0ZSBmaWxlIGZvciBzaGFyaW5nIGJldHdlZW4gdGhlIGhhbmRsZXIgYW5kIHRoZSBwcm92aWRlciBjb25zdHJ1Y3RzLlxuXG5leHBvcnQgY29uc3QgQVNTRVJUX1JFU09VUkNFX1RZUEUgPSAnQ3VzdG9tOjpEZXBsb3lBc3NlcnRAQXNzZXJ0RXF1YWxzJztcbmV4cG9ydCBjb25zdCBSRVNVTFRTX1JFU09VUkNFX1RZUEUgPSAnQ3VzdG9tOjpEZXBsb3lBc3NlcnRAUmVzdWx0c0NvbGxlY3Rpb24nO1xuZXhwb3J0IGNvbnN0IFNES19SRVNPVVJDRV9UWVBFX1BSRUZJWCA9ICdDdXN0b206OkRlcGxveUFzc2VydEBTZGtDYWxsJztcblxuLyoqXG4gKiBBIEFXUyBKYXZhU2NyaXB0IFNESyBWMiByZXF1ZXN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXdzQXBpQ2FsbFJlcXVlc3Qge1xuICAvKipcbiAgICogVGhlIEFXUyBzZXJ2aWNlIGkuZS4gUzNcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2U6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFXUyBhcGkgY2FsbCB0byBtYWtlIGkuZS4gZ2V0QnVja2V0TGlmZWN5Y2xlXG4gICAqL1xuICByZWFkb25seSBhcGk6IHN0cmluZztcblxuICAvKipcbiAgICogQW55IHBhcmFtZXRlcnMgdG8gcGFzcyB0byB0aGUgYXBpIGNhbGxcbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBwYXJhbWV0ZXJzXG4gICAqL1xuICByZWFkb25seSBwYXJhbWV0ZXJzPzogYW55O1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIG9yIG5vdCB0byBmbGF0dGVuIHRoZSByZXNwb25zZSBmcm9tIHRoZSBhcGkgY2FsbFxuICAgKlxuICAgKiBWYWxpZCB2YWx1ZXMgYXJlICd0cnVlJyBvciAnZmFsc2UnIGFzIHN0cmluZ3NcbiAgICpcbiAgICogVHlwaWNhbGx5IHdoZW4gdXNpbmcgYW4gU2RrUmVxdWVzdCB5b3Ugd2lsbCBiZSBwYXNzaW5nIGl0IGFzIHRoZVxuICAgKiBgYWN0dWFsYCB2YWx1ZSB0byBhbiBhc3NlcnRpb24gcHJvdmlkZXIgc28gdGhpcyB3b3VsZCBiZSBzZXRcbiAgICogdG8gJ2ZhbHNlJyAoeW91IHdhbnQgdGhlIGFjdHVhbCByZXNwb25zZSkuXG4gICAqXG4gICAqIElmIHlvdSBhcmUgdXNpbmcgdGhlIFNka1JlcXVlc3QgdG8gcGVyZm9ybSBtb3JlIG9mIGEgcXVlcnkgdG8gcmV0dXJuXG4gICAqIGEgc2luZ2xlIHZhbHVlIHRvIHVzZSwgdGhlbiB0aGlzIHNob3VsZCBiZSBzZXQgdG8gJ3RydWUnLiBGb3IgZXhhbXBsZSxcbiAgICogeW91IGNvdWxkIG1ha2UgYSBTdGVwRnVuY3Rpb25zLnN0YXJ0RXhlY3V0aW9uIGFwaSBjYWxsIGFuZCByZXRyZWl2ZSB0aGVcbiAgICogYGV4ZWN1dGlvbkFybmAgZnJvbSB0aGUgcmVzcG9uc2UuXG4gICAqXG4gICAqIEBkZWZhdWx0ICdmYWxzZSdcbiAgICovXG4gIHJlYWRvbmx5IGZsYXR0ZW5SZXNwb25zZT86IHN0cmluZztcbn1cblxuLyoqXG4gKiBUaGUgcmVzdWx0IGZyb20gYSBTZGtRdWVyeVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF3c0FwaUNhbGxSZXN1bHQge1xuICAvKipcbiAgICogVGhlIGZ1bGwgYXBpIHJlc3BvbnNlXG4gICAqL1xuICByZWFkb25seSBhcGlDYWxsUmVzcG9uc2U6IGFueTtcbn1cblxuLyoqXG4gKiBUaGUgdHlwZSBvZiBhc3NlcnRpb24gdG8gcGVyZm9ybVxuICovXG5leHBvcnQgZW51bSBBc3NlcnRpb25UeXBlIHtcbiAgLyoqXG4gICAqIEFzc2VydCB0aGF0IHR3byB2YWx1ZXMgYXJlIGVxdWFsXG4gICAqL1xuICBFUVVBTFMgPSAnZXF1YWxzJyxcblxuICAvKipcbiAgICogVGhlIGtleXMgYW5kIHRoZWlyIHZhbHVlcyBtdXN0IGJlIHByZXNlbnQgaW4gdGhlIHRhcmdldCBidXQgdGhlIHRhcmdldFxuICAgKiBjYW4gYmUgYSBzdXBlcnNldC5cbiAgICovXG4gIE9CSkVDVF9MSUtFID0gJ29iamVjdExpa2UnLFxuXG4gIC8qKlxuICAgKiBNYXRjaGVzIHRoZSBzcGVjaWZpZWQgcGF0dGVybiB3aXRoIHRoZSBhcnJheVxuICAgKiBUaGUgc2V0IG9mIGVsZW1lbnRzIG11c3QgYmUgaW4gdGhlIHNhbWUgb3JkZXIgYXMgd291bGQgYmUgZm91bmRcbiAgICovXG4gIEFSUkFZX1dJVEggPSAnYXJyYXlXaXRoJyxcbn1cblxuLyoqXG4gKiBBIHJlcXVlc3QgdG8gbWFrZSBhbiBhc3NlcnRpb24gdGhhdCB0aGVcbiAqIGFjdHVhbCB2YWx1ZSBtYXRjaGVzIHRoZSBleHBlY3RlZFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEFzc2VydGlvblJlcXVlc3Qge1xuICAvKipcbiAgICogVGhlIGV4cGVjdGVkIHZhbHVlIHRvIGFzc2VydFxuICAgKi9cbiAgcmVhZG9ubHkgZXhwZWN0ZWQ6IGFueTtcblxuICAvKipcbiAgICogVGhlIGFjdHVhbCB2YWx1ZSByZWNlaXZlZFxuICAgKi9cbiAgcmVhZG9ubHkgYWN0dWFsOiBhbnk7XG5cbiAgLyoqXG4gICAqIFNldCB0aGlzIHRvIHRydWUgaWYgYSBmYWlsZWQgYXNzZXJ0aW9uIHNob3VsZFxuICAgKiByZXN1bHQgaW4gYSBDbG91ZEZvcm1hdGlvbiBkZXBsb3ltZW50IGZhaWx1cmVcbiAgICpcbiAgICogVGhpcyBpcyBvbmx5IG5lY2Vzc2FyeSBpZiBhc3NlcnRpb25zIGFyZSBiZWluZ1xuICAgKiBleGVjdXRlZCBvdXRzaWRlIG9mIGBpbnRlZy1ydW5uZXJgLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZmFpbERlcGxveW1lbnQ/OiBib29sZWFuO1xufVxuLyoqXG4gKiBUaGUgcmVzdWx0IG9mIGFuIEFzc2VydGlvblxuICogd3JhcHBpbmcgdGhlIGFjdHVhbCByZXN1bHQgZGF0YSBpbiBhbm90aGVyIHN0cnVjdC5cbiAqIE5lZWRlZCB0byBhY2Nlc3MgdGhlIHdob2xlIG1lc3NhZ2UgdmlhIGdldEF0dCgpIG9uIHRoZSBjdXN0b20gcmVzb3VyY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXNzZXJ0aW9uUmVzdWx0IHtcbi8qKlxuICogVGhlIHJlc3VsdCBvZiBhbiBhc3NlcnRpb25cbiAqL1xuICByZWFkb25seSBkYXRhOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgb3Igbm90IHRoZSBhc3NlcnRpb24gZmFpbGVkXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBmYWlsZWQ/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIFRoZSBzdGF0dXMgb2YgdGhlIGFzc2VydGlvblxuICovXG5leHBvcnQgZW51bSBTdGF0dXMge1xuICAvKipcbiAgICogVGhlIGFzc2VydGlvbiBwYXNzZWRcbiAgICovXG4gIFBBU1MgPSAncGFzcycsXG5cbiAgLyoqXG4gICAqIFRoZSBhc3NlcnRpb24gZmFpbGVkXG4gICAqL1xuICBGQUlMID0gJ2ZhaWwnLFxufVxuXG4vKipcbiAqIFRoZSByZXN1bHQgb2YgYW4gYXNzZXJ0aW9uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXNzZXJ0aW9uUmVzdWx0RGF0YSB7XG4gIC8qKlxuICAgKiBUaGUgc3RhdHVzIG9mIHRoZSBhc3NlcnRpb24sIGkuZS5cbiAgICogcGFzcyBvciBmYWlsXG4gICAqL1xuICByZWFkb25seSBzdGF0dXM6IFN0YXR1cztcblxuICAvKipcbiAgICogQW55IG1lc3NhZ2UgcmV0dXJuZWQgd2l0aCB0aGUgYXNzZXJ0aW9uIHJlc3VsdFxuICAgKiB0eXBpY2FsbHkgdGhpcyB3aWxsIGJlIHRoZSBkaWZmIGlmIHRoZXJlIGlzIGFueVxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG1lc3NhZ2U/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGNvbGxlY3Rpb24gb2YgYXNzZXJ0aW9uIHJlcXVlc3QgcmVzdWx0c1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFJlc3VsdHNDb2xsZWN0aW9uUmVxdWVzdCB7XG4gIC8qKlxuICAgKiBUaGUgcmVzdWx0cyBvZiBhbGwgdGhlIGFzc2VydGlvbnMgdGhhdCBoYXZlIGJlZW5cbiAgICogcmVnaXN0ZXJlZFxuICAgKi9cbiAgcmVhZG9ubHkgYXNzZXJ0aW9uUmVzdWx0czogQXNzZXJ0aW9uUmVzdWx0RGF0YVtdO1xufVxuXG4vKipcbiAqIFRoZSByZXN1bHQgb2YgYSByZXN1bHRzIHJlcXVlc3RcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSZXN1bHRzQ29sbGVjdGlvblJlc3VsdCB7XG4gIC8qKlxuICAgKiBBIG1lc3NhZ2UgY29udGFpbmluZyB0aGUgcmVzdWx0cyBvZiB0aGUgYXNzZXJ0aW9uXG4gICAqL1xuICByZWFkb25seSBtZXNzYWdlOiBzdHJpbmc7XG59XG4iXX0=