"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const assertion_1 = require("./assertion");
const results_1 = require("./results");
const sdk_1 = require("./sdk");
const types = require("./types");
async function handler(event, context) {
    const provider = createResourceHandler(event, context);
    await provider.handle();
}
exports.handler = handler;
function createResourceHandler(event, context) {
    if (event.ResourceType.startsWith(types.SDK_RESOURCE_TYPE_PREFIX)) {
        return new sdk_1.AwsApiCallHandler(event, context);
    }
    switch (event.ResourceType) {
        case types.ASSERT_RESOURCE_TYPE: return new assertion_1.AssertionHandler(event, context);
        case types.RESULTS_RESOURCE_TYPE: return new results_1.ResultsCollectionHandler(event, context);
        default:
            throw new Error(`Unsupported resource type "${event.ResourceType}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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