"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployAssert = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
const assertions_1 = require("./assertions");
const hash_1 = require("./private/hash");
const sdk_1 = require("./sdk");
const DEPLOY_ASSERT_SYMBOL = Symbol.for('@aws-cdk/integ-tests.DeployAssert');
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
class DeployAssert extends core_2.Construct {
    constructor(scope) {
        /**
         * Normally we would not want to do a scope swapparoo like this
         * but in this case this it allows us to provide a better experience
         * for the user. This allows DeployAssert to be created _not_ in the
         * scope of a Stack. DeployAssert is treated like a Stack, but doesn't
         * exose any of the stack functionality (the methods that the user sees
         * are just DeployAssert methods and not any Stack methods). So you can do
         * something like this, which you would not normally be allowed to do
         *
         * const deployAssert = new DeployAssert(app);
         * new AwsApiCall(deployAssert, 'AwsApiCall', {...});
         */
        scope = new core_1.Stack(scope, 'DeployAssert');
        super(scope, 'Default');
        Object.defineProperty(this, DEPLOY_ASSERT_SYMBOL, { value: true });
    }
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x) {
        return x !== null && typeof (x) === 'object' && DEPLOY_ASSERT_SYMBOL in x;
    }
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct) {
        const scopes = constructs_1.Node.of(constructs_1.Node.of(construct).root).findAll();
        const deployAssert = scopes.find(s => DeployAssert.isDeployAssert(s));
        if (!deployAssert) {
            throw new Error('No DeployAssert construct found in scopes');
        }
        return deployAssert;
    }
    /**
     * Query AWS using JavaScript SDK V2 API calls. This can be used to either
     * trigger an action or to return a result that can then be asserted against
     * an expected value
     *
     * @example
     * declare const app: App;
     * const assert = new DeployAssert(app);
     * assert.awsApiCall('SQS', 'sendMessage', {
     *   QueueUrl: 'url',
     *   MessageBody: 'hello',
     * });
     * const message = assert.awsApiCall('SQS', 'receiveMessage', {
     *   QueueUrl: 'url',
     * });
     * message.assert(ExpectedResult.objectLike({
     *   Messages: [{ Body: 'hello' }],
     * }));
     */
    awsApiCall(service, api, parameters) {
        return new sdk_1.AwsApiCall(this, `AwsApiCall${service}${api}`, {
            api,
            service,
            parameters,
        });
    }
    /**
     * Invoke a lambda function and return the response which can be asserted
     *
     * @example
     * declare const app: App;
     * const assert = new DeployAssert(app);
     * const invoke = assert.invokeFunction({
     *   functionName: 'my-function',
     * });
     * invoke.assert(ExpectedResult.objectLike({
     *   Payload: '200',
     * }));
     */
    invokeFunction(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_LambdaInvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.invokeFunction);
            }
            throw error;
        }
        const hash = hash_1.md5hash(core_1.Stack.of(this).resolve(props));
        return new sdk_1.LambdaInvokeFunction(this, `LambdaInvoke${hash}`, props);
    }
    /**
     * Assert that the ExpectedResult is equal
     * to the ActualResult
     *
     * @example
     * declare const deployAssert: DeployAssert;
     * declare const apiCall: AwsApiCall;
     * deployAssert.assert(
     *   'invoke',
     *   ExpectedResult.objectLike({ Payload: 'OK' }),
     *   ActualResult.fromAwsApiCall(apiCall, 'Body'),
     * );
     */
    assert(id, expected, actual) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ExpectedResult(expected);
            jsiiDeprecationWarnings._aws_cdk_integ_tests_ActualResult(actual);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assert);
            }
            throw error;
        }
        new assertions_1.EqualsAssertion(this, `EqualsAssertion${id}`, {
            expected,
            actual,
        });
    }
}
exports.DeployAssert = DeployAssert;
_a = JSII_RTTI_SYMBOL_1;
DeployAssert[_a] = { fqn: "@aws-cdk/integ-tests.DeployAssert", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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