import { Construct, IConstruct } from 'constructs';
import { ExpectedResult, ActualResult } from './common';
import { AwsApiCall, LambdaInvokeFunction, LambdaInvokeFunctionProps } from './sdk';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options for DeployAssert
 */
export interface DeployAssertProps {
}
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
export declare class DeployAssert extends CoreConstruct {
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x: any): x is DeployAssert;
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct: IConstruct): DeployAssert;
    constructor(scope: Construct);
    /**
     * Query AWS using JavaScript SDK V2 API calls. This can be used to either
     * trigger an action or to return a result that can then be asserted against
     * an expected value
     *
     * @example
     * declare const app: App;
     * const assert = new DeployAssert(app);
     * assert.awsApiCall('SQS', 'sendMessage', {
     *   QueueUrl: 'url',
     *   MessageBody: 'hello',
     * });
     * const message = assert.awsApiCall('SQS', 'receiveMessage', {
     *   QueueUrl: 'url',
     * });
     * message.assert(ExpectedResult.objectLike({
     *   Messages: [{ Body: 'hello' }],
     * }));
     */
    awsApiCall(service: string, api: string, parameters?: any): AwsApiCall;
    /**
     * Invoke a lambda function and return the response which can be asserted
     *
     * @example
     * declare const app: App;
     * const assert = new DeployAssert(app);
     * const invoke = assert.invokeFunction({
     *   functionName: 'my-function',
     * });
     * invoke.assert(ExpectedResult.objectLike({
     *   Payload: '200',
     * }));
     */
    invokeFunction(props: LambdaInvokeFunctionProps): LambdaInvokeFunction;
    /**
     * Assert that the ExpectedResult is equal
     * to the ActualResult
     *
     * @example
     * declare const deployAssert: DeployAssert;
     * declare const apiCall: AwsApiCall;
     * deployAssert.assert(
     *   'invoke',
     *   ExpectedResult.objectLike({ Payload: 'OK' }),
     *   ActualResult.fromAwsApiCall(apiCall, 'Body'),
     * );
     */
    assert(id: string, expected: ExpectedResult, actual: ActualResult): void;
}
