"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_AwsApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
exports.ActualResult = ActualResult;
_a = JSII_RTTI_SYMBOL_1;
ActualResult[_a] = { fqn: "@aws-cdk/integ-tests.ActualResult", version: "1.157.0" };
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     * });
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
exports.ExpectedResult = ExpectedResult;
_b = JSII_RTTI_SYMBOL_1;
ExpectedResult[_b] = { fqn: "@aws-cdk/integ-tests.ExpectedResult", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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