def getNativeInfo(vmanage, deviceId):
    """
    Get device system native settings from device
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/csp/system/native?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getProcessList(vmanage, deviceId):
    """
    Get device system process list from device
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/csp/system/processlist?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getSetting(vmanage, deviceId):
    """
    Get device system settings from device
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/csp/system/settings?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getStatus(vmanage, deviceId):
    """
    Get device system status from device
    
    Parameters:
    deviceId	 (string):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/csp/system/status?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getInfoList(vmanage, deviceId):
    """
    Get device information list
    
    Parameters:
    deviceId	 (array):	Device Id
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/system/info?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getStats(vmanage, deviceId):
    """
    Get device system stats list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device IP
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/system/statistics?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getStatusList(vmanage, deviceId):
    """
    Get device system status list (Real Time)
    
    Parameters:
    deviceId	 (string):	Device IP
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/system/status?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
def getSyncedStatusList(vmanage, deviceId):
    """
    Get device system stats list synchronously
    
    Parameters:
    deviceId	 (string):	Device IP
    
    Returns
    response    (dict)
    
    
    """
    
    endpoint = f"dataservice/device/system/synced/status?deviceId={deviceId}"
    response = vmanage.apiCall("GET", endpoint)
    return response
