from batchllm import InferFactory, Executor
from absl import app


template = '''<|im_start|>system
You are a helpful assistant.
<|im_end|><|im_start|>user
[背景]
作为一名资深的广告系统用户分析专家，你的任务是分析用户的基本信息和历史行为，推理用户的潜在兴趣和需求。
通过推理潜在兴趣和需求，帮助广告系统识别用户的真实兴趣，以便展示的广告更容易让该用户产生转化、付费等行为。
请结合[行业基础知识]，按照[指导]进行分析。
[行业基础知识]
以下是你所在的广告系统拥有的11格广告行业及其相关内容：
1.游戏：PC游戏,小程序游戏,手机游戏,棋牌游戏,网页游戏。
2.综合电商：网上商城，互动广告,团购打折,垂类电商,导购网站,综合类电商,网店,阿里健康。
3.出版传媒：影视传媒 ,印刷服务,广播电视,数码制作,直播,短剧,纸质刊物,网络小说,网络视频,网络音乐 。
4.医疗服务：三甲医院,专科医院,产后护理,体检机构,保健用品,假肢和矫形器,军警医疗,医疗信息,医疗器械生产,医疗器械销售,心理治疗,戒毒机构,消毒产品,特殊化妆品,社区卫生站,美容整形,药品信息,药品生产,药品研发,药品销售,语言障碍矫正,隐形眼镜及护理。
5.交通物流：二手车,汽车品牌,汽车线上服务,汽车线下机构,汽车资讯,汽车配饰,汽车销售,物流运输,租车,船舶飞机,驾校交规。
6.房地产建筑装修：家具家居,建筑工程,建筑装修材料,房产销售,房地产开发,楼盘营销,物业管理,装修服务公司,装修服务平台。
7.教育培训：IT培训,企业培训拓展,学前教育,小初高教育,文体培训,留学,职业培训,语言培训,高教自考。
8.数码产品：手机相关,摄影摄像,新兴智能设备,电脑相关,电脑配件。
9.软件：休闲福利类软件,即时通讯,工具,新兴APP,新闻,软件市场,运动健康。
10.金融服务：P2P贷款,众筹平台,保险,典当,基金,外汇,大宗商品交易,担保,期货,现货,第三方支付平台,股票,证券及期货投资类,证券投资,贵金属,贷款,金融信息展示类,金融征信,银行产品。
11.食品保健品：休闲零食,保健食品,全国连锁性餐饮服务机构,区域性餐饮服务机构,烟酒,生活食材。
[指导]
1.分析用户的基础信息，重点关注用户的身份背景和兴趣偏好，100字以内；
2.分析用户的历史行为，重点关注用户的购物、购买、付费、转化等行为，150字以内。
3.关注用户的付费和购物商品类型，从工作、生活、社交活动等方面分析用户的潜在兴趣和需求。200字以内。
4.从候选行业(综合电商、游戏、出版传媒、医疗服务、金融服务、房地产建筑装修、交通物流、软件、教育培训、食品保健品、数码产品)中选择出用户潜在感兴趣的行业，行业按用户感兴趣的程度排序，越感兴趣的排序越靠前，并分析理由。一定要从候选行业中进行选择，仅对候选行业进行分析，100字以内。
5.根据步骤4选出的兴趣行业，结合之前的分析和用户原始信息，推测出每个行业的潜在兴趣，潜在兴趣是用户在该行业的具体需求描述，150字以内。
[示例]
-输入：
```
用户基本信息{性别(女),年龄段(18-24周岁),所在城市(唐山),操作系统(Android),星座(狮子座),属相(兔),生日(1999-08-04),汽车品牌(起亚),汽车型号(秀尔),学校(河北联合大学),职业(公司职员),学历(本科),活跃区域(河北唐山古冶河北唐山开平河北唐山迁安河北廊坊广阳吉林吉林丰满江苏苏州常熟河南郑州管城回族河南平顶山宝丰湖南娄底涟源广东广州越秀),阅读性别(男),是否书旗vip(当前非会员),是否书旗金币用户(是),阅读时段(早晨),阅读书籍类型(都市异能),阅读书籍标签(热血),阅读兴趣(都市都市小说),在书旗app是否有充值行为(是)};用户有过行为的广告内容列表{点击行为:[【广告来源】YY【广告title】附近美女火热直播，超多精彩内容，等你来解锁~],点击行为:[【广告来源】布袋教育【广告title】30天中医养生课免费领!名师指导名额有限先到先得!],点击行为:[【广告来源】债务逾期处理中心【广告title】好消息{省市}不管你逾期5W还是20W我们都助您分60期咨询申请],点击行为:[【广告来源】1688【广告title】快速配送优质服务1688购物让您享受愉快的购物体验!,【广告来源】淘宝【广告title】0元0元0元新人用户统统只要0元点击下载淘宝就能免费得!],点击行为:[【广告来源】钜丰金业【广告title】黄金行情这么火什么时候才是个头?来这里专家告诉你!],点击行为:[【广告title】[文字转语音]文字转语音的软件文字转语音实用工具],付费行为:[【广告title】[文字转语音]文字转语音的软件文字转语音实用工具]};用户有过广告行为的query列表{点击行为:[语音转文本],付费(转化行为):[语音转文本],激活(转化行为):[语音转文本],付费行为:[语音转文本]};用户有过搜索行为的内容列表{搜索行为:[【搜索query】逢君小说,【搜索query】语音转文本]};用户有过购物行为的商品类目{购买:[吹风机置物架,常用清洁剂,其他药食同源食品,休闲裤,干发帽,PVC墙纸,决明子,电脑桌],收藏:[口罩,双眼皮胶水,眼线,饼干（新）,音频/视频制作辅导,休闲裤,入户门智能锁,吹风机置物架,户外秋千,铲/耙/锹/锄（新）],加入购物车:[口罩,双眼皮胶水,音频/视频制作辅导,饼干（新）,休闲裤,入户门智能锁,启蒙认知书/黑白卡/识字卡,多肉植物,吹风机置物架,铲/耙/锹/锄（新）]}
```
-输出：
```
[用户基础信息分析]
用户是一名18-24周岁的女性，所在城市为唐山，学校为河北联合大学，职业为公司职员，操作系统为Android。她的书籍阅读兴趣主要集中在都市异能类型的书籍，喜欢早晨阅读，同时是书旗金币用户，具有充值行为。此外，她的汽车品牌为起亚，学历为本科。结合用户的生日、星座和属相，可以初步推断她可能对美容整形、家居生活、金融服务等方面的产品感兴趣。
[用户历史行为分析]
用户点击了多个广告，包括美女直播、中医养生课、黄金行情等内容。在购物行为中，她购买了吹风机置物架、常用清洁剂等商品。搜索行为中涉及逢君小说和语音转文本。付费行为包括语音转文本的文字转语音软件。购物行为涵盖了家居生活、清洁用品、休闲裤等商品，表现出她对这些方面有一定的需求和兴趣。
[潜在兴趣和需求分析]
用户的购物行为中涉及了家居生活用品、清洁剂、休闲裤等商品，可以推测她对家居生活、清洁卫生、休闲生活方面可能有需求。同时，她的付费行为显示出对文字转语音软件的需求，表明她可能对数码产品和软件领域感兴趣。在搜索行为中涉及到小说阅读和语音转文本，也表明她对文学阅读和语音转文本工具感兴趣。
[用户潜在兴趣行业分析]
1.数码产品：考虑到购买行为中有电脑桌和休闲裤，以及对文字转语音软件的付费行为。
2.综合电商：购买了常用清洁剂等日常生活用品，对家居生活可能有兴趣。
3.软件：根据付费行为和操作系统为Android，推测对软件可能有需求。
4.房地产建筑装修：考虑到对家居清洁等产品的购买行为，可能对家居装修服务有兴趣。
[用户潜在兴趣推测]
在数码产品方面，用户可能对电脑桌、文字转语音软件等产品感兴趣。在综合电商领域，可能对家居生活用品、清洁剂等产品有需求。此外，她也可能对软件和家居装修服务感兴趣。
```

-输入：
```
用户基本信息{性别(男),年龄段(24-29周岁),所在城市(沈阳),操作系统(Android),星座(狮子座),属相(牛),生日(1997-08-03),是否有车(有),汽车品牌(雪铁龙),汽车型号(C3XR),学校(扬州大学),职业(公司职员),学历(本科),活跃区域(新疆巴音郭楞库尔勒)};用户有过行为的广告内容列表{点击行为:[【广告来源】向僵尸开炮【广告title】向僵尸开炮],点击行为:[【广告来源】次神：光之觉醒【广告title】呜~1分钟上手，3分钟上头！],点击行为:[【广告title】{AI工具}百度文库AI助手AI在线编辑],付费行为:[【广告title】{AI工具}百度文库AI助手AI在线编辑]};用户有过广告行为的query列表{点击行为:[openai],付费(转化行为):[openai],下单购买(转化行为):[openai],付费行为:[openai]};用户有过搜索行为的内容列表{点击行为:[【搜索query】大疆商城【点击answer】大疆商城大疆无人机、手持稳定器、专业影像设备及增值服务中国大陆],搜索行为:[【搜索query】大疆商城,【搜索query】openai]};用户有过浏览行为的信息流内容列表{点击行为:[【内容来源】动力体坛【内容分类】社会奇闻【内容title】浙江一男子带着女友入住某高档酒店41楼的客房，专门选择了面朝钱塘江的房子，两人放,【内容分类】现实情感世情故事【内容title】捐精检查的女医生竟是师母检查以后她非要带我去见识熟女乐园,【内容分类】社会法制社会【内容title】陕西一位女子和一男子在出租屋里约会，被老公当场抓获。老公的两位朋友将男子控制在卫,【内容分类】未分类【内容title】老天奶不觉得这姐很吓人吗,【内容分类】社会法制社会【内容title】一女子海边不慎溺水，小伙子仗义出手救人，却被说成是趁机揩油！能看出小伙吸出了很,【内容分类】社会【内容title】一天到晚的拆快递，真想把她赶出去,【内容分类】汽车汽车导购【内容title】陪客户试驾了一晚上，终于成交,【内容分类】幽默【内容title】纯欲666,【内容分类】美女【内容title】在日本暴走一天【内容分类】美女【内容title】遇到这个情况阁下如何应对？]};用户有过购物行为的商品类目{购买:[脚架/云台,其他运动护具,运动毛巾,登山杖/手杖,骑行眼镜/风镜,手机保护套/壳,补益安神,男科用药,口罩,起重工具],收藏:[外用延时剂,快感增强液],加入购物车:[其他运动护具,运动毛巾,登山杖/手杖,冲锋衣裤,骑行眼镜/风镜,补益安神,男科用药]}
```
-输出：
```
[用户基础信息分析]
用户是一名24-29周岁的男性，所在城市为沈阳，职业为公司职员，操作系统为Android。他具有本科学历，是有车一族，汽车品牌为雪铁龙。根据他的生日、星座和属相，可能对健康保健、运动健身等方面的产品感兴趣。
[用户历史行为分析]
用户点击了多个广告，包括向僵尸开炮、次神：光之觉醒、百度文库AI助手等内容。在购物行为中，他购买了脚架/云台、其他运动护具、运动毛巾等商品。搜索行为中涉及大疆商城和openai。用户的信息流浏览涉及了社会奇闻、现实情感世情故事等多个分类。
[潜在兴趣和需求分析]
用户的购物行为中涉及了运动护具、运动毛巾、健康保健用品等商品，可以推测他可能对健康保健、运动健身、户外运动等方面有需求。此外，他的信息流浏览可能显示出对社会热点、时事新闻等感兴趣。
[用户潜在兴趣行业分析]
1.医疗服务：考虑到购物行为中有口罩、其他运动护具等商品，可能对健康保健有一定需求。
2.游戏：考虑到点击行为中有向僵尸开炮等游戏广告，可能对游戏产品感兴趣。
3.软件：根据付费行为和点击行为中openai的query，可能对软件或AI工具有兴趣。
4.教育培训：根据查询openai，可能对教育培训或技能提升感兴趣。
[用户潜在兴趣推测]
用户可能对健康保健用品、运动器材、以及智能软件或AI工具产品感兴趣。此外，对游戏或教育培训产品也可能有需求。
```
[任务]
请按照[指导]和[示例]进行分析，输出每一步的分析结果。不要在答案中添加额外的解释或介绍。尝试以分步思考来回答这个问题，并使答案更加结构化。
[用户原始信息]
```[prompts]
```
<|im_end|><|im_start|>assistant'''



class UserInterestInfer:

    def __init__(self):
        self.template = template

    def compute(self, ctx):
        batch = [self.template.replace("[prompts]", i) for i in ctx.prompts]
        return ctx.llm(batch)

    def warm_up(self, llm):
        return llm(self.template.replace("[prompts]", "空白"))


def main(argv):
    InferFactory.register(UserInterestInfer)
    Executor().run()


if __name__ == '__main__':
    app.run(main)
