#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.resources',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200521',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Resource management classes and functions.',
  long_description =
    ('Resource management classes and functions.\n'    
 '\n'    
 '*Latest release 20200521*:\n'    
 'Sweeping removal of cs.obj.O, universally supplanted by '    
 'types.SimpleNamespace.\n'    
 '\n'    
 '## Class `ClosedError(builtins.Exception,builtins.BaseException)`\n'    
 '\n'    
 'Exception for operations invalid when something is closed.\n'    
 '\n'    
 '## Class `MultiOpen(MultiOpenMixin)`\n'    
 '\n'    
 'Context manager class that manages a single open/close object\n'    
 'using a MultiOpenMixin.\n'    
 '\n'    
 '### Method `MultiOpen.__init__(self, openable, finalise_later=False)`\n'    
 '\n'    
 'Initialise: save the `openable` and call the MultiOpenMixin initialiser.\n'    
 '\n'    
 '## Class `MultiOpenMixin`\n'    
 '\n'    
 'A mixin to count open and close calls, and to call `.startup`\n'    
 'on the first `.open` and to call `.shutdown` on the last `.close`.\n'    
 '\n'    
 'Recommended subclass implementations do as little as possible\n'    
 'during `__init__`, and do almost all setup during startup so\n'    
 'that the class may perform multiple startup/shutdown iterations.\n'    
 '\n'    
 'If used as a context manager this mixin calls `open()`/`close()` from\n'    
 '`__enter__()` and `__exit__()`.\n'    
 '\n'    
 'Multithread safe.\n'    
 '\n'    
 'Classes using this mixin need to define `.startup` and `.shutdown`.\n'    
 '\n'    
 '### Method `MultiOpenMixin.__init__(self, finalise_later=False)`\n'    
 '\n'    
 'Initialise the `MultiOpenMixin` state.\n'    
 '\n'    
 'Parameters:\n'    
 '* `finalise_later`: do not notify the finalisation `Condition`\n'    
 '  on shutdown, instead require a separate call to `.finalise()`.\n'    
 '  This is mode is useful for objects such as queues where\n'    
 '  the final close prevents further `.put` calls, but users\n'    
 '  calling `.join` may need to wait for all the queued items\n'    
 '  to be processed.\n'    
 '\n'    
 'TODO:\n'    
 '* `subopens`: if true (default false) then `.open` will return\n'    
 '  a proxy object with its own `.closed` attribute set by the\n'    
 "  proxy's `.close`.\n"    
 '\n'    
 '## Function `not_closed(func)`\n'    
 '\n'    
 'Decorator to wrap methods of objects with a .closed property\n'    
 'which should raise when self.closed.\n'    
 '\n'    
 '## Class `Pool`\n'    
 '\n'    
 'A generic pool of objects on the premise that reuse is cheaper than '    
 'recreation.\n'    
 '\n'    
 'All the pool objects must be suitable for use, so the\n'    
 '`new_object` callable will typically be a closure.\n'    
 'For example, here is the __init__ for a per-thread AWS Bucket using a\n'    
 'distinct Session:\n'    
 '\n'    
 '    def __init__(self, bucket_name):\n'    
 '        Pool.__init__(self, lambda: '    
 "boto3.session.Session().resource('s3').Bucket(bucket_name)\n"    
 '\n'    
 '### Method `Pool.__init__(self, new_object, max_size=None, lock=None)`\n'    
 '\n'    
 'Initialise the Pool with creator `new_object` and maximum size `max_size`.\n'    
 '\n'    
 'Parameters:\n'    
 '* `new_object` is a callable which returns a new object for the Pool.\n'    
 '* `max_size`: The maximum size of the pool of available objects saved for '    
 'reuse.\n'    
 '    If omitted or `None`, defaults to 4.\n'    
 '    If 0, no upper limit is applied.\n'    
 '* `lock`: optional shared Lock; if omitted or `None` a new Lock is '    
 'allocated\n'    
 '\n'    
 '## Class `RunState`\n'    
 '\n'    
 'A class to track a running task whose cancellation may be requested.\n'    
 '\n'    
 'Its purpose is twofold, to provide easily queriable state\n'    
 'around tasks which can start and stop, and to provide control\n'    
 'methods to pronounce that a task has started (`.start`),\n'    
 'should stop (`.cancel`)\n'    
 'and has stopped (`.stop`).\n'    
 '\n'    
 'A `RunState` can be used as a context manager, with the enter\n'    
 'and exit methods calling `.start` and `.stop` respectively.\n'    
 'Note that if the suite raises an exception\n'    
 'then the exit method also calls `.cancel` before the call to `.stop`.\n'    
 '\n'    
 'Monitor or daemon processes can poll the `RunState` to see when\n'    
 'they should terminate, and may also manage the overall state\n'    
 'easily using a context manager.\n'    
 'Example:\n'    
 '\n'    
 '    def monitor(self):\n'    
 '        with self.runstate:\n'    
 '            while not self.runstate.cancelled:\n'    
 '                ... main loop body here ...\n'    
 '\n'    
 'A `RunState` has three main methods:\n'    
 '* `.start()`: set `.running` and clear `.cancelled`\n'    
 '* `.cancel()`: set `.cancelled`\n'    
 '* `.stop()`: clear `.running`\n'    
 '\n'    
 'A `RunState` has the following properties:\n'    
 '* `cancelled`: true if `.cancel` has been called.\n'    
 '* `running`: true if the task is running.\n'    
 '  Further, assigning a true value to it also sets `.start_time` to now.\n'    
 '  Assigning a false value to it also sets `.stop_time` to now.\n'    
 '* `start_time`: the time `.running` was last set to true.\n'    
 '* `stop_time`: the time `.running` was last set to false.\n'    
 '* `run_time`: `max(0,.stop_time-.start_time)`\n'    
 '* `stopped`: true if the task is not running.\n'    
 '* `stopping`: true if the task is running but has been cancelled.\n'    
 '* `notify_start`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.running` becomes true.\n'    
 '* `notify_end`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.running` becomes false.\n'    
 '* `notify_cancel`: a set of callables called with the `RunState` instance\n'    
 '  to be called whenever `.cancel` is called.\n'    
 '\n'    
 '## Class `RunStateMixin`\n'    
 '\n'    
 'Mixin to provide convenient access to a `RunState`.\n'    
 '\n'    
 'Provides: `.runstate`, `.cancelled`, `.running`, `.stopping`, `.stopped`.\n'    
 '\n'    
 '### Method `RunStateMixin.__init__(self, runstate=None)`\n'    
 '\n'    
 'Initialise the `RunStateMixin`; sets the `.runstate` attribute.\n'    
 '\n'    
 '`runstate`: `RunState` instance or name.\n'    
 'If a `str`, a new `RunState` with that name is allocated.\n'    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20200521*:\n'    
 'Sweeping removal of cs.obj.O, universally supplanted by '    
 'types.SimpleNamespace.\n'    
 '\n'    
 '*Release 20190812*:\n'    
 '* MultiOpenMixin: no longer subclass cs.obj.O.\n'    
 '* MultiOpenMixin: remove `lock` param support, the mixin has its own lock.\n'    
 '* MultiOpen: drop `lock` param support, no longer used by MultiOpenMixin.\n'    
 '* MultiOpenMixin: do finalise inside the lock for the same reason as '    
 'shutdown (competition with open/startup).\n'    
 '* MultiOpenMixin.close: new `unopened_ok=False` parameter intended for '    
 'callback closes which might fire even if the initial open does not occur.\n'    
 '\n'    
 '*Release 20190617*:\n'    
 'RunState.__exit__: if an exception was raised call .canel() before calling '    
 '.stop().\n'    
 '\n'    
 '*Release 20190103*:\n'    
 '* Bugfixes for context managers.\n'    
 '* MultiOpenMixin fixes and changes.\n'    
 '* RunState improvements.\n'    
 '\n'    
 '*Release 20171024*:\n'    
 '* bugfix MultiOpenMixin finalise logic and other small logic fixes and '    
 'checs\n'    
 '* new class RunState for tracking or controlling a running task\n'    
 '\n'    
 '*Release 20160828*:\n'    
 'Use "install_requires" instead of "requires" in DISTINFO.\n'    
 '\n'    
 '*Release 20160827*:\n'    
 '* BREAKING CHANGE: rename NestingOpenCloseMixin to MultiOpenMixin.\n'    
 '* New Pool class for generic object reuse.\n'    
 '* Assorted minor improvements.\n'    
 '\n'    
 '*Release 20150115*:\n'    
 'First PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = ['cs.logutils', 'cs.obj', 'cs.py.func', 'cs.py.stack'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.resources'],
)
