class EnvisionError(object):

    def __init__(self, error_code, error_message):
        self.__error_code = error_code
        self.__error_message = error_message

    def get_error_code(self):
        return self.__error_code

    def get_error_message(self):
        return self.__error_message


SUCCESS = EnvisionError(0, "success")
INIT_MQTT_CLIENT_FAILED = EnvisionError(-100, "INIT_MQTT_CLIENT_FAILED")
MQTT_CLIENT_CONNECT_FAILED = EnvisionError(-101, "MQTT_CLIENT_CONNECT_FAILED")
MQTT_CLIENT_PUBLISH_FAILED = EnvisionError(-102, "MQTT_CLIENT_PUBLISH_FAILED")
MQTT_CLIENT_DISCONNECT_FAILED = EnvisionError(-103, "MQTT_CLIENT_DISCONNECT_FAILED")
MQTT_CLIENT_SUBSCRIEBE_FAILED = EnvisionError(-104, "MQTT_CLIENT_SUBSCRIEBE_FAILED")
MQTT_CLIENT_CLOSE_FAILED = EnvisionError(-105, "MQTT_CLIENT_CLOSE_FAILED")
INVALID_DEVICE_CREDENTIAL = EnvisionError(-106, "INVALID_DEVICE_CREDENTIAL")
INVALID_REPLY_MESSAGE_FORMAT = EnvisionError(-107, "INVALID_REPLY_MESSAGE_FORMAT")
INVALID_PAYLOAD = EnvisionError(-108, "INVALID_PAYLOAD")
EMPTY_PAYLOAD = EnvisionError(-109, "EMPTY_PAYLOAD")
GET_LOCAL_MODEL_FAILED = EnvisionError(-110, "GET_LOCAL_MODEL_FAILED")
MODEL_VALIDATION_FAILED = EnvisionError(-111, "MODEL_VALIDATION_FAILED")
RESPONSE_PARSE_ERR = EnvisionError(-112, "RESPONSE_PARSE_ERR")
MQTT_RESPONSE_PARSED_FALED = EnvisionError(-113, "INIT_MQTT_CLIENT_FAILED")
UNSUPPPORTED_REQUEST_CALL_TYPE = EnvisionError(-114, "UNSUPPPORTED_REQUEST_CALL_TYPE")
SESSION_IS_NULL = EnvisionError(-115, "SESSION_IS_NULL")
STATUS_IS_UNKNOWN = EnvisionError(-116, "STATUS_IS_UNKNOWN")
CODE_ERROR_MISSING_ARGS = EnvisionError(-117, "CODE_ERROR_MISSING_ARGS")
CODE_ERROR_ARG_INVALID = EnvisionError(-118, "CODE_ERROR_ARG_INVALID")
CANNOT_REGISTER_CALLBACK = EnvisionError(-119, "CANNOT_REGISTER_CALLBACK")
DEVICE_SESSION_IS_NULL = EnvisionError(-120, "DEVICE_SESSION_IS_NULL")
CALLBACK_EXECUTION_FAILED = EnvisionError(-121, "CALLBACK_EXECUTION_FAILED")
STATUS_ERROR = EnvisionError(-122, "STATUS_ERROR")
STATUS_NOT_ALLOW_LOGIN = EnvisionError(-123, "STATUS_NOT_ALLOW_LOGIN")
STATUS_NOT_ALLOW_LOGOUT = EnvisionError(-124, "STATUS_NOT_ALLOW_LOGOUT")
FUTURE_TASK_TIME_OUT = EnvisionError(-125, "FUTURE_TASK_TIME_OUT")
THREAD_INTERRUPTED = EnvisionError(-126, "THREAD_INTERRUPTED")
QOS_2_NOT_ALLOWED = EnvisionError(-127, "QOS_2_NOT_ALLOWED")
