"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhookHandler = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const webhook_handler_function_1 = require("./lambdas/webhook-handler-function");
/**
 * Create a Lambda with a public URL to handle GitHub webhook events. After validating the event with the given secret, the orchestrator step function is called with information about the workflow job.
 *
 * This construct is not meant to be used by itself.
 */
class GithubWebhookHandler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.handler = new webhook_handler_function_1.WebhookHandlerFunction(this, 'webhook-handler', {
            description: 'Handle GitHub webhook and start runner orchestrator',
            environment: {
                STEP_FUNCTION_ARN: props.orchestrator.stateMachineArn,
                WEBHOOK_SECRET_ARN: props.secrets.webhook.secretArn,
            },
            timeout: cdk.Duration.seconds(30),
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        this.url = this.handler.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE }).url;
        props.secrets.webhook.grantRead(this.handler);
        props.orchestrator.grantStartExecution(this.handler);
    }
}
exports.GithubWebhookHandler = GithubWebhookHandler;
//# sourceMappingURL=data:application/json;base64,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