"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const lambda = new AWS.Lambda();
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
async function handler(event) {
    console.log(JSON.stringify(event));
    while (true) {
        try {
            await lambda.updateFunctionCode({
                FunctionName: event.lambdaName,
                ImageUri: `${event.repositoryUri}:${event.repositoryTag}`,
                Publish: true,
            }).promise();
            break;
        }
        catch (e) {
            if (e.code == 'ResourceConflictException') {
                // keep trying if function is already being updated by CloudFormation
                // this can happen if we update some settings on the function and the image code at the same time
                await sleep(10000);
            }
            else {
                throw e;
            }
        }
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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