# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class UtilsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_reason_code_using_post(self, reason_code_request, **kwargs):  # noqa: E501
        """Create a reason code  # noqa: E501

        Create a new reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reason_code_using_post(reason_code_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReasonCode reason_code_request: reasonCodeRequest (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_reason_code_using_post_with_http_info(reason_code_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_reason_code_using_post_with_http_info(reason_code_request, **kwargs)  # noqa: E501
            return data

    def create_reason_code_using_post_with_http_info(self, reason_code_request, **kwargs):  # noqa: E501
        """Create a reason code  # noqa: E501

        Create a new reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reason_code_using_post_with_http_info(reason_code_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReasonCode reason_code_request: reasonCodeRequest (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reason_code_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_reason_code_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reason_code_request' is set
        if ('reason_code_request' not in params or
                params['reason_code_request'] is None):
            raise ValueError("Missing the required parameter `reason_code_request` when calling `create_reason_code_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reason_code_request' in params:
            body_params = params['reason_code_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/reason_code', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReasonCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_stage_using_post(self, stage_request, **kwargs):  # noqa: E501
        """Create an account stage  # noqa: E501

        Create a new account stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_stage_using_post(stage_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Stage stage_request: stageRequest (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_stage_using_post_with_http_info(stage_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_stage_using_post_with_http_info(stage_request, **kwargs)  # noqa: E501
            return data

    def create_stage_using_post_with_http_info(self, stage_request, **kwargs):  # noqa: E501
        """Create an account stage  # noqa: E501

        Create a new account stage  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_stage_using_post_with_http_info(stage_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Stage stage_request: stageRequest (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['stage_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_stage_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'stage_request' is set
        if ('stage_request' not in params or
                params['stage_request'] is None):
            raise ValueError("Missing the required parameter `stage_request` when calling `create_stage_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stage_request' in params:
            body_params = params['stage_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/stage', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_transaction_code_using_post(self, transaction_request, **kwargs):  # noqa: E501
        """Create a transaction code  # noqa: E501

        Create a new transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transaction_code_using_post(transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCode transaction_request: transactionRequest (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_transaction_code_using_post_with_http_info(transaction_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_transaction_code_using_post_with_http_info(transaction_request, **kwargs)  # noqa: E501
            return data

    def create_transaction_code_using_post_with_http_info(self, transaction_request, **kwargs):  # noqa: E501
        """Create a transaction code  # noqa: E501

        Create a new transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_transaction_code_using_post_with_http_info(transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TransactionCode transaction_request: transactionRequest (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transaction_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transaction_code_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transaction_request' is set
        if ('transaction_request' not in params or
                params['transaction_request'] is None):
            raise ValueError("Missing the required parameter `transaction_request` when calling `create_transaction_code_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_request' in params:
            body_params = params['transaction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/transaction_code', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reason_code_using_delete(self, reason_code_id, **kwargs):  # noqa: E501
        """Delete a reason code  # noqa: E501

        Permanently delete a reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reason_code_using_delete(reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason_code_id: UUID reason_code_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_reason_code_using_delete_with_http_info(reason_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_reason_code_using_delete_with_http_info(reason_code_id, **kwargs)  # noqa: E501
            return data

    def delete_reason_code_using_delete_with_http_info(self, reason_code_id, **kwargs):  # noqa: E501
        """Delete a reason code  # noqa: E501

        Permanently delete a reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reason_code_using_delete_with_http_info(reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason_code_id: UUID reason_code_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reason_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reason_code_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reason_code_id' is set
        if ('reason_code_id' not in params or
                params['reason_code_id'] is None):
            raise ValueError("Missing the required parameter `reason_code_id` when calling `delete_reason_code_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reason_code_id' in params:
            path_params['reason_code_id'] = params['reason_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/reason_code/{reason_code_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_stage_using_delete(self, stage_id, **kwargs):  # noqa: E501
        """Delete an account stage  # noqa: E501

        Permanently delete an account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stage_using_delete(stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stage_id: UUID stage_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_stage_using_delete_with_http_info(stage_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_stage_using_delete_with_http_info(stage_id, **kwargs)  # noqa: E501
            return data

    def delete_stage_using_delete_with_http_info(self, stage_id, **kwargs):  # noqa: E501
        """Delete an account stage  # noqa: E501

        Permanently delete an account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_stage_using_delete_with_http_info(stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stage_id: UUID stage_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['stage_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_stage_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'stage_id' is set
        if ('stage_id' not in params or
                params['stage_id'] is None):
            raise ValueError("Missing the required parameter `stage_id` when calling `delete_stage_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stage_id' in params:
            path_params['stage_id'] = params['stage_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/stage/{stage_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_transaction_code_using_delete(self, transaction_code_id, **kwargs):  # noqa: E501
        """Delete a transaction code  # noqa: E501

        Permanently delete a transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transaction_code_using_delete(transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_transaction_code_using_delete_with_http_info(transaction_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_transaction_code_using_delete_with_http_info(transaction_code_id, **kwargs)  # noqa: E501
            return data

    def delete_transaction_code_using_delete_with_http_info(self, transaction_code_id, **kwargs):  # noqa: E501
        """Delete a transaction code  # noqa: E501

        Permanently delete a transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_transaction_code_using_delete_with_http_info(transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transaction_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transaction_code_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transaction_code_id' is set
        if ('transaction_code_id' not in params or
                params['transaction_code_id'] is None):
            raise ValueError("Missing the required parameter `transaction_code_id` when calling `delete_transaction_code_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_code_id' in params:
            path_params['transaction_code_id'] = params['transaction_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/transaction_code/{transaction_code_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reason_code_all_using_get(self, **kwargs):  # noqa: E501
        """List all reason codes  # noqa: E501

        Get the information for all reason codes defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reason_code_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reason_code_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reason_code_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reason_code_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all reason codes  # noqa: E501

        Get the information for all reason codes defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reason_code_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reason_code_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/reason_code', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageReasonCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reason_code_using_get(self, reason_code_id, **kwargs):  # noqa: E501
        """Retrieve a reason code  # noqa: E501

        Retrieve the information for a reason code defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reason_code_using_get(reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason_code_id: UUID reason_code_id (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reason_code_using_get_with_http_info(reason_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_reason_code_using_get_with_http_info(reason_code_id, **kwargs)  # noqa: E501
            return data

    def get_reason_code_using_get_with_http_info(self, reason_code_id, **kwargs):  # noqa: E501
        """Retrieve a reason code  # noqa: E501

        Retrieve the information for a reason code defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reason_code_using_get_with_http_info(reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str reason_code_id: UUID reason_code_id (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reason_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reason_code_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reason_code_id' is set
        if ('reason_code_id' not in params or
                params['reason_code_id'] is None):
            raise ValueError("Missing the required parameter `reason_code_id` when calling `get_reason_code_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reason_code_id' in params:
            path_params['reason_code_id'] = params['reason_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/reason_code/{reason_code_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReasonCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stage_all_using_get(self, **kwargs):  # noqa: E501
        """List all account stages  # noqa: E501

        Get the information for all possible account stages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stage_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageStage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_stage_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_stage_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_stage_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account stages  # noqa: E501

        Get the information for all possible account stages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stage_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageStage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stage_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/stage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageStage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stage_using_get(self, stage_id, **kwargs):  # noqa: E501
        """Retrieve an account stage  # noqa: E501

        Retrieve the information for a specific account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stage_using_get(stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stage_id: UUID stage_id (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_stage_using_get_with_http_info(stage_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stage_using_get_with_http_info(stage_id, **kwargs)  # noqa: E501
            return data

    def get_stage_using_get_with_http_info(self, stage_id, **kwargs):  # noqa: E501
        """Retrieve an account stage  # noqa: E501

        Retrieve the information for a specific account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stage_using_get_with_http_info(stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str stage_id: UUID stage_id (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['stage_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stage_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'stage_id' is set
        if ('stage_id' not in params or
                params['stage_id'] is None):
            raise ValueError("Missing the required parameter `stage_id` when calling `get_stage_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stage_id' in params:
            path_params['stage_id'] = params['stage_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/stage/{stage_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_code_all_using_get(self, **kwargs):  # noqa: E501
        """List all transaction codes  # noqa: E501

        Get the information for all transaction codes defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_code_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageTransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_code_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_code_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_transaction_code_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all transaction codes  # noqa: E501

        Get the information for all transaction codes defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_code_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageTransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_code_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/transaction_code', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageTransactionCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_transaction_code_using_get(self, transaction_code_id, **kwargs):  # noqa: E501
        """Retrieve a transaction code  # noqa: E501

        Retrieve the information for a transaction code defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_code_using_get(transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_transaction_code_using_get_with_http_info(transaction_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_transaction_code_using_get_with_http_info(transaction_code_id, **kwargs)  # noqa: E501
            return data

    def get_transaction_code_using_get_with_http_info(self, transaction_code_id, **kwargs):  # noqa: E501
        """Retrieve a transaction code  # noqa: E501

        Retrieve the information for a transaction code defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_transaction_code_using_get_with_http_info(transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transaction_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transaction_code_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transaction_code_id' is set
        if ('transaction_code_id' not in params or
                params['transaction_code_id'] is None):
            raise ValueError("Missing the required parameter `transaction_code_id` when calling `get_transaction_code_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_code_id' in params:
            path_params['transaction_code_id'] = params['transaction_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/transaction_code/{transaction_code_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_reason_code_using_put(self, reason_code, reason_code_id, **kwargs):  # noqa: E501
        """Update a reason code  # noqa: E501

        Update a reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reason_code_using_put(reason_code, reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object reason_code: reason_code (required)
        :param str reason_code_id: UUID reason_code_id (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_reason_code_using_put_with_http_info(reason_code, reason_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_reason_code_using_put_with_http_info(reason_code, reason_code_id, **kwargs)  # noqa: E501
            return data

    def update_reason_code_using_put_with_http_info(self, reason_code, reason_code_id, **kwargs):  # noqa: E501
        """Update a reason code  # noqa: E501

        Update a reason code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reason_code_using_put_with_http_info(reason_code, reason_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object reason_code: reason_code (required)
        :param str reason_code_id: UUID reason_code_id (required)
        :return: ReasonCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reason_code', 'reason_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reason_code_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'reason_code' is set
        if ('reason_code' not in params or
                params['reason_code'] is None):
            raise ValueError("Missing the required parameter `reason_code` when calling `update_reason_code_using_put`")  # noqa: E501
        # verify the required parameter 'reason_code_id' is set
        if ('reason_code_id' not in params or
                params['reason_code_id'] is None):
            raise ValueError("Missing the required parameter `reason_code_id` when calling `update_reason_code_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'reason_code_id' in params:
            path_params['reason_code_id'] = params['reason_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reason_code' in params:
            body_params = params['reason_code']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/reason_code/{reason_code_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ReasonCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_stage_using_put(self, stage, stage_id, **kwargs):  # noqa: E501
        """Update an account stage  # noqa: E501

        Update the information for an account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stage_using_put(stage, stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object stage: stage (required)
        :param str stage_id: UUID stage_id (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_stage_using_put_with_http_info(stage, stage_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_stage_using_put_with_http_info(stage, stage_id, **kwargs)  # noqa: E501
            return data

    def update_stage_using_put_with_http_info(self, stage, stage_id, **kwargs):  # noqa: E501
        """Update an account stage  # noqa: E501

        Update the information for an account stage.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_stage_using_put_with_http_info(stage, stage_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object stage: stage (required)
        :param str stage_id: UUID stage_id (required)
        :return: Stage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['stage', 'stage_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_stage_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'stage' is set
        if ('stage' not in params or
                params['stage'] is None):
            raise ValueError("Missing the required parameter `stage` when calling `update_stage_using_put`")  # noqa: E501
        # verify the required parameter 'stage_id' is set
        if ('stage_id' not in params or
                params['stage_id'] is None):
            raise ValueError("Missing the required parameter `stage_id` when calling `update_stage_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'stage_id' in params:
            path_params['stage_id'] = params['stage_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stage' in params:
            body_params = params['stage']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/stage/{stage_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_transaction_code_using_put(self, transaction_code, transaction_code_id, **kwargs):  # noqa: E501
        """Update a transaction code  # noqa: E501

        Update a transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_code_using_put(transaction_code, transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object transaction_code: transaction_code (required)
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_transaction_code_using_put_with_http_info(transaction_code, transaction_code_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_transaction_code_using_put_with_http_info(transaction_code, transaction_code_id, **kwargs)  # noqa: E501
            return data

    def update_transaction_code_using_put_with_http_info(self, transaction_code, transaction_code_id, **kwargs):  # noqa: E501
        """Update a transaction code  # noqa: E501

        Update a transaction code for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_transaction_code_using_put_with_http_info(transaction_code, transaction_code_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object transaction_code: transaction_code (required)
        :param str transaction_code_id: UUID transaction_code_id (required)
        :return: TransactionCode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['transaction_code', 'transaction_code_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transaction_code_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'transaction_code' is set
        if ('transaction_code' not in params or
                params['transaction_code'] is None):
            raise ValueError("Missing the required parameter `transaction_code` when calling `update_transaction_code_using_put`")  # noqa: E501
        # verify the required parameter 'transaction_code_id' is set
        if ('transaction_code_id' not in params or
                params['transaction_code_id'] is None):
            raise ValueError("Missing the required parameter `transaction_code_id` when calling `update_transaction_code_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_code_id' in params:
            path_params['transaction_code_id'] = params['transaction_code_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'transaction_code' in params:
            body_params = params['transaction_code']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/transaction_code/{transaction_code_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionCode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
