# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class SecuritiesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_security_exclusion_using_post(self, security_exclusion_request, **kwargs):  # noqa: E501
        """Create a security exclusion  # noqa: E501

        Create a new security exclusion for a specific account or portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_exclusion_using_post(security_exclusion_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecurityExclusion security_exclusion_request: securityExclusionRequest (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_security_exclusion_using_post_with_http_info(security_exclusion_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_security_exclusion_using_post_with_http_info(security_exclusion_request, **kwargs)  # noqa: E501
            return data

    def create_security_exclusion_using_post_with_http_info(self, security_exclusion_request, **kwargs):  # noqa: E501
        """Create a security exclusion  # noqa: E501

        Create a new security exclusion for a specific account or portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_exclusion_using_post_with_http_info(security_exclusion_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecurityExclusion security_exclusion_request: securityExclusionRequest (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_exclusion_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_security_exclusion_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_exclusion_request' is set
        if ('security_exclusion_request' not in params or
                params['security_exclusion_request'] is None):
            raise ValueError("Missing the required parameter `security_exclusion_request` when calling `create_security_exclusion_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security_exclusion_request' in params:
            body_params = params['security_exclusion_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_exclusion', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityExclusion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_security_price_using_post(self, security_price_request, **kwargs):  # noqa: E501
        """Create a security price  # noqa: E501

        Create a new price for a security defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_price_using_post(security_price_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecurityPrice security_price_request: securityPriceRequest (required)
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_security_price_using_post_with_http_info(security_price_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_security_price_using_post_with_http_info(security_price_request, **kwargs)  # noqa: E501
            return data

    def create_security_price_using_post_with_http_info(self, security_price_request, **kwargs):  # noqa: E501
        """Create a security price  # noqa: E501

        Create a new price for a security defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_price_using_post_with_http_info(security_price_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecurityPrice security_price_request: securityPriceRequest (required)
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_price_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_security_price_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_price_request' is set
        if ('security_price_request' not in params or
                params['security_price_request'] is None):
            raise ValueError("Missing the required parameter `security_price_request` when calling `create_security_price_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security_price_request' in params:
            body_params = params['security_price_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_price', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityPrice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_security_using_post(self, securities_info_request, **kwargs):  # noqa: E501
        """Create a security  # noqa: E501

        Create a new security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_using_post(securities_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Security securities_info_request: securitiesInfoRequest (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_security_using_post_with_http_info(securities_info_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_security_using_post_with_http_info(securities_info_request, **kwargs)  # noqa: E501
            return data

    def create_security_using_post_with_http_info(self, securities_info_request, **kwargs):  # noqa: E501
        """Create a security  # noqa: E501

        Create a new security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_security_using_post_with_http_info(securities_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Security securities_info_request: securitiesInfoRequest (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['securities_info_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_security_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'securities_info_request' is set
        if ('securities_info_request' not in params or
                params['securities_info_request'] is None):
            raise ValueError("Missing the required parameter `securities_info_request` when calling `create_security_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'securities_info_request' in params:
            body_params = params['securities_info_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Security',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_security_exclusion_using_delete(self, security_exclusion_id, **kwargs):  # noqa: E501
        """Delete a security exclusion  # noqa: E501

        Permanently delete a security exclusion  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_exclusion_using_delete(security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_security_exclusion_using_delete_with_http_info(security_exclusion_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_security_exclusion_using_delete_with_http_info(security_exclusion_id, **kwargs)  # noqa: E501
            return data

    def delete_security_exclusion_using_delete_with_http_info(self, security_exclusion_id, **kwargs):  # noqa: E501
        """Delete a security exclusion  # noqa: E501

        Permanently delete a security exclusion  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_exclusion_using_delete_with_http_info(security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_exclusion_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_security_exclusion_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_exclusion_id' is set
        if ('security_exclusion_id' not in params or
                params['security_exclusion_id'] is None):
            raise ValueError("Missing the required parameter `security_exclusion_id` when calling `delete_security_exclusion_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_exclusion_id' in params:
            path_params['security_exclusion_id'] = params['security_exclusion_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_exclusion/{security_exclusion_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_security_price_using_delete(self, security_price_id, **kwargs):  # noqa: E501
        """Delete a security price  # noqa: E501

        Permanently delete a security price from a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_price_using_delete(security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_price_id: UUID security_price_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_security_price_using_delete_with_http_info(security_price_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_security_price_using_delete_with_http_info(security_price_id, **kwargs)  # noqa: E501
            return data

    def delete_security_price_using_delete_with_http_info(self, security_price_id, **kwargs):  # noqa: E501
        """Delete a security price  # noqa: E501

        Permanently delete a security price from a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_price_using_delete_with_http_info(security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_price_id: UUID security_price_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_price_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_security_price_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_price_id' is set
        if ('security_price_id' not in params or
                params['security_price_id'] is None):
            raise ValueError("Missing the required parameter `security_price_id` when calling `delete_security_price_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_price_id' in params:
            path_params['security_price_id'] = params['security_price_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_price/{security_price_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_security_using_delete(self, security_id, **kwargs):  # noqa: E501
        """Delete a security  # noqa: E501

        Permanently delete a security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_using_delete(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: UUID security_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_security_using_delete_with_http_info(security_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_security_using_delete_with_http_info(security_id, **kwargs)  # noqa: E501
            return data

    def delete_security_using_delete_with_http_info(self, security_id, **kwargs):  # noqa: E501
        """Delete a security  # noqa: E501

        Permanently delete a security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_security_using_delete_with_http_info(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: UUID security_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_security_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_id' is set
        if ('security_id' not in params or
                params['security_id'] is None):
            raise ValueError("Missing the required parameter `security_id` when calling `delete_security_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_id' in params:
            path_params['security_id'] = params['security_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security/{security_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_all_using_get(self, **kwargs):  # noqa: E501
        """List all securities  # noqa: E501

        Get details for all securities defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_security_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_security_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all securities  # noqa: E501

        Get details for all securities defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageSecurity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_exclusion_all_using_get(self, **kwargs):  # noqa: E501
        """List all security exclusions  # noqa: E501

        Get details for all security exclusions defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exclusion_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_exclusion_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_security_exclusion_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_security_exclusion_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all security exclusions  # noqa: E501

        Get details for all security exclusions defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exclusion_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_exclusion_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_exclusion', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageSecurityExclusion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_exclusion_using_get(self, security_exclusion_id, **kwargs):  # noqa: E501
        """Retrieve a security exclusion  # noqa: E501

        Retrieve the information for a security exclusion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exclusion_using_get(security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_exclusion_using_get_with_http_info(security_exclusion_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_exclusion_using_get_with_http_info(security_exclusion_id, **kwargs)  # noqa: E501
            return data

    def get_security_exclusion_using_get_with_http_info(self, security_exclusion_id, **kwargs):  # noqa: E501
        """Retrieve a security exclusion  # noqa: E501

        Retrieve the information for a security exclusion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_exclusion_using_get_with_http_info(security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_exclusion_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_exclusion_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_exclusion_id' is set
        if ('security_exclusion_id' not in params or
                params['security_exclusion_id'] is None):
            raise ValueError("Missing the required parameter `security_exclusion_id` when calling `get_security_exclusion_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_exclusion_id' in params:
            path_params['security_exclusion_id'] = params['security_exclusion_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_exclusion/{security_exclusion_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityExclusion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_all_using_get(self, **kwargs):  # noqa: E501
        """List all security prices  # noqa: E501

        Get prices for all securities defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_price_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_price_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_security_price_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all security prices  # noqa: E501

        Get prices for all securities defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_price_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageSecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_price', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageSecurityPrice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_price_using_get(self, security_price_id, **kwargs):  # noqa: E501
        """Retrieve a security price  # noqa: E501

        Retrieve the information for a security price for a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_price_using_get(security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_price_id: UUID security_price_id (required)
        :param str currency_conversion: USD
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_price_using_get_with_http_info(security_price_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_price_using_get_with_http_info(security_price_id, **kwargs)  # noqa: E501
            return data

    def get_security_price_using_get_with_http_info(self, security_price_id, **kwargs):  # noqa: E501
        """Retrieve a security price  # noqa: E501

        Retrieve the information for a security price for a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_price_using_get_with_http_info(security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_price_id: UUID security_price_id (required)
        :param str currency_conversion: USD
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_price_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_price_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_price_id' is set
        if ('security_price_id' not in params or
                params['security_price_id'] is None):
            raise ValueError("Missing the required parameter `security_price_id` when calling `get_security_price_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_price_id' in params:
            path_params['security_price_id'] = params['security_price_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_price/{security_price_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityPrice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_using_get(self, security_id, **kwargs):  # noqa: E501
        """Retrieve a security  # noqa: E501

        Retrieve the information for a security defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_using_get(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: UUID security_id (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_using_get_with_http_info(security_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_using_get_with_http_info(security_id, **kwargs)  # noqa: E501
            return data

    def get_security_using_get_with_http_info(self, security_id, **kwargs):  # noqa: E501
        """Retrieve a security  # noqa: E501

        Retrieve the information for a security defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_using_get_with_http_info(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: UUID security_id (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_id' is set
        if ('security_id' not in params or
                params['security_id'] is None):
            raise ValueError("Missing the required parameter `security_id` when calling `get_security_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_id' in params:
            path_params['security_id'] = params['security_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security/{security_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Security',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_security_exclusion_using_put(self, security_exclusion, security_exclusion_id, **kwargs):  # noqa: E501
        """Update a security exclusion  # noqa: E501

        Update the information for a security exclusion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_exclusion_using_put(security_exclusion, security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security_exclusion: security_exclusion (required)
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_security_exclusion_using_put_with_http_info(security_exclusion, security_exclusion_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_security_exclusion_using_put_with_http_info(security_exclusion, security_exclusion_id, **kwargs)  # noqa: E501
            return data

    def update_security_exclusion_using_put_with_http_info(self, security_exclusion, security_exclusion_id, **kwargs):  # noqa: E501
        """Update a security exclusion  # noqa: E501

        Update the information for a security exclusion.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_exclusion_using_put_with_http_info(security_exclusion, security_exclusion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security_exclusion: security_exclusion (required)
        :param str security_exclusion_id: UUID security_exclusion_id (required)
        :return: SecurityExclusion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_exclusion', 'security_exclusion_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_security_exclusion_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_exclusion' is set
        if ('security_exclusion' not in params or
                params['security_exclusion'] is None):
            raise ValueError("Missing the required parameter `security_exclusion` when calling `update_security_exclusion_using_put`")  # noqa: E501
        # verify the required parameter 'security_exclusion_id' is set
        if ('security_exclusion_id' not in params or
                params['security_exclusion_id'] is None):
            raise ValueError("Missing the required parameter `security_exclusion_id` when calling `update_security_exclusion_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_exclusion_id' in params:
            path_params['security_exclusion_id'] = params['security_exclusion_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security_exclusion' in params:
            body_params = params['security_exclusion']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_exclusion/{security_exclusion_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityExclusion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_security_price_using_put(self, security_price, security_price_id, **kwargs):  # noqa: E501
        """Update a security price  # noqa: E501

        Update a security price for a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_price_using_put(security_price, security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security_price: security_price (required)
        :param str security_price_id: UUID security_price_id (required)
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_security_price_using_put_with_http_info(security_price, security_price_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_security_price_using_put_with_http_info(security_price, security_price_id, **kwargs)  # noqa: E501
            return data

    def update_security_price_using_put_with_http_info(self, security_price, security_price_id, **kwargs):  # noqa: E501
        """Update a security price  # noqa: E501

        Update a security price for a security.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_price_using_put_with_http_info(security_price, security_price_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security_price: security_price (required)
        :param str security_price_id: UUID security_price_id (required)
        :return: SecurityPrice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_price', 'security_price_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_security_price_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_price' is set
        if ('security_price' not in params or
                params['security_price'] is None):
            raise ValueError("Missing the required parameter `security_price` when calling `update_security_price_using_put`")  # noqa: E501
        # verify the required parameter 'security_price_id' is set
        if ('security_price_id' not in params or
                params['security_price_id'] is None):
            raise ValueError("Missing the required parameter `security_price_id` when calling `update_security_price_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_price_id' in params:
            path_params['security_price_id'] = params['security_price_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security_price' in params:
            body_params = params['security_price']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security_price/{security_price_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SecurityPrice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_security_using_put(self, security, security_id, **kwargs):  # noqa: E501
        """Update a security  # noqa: E501

        Update a security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_using_put(security, security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security: security (required)
        :param str security_id: UUID security_id (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_security_using_put_with_http_info(security, security_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_security_using_put_with_http_info(security, security_id, **kwargs)  # noqa: E501
            return data

    def update_security_using_put_with_http_info(self, security, security_id, **kwargs):  # noqa: E501
        """Update a security  # noqa: E501

        Update a security for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_security_using_put_with_http_info(security, security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object security: security (required)
        :param str security_id: UUID security_id (required)
        :return: Security
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security', 'security_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_security_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security' is set
        if ('security' not in params or
                params['security'] is None):
            raise ValueError("Missing the required parameter `security` when calling `update_security_using_put`")  # noqa: E501
        # verify the required parameter 'security_id' is set
        if ('security_id' not in params or
                params['security_id'] is None):
            raise ValueError("Missing the required parameter `security_id` when calling `update_security_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_id' in params:
            path_params['security_id'] = params['security_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'security' in params:
            body_params = params['security']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security/{security_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Security',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
