# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class PortfolioApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_portfolio_asset_size_using_post(self, portfolio_asset_size_log_request, **kwargs):  # noqa: E501
        """Create a portfolio asset size  # noqa: E501

        Create a new asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_asset_size_using_post(portfolio_asset_size_log_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioAssetSizeLog portfolio_asset_size_log_request: portfolioAssetSizeLogRequest (required)
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_asset_size_using_post_with_http_info(portfolio_asset_size_log_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_asset_size_using_post_with_http_info(portfolio_asset_size_log_request, **kwargs)  # noqa: E501
            return data

    def create_portfolio_asset_size_using_post_with_http_info(self, portfolio_asset_size_log_request, **kwargs):  # noqa: E501
        """Create a portfolio asset size  # noqa: E501

        Create a new asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_asset_size_using_post_with_http_info(portfolio_asset_size_log_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioAssetSizeLog portfolio_asset_size_log_request: portfolioAssetSizeLogRequest (required)
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_asset_size_log_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_asset_size_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_asset_size_log_request' is set
        if ('portfolio_asset_size_log_request' not in params or
                params['portfolio_asset_size_log_request'] is None):
            raise ValueError("Missing the required parameter `portfolio_asset_size_log_request` when calling `create_portfolio_asset_size_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_asset_size_log_request' in params:
            body_params = params['portfolio_asset_size_log_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_asset_size', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioAssetSizeLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_comment_using_post(self, portfolio_comment, **kwargs):  # noqa: E501
        """Create a portfolio commentary  # noqa: E501

        Create a new comment for a portfolio defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_comment_using_post(portfolio_comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioComment portfolio_comment: portfolioComment (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_comment_using_post_with_http_info(portfolio_comment, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_comment_using_post_with_http_info(portfolio_comment, **kwargs)  # noqa: E501
            return data

    def create_portfolio_comment_using_post_with_http_info(self, portfolio_comment, **kwargs):  # noqa: E501
        """Create a portfolio commentary  # noqa: E501

        Create a new comment for a portfolio defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_comment_using_post_with_http_info(portfolio_comment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioComment portfolio_comment: portfolioComment (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_comment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_comment_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_comment' is set
        if ('portfolio_comment' not in params or
                params['portfolio_comment'] is None):
            raise ValueError("Missing the required parameter `portfolio_comment` when calling `create_portfolio_comment_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_comment' in params:
            body_params = params['portfolio_comment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_comment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_goal_using_post(self, portfolio_goal, **kwargs):  # noqa: E501
        """Create an portfolio goal  # noqa: E501

        Create an portfolio goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_goal_using_post(portfolio_goal, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGoal portfolio_goal: portfolioGoal (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_goal_using_post_with_http_info(portfolio_goal, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_goal_using_post_with_http_info(portfolio_goal, **kwargs)  # noqa: E501
            return data

    def create_portfolio_goal_using_post_with_http_info(self, portfolio_goal, **kwargs):  # noqa: E501
        """Create an portfolio goal  # noqa: E501

        Create an portfolio goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_goal_using_post_with_http_info(portfolio_goal, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioGoal portfolio_goal: portfolioGoal (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_goal']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_goal_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_goal' is set
        if ('portfolio_goal' not in params or
                params['portfolio_goal'] is None):
            raise ValueError("Missing the required parameter `portfolio_goal` when calling `create_portfolio_goal_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_goal' in params:
            body_params = params['portfolio_goal']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_goal', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioGoal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_holding_using_post(self, portfolio_holdin_log_request, **kwargs):  # noqa: E501
        """Create a portfolio holding  # noqa: E501

        Create a new holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_holding_using_post(portfolio_holdin_log_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioHoldingLog portfolio_holdin_log_request: portfolioHoldinLogRequest (required)
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_holding_using_post_with_http_info(portfolio_holdin_log_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_holding_using_post_with_http_info(portfolio_holdin_log_request, **kwargs)  # noqa: E501
            return data

    def create_portfolio_holding_using_post_with_http_info(self, portfolio_holdin_log_request, **kwargs):  # noqa: E501
        """Create a portfolio holding  # noqa: E501

        Create a new holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_holding_using_post_with_http_info(portfolio_holdin_log_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioHoldingLog portfolio_holdin_log_request: portfolioHoldinLogRequest (required)
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_holdin_log_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_holding_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_holdin_log_request' is set
        if ('portfolio_holdin_log_request' not in params or
                params['portfolio_holdin_log_request'] is None):
            raise ValueError("Missing the required parameter `portfolio_holdin_log_request` when calling `create_portfolio_holding_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_holdin_log_request' in params:
            body_params = params['portfolio_holdin_log_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_holding', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioHoldingLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_transaction_using_post(self, portfolio_transaction_request, **kwargs):  # noqa: E501
        """Create a portfolio transaction  # noqa: E501

        Create a new transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_transaction_using_post(portfolio_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioTransaction portfolio_transaction_request: portfolioTransactionRequest (required)
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_transaction_using_post_with_http_info(portfolio_transaction_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_transaction_using_post_with_http_info(portfolio_transaction_request, **kwargs)  # noqa: E501
            return data

    def create_portfolio_transaction_using_post_with_http_info(self, portfolio_transaction_request, **kwargs):  # noqa: E501
        """Create a portfolio transaction  # noqa: E501

        Create a new transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_transaction_using_post_with_http_info(portfolio_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PortfolioTransaction portfolio_transaction_request: portfolioTransactionRequest (required)
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_transaction_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_transaction_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_transaction_request' is set
        if ('portfolio_transaction_request' not in params or
                params['portfolio_transaction_request'] is None):
            raise ValueError("Missing the required parameter `portfolio_transaction_request` when calling `create_portfolio_transaction_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_transaction_request' in params:
            body_params = params['portfolio_transaction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_transaction', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portfolio_using_post(self, portfolio_request, **kwargs):  # noqa: E501
        """Create a portfolio  # noqa: E501

        Create a new portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_using_post(portfolio_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Portfolio portfolio_request: portfolioRequest (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_portfolio_using_post_with_http_info(portfolio_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portfolio_using_post_with_http_info(portfolio_request, **kwargs)  # noqa: E501
            return data

    def create_portfolio_using_post_with_http_info(self, portfolio_request, **kwargs):  # noqa: E501
        """Create a portfolio  # noqa: E501

        Create a new portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_portfolio_using_post_with_http_info(portfolio_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Portfolio portfolio_request: portfolioRequest (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portfolio_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_request' is set
        if ('portfolio_request' not in params or
                params['portfolio_request'] is None):
            raise ValueError("Missing the required parameter `portfolio_request` when calling `create_portfolio_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_request' in params:
            body_params = params['portfolio_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Portfolio',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_asset_size_using_delete(self, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Delete a portfolio asset size  # noqa: E501

        Permanently delete a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_asset_size_using_delete(portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_asset_size_id: UUID portfolio_asset_size_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_asset_size_using_delete_with_http_info(portfolio_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_asset_size_using_delete_with_http_info(portfolio_asset_size_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_asset_size_using_delete_with_http_info(self, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Delete a portfolio asset size  # noqa: E501

        Permanently delete a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_asset_size_using_delete_with_http_info(portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_asset_size_id: UUID portfolio_asset_size_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_asset_size_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_asset_size_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_asset_size_id' is set
        if ('portfolio_asset_size_id' not in params or
                params['portfolio_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_asset_size_id` when calling `delete_portfolio_asset_size_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_asset_size_id' in params:
            path_params['portfolio_asset_size_id'] = params['portfolio_asset_size_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_asset_size/{portfolio_asset_size_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_comment_using_delete(self, portfolio_comment_id, **kwargs):  # noqa: E501
        """Delete a portfolio commentary  # noqa: E501

        Permanently delete a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_comment_using_delete(portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_comment_using_delete_with_http_info(portfolio_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_comment_using_delete_with_http_info(portfolio_comment_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_comment_using_delete_with_http_info(self, portfolio_comment_id, **kwargs):  # noqa: E501
        """Delete a portfolio commentary  # noqa: E501

        Permanently delete a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_comment_using_delete_with_http_info(portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_comment_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_comment_id' is set
        if ('portfolio_comment_id' not in params or
                params['portfolio_comment_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_comment_id` when calling `delete_portfolio_comment_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_comment_id' in params:
            path_params['portfolio_comment_id'] = params['portfolio_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_comment/{portfolio_comment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_goal_using_delete(self, portfolio_goal_id, **kwargs):  # noqa: E501
        """Delete an portfolio goal  # noqa: E501

        Permanently delete an portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_goal_using_delete(portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_goal_using_delete_with_http_info(portfolio_goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_goal_using_delete_with_http_info(portfolio_goal_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_goal_using_delete_with_http_info(self, portfolio_goal_id, **kwargs):  # noqa: E501
        """Delete an portfolio goal  # noqa: E501

        Permanently delete an portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_goal_using_delete_with_http_info(portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_goal_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_goal_id' is set
        if ('portfolio_goal_id' not in params or
                params['portfolio_goal_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_goal_id` when calling `delete_portfolio_goal_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_goal_id' in params:
            path_params['portfolio_goal_id'] = params['portfolio_goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_goal/{portfolio_goal_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_holding_using_delete(self, portfolio_holding_id, **kwargs):  # noqa: E501
        """Delete a portfolio holding  # noqa: E501

        Permanently delete a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_holding_using_delete(portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_holding_using_delete_with_http_info(portfolio_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_holding_using_delete_with_http_info(portfolio_holding_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_holding_using_delete_with_http_info(self, portfolio_holding_id, **kwargs):  # noqa: E501
        """Delete a portfolio holding  # noqa: E501

        Permanently delete a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_holding_using_delete_with_http_info(portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_holding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_holding_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_holding_id' is set
        if ('portfolio_holding_id' not in params or
                params['portfolio_holding_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_holding_id` when calling `delete_portfolio_holding_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_holding_id' in params:
            path_params['portfolio_holding_id'] = params['portfolio_holding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_holding/{portfolio_holding_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_transaction_using_delete(self, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Delete a portfolio transaction  # noqa: E501

        Permanently delete a portfolio transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_transaction_using_delete(portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_transaction_using_delete_with_http_info(portfolio_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_transaction_using_delete_with_http_info(portfolio_transaction_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_transaction_using_delete_with_http_info(self, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Delete a portfolio transaction  # noqa: E501

        Permanently delete a portfolio transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_transaction_using_delete_with_http_info(portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_transaction_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_transaction_id' is set
        if ('portfolio_transaction_id' not in params or
                params['portfolio_transaction_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_transaction_id` when calling `delete_portfolio_transaction_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_transaction_id' in params:
            path_params['portfolio_transaction_id'] = params['portfolio_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_transaction/{portfolio_transaction_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portfolio_using_delete(self, portfolio_id, **kwargs):  # noqa: E501
        """Delete a portfolio  # noqa: E501

        Permanently delete a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_using_delete(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: UUID portfolio_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_portfolio_using_delete_with_http_info(portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portfolio_using_delete_with_http_info(portfolio_id, **kwargs)  # noqa: E501
            return data

    def delete_portfolio_using_delete_with_http_info(self, portfolio_id, **kwargs):  # noqa: E501
        """Delete a portfolio  # noqa: E501

        Permanently delete a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_portfolio_using_delete_with_http_info(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: UUID portfolio_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portfolio_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if ('portfolio_id' not in params or
                params['portfolio_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_id` when calling `delete_portfolio_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio/{portfolio_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_aggregated_data_using_get(self, portfolio_id, **kwargs):  # noqa: E501
        """Retrieve an portfolio aggregate data  # noqa: E501

        Retrieve the information for a securities associated with a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_aggregated_data_using_get(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: Portfolio Id (required)
        :param bool show_asset_class: true or false
        :param bool show_category: true or false
        :param bool show_industry: true or false
        :param bool show_sector: true or false
        :param bool show_security_class: true or false
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_aggregated_data_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_aggregated_data_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_aggregated_data_using_get_with_http_info(self, portfolio_id, **kwargs):  # noqa: E501
        """Retrieve an portfolio aggregate data  # noqa: E501

        Retrieve the information for a securities associated with a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_aggregated_data_using_get_with_http_info(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: Portfolio Id (required)
        :param bool show_asset_class: true or false
        :param bool show_category: true or false
        :param bool show_industry: true or false
        :param bool show_sector: true or false
        :param bool show_security_class: true or false
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'show_asset_class', 'show_category', 'show_industry', 'show_sector', 'show_security_class']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_aggregated_data_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if ('portfolio_id' not in params or
                params['portfolio_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_id` when calling `get_portfolio_aggregated_data_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []
        if 'show_asset_class' in params:
            query_params.append(('show_asset_class', params['show_asset_class']))  # noqa: E501
        if 'show_category' in params:
            query_params.append(('show_category', params['show_category']))  # noqa: E501
        if 'show_industry' in params:
            query_params.append(('show_industry', params['show_industry']))  # noqa: E501
        if 'show_sector' in params:
            query_params.append(('show_sector', params['show_sector']))  # noqa: E501
        if 'show_security_class' in params:
            query_params.append(('show_security_class', params['show_security_class']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio/{portfolio_id}/aggregate_data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_all_using_get(self, **kwargs):  # noqa: E501
        """List all portfolios  # noqa: E501

        Get the information for all portfolios assigned to all of your firm’s accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all portfolios  # noqa: E501

        Get the information for all portfolios assigned to all of your firm’s accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolio',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_asset_size_all_using_get(self, **kwargs):  # noqa: E501
        """Retrieve a portfolio asset size  # noqa: E501

        Retrieve the information for a portfolio asset size record for a portfolio.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_asset_size_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_asset_size_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve a portfolio asset size  # noqa: E501

        Retrieve the information for a portfolio asset size record for a portfolio.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_asset_size_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_asset_size_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioAssetSizeLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_asset_size_using_get(self, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio asset size  # noqa: E501

        Retrieve the information for a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_asset_size_using_get(portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_asset_size_id: portfolio_asset_size_id (required)
        :param str currency_conversion: currency_conversion
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_asset_size_using_get_with_http_info(portfolio_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_asset_size_using_get_with_http_info(portfolio_asset_size_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_asset_size_using_get_with_http_info(self, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio asset size  # noqa: E501

        Retrieve the information for a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_asset_size_using_get_with_http_info(portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_asset_size_id: portfolio_asset_size_id (required)
        :param str currency_conversion: currency_conversion
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_asset_size_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_asset_size_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_asset_size_id' is set
        if ('portfolio_asset_size_id' not in params or
                params['portfolio_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_asset_size_id` when calling `get_portfolio_asset_size_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_asset_size_id' in params:
            path_params['portfolio_asset_size_id'] = params['portfolio_asset_size_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_asset_size/{portfolio_asset_size_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioAssetSizeLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_comment_all_using_get(self, **kwargs):  # noqa: E501
        """List all portfolio commentary  # noqa: E501

        List all comments for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_comment_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_comment_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_comment_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_comment_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all portfolio commentary  # noqa: E501

        List all comments for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_comment_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_comment_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_comment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_comment_using_get(self, portfolio_comment_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio commentary  # noqa: E501

        Retrieve the information for a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_comment_using_get(portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_comment_using_get_with_http_info(portfolio_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_comment_using_get_with_http_info(portfolio_comment_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_comment_using_get_with_http_info(self, portfolio_comment_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio commentary  # noqa: E501

        Retrieve the information for a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_comment_using_get_with_http_info(portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_comment_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_comment_id' is set
        if ('portfolio_comment_id' not in params or
                params['portfolio_comment_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_comment_id` when calling `get_portfolio_comment_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_comment_id' in params:
            path_params['portfolio_comment_id'] = params['portfolio_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_comment/{portfolio_comment_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_goal_all_using_get(self, **kwargs):  # noqa: E501
        """List all portfolio goals  # noqa: E501

        Get information for all portfolio-goal mappings defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_goal_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_goal_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_goal_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_goal_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all portfolio goals  # noqa: E501

        Get information for all portfolio-goal mappings defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_goal_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_goal_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_goal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioGoal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_goal_using_get(self, portfolio_goal_id, **kwargs):  # noqa: E501
        """Retrieve an portfolio goal  # noqa: E501

        Retrieve the information for a specific portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_goal_using_get(portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_goal_using_get_with_http_info(portfolio_goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_goal_using_get_with_http_info(portfolio_goal_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_goal_using_get_with_http_info(self, portfolio_goal_id, **kwargs):  # noqa: E501
        """Retrieve an portfolio goal  # noqa: E501

        Retrieve the information for a specific portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_goal_using_get_with_http_info(portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_goal_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_goal_id' is set
        if ('portfolio_goal_id' not in params or
                params['portfolio_goal_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_goal_id` when calling `get_portfolio_goal_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_goal_id' in params:
            path_params['portfolio_goal_id'] = params['portfolio_goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_goal/{portfolio_goal_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioGoal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_holding_all_using_get(self, **kwargs):  # noqa: E501
        """List all portfolio holdings  # noqa: E501

        Get the information for all holding records for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_holding_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_holding_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_holding_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all portfolio holdings  # noqa: E501

        Get the information for all holding records for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_holding_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioHoldingLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_holding_using_get(self, portfolio_holding_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio holding  # noqa: E501

        Retrieve the information for a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_using_get(portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :param str currency_conversion: USD
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_holding_using_get_with_http_info(portfolio_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_holding_using_get_with_http_info(portfolio_holding_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_holding_using_get_with_http_info(self, portfolio_holding_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio holding  # noqa: E501

        Retrieve the information for a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_using_get_with_http_info(portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :param str currency_conversion: USD
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_holding_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_holding_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_holding_id' is set
        if ('portfolio_holding_id' not in params or
                params['portfolio_holding_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_holding_id` when calling `get_portfolio_holding_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_holding_id' in params:
            path_params['portfolio_holding_id'] = params['portfolio_holding_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_holding/{portfolio_holding_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioHoldingLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_transaction_all_using_get(self, **kwargs):  # noqa: E501
        """List all portfolio transactions  # noqa: E501

        Get the information for all transaction records for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_portfolio_transaction_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all portfolio transactions  # noqa: E501

        Get the information for all transaction records for all portfolios defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_transaction_using_get(self, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio transaction  # noqa: E501

        Retrieve the information for a portfolio transaction record for a portfolio.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_using_get(portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :param str currency_conversion: USD
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_transaction_using_get_with_http_info(portfolio_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_transaction_using_get_with_http_info(portfolio_transaction_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_transaction_using_get_with_http_info(self, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio transaction  # noqa: E501

        Retrieve the information for a portfolio transaction record for a portfolio.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_using_get_with_http_info(portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :param str currency_conversion: USD
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_transaction_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_transaction_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_transaction_id' is set
        if ('portfolio_transaction_id' not in params or
                params['portfolio_transaction_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_transaction_id` when calling `get_portfolio_transaction_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_transaction_id' in params:
            path_params['portfolio_transaction_id'] = params['portfolio_transaction_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_transaction/{portfolio_transaction_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_using_get(self, portfolio_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio  # noqa: E501

        Retrieve a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_using_get(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: UUID portfolio_id (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_using_get_with_http_info(self, portfolio_id, **kwargs):  # noqa: E501
        """Retrieve a portfolio  # noqa: E501

        Retrieve a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_using_get_with_http_info(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: UUID portfolio_id (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if ('portfolio_id' not in params or
                params['portfolio_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_id` when calling `get_portfolio_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio/{portfolio_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Portfolio',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_asset_size_using_put(self, portfolio_asset_size, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Update a portfolio asset size  # noqa: E501

        Update the information for a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_asset_size_using_put(portfolio_asset_size, portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_asset_size: portfolio_asset_size (required)
        :param str portfolio_asset_size_id: UUID portfolio_asset_size_id (required)
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_asset_size_using_put_with_http_info(portfolio_asset_size, portfolio_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_asset_size_using_put_with_http_info(portfolio_asset_size, portfolio_asset_size_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_asset_size_using_put_with_http_info(self, portfolio_asset_size, portfolio_asset_size_id, **kwargs):  # noqa: E501
        """Update a portfolio asset size  # noqa: E501

        Update the information for a portfolio asset size record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_asset_size_using_put_with_http_info(portfolio_asset_size, portfolio_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_asset_size: portfolio_asset_size (required)
        :param str portfolio_asset_size_id: UUID portfolio_asset_size_id (required)
        :return: PortfolioAssetSizeLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_asset_size', 'portfolio_asset_size_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_asset_size_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_asset_size' is set
        if ('portfolio_asset_size' not in params or
                params['portfolio_asset_size'] is None):
            raise ValueError("Missing the required parameter `portfolio_asset_size` when calling `update_portfolio_asset_size_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_asset_size_id' is set
        if ('portfolio_asset_size_id' not in params or
                params['portfolio_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_asset_size_id` when calling `update_portfolio_asset_size_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_asset_size_id' in params:
            path_params['portfolio_asset_size_id'] = params['portfolio_asset_size_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_asset_size' in params:
            body_params = params['portfolio_asset_size']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_asset_size/{portfolio_asset_size_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioAssetSizeLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_comment_using_put(self, portfolio_comment, portfolio_comment_id, **kwargs):  # noqa: E501
        """Update a portfolio comment  # noqa: E501

        Update the information for a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_comment_using_put(portfolio_comment, portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_comment: portfolio_comment (required)
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_comment_using_put_with_http_info(portfolio_comment, portfolio_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_comment_using_put_with_http_info(portfolio_comment, portfolio_comment_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_comment_using_put_with_http_info(self, portfolio_comment, portfolio_comment_id, **kwargs):  # noqa: E501
        """Update a portfolio comment  # noqa: E501

        Update the information for a portfolio comment for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_comment_using_put_with_http_info(portfolio_comment, portfolio_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_comment: portfolio_comment (required)
        :param str portfolio_comment_id: UUID portfolio_comment_id (required)
        :return: PortfolioComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_comment', 'portfolio_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_comment_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_comment' is set
        if ('portfolio_comment' not in params or
                params['portfolio_comment'] is None):
            raise ValueError("Missing the required parameter `portfolio_comment` when calling `update_portfolio_comment_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_comment_id' is set
        if ('portfolio_comment_id' not in params or
                params['portfolio_comment_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_comment_id` when calling `update_portfolio_comment_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_comment_id' in params:
            path_params['portfolio_comment_id'] = params['portfolio_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_comment' in params:
            body_params = params['portfolio_comment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_comment/{portfolio_comment_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_goal_using_put(self, portfolio_goal, portfolio_goal_id, **kwargs):  # noqa: E501
        """Update an portfolio goal  # noqa: E501

        Update the information for an portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_goal_using_put(portfolio_goal, portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_goal: portfolio_goal (required)
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_goal_using_put_with_http_info(portfolio_goal, portfolio_goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_goal_using_put_with_http_info(portfolio_goal, portfolio_goal_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_goal_using_put_with_http_info(self, portfolio_goal, portfolio_goal_id, **kwargs):  # noqa: E501
        """Update an portfolio goal  # noqa: E501

        Update the information for an portfolio-goal mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_goal_using_put_with_http_info(portfolio_goal, portfolio_goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_goal: portfolio_goal (required)
        :param str portfolio_goal_id: UUID portfolio_goal_id (required)
        :return: PortfolioGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_goal', 'portfolio_goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_goal_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_goal' is set
        if ('portfolio_goal' not in params or
                params['portfolio_goal'] is None):
            raise ValueError("Missing the required parameter `portfolio_goal` when calling `update_portfolio_goal_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_goal_id' is set
        if ('portfolio_goal_id' not in params or
                params['portfolio_goal_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_goal_id` when calling `update_portfolio_goal_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_goal_id' in params:
            path_params['portfolio_goal_id'] = params['portfolio_goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_goal' in params:
            body_params = params['portfolio_goal']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_goal/{portfolio_goal_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioGoal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_holding_using_put(self, portfolio_holding, portfolio_holding_id, **kwargs):  # noqa: E501
        """Update a portfolio holding  # noqa: E501

        Update the information for a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_holding_using_put(portfolio_holding, portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_holding: portfolio_holding (required)
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_holding_using_put_with_http_info(portfolio_holding, portfolio_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_holding_using_put_with_http_info(portfolio_holding, portfolio_holding_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_holding_using_put_with_http_info(self, portfolio_holding, portfolio_holding_id, **kwargs):  # noqa: E501
        """Update a portfolio holding  # noqa: E501

        Update the information for a portfolio holding record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_holding_using_put_with_http_info(portfolio_holding, portfolio_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_holding: portfolio_holding (required)
        :param str portfolio_holding_id: UUID portfolio_holding_id (required)
        :return: PortfolioHoldingLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_holding', 'portfolio_holding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_holding_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_holding' is set
        if ('portfolio_holding' not in params or
                params['portfolio_holding'] is None):
            raise ValueError("Missing the required parameter `portfolio_holding` when calling `update_portfolio_holding_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_holding_id' is set
        if ('portfolio_holding_id' not in params or
                params['portfolio_holding_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_holding_id` when calling `update_portfolio_holding_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_holding_id' in params:
            path_params['portfolio_holding_id'] = params['portfolio_holding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_holding' in params:
            body_params = params['portfolio_holding']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_holding/{portfolio_holding_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioHoldingLog',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_transaction_using_put(self, portfolio_transaction, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Update a portfolio transaction  # noqa: E501

        Update the information for a portfolio transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_transaction_using_put(portfolio_transaction, portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_transaction: portfolio_transaction (required)
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_transaction_using_put_with_http_info(portfolio_transaction, portfolio_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_transaction_using_put_with_http_info(portfolio_transaction, portfolio_transaction_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_transaction_using_put_with_http_info(self, portfolio_transaction, portfolio_transaction_id, **kwargs):  # noqa: E501
        """Update a portfolio transaction  # noqa: E501

        Update the information for a portfolio transaction record for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_transaction_using_put_with_http_info(portfolio_transaction, portfolio_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio_transaction: portfolio_transaction (required)
        :param str portfolio_transaction_id: UUID portfolio_transaction_id (required)
        :return: PortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_transaction', 'portfolio_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_transaction_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_transaction' is set
        if ('portfolio_transaction' not in params or
                params['portfolio_transaction'] is None):
            raise ValueError("Missing the required parameter `portfolio_transaction` when calling `update_portfolio_transaction_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_transaction_id' is set
        if ('portfolio_transaction_id' not in params or
                params['portfolio_transaction_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_transaction_id` when calling `update_portfolio_transaction_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_transaction_id' in params:
            path_params['portfolio_transaction_id'] = params['portfolio_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio_transaction' in params:
            body_params = params['portfolio_transaction']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio_transaction/{portfolio_transaction_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_portfolio_using_put(self, portfolio, portfolio_id, **kwargs):  # noqa: E501
        """Update a portfolio  # noqa: E501

        Update a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_using_put(portfolio, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio: portfolio (required)
        :param str portfolio_id: UUID portfolio_id (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_portfolio_using_put_with_http_info(portfolio, portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_portfolio_using_put_with_http_info(portfolio, portfolio_id, **kwargs)  # noqa: E501
            return data

    def update_portfolio_using_put_with_http_info(self, portfolio, portfolio_id, **kwargs):  # noqa: E501
        """Update a portfolio  # noqa: E501

        Update a portfolio for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_portfolio_using_put_with_http_info(portfolio, portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object portfolio: portfolio (required)
        :param str portfolio_id: UUID portfolio_id (required)
        :return: Portfolio
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio', 'portfolio_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_portfolio_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio' is set
        if ('portfolio' not in params or
                params['portfolio'] is None):
            raise ValueError("Missing the required parameter `portfolio` when calling `update_portfolio_using_put`")  # noqa: E501
        # verify the required parameter 'portfolio_id' is set
        if ('portfolio_id' not in params or
                params['portfolio_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_id` when calling `update_portfolio_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'portfolio' in params:
            body_params = params['portfolio']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio/{portfolio_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Portfolio',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
