# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class PerformanceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_account_performance_using_get(self, account_id, **kwargs):  # noqa: E501
        """Account Performance  # noqa: E501

        Get information on the performance of an account using IRR (Internal Rate of Return). You must provide the unique account_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_performance_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Account Id -/account (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_performance_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_performance_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_account_performance_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """Account Performance  # noqa: E501

        Get information on the performance of an account using IRR (Internal Rate of Return). You must provide the unique account_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_performance_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Account Id -/account (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_allocation_performance_using_get(self, allocation_id, **kwargs):  # noqa: E501
        """Allocation Performance  # noqa: E501

        Get information on the performance of an allocation using TWR (Time Weighted Return). You must provide the unique allocation_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_performance_using_get(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: Allocation Id -/allocation (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Tenant Benchmark Id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param bool is_current_weight: is_current_weight
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type found under the Statistics banner
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_allocation_performance_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_allocation_performance_using_get_with_http_info(allocation_id, **kwargs)  # noqa: E501
            return data

    def get_allocation_performance_using_get_with_http_info(self, allocation_id, **kwargs):  # noqa: E501
        """Allocation Performance  # noqa: E501

        Get information on the performance of an allocation using TWR (Time Weighted Return). You must provide the unique allocation_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_allocation_performance_using_get_with_http_info(allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str allocation_id: Allocation Id -/allocation (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Tenant Benchmark Id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param bool is_current_weight: is_current_weight
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type found under the Statistics banner
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['allocation_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'is_current_weight', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_allocation_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'allocation_id' is set
        if ('allocation_id' not in params or
                params['allocation_id'] is None):
            raise ValueError("Missing the required parameter `allocation_id` when calling `get_allocation_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'allocation_id' in params:
            path_params['allocation_id'] = params['allocation_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'is_current_weight' in params:
            query_params.append(('is_current_weight', params['is_current_weight']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/allocation/{allocation_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_benchmark_performance_using_get(self, benchmark_id, **kwargs):  # noqa: E501
        """Benchmark Performance  # noqa: E501

        Get information on the performance of a benchmark using TWR (Time Weighted Return). You must provide the unique benchmark_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_benchmark_performance_using_get(benchmark_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str benchmark_id: Benchmark Id - /benchmark (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str comparison_benchmark_id: comparison_benchmark_id
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: Stat type - /statistics endpoint
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_benchmark_performance_using_get_with_http_info(benchmark_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_benchmark_performance_using_get_with_http_info(benchmark_id, **kwargs)  # noqa: E501
            return data

    def get_benchmark_performance_using_get_with_http_info(self, benchmark_id, **kwargs):  # noqa: E501
        """Benchmark Performance  # noqa: E501

        Get information on the performance of a benchmark using TWR (Time Weighted Return). You must provide the unique benchmark_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_benchmark_performance_using_get_with_http_info(benchmark_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str benchmark_id: Benchmark Id - /benchmark (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str comparison_benchmark_id: comparison_benchmark_id
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: Stat type - /statistics endpoint
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['benchmark_id', 'active_premium_period', 'annualized_return_period', 'comparison_benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_benchmark_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'benchmark_id' is set
        if ('benchmark_id' not in params or
                params['benchmark_id'] is None):
            raise ValueError("Missing the required parameter `benchmark_id` when calling `get_benchmark_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'benchmark_id' in params:
            path_params['benchmark_id'] = params['benchmark_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'comparison_benchmark_id' in params:
            query_params.append(('comparison_benchmark_id', params['comparison_benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/benchmark/{benchmark_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_performance_using_get(self, client_id, **kwargs):  # noqa: E501
        """Client Performance  # noqa: E501

        Get information on the performance of a client using IRR (Internal Rate of Return). You must provide the unique client_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_performance_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: Client Id -/client (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type -- /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_performance_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_performance_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_performance_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """Client Performance  # noqa: E501

        Get information on the performance of a client using IRR (Internal Rate of Return). You must provide the unique client_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_performance_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: Client Id -/client (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type -- /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_performance_using_get(self, client_id, goal_id, **kwargs):  # noqa: E501
        """Goal Performance  # noqa: E501

        Get information on the performance of a goal using IRR (Internal Rate of Return). You must provide the unique goal_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_performance_using_get(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: Goal Id - /account (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param bool portfolio_goal: portfolio_goal
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_performance_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_performance_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
            return data

    def get_goal_performance_using_get_with_http_info(self, client_id, goal_id, **kwargs):  # noqa: E501
        """Goal Performance  # noqa: E501

        Get information on the performance of a goal using IRR (Internal Rate of Return). You must provide the unique goal_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_performance_using_get_with_http_info(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: Goal Id - /account (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param bool portfolio_goal: portfolio_goal
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'goal_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'portfolio_goal', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_goal_performance_using_get`")  # noqa: E501
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `get_goal_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'client_id' in params:
            query_params.append(('client_id', params['client_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'portfolio_goal' in params:
            query_params.append(('portfolio_goal', params['portfolio_goal']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_household_client_performance_using_get(self, household_id, **kwargs):  # noqa: E501
        """Household Performance  # noqa: E501

        Get information on the performance of a Household using IRR (Internal Rate of Return). You must provide the unique household_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_household_client_performance_using_get(household_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str household_id: Household Id -/household (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type -- /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_household_client_performance_using_get_with_http_info(household_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_household_client_performance_using_get_with_http_info(household_id, **kwargs)  # noqa: E501
            return data

    def get_household_client_performance_using_get_with_http_info(self, household_id, **kwargs):  # noqa: E501
        """Household Performance  # noqa: E501

        Get information on the performance of a Household using IRR (Internal Rate of Return). You must provide the unique household_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_household_client_performance_using_get_with_http_info(household_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str household_id: Household Id -/household (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Client Benchmark or Tenant Benchmark id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type -- /statistics
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['household_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_household_client_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'household_id' is set
        if ('household_id' not in params or
                params['household_id'] is None):
            raise ValueError("Missing the required parameter `household_id` when calling `get_household_client_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'household_id' in params:
            path_params['household_id'] = params['household_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/household/{household_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_performance_using_get(self, model_id, **kwargs):  # noqa: E501
        """Model Performance  # noqa: E501

        Get information on the performance of a model using TWR (Time Weighted Return). You must provide the unique model_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_performance_using_get(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Model Id - /model (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Tenant Benchmark Id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: Stat Type
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_performance_using_get_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_performance_using_get_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def get_model_performance_using_get_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Model Performance  # noqa: E501

        Get information on the performance of a model using TWR (Time Weighted Return). You must provide the unique model_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_performance_using_get_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: Model Id - /model (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Tenant Benchmark Id -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: Stat Type
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `get_model_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['model_id'] = params['model_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model/{model_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_performance_using_get(self, portfolio_id, **kwargs):  # noqa: E501
        """Portfolio Performance  # noqa: E501

        Get information on the performance of a portfolio using IRR (Internal Rate of Return). You must provide the unique portfolio_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_performance_using_get(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: Portfolio Id -/portoflio (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Benchmark Id - benchmarkId or clientBenchmarkId -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics endpoint to get types
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_performance_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_performance_using_get_with_http_info(portfolio_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_performance_using_get_with_http_info(self, portfolio_id, **kwargs):  # noqa: E501
        """Portfolio Performance  # noqa: E501

        Get information on the performance of a portfolio using IRR (Internal Rate of Return). You must provide the unique portfolio_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_performance_using_get_with_http_info(portfolio_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str portfolio_id: Portfolio Id -/portoflio (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str benchmark_id: Benchmark Id - benchmarkId or clientBenchmarkId -/benchmark
        :param date end_date: end date
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: start date
        :param str stat: A stat type - /statistics endpoint to get types
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'active_premium_period', 'annualized_return_period', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'portfolio_id' is set
        if ('portfolio_id' not in params or
                params['portfolio_id'] is None):
            raise ValueError("Missing the required parameter `portfolio_id` when calling `get_portfolio_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'portfolio_id' in params:
            path_params['portfolio_id'] = params['portfolio_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/portfolio/{portfolio_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_security_performance_using_get(self, security_id, **kwargs):  # noqa: E501
        """Security Performance  # noqa: E501

        Get performance statistics for a security using TWR (Time Weighted Return). You must provide the unique security_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_performance_using_get(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: security_id (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str bench_ticker: Bench Ticker for security - (default: ^GSPC) 
        :param str benchmark_id: benchmark_id
        :param date end_date: Ending parameter for time window
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: Starting parameter for time window
        :param str stat: A stat type - /statistics endpoint
        :param str ticker: Ticker for security
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_security_performance_using_get_with_http_info(security_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_security_performance_using_get_with_http_info(security_id, **kwargs)  # noqa: E501
            return data

    def get_security_performance_using_get_with_http_info(self, security_id, **kwargs):  # noqa: E501
        """Security Performance  # noqa: E501

        Get performance statistics for a security using TWR (Time Weighted Return). You must provide the unique security_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_security_performance_using_get_with_http_info(security_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str security_id: security_id (required)
        :param str active_premium_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str annualized_return_period: Q (quarterly), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () - (statId: 19, default: 'D')
        :param str bench_ticker: Bench Ticker for security - (default: ^GSPC) 
        :param str benchmark_id: benchmark_id
        :param date end_date: Ending parameter for time window
        :param float hist_factor: Histogram factor- (statId: 39, default: 5)
        :param float mar_down_side_deviation: minimum acceptable return for downside deviation - (statId: 58, default: 0) 
        :param float max_percentile_monte_carlo: max percentile for monte carlo, i.entity. 80 - (statId: 62, default: 95)
        :param float mean_percentile_monte_carlo: mean percentile for monte carlo i.entity. 50- (statId: 62, default: 50)
        :param float min_percentile_monte_carlo: min percentile for monte carlo i.entity. 20 - (statId: 62, default: 5)
        :param int moving_average_n_day: number of days for moving average n-day - (statId: 18, default: 7)
        :param int n_day_returns: number of days for Rolling n-day returns - (statId: 2, default: 7)  
        :param int n_path_monte_carlo: number of points for a simulation- (statId: 62, default: 100)
        :param int n_rolling_max_drawdown: number of days for Rolling n-day max drawdown- (statId: 46, default: 7)
        :param int n_rolling_volatility: number of days for Rolling n-day volatility- (statId: 34, default: 7)
        :param int num_sim_monte_carlo: number of simulations - (statId: 62, default: 1000) 
        :param str period_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in () -Carries out stats on either daily, monthly, annually or quarterly dates (default: 'D')
        :param float risk_free_alpha: risk free val alpha - (statId: 52, default: 0)
        :param float risk_free_sharpe: risk free val sharpe- (statId: 49, default: 0) 
        :param float risk_free_sortino: risk free val sortino - (statId: 56, default: 0)
        :param float risk_free_treynor: risk free val treynor- (statId: 51, default: 0) 
        :param date start_date: Starting parameter for time window
        :param str stat: A stat type - /statistics endpoint
        :param str ticker: Ticker for security
        :param float var_conf_interval: VaR Confidence Interval ( alpha ) i.entity 99, 95, etc - (statId: 40, default: 95)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_id', 'active_premium_period', 'annualized_return_period', 'bench_ticker', 'benchmark_id', 'end_date', 'hist_factor', 'mar_down_side_deviation', 'max_percentile_monte_carlo', 'mean_percentile_monte_carlo', 'min_percentile_monte_carlo', 'moving_average_n_day', 'n_day_returns', 'n_path_monte_carlo', 'n_rolling_max_drawdown', 'n_rolling_volatility', 'num_sim_monte_carlo', 'period_type', 'risk_free_alpha', 'risk_free_sharpe', 'risk_free_sortino', 'risk_free_treynor', 'start_date', 'stat', 'ticker', 'var_conf_interval']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_security_performance_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'security_id' is set
        if ('security_id' not in params or
                params['security_id'] is None):
            raise ValueError("Missing the required parameter `security_id` when calling `get_security_performance_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'security_id' in params:
            path_params['security_id'] = params['security_id']  # noqa: E501

        query_params = []
        if 'active_premium_period' in params:
            query_params.append(('active_premium_period', params['active_premium_period']))  # noqa: E501
        if 'annualized_return_period' in params:
            query_params.append(('annualized_return_period', params['annualized_return_period']))  # noqa: E501
        if 'bench_ticker' in params:
            query_params.append(('benchTicker', params['bench_ticker']))  # noqa: E501
        if 'benchmark_id' in params:
            query_params.append(('benchmark_id', params['benchmark_id']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'hist_factor' in params:
            query_params.append(('hist_factor', params['hist_factor']))  # noqa: E501
        if 'mar_down_side_deviation' in params:
            query_params.append(('mar_down_side_deviation', params['mar_down_side_deviation']))  # noqa: E501
        if 'max_percentile_monte_carlo' in params:
            query_params.append(('max_percentile_monte_carlo', params['max_percentile_monte_carlo']))  # noqa: E501
        if 'mean_percentile_monte_carlo' in params:
            query_params.append(('mean_percentile_monte_carlo', params['mean_percentile_monte_carlo']))  # noqa: E501
        if 'min_percentile_monte_carlo' in params:
            query_params.append(('min_percentile_monte_carlo', params['min_percentile_monte_carlo']))  # noqa: E501
        if 'moving_average_n_day' in params:
            query_params.append(('moving_average_n_day', params['moving_average_n_day']))  # noqa: E501
        if 'n_day_returns' in params:
            query_params.append(('n_day_returns', params['n_day_returns']))  # noqa: E501
        if 'n_path_monte_carlo' in params:
            query_params.append(('n_path_monte_carlo', params['n_path_monte_carlo']))  # noqa: E501
        if 'n_rolling_max_drawdown' in params:
            query_params.append(('n_rolling_max_drawdown', params['n_rolling_max_drawdown']))  # noqa: E501
        if 'n_rolling_volatility' in params:
            query_params.append(('n_rolling_volatility', params['n_rolling_volatility']))  # noqa: E501
        if 'num_sim_monte_carlo' in params:
            query_params.append(('num_sim_monte_carlo', params['num_sim_monte_carlo']))  # noqa: E501
        if 'period_type' in params:
            query_params.append(('period_type', params['period_type']))  # noqa: E501
        if 'risk_free_alpha' in params:
            query_params.append(('risk_free_alpha', params['risk_free_alpha']))  # noqa: E501
        if 'risk_free_sharpe' in params:
            query_params.append(('risk_free_sharpe', params['risk_free_sharpe']))  # noqa: E501
        if 'risk_free_sortino' in params:
            query_params.append(('risk_free_sortino', params['risk_free_sortino']))  # noqa: E501
        if 'risk_free_treynor' in params:
            query_params.append(('risk_free_treynor', params['risk_free_treynor']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'stat' in params:
            query_params.append(('stat', params['stat']))  # noqa: E501
        if 'ticker' in params:
            query_params.append(('ticker', params['ticker']))  # noqa: E501
        if 'var_conf_interval' in params:
            query_params.append(('var_conf_interval', params['var_conf_interval']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/security/{security_id}/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
