# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class OverflowApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_overflow_settings_using_post(self, overflow_settings, **kwargs):  # noqa: E501
        """Create a Overflow Settings request  # noqa: E501

        Create a new Overflow Settings request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_overflow_settings_using_post(overflow_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OverflowSettings overflow_settings: overflowSettings (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_overflow_settings_using_post_with_http_info(overflow_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.create_overflow_settings_using_post_with_http_info(overflow_settings, **kwargs)  # noqa: E501
            return data

    def create_overflow_settings_using_post_with_http_info(self, overflow_settings, **kwargs):  # noqa: E501
        """Create a Overflow Settings request  # noqa: E501

        Create a new Overflow Settings request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_overflow_settings_using_post_with_http_info(overflow_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OverflowSettings overflow_settings: overflowSettings (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_overflow_settings_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_settings' is set
        if ('overflow_settings' not in params or
                params['overflow_settings'] is None):
            raise ValueError("Missing the required parameter `overflow_settings` when calling `create_overflow_settings_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'overflow_settings' in params:
            body_params = params['overflow_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow_setting', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OverflowSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_overflow_using_post(self, overflow_vo, **kwargs):  # noqa: E501
        """Create a Overflow request  # noqa: E501

        Create a new Overflow request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_overflow_using_post(overflow_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OverflowVO overflow_vo: overflowVO (required)
        :return: Overflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_overflow_using_post_with_http_info(overflow_vo, **kwargs)  # noqa: E501
        else:
            (data) = self.create_overflow_using_post_with_http_info(overflow_vo, **kwargs)  # noqa: E501
            return data

    def create_overflow_using_post_with_http_info(self, overflow_vo, **kwargs):  # noqa: E501
        """Create a Overflow request  # noqa: E501

        Create a new Overflow request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_overflow_using_post_with_http_info(overflow_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OverflowVO overflow_vo: overflowVO (required)
        :return: Overflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_vo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_overflow_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_vo' is set
        if ('overflow_vo' not in params or
                params['overflow_vo'] is None):
            raise ValueError("Missing the required parameter `overflow_vo` when calling `create_overflow_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'overflow_vo' in params:
            body_params = params['overflow_vo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Overflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_overflow_settings_using_delete(self, overflow_settings_id, **kwargs):  # noqa: E501
        """Delete a overflow settings  # noqa: E501

        Permanently delete a  overflow settings registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_overflow_settings_using_delete(overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_overflow_settings_using_delete_with_http_info(overflow_settings_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_overflow_settings_using_delete_with_http_info(overflow_settings_id, **kwargs)  # noqa: E501
            return data

    def delete_overflow_settings_using_delete_with_http_info(self, overflow_settings_id, **kwargs):  # noqa: E501
        """Delete a overflow settings  # noqa: E501

        Permanently delete a  overflow settings registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_overflow_settings_using_delete_with_http_info(overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_settings_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_overflow_settings_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_settings_id' is set
        if ('overflow_settings_id' not in params or
                params['overflow_settings_id'] is None):
            raise ValueError("Missing the required parameter `overflow_settings_id` when calling `delete_overflow_settings_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'overflow_settings_id' in params:
            path_params['overflow_settings_id'] = params['overflow_settings_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow_setting/{overflow_settings_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_overflow_all_using_get(self, **kwargs):  # noqa: E501
        """List all overflow objects  # noqa: E501

        Get details for all overflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOverflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_overflow_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_overflow_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_overflow_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all overflow objects  # noqa: E501

        Get details for all overflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOverflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_overflow_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOverflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_overflow_settings_all_using_get(self, **kwargs):  # noqa: E501
        """List all overflow settings  # noqa: E501

        Get details for all overflow setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_settings_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_overflow_settings_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_overflow_settings_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_overflow_settings_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all overflow settings  # noqa: E501

        Get details for all overflow setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_settings_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageOverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_overflow_settings_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow_setting', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageOverflowSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_overflow_settings_using_get(self, overflow_settings_id, **kwargs):  # noqa: E501
        """Retrieve a Overflow Setting  # noqa: E501

        Retrieve the information for a Overflow Settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_settings_using_get(overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_overflow_settings_using_get_with_http_info(overflow_settings_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_overflow_settings_using_get_with_http_info(overflow_settings_id, **kwargs)  # noqa: E501
            return data

    def get_overflow_settings_using_get_with_http_info(self, overflow_settings_id, **kwargs):  # noqa: E501
        """Retrieve a Overflow Setting  # noqa: E501

        Retrieve the information for a Overflow Settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_settings_using_get_with_http_info(overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_settings_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_overflow_settings_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_settings_id' is set
        if ('overflow_settings_id' not in params or
                params['overflow_settings_id'] is None):
            raise ValueError("Missing the required parameter `overflow_settings_id` when calling `get_overflow_settings_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'overflow_settings_id' in params:
            path_params['overflow_settings_id'] = params['overflow_settings_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow_setting/{overflow_settings_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OverflowSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_overflow_using_get(self, overflow_id, **kwargs):  # noqa: E501
        """Retrieve a Overflow object  # noqa: E501

        Retrieve the information for a Overflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_using_get(overflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_id: UUID overflow_id (required)
        :return: Overflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_overflow_using_get_with_http_info(overflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_overflow_using_get_with_http_info(overflow_id, **kwargs)  # noqa: E501
            return data

    def get_overflow_using_get_with_http_info(self, overflow_id, **kwargs):  # noqa: E501
        """Retrieve a Overflow object  # noqa: E501

        Retrieve the information for a Overflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_overflow_using_get_with_http_info(overflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str overflow_id: UUID overflow_id (required)
        :return: Overflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_overflow_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_id' is set
        if ('overflow_id' not in params or
                params['overflow_id'] is None):
            raise ValueError("Missing the required parameter `overflow_id` when calling `get_overflow_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'overflow_id' in params:
            path_params['overflow_id'] = params['overflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow/{overflow_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Overflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_overflow_settings_using_put(self, overflow_settings, overflow_settings_id, **kwargs):  # noqa: E501
        """Update a overflow settings  # noqa: E501

        Update the information for a overflow setting registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_overflow_settings_using_put(overflow_settings, overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object overflow_settings: overflow_settings (required)
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_overflow_settings_using_put_with_http_info(overflow_settings, overflow_settings_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_overflow_settings_using_put_with_http_info(overflow_settings, overflow_settings_id, **kwargs)  # noqa: E501
            return data

    def update_overflow_settings_using_put_with_http_info(self, overflow_settings, overflow_settings_id, **kwargs):  # noqa: E501
        """Update a overflow settings  # noqa: E501

        Update the information for a overflow setting registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_overflow_settings_using_put_with_http_info(overflow_settings, overflow_settings_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object overflow_settings: overflow_settings (required)
        :param str overflow_settings_id: UUID overflow_settings_id (required)
        :return: OverflowSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['overflow_settings', 'overflow_settings_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_overflow_settings_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'overflow_settings' is set
        if ('overflow_settings' not in params or
                params['overflow_settings'] is None):
            raise ValueError("Missing the required parameter `overflow_settings` when calling `update_overflow_settings_using_put`")  # noqa: E501
        # verify the required parameter 'overflow_settings_id' is set
        if ('overflow_settings_id' not in params or
                params['overflow_settings_id'] is None):
            raise ValueError("Missing the required parameter `overflow_settings_id` when calling `update_overflow_settings_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'overflow_settings_id' in params:
            path_params['overflow_settings_id'] = params['overflow_settings_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'overflow_settings' in params:
            body_params = params['overflow_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/overflow_setting/{overflow_settings_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OverflowSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
