# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class NotificationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_notification_client_using_post(self, notification_client, **kwargs):  # noqa: E501
        """Create a Notification Client  # noqa: E501

        Create a new Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_client_using_post(notification_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationClient notification_client: notificationClient (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_client_using_post_with_http_info(notification_client, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_client_using_post_with_http_info(notification_client, **kwargs)  # noqa: E501
            return data

    def create_notification_client_using_post_with_http_info(self, notification_client, **kwargs):  # noqa: E501
        """Create a Notification Client  # noqa: E501

        Create a new Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_client_using_post_with_http_info(notification_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationClient notification_client: notificationClient (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification_client_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_client' is set
        if ('notification_client' not in params or
                params['notification_client'] is None):
            raise ValueError("Missing the required parameter `notification_client` when calling `create_notification_client_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_client' in params:
            body_params = params['notification_client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_client', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_notification_setting_using_post(self, notification_setting, **kwargs):  # noqa: E501
        """Create a Notification Setting  # noqa: E501

        Create a new Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_setting_using_post(notification_setting, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationSetting notification_setting: notificationSetting (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_setting_using_post_with_http_info(notification_setting, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_setting_using_post_with_http_info(notification_setting, **kwargs)  # noqa: E501
            return data

    def create_notification_setting_using_post_with_http_info(self, notification_setting, **kwargs):  # noqa: E501
        """Create a Notification Setting  # noqa: E501

        Create a new Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_setting_using_post_with_http_info(notification_setting, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NotificationSetting notification_setting: notificationSetting (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_setting']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification_setting_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_setting' is set
        if ('notification_setting' not in params or
                params['notification_setting'] is None):
            raise ValueError("Missing the required parameter `notification_setting` when calling `create_notification_setting_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_setting' in params:
            body_params = params['notification_setting']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_setting', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationSetting',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_notification_using_post(self, notification, **kwargs):  # noqa: E501
        """Create a Notification  # noqa: E501

        Create a new Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_using_post(notification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Notification notification: notification (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_notification_using_post_with_http_info(notification, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notification_using_post_with_http_info(notification, **kwargs)  # noqa: E501
            return data

    def create_notification_using_post_with_http_info(self, notification, **kwargs):  # noqa: E501
        """Create a Notification  # noqa: E501

        Create a new Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_notification_using_post_with_http_info(notification, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Notification notification: notification (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification' is set
        if ('notification' not in params or
                params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `create_notification_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification' in params:
            body_params = params['notification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Notification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notification_client_using_delete(self, notification_client_id, **kwargs):  # noqa: E501
        """Delete a Notification Client  # noqa: E501

        Permanently Delete Notification Client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_client_using_delete(notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_client_id: notification_client_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_client_using_delete_with_http_info(notification_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_client_using_delete_with_http_info(notification_client_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_client_using_delete_with_http_info(self, notification_client_id, **kwargs):  # noqa: E501
        """Delete a Notification Client  # noqa: E501

        Permanently Delete Notification Client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_client_using_delete_with_http_info(notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_client_id: notification_client_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification_client_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_client_id' is set
        if ('notification_client_id' not in params or
                params['notification_client_id'] is None):
            raise ValueError("Missing the required parameter `notification_client_id` when calling `delete_notification_client_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_client_id' in params:
            path_params['notification_client_id'] = params['notification_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_client/{notification_client_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notification_setting_using_delete(self, notification_setting_id, **kwargs):  # noqa: E501
        """Delete a Notification Setting  # noqa: E501

        Permanently Delete Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_setting_using_delete(notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_setting_id: notification_setting_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_setting_using_delete_with_http_info(notification_setting_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_setting_using_delete_with_http_info(notification_setting_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_setting_using_delete_with_http_info(self, notification_setting_id, **kwargs):  # noqa: E501
        """Delete a Notification Setting  # noqa: E501

        Permanently Delete Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_setting_using_delete_with_http_info(notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_setting_id: notification_setting_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_setting_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification_setting_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_setting_id' is set
        if ('notification_setting_id' not in params or
                params['notification_setting_id'] is None):
            raise ValueError("Missing the required parameter `notification_setting_id` when calling `delete_notification_setting_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_setting_id' in params:
            path_params['notification_setting_id'] = params['notification_setting_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_setting/{notification_setting_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notification_using_delete(self, notification_id, **kwargs):  # noqa: E501
        """Delete a Notification  # noqa: E501

        Permanently Delete a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_using_delete(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_id: UUID notification_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_notification_using_delete_with_http_info(notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notification_using_delete_with_http_info(notification_id, **kwargs)  # noqa: E501
            return data

    def delete_notification_using_delete_with_http_info(self, notification_id, **kwargs):  # noqa: E501
        """Delete a Notification  # noqa: E501

        Permanently Delete a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_notification_using_delete_with_http_info(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_id: UUID notification_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `delete_notification_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification/{notification_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_all_using_get(self, **kwargs):  # noqa: E501
        """Get All Notifications  # noqa: E501

        Get All Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_notification_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get All Notifications  # noqa: E501

        Get All Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageNotification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_client_all_using_get(self, **kwargs):  # noqa: E501
        """List all Notification Client  # noqa: E501

        List all Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_client_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_client_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_client_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_notification_client_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all Notification Client  # noqa: E501

        List all Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_client_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_client_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_client', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageNotificationClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_client_using_get(self, notification_client_id, **kwargs):  # noqa: E501
        """Retrieve a Notification Client  # noqa: E501

        Retrieve a  Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_client_using_get(notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_client_id: notification_client_id (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_client_using_get_with_http_info(notification_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_client_using_get_with_http_info(notification_client_id, **kwargs)  # noqa: E501
            return data

    def get_notification_client_using_get_with_http_info(self, notification_client_id, **kwargs):  # noqa: E501
        """Retrieve a Notification Client  # noqa: E501

        Retrieve a  Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_client_using_get_with_http_info(notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_client_id: notification_client_id (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_client_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_client_id' is set
        if ('notification_client_id' not in params or
                params['notification_client_id'] is None):
            raise ValueError("Missing the required parameter `notification_client_id` when calling `get_notification_client_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_client_id' in params:
            path_params['notification_client_id'] = params['notification_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_client/{notification_client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_setting_all_using_get(self, **kwargs):  # noqa: E501
        """List all Notification Setting  # noqa: E501

        List all Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_setting_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_setting_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_setting_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_notification_setting_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all Notification Setting  # noqa: E501

        List all Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_setting_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_setting_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_setting', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageNotificationSetting',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_setting_using_get(self, notification_setting_id, **kwargs):  # noqa: E501
        """Retrieve a Notification Setting  # noqa: E501

        Retrieve a  Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_setting_using_get(notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_setting_id: notification_setting_id (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_setting_using_get_with_http_info(notification_setting_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_setting_using_get_with_http_info(notification_setting_id, **kwargs)  # noqa: E501
            return data

    def get_notification_setting_using_get_with_http_info(self, notification_setting_id, **kwargs):  # noqa: E501
        """Retrieve a Notification Setting  # noqa: E501

        Retrieve a  Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_setting_using_get_with_http_info(notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_setting_id: notification_setting_id (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_setting_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_setting_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_setting_id' is set
        if ('notification_setting_id' not in params or
                params['notification_setting_id'] is None):
            raise ValueError("Missing the required parameter `notification_setting_id` when calling `get_notification_setting_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_setting_id' in params:
            path_params['notification_setting_id'] = params['notification_setting_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_setting/{notification_setting_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationSetting',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notification_using_get(self, notification_id, **kwargs):  # noqa: E501
        """Get a Notification  # noqa: E501

        Get a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_using_get(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_id: notification_id (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_notification_using_get_with_http_info(notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notification_using_get_with_http_info(notification_id, **kwargs)  # noqa: E501
            return data

    def get_notification_using_get_with_http_info(self, notification_id, **kwargs):  # noqa: E501
        """Get a Notification  # noqa: E501

        Get a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_notification_using_get_with_http_info(notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str notification_id: notification_id (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `get_notification_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification/{notification_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Notification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_notification_client_using_put(self, notification_client, notification_client_id, **kwargs):  # noqa: E501
        """Update a Notification Client  # noqa: E501

        Update a  Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_client_using_put(notification_client, notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification_client: notification_client (required)
        :param str notification_client_id: UUID notification_client_id (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_notification_client_using_put_with_http_info(notification_client, notification_client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_notification_client_using_put_with_http_info(notification_client, notification_client_id, **kwargs)  # noqa: E501
            return data

    def update_notification_client_using_put_with_http_info(self, notification_client, notification_client_id, **kwargs):  # noqa: E501
        """Update a Notification Client  # noqa: E501

        Update a  Notification Client.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_client_using_put_with_http_info(notification_client, notification_client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification_client: notification_client (required)
        :param str notification_client_id: UUID notification_client_id (required)
        :return: NotificationClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_client', 'notification_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification_client_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_client' is set
        if ('notification_client' not in params or
                params['notification_client'] is None):
            raise ValueError("Missing the required parameter `notification_client` when calling `update_notification_client_using_put`")  # noqa: E501
        # verify the required parameter 'notification_client_id' is set
        if ('notification_client_id' not in params or
                params['notification_client_id'] is None):
            raise ValueError("Missing the required parameter `notification_client_id` when calling `update_notification_client_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_client_id' in params:
            path_params['notification_client_id'] = params['notification_client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_client' in params:
            body_params = params['notification_client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_client/{notification_client_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_notification_setting_using_put(self, notification_setting, notification_setting_id, **kwargs):  # noqa: E501
        """Update a Notification Setting  # noqa: E501

        Update a  Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_setting_using_put(notification_setting, notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification_setting: notification_setting (required)
        :param str notification_setting_id: UUID notification_setting_id (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_notification_setting_using_put_with_http_info(notification_setting, notification_setting_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_notification_setting_using_put_with_http_info(notification_setting, notification_setting_id, **kwargs)  # noqa: E501
            return data

    def update_notification_setting_using_put_with_http_info(self, notification_setting, notification_setting_id, **kwargs):  # noqa: E501
        """Update a Notification Setting  # noqa: E501

        Update a  Notification Setting.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_setting_using_put_with_http_info(notification_setting, notification_setting_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification_setting: notification_setting (required)
        :param str notification_setting_id: UUID notification_setting_id (required)
        :return: NotificationSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification_setting', 'notification_setting_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification_setting_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification_setting' is set
        if ('notification_setting' not in params or
                params['notification_setting'] is None):
            raise ValueError("Missing the required parameter `notification_setting` when calling `update_notification_setting_using_put`")  # noqa: E501
        # verify the required parameter 'notification_setting_id' is set
        if ('notification_setting_id' not in params or
                params['notification_setting_id'] is None):
            raise ValueError("Missing the required parameter `notification_setting_id` when calling `update_notification_setting_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_setting_id' in params:
            path_params['notification_setting_id'] = params['notification_setting_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification_setting' in params:
            body_params = params['notification_setting']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification_setting/{notification_setting_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationSetting',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_notification_using_put(self, notification, notification_id, **kwargs):  # noqa: E501
        """Update a Notification  # noqa: E501

        Update a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_using_put(notification, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification: notification (required)
        :param str notification_id: UUID notification_id (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_notification_using_put_with_http_info(notification, notification_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_notification_using_put_with_http_info(notification, notification_id, **kwargs)  # noqa: E501
            return data

    def update_notification_using_put_with_http_info(self, notification, notification_id, **kwargs):  # noqa: E501
        """Update a Notification  # noqa: E501

        Update a Notification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_notification_using_put_with_http_info(notification, notification_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object notification: notification (required)
        :param str notification_id: UUID notification_id (required)
        :return: Notification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['notification', 'notification_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'notification' is set
        if ('notification' not in params or
                params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `update_notification_using_put`")  # noqa: E501
        # verify the required parameter 'notification_id' is set
        if ('notification_id' not in params or
                params['notification_id'] is None):
            raise ValueError("Missing the required parameter `notification_id` when calling `update_notification_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'notification_id' in params:
            path_params['notification_id'] = params['notification_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'notification' in params:
            body_params = params['notification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/notification/{notification_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Notification',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
