# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class ModelApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_model_asset_size_using_post(self, req, **kwargs):  # noqa: E501
        """Create a model asset size  # noqa: E501

        Create a new asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_asset_size_using_post(req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelAssetSize req: req (required)
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_asset_size_using_post_with_http_info(req, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_asset_size_using_post_with_http_info(req, **kwargs)  # noqa: E501
            return data

    def create_model_asset_size_using_post_with_http_info(self, req, **kwargs):  # noqa: E501
        """Create a model asset size  # noqa: E501

        Create a new asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_asset_size_using_post_with_http_info(req, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelAssetSize req: req (required)
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['req']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_asset_size_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'req' is set
        if ('req' not in params or
                params['req'] is None):
            raise ValueError("Missing the required parameter `req` when calling `create_model_asset_size_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'req' in params:
            body_params = params['req']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_asset_size', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssetSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_model_change_using_post(self, change_request, model_id, **kwargs):  # noqa: E501
        """Change a model composition  # noqa: E501

        Model composition changes represent a change in a model’s holdings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_change_using_post(change_request, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderReconcileRequest change_request: changeRequest (required)
        :param str model_id: UUID model_id (required)
        :return: list[ModelTransaction]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_change_using_post_with_http_info(change_request, model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_change_using_post_with_http_info(change_request, model_id, **kwargs)  # noqa: E501
            return data

    def create_model_change_using_post_with_http_info(self, change_request, model_id, **kwargs):  # noqa: E501
        """Change a model composition  # noqa: E501

        Model composition changes represent a change in a model’s holdings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_change_using_post_with_http_info(change_request, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrderReconcileRequest change_request: changeRequest (required)
        :param str model_id: UUID model_id (required)
        :return: list[ModelTransaction]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['change_request', 'model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_change_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'change_request' is set
        if ('change_request' not in params or
                params['change_request'] is None):
            raise ValueError("Missing the required parameter `change_request` when calling `create_model_change_using_post`")  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `create_model_change_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['model_id'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_request' in params:
            body_params = params['change_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model/{model_id}/model_change', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ModelTransaction]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_model_comment_using_post(self, model_comment_request, **kwargs):  # noqa: E501
        """Create a model commentary  # noqa: E501

        Create a new comment for a model available for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_comment_using_post(model_comment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelComment model_comment_request: modelCommentRequest (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_comment_using_post_with_http_info(model_comment_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_comment_using_post_with_http_info(model_comment_request, **kwargs)  # noqa: E501
            return data

    def create_model_comment_using_post_with_http_info(self, model_comment_request, **kwargs):  # noqa: E501
        """Create a model commentary  # noqa: E501

        Create a new comment for a model available for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_comment_using_post_with_http_info(model_comment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelComment model_comment_request: modelCommentRequest (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_comment_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_comment_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_comment_request' is set
        if ('model_comment_request' not in params or
                params['model_comment_request'] is None):
            raise ValueError("Missing the required parameter `model_comment_request` when calling `create_model_comment_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_comment_request' in params:
            body_params = params['model_comment_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_comment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_model_holding_using_post(self, model_holding_request, **kwargs):  # noqa: E501
        """Create a model holding  # noqa: E501

        Create a new model holding record for a specific model and date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_holding_using_post(model_holding_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelHolding model_holding_request: modelHoldingRequest (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_holding_using_post_with_http_info(model_holding_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_holding_using_post_with_http_info(model_holding_request, **kwargs)  # noqa: E501
            return data

    def create_model_holding_using_post_with_http_info(self, model_holding_request, **kwargs):  # noqa: E501
        """Create a model holding  # noqa: E501

        Create a new model holding record for a specific model and date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_holding_using_post_with_http_info(model_holding_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelHolding model_holding_request: modelHoldingRequest (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_holding_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_holding_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_holding_request' is set
        if ('model_holding_request' not in params or
                params['model_holding_request'] is None):
            raise ValueError("Missing the required parameter `model_holding_request` when calling `create_model_holding_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_holding_request' in params:
            body_params = params['model_holding_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_holding', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelHolding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_model_transaction_using_post(self, model_transaction_request, **kwargs):  # noqa: E501
        """Create a model transaction  # noqa: E501

        Create a new transaction record for a security under a model for a specific date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_transaction_using_post(model_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelTransaction model_transaction_request: modelTransactionRequest (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_transaction_using_post_with_http_info(model_transaction_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_transaction_using_post_with_http_info(model_transaction_request, **kwargs)  # noqa: E501
            return data

    def create_model_transaction_using_post_with_http_info(self, model_transaction_request, **kwargs):  # noqa: E501
        """Create a model transaction  # noqa: E501

        Create a new transaction record for a security under a model for a specific date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_transaction_using_post_with_http_info(model_transaction_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelTransaction model_transaction_request: modelTransactionRequest (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_transaction_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_transaction_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_transaction_request' is set
        if ('model_transaction_request' not in params or
                params['model_transaction_request'] is None):
            raise ValueError("Missing the required parameter `model_transaction_request` when calling `create_model_transaction_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_transaction_request' in params:
            body_params = params['model_transaction_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_transaction', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_model_using_post(self, model_info_request, **kwargs):  # noqa: E501
        """Create a model  # noqa: E501

        Create a new model for your firm to which a portfolios can later subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_using_post(model_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Model model_info_request: modelInfoRequest (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_model_using_post_with_http_info(model_info_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_model_using_post_with_http_info(model_info_request, **kwargs)  # noqa: E501
            return data

    def create_model_using_post_with_http_info(self, model_info_request, **kwargs):  # noqa: E501
        """Create a model  # noqa: E501

        Create a new model for your firm to which a portfolios can later subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_model_using_post_with_http_info(model_info_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Model model_info_request: modelInfoRequest (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_info_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_model_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_info_request' is set
        if ('model_info_request' not in params or
                params['model_info_request'] is None):
            raise ValueError("Missing the required parameter `model_info_request` when calling `create_model_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_info_request' in params:
            body_params = params['model_info_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Model',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model_asset_size_using_delete(self, model_asset_size_id, **kwargs):  # noqa: E501
        """Delete a model asset size  # noqa: E501

        Permanently delete a model asset size record for a model.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_asset_size_using_delete(model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_asset_size_using_delete_with_http_info(model_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_asset_size_using_delete_with_http_info(model_asset_size_id, **kwargs)  # noqa: E501
            return data

    def delete_model_asset_size_using_delete_with_http_info(self, model_asset_size_id, **kwargs):  # noqa: E501
        """Delete a model asset size  # noqa: E501

        Permanently delete a model asset size record for a model.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_asset_size_using_delete_with_http_info(model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_asset_size_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model_asset_size_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_asset_size_id' is set
        if ('model_asset_size_id' not in params or
                params['model_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `model_asset_size_id` when calling `delete_model_asset_size_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_asset_size_id' in params:
            path_params['model_asset_size_id'] = params['model_asset_size_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_asset_size/{model_asset_size_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model_comment_using_delete(self, model_comment_id, **kwargs):  # noqa: E501
        """Delete a model commentary  # noqa: E501

        Permanently delete a model comment for a model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_comment_using_delete(model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_comment_id: UUID model_comment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_comment_using_delete_with_http_info(model_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_comment_using_delete_with_http_info(model_comment_id, **kwargs)  # noqa: E501
            return data

    def delete_model_comment_using_delete_with_http_info(self, model_comment_id, **kwargs):  # noqa: E501
        """Delete a model commentary  # noqa: E501

        Permanently delete a model comment for a model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_comment_using_delete_with_http_info(model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_comment_id: UUID model_comment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model_comment_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_comment_id' is set
        if ('model_comment_id' not in params or
                params['model_comment_id'] is None):
            raise ValueError("Missing the required parameter `model_comment_id` when calling `delete_model_comment_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_comment_id' in params:
            path_params['model_comment_id'] = params['model_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_comment/{model_comment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model_holding_using_delete(self, model_holding_id, **kwargs):  # noqa: E501
        """Delete a model holding  # noqa: E501

        Permanently delete a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_holding_using_delete(model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_holding_id: UUID model_holding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_holding_using_delete_with_http_info(model_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_holding_using_delete_with_http_info(model_holding_id, **kwargs)  # noqa: E501
            return data

    def delete_model_holding_using_delete_with_http_info(self, model_holding_id, **kwargs):  # noqa: E501
        """Delete a model holding  # noqa: E501

        Permanently delete a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_holding_using_delete_with_http_info(model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_holding_id: UUID model_holding_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_holding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model_holding_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_holding_id' is set
        if ('model_holding_id' not in params or
                params['model_holding_id'] is None):
            raise ValueError("Missing the required parameter `model_holding_id` when calling `delete_model_holding_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_holding_id' in params:
            path_params['model_holding_id'] = params['model_holding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_holding/{model_holding_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model_transaction_using_delete(self, model_transaction_id, **kwargs):  # noqa: E501
        """Delete a model transaction  # noqa: E501

        Permanently delete a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_transaction_using_delete(model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_transaction_using_delete_with_http_info(model_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_transaction_using_delete_with_http_info(model_transaction_id, **kwargs)  # noqa: E501
            return data

    def delete_model_transaction_using_delete_with_http_info(self, model_transaction_id, **kwargs):  # noqa: E501
        """Delete a model transaction  # noqa: E501

        Permanently delete a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_transaction_using_delete_with_http_info(model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model_transaction_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_transaction_id' is set
        if ('model_transaction_id' not in params or
                params['model_transaction_id'] is None):
            raise ValueError("Missing the required parameter `model_transaction_id` when calling `delete_model_transaction_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_transaction_id' in params:
            path_params['model_transaction_id'] = params['model_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_transaction/{model_transaction_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_model_using_delete(self, model_id, **kwargs):  # noqa: E501
        """Delete a model  # noqa: E501

        Permanently delete a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_using_delete(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: UUID model_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_model_using_delete_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_model_using_delete_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def delete_model_using_delete_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Delete a model  # noqa: E501

        Permanently delete a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_model_using_delete_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: UUID model_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_model_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `delete_model_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['model_id'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model/{model_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_all_using_get(self, **kwargs):  # noqa: E501
        """List all models  # noqa: E501

        Get details for all models defined for your firm to which portfolios can subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all models  # noqa: E501

        Get details for all models defined for your firm to which portfolios can subscribe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_asset_size_all_using_get(self, **kwargs):  # noqa: E501
        """List all model asset sizes  # noqa: E501

        Get a list of asset sizes per date for all models defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_asset_size_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_asset_size_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all model asset sizes  # noqa: E501

        Get a list of asset sizes per date for all models defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_asset_size_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_asset_size_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModelAssetSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_asset_size_using_get(self, model_asset_size_id, **kwargs):  # noqa: E501
        """Retrieve a model asset size  # noqa: E501

        Retrieve the information for a model asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_asset_size_using_get(model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :param str currency_conversion: USD
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_asset_size_using_get_with_http_info(model_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_asset_size_using_get_with_http_info(model_asset_size_id, **kwargs)  # noqa: E501
            return data

    def get_model_asset_size_using_get_with_http_info(self, model_asset_size_id, **kwargs):  # noqa: E501
        """Retrieve a model asset size  # noqa: E501

        Retrieve the information for a model asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_asset_size_using_get_with_http_info(model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :param str currency_conversion: USD
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_asset_size_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_asset_size_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_asset_size_id' is set
        if ('model_asset_size_id' not in params or
                params['model_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `model_asset_size_id` when calling `get_model_asset_size_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_asset_size_id' in params:
            path_params['model_asset_size_id'] = params['model_asset_size_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_asset_size/{model_asset_size_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssetSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_comment_all_using_get(self, **kwargs):  # noqa: E501
        """List all model commentaries  # noqa: E501

        List all comments for all models defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_comment_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_comment_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_comment_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_comment_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all model commentaries  # noqa: E501

        List all comments for all models defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_comment_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_comment_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_comment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModelComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_comment_using_get(self, model_comment_id, **kwargs):  # noqa: E501
        """Retrieve a model commentary  # noqa: E501

        Retrieve the information for a model comment for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_comment_using_get(model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_comment_id: UUID model_comment_id (required)
        :return: ModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_comment_using_get_with_http_info(model_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_comment_using_get_with_http_info(model_comment_id, **kwargs)  # noqa: E501
            return data

    def get_model_comment_using_get_with_http_info(self, model_comment_id, **kwargs):  # noqa: E501
        """Retrieve a model commentary  # noqa: E501

        Retrieve the information for a model comment for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_comment_using_get_with_http_info(model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_comment_id: UUID model_comment_id (required)
        :return: ModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_comment_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_comment_id' is set
        if ('model_comment_id' not in params or
                params['model_comment_id'] is None):
            raise ValueError("Missing the required parameter `model_comment_id` when calling `get_model_comment_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_comment_id' in params:
            path_params['model_comment_id'] = params['model_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_comment/{model_comment_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_holding_all_using_get(self, **kwargs):  # noqa: E501
        """List all model holdings  # noqa: E501

        Get all model holding records for all models defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_holding_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_holding_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_holding_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_holding_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all model holdings  # noqa: E501

        Get all model holding records for all models defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_holding_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_holding_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModelHolding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_holding_using_get(self, model_holding_id, **kwargs):  # noqa: E501
        """Retrieve a model holding  # noqa: E501

        Retrieve the information for a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_holding_using_get(model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_holding_id: UUID model_holding_id (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_holding_using_get_with_http_info(model_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_holding_using_get_with_http_info(model_holding_id, **kwargs)  # noqa: E501
            return data

    def get_model_holding_using_get_with_http_info(self, model_holding_id, **kwargs):  # noqa: E501
        """Retrieve a model holding  # noqa: E501

        Retrieve the information for a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_holding_using_get_with_http_info(model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_holding_id: UUID model_holding_id (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_holding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_holding_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_holding_id' is set
        if ('model_holding_id' not in params or
                params['model_holding_id'] is None):
            raise ValueError("Missing the required parameter `model_holding_id` when calling `get_model_holding_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_holding_id' in params:
            path_params['model_holding_id'] = params['model_holding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_holding/{model_holding_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelHolding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_transaction_all_using_get(self, **kwargs):  # noqa: E501
        """List all model transactions  # noqa: E501

        Get details for all transaction records for all models defined by your firm.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_transaction_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_model_transaction_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_model_transaction_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all model transactions  # noqa: E501

        Get details for all transaction records for all models defined by your firm.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_transaction_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageModelTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_transaction_using_get(self, model_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a model transaction  # noqa: E501

        Retrieve the information for a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_transaction_using_get(model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_transaction_using_get_with_http_info(model_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_transaction_using_get_with_http_info(model_transaction_id, **kwargs)  # noqa: E501
            return data

    def get_model_transaction_using_get_with_http_info(self, model_transaction_id, **kwargs):  # noqa: E501
        """Retrieve a model transaction  # noqa: E501

        Retrieve the information for a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_transaction_using_get_with_http_info(model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_transaction_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_transaction_id' is set
        if ('model_transaction_id' not in params or
                params['model_transaction_id'] is None):
            raise ValueError("Missing the required parameter `model_transaction_id` when calling `get_model_transaction_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_transaction_id' in params:
            path_params['model_transaction_id'] = params['model_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_transaction/{model_transaction_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_using_get(self, model_id, **kwargs):  # noqa: E501
        """Retrieve a model  # noqa: E501

        Get the information for a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_using_get(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: UUID model_id (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_using_get_with_http_info(model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_using_get_with_http_info(model_id, **kwargs)  # noqa: E501
            return data

    def get_model_using_get_with_http_info(self, model_id, **kwargs):  # noqa: E501
        """Retrieve a model  # noqa: E501

        Get the information for a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_using_get_with_http_info(model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id: UUID model_id (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `get_model_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['model_id'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model/{model_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Model',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model_asset_size_using_put(self, model_asset_size, model_asset_size_id, **kwargs):  # noqa: E501
        """Update a model asset size  # noqa: E501

        Update a model asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_asset_size_using_put(model_asset_size, model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_asset_size: model_asset_size (required)
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_asset_size_using_put_with_http_info(model_asset_size, model_asset_size_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_asset_size_using_put_with_http_info(model_asset_size, model_asset_size_id, **kwargs)  # noqa: E501
            return data

    def update_model_asset_size_using_put_with_http_info(self, model_asset_size, model_asset_size_id, **kwargs):  # noqa: E501
        """Update a model asset size  # noqa: E501

        Update a model asset size record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_asset_size_using_put_with_http_info(model_asset_size, model_asset_size_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_asset_size: model_asset_size (required)
        :param str model_asset_size_id: UUID model_asset_size_id (required)
        :return: ModelAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_asset_size', 'model_asset_size_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model_asset_size_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_asset_size' is set
        if ('model_asset_size' not in params or
                params['model_asset_size'] is None):
            raise ValueError("Missing the required parameter `model_asset_size` when calling `update_model_asset_size_using_put`")  # noqa: E501
        # verify the required parameter 'model_asset_size_id' is set
        if ('model_asset_size_id' not in params or
                params['model_asset_size_id'] is None):
            raise ValueError("Missing the required parameter `model_asset_size_id` when calling `update_model_asset_size_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_asset_size_id' in params:
            path_params['model_asset_size_id'] = params['model_asset_size_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_asset_size' in params:
            body_params = params['model_asset_size']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_asset_size/{model_asset_size_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelAssetSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model_comment_using_put(self, model_comment, model_comment_id, **kwargs):  # noqa: E501
        """Update a model commentary  # noqa: E501

        Update a model comment for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_comment_using_put(model_comment, model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_comment: model_comment (required)
        :param str model_comment_id: UUID model_comment_id (required)
        :return: ModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_comment_using_put_with_http_info(model_comment, model_comment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_comment_using_put_with_http_info(model_comment, model_comment_id, **kwargs)  # noqa: E501
            return data

    def update_model_comment_using_put_with_http_info(self, model_comment, model_comment_id, **kwargs):  # noqa: E501
        """Update a model commentary  # noqa: E501

        Update a model comment for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_comment_using_put_with_http_info(model_comment, model_comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_comment: model_comment (required)
        :param str model_comment_id: UUID model_comment_id (required)
        :return: ModelComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_comment', 'model_comment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model_comment_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_comment' is set
        if ('model_comment' not in params or
                params['model_comment'] is None):
            raise ValueError("Missing the required parameter `model_comment` when calling `update_model_comment_using_put`")  # noqa: E501
        # verify the required parameter 'model_comment_id' is set
        if ('model_comment_id' not in params or
                params['model_comment_id'] is None):
            raise ValueError("Missing the required parameter `model_comment_id` when calling `update_model_comment_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_comment_id' in params:
            path_params['model_comment_id'] = params['model_comment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_comment' in params:
            body_params = params['model_comment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_comment/{model_comment_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelComment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model_holding_using_put(self, model_holding, model_holding_id, **kwargs):  # noqa: E501
        """Update a model holding  # noqa: E501

        Update a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_holding_using_put(model_holding, model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_holding: model_holding (required)
        :param str model_holding_id: UUID model_holding_id (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_holding_using_put_with_http_info(model_holding, model_holding_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_holding_using_put_with_http_info(model_holding, model_holding_id, **kwargs)  # noqa: E501
            return data

    def update_model_holding_using_put_with_http_info(self, model_holding, model_holding_id, **kwargs):  # noqa: E501
        """Update a model holding  # noqa: E501

        Update a model holding record for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_holding_using_put_with_http_info(model_holding, model_holding_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_holding: model_holding (required)
        :param str model_holding_id: UUID model_holding_id (required)
        :return: ModelHolding
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_holding', 'model_holding_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model_holding_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_holding' is set
        if ('model_holding' not in params or
                params['model_holding'] is None):
            raise ValueError("Missing the required parameter `model_holding` when calling `update_model_holding_using_put`")  # noqa: E501
        # verify the required parameter 'model_holding_id' is set
        if ('model_holding_id' not in params or
                params['model_holding_id'] is None):
            raise ValueError("Missing the required parameter `model_holding_id` when calling `update_model_holding_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_holding_id' in params:
            path_params['model_holding_id'] = params['model_holding_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_holding' in params:
            body_params = params['model_holding']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_holding/{model_holding_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelHolding',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model_transaction_using_put(self, model_transaction, model_transaction_id, **kwargs):  # noqa: E501
        """Update a model transaction  # noqa: E501

        Update a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_transaction_using_put(model_transaction, model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_transaction: model_transaction (required)
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_transaction_using_put_with_http_info(model_transaction, model_transaction_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_transaction_using_put_with_http_info(model_transaction, model_transaction_id, **kwargs)  # noqa: E501
            return data

    def update_model_transaction_using_put_with_http_info(self, model_transaction, model_transaction_id, **kwargs):  # noqa: E501
        """Update a model transaction  # noqa: E501

        Update a model transaction for a model.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_transaction_using_put_with_http_info(model_transaction, model_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model_transaction: model_transaction (required)
        :param str model_transaction_id: UUID model_transaction_id (required)
        :return: ModelTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_transaction', 'model_transaction_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model_transaction_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_transaction' is set
        if ('model_transaction' not in params or
                params['model_transaction'] is None):
            raise ValueError("Missing the required parameter `model_transaction` when calling `update_model_transaction_using_put`")  # noqa: E501
        # verify the required parameter 'model_transaction_id' is set
        if ('model_transaction_id' not in params or
                params['model_transaction_id'] is None):
            raise ValueError("Missing the required parameter `model_transaction_id` when calling `update_model_transaction_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_transaction_id' in params:
            path_params['model_transaction_id'] = params['model_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model_transaction' in params:
            body_params = params['model_transaction']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model_transaction/{model_transaction_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ModelTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_model_using_put(self, model, model_id, **kwargs):  # noqa: E501
        """Update a model  # noqa: E501

        Update a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_using_put(model, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model: model (required)
        :param str model_id: UUID model_id (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_model_using_put_with_http_info(model, model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_model_using_put_with_http_info(model, model_id, **kwargs)  # noqa: E501
            return data

    def update_model_using_put_with_http_info(self, model, model_id, **kwargs):  # noqa: E501
        """Update a model  # noqa: E501

        Update a model for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_model_using_put_with_http_info(model, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object model: model (required)
        :param str model_id: UUID model_id (required)
        :return: Model
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model', 'model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_model_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model' is set
        if ('model' not in params or
                params['model'] is None):
            raise ValueError("Missing the required parameter `model` when calling `update_model_using_put`")  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or
                params['model_id'] is None):
            raise ValueError("Missing the required parameter `model_id` when calling `update_model_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id' in params:
            path_params['model_id'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'model' in params:
            body_params = params['model']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/model/{model_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Model',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
