# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class InvoiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_invoice_payment_using_post(self, invoice_payment, **kwargs):  # noqa: E501
        """Create a invoicePayment  # noqa: E501

        Create a new invoicePayment, for tracking invoice status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_payment_using_post(invoice_payment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoicePayment invoice_payment: invoicePayment (required)
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_invoice_payment_using_post_with_http_info(invoice_payment, **kwargs)  # noqa: E501
        else:
            (data) = self.create_invoice_payment_using_post_with_http_info(invoice_payment, **kwargs)  # noqa: E501
            return data

    def create_invoice_payment_using_post_with_http_info(self, invoice_payment, **kwargs):  # noqa: E501
        """Create a invoicePayment  # noqa: E501

        Create a new invoicePayment, for tracking invoice status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_payment_using_post_with_http_info(invoice_payment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InvoicePayment invoice_payment: invoicePayment (required)
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_payment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_invoice_payment_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_payment' is set
        if ('invoice_payment' not in params or
                params['invoice_payment'] is None):
            raise ValueError("Missing the required parameter `invoice_payment` when calling `create_invoice_payment_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice_payment' in params:
            body_params = params['invoice_payment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice_payment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvoicePayment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_invoice_using_post(self, invoice, **kwargs):  # noqa: E501
        """Create a invoice  # noqa: E501

        Create a new invoice, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_using_post(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Invoice invoice: invoice (required)
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_invoice_using_post_with_http_info(invoice, **kwargs)  # noqa: E501
        else:
            (data) = self.create_invoice_using_post_with_http_info(invoice, **kwargs)  # noqa: E501
            return data

    def create_invoice_using_post_with_http_info(self, invoice, **kwargs):  # noqa: E501
        """Create a invoice  # noqa: E501

        Create a new invoice, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_invoice_using_post_with_http_info(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Invoice invoice: invoice (required)
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_invoice_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice' is set
        if ('invoice' not in params or
                params['invoice'] is None):
            raise ValueError("Missing the required parameter `invoice` when calling `create_invoice_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice' in params:
            body_params = params['invoice']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_invoice_payment_using_delete(self, invoice_payment_id, **kwargs):  # noqa: E501
        """Delete a invoicePayment  # noqa: E501

        Delete a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_payment_using_delete(invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_invoice_payment_using_delete_with_http_info(invoice_payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_invoice_payment_using_delete_with_http_info(invoice_payment_id, **kwargs)  # noqa: E501
            return data

    def delete_invoice_payment_using_delete_with_http_info(self, invoice_payment_id, **kwargs):  # noqa: E501
        """Delete a invoicePayment  # noqa: E501

        Delete a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_payment_using_delete_with_http_info(invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_payment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_invoice_payment_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_payment_id' is set
        if ('invoice_payment_id' not in params or
                params['invoice_payment_id'] is None):
            raise ValueError("Missing the required parameter `invoice_payment_id` when calling `delete_invoice_payment_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_payment_id' in params:
            path_params['invoice_payment_id'] = params['invoice_payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice_payment/{invoice_payment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_invoice_using_delete(self, invoice_id, **kwargs):  # noqa: E501
        """Delete a invoice  # noqa: E501

        Delete a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_using_delete(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: UUID invoice_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_invoice_using_delete_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_invoice_using_delete_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def delete_invoice_using_delete_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Delete a invoice  # noqa: E501

        Delete a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_invoice_using_delete_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: UUID invoice_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_invoice_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `delete_invoice_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoice_id'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice/{invoice_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_all_using_get(self, **kwargs):  # noqa: E501
        """List all invoices  # noqa: E501

        List all invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInvoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_invoice_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all invoices  # noqa: E501

        List all invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInvoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageInvoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_payment_all_using_get(self, **kwargs):  # noqa: E501
        """List all invoice payments  # noqa: E501

        List all invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_payment_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_payment_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_payment_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_invoice_payment_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all invoice payments  # noqa: E501

        List all invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_payment_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageInvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'currency_conversion', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_payment_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice_payment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageInvoicePayment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_payment_using_get(self, invoice_payment_id, **kwargs):  # noqa: E501
        """Retrieve a invoicePayment  # noqa: E501

        Retrieve a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_payment_using_get(invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :param str currency_conversion: USD
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_payment_using_get_with_http_info(invoice_payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_payment_using_get_with_http_info(invoice_payment_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_payment_using_get_with_http_info(self, invoice_payment_id, **kwargs):  # noqa: E501
        """Retrieve a invoicePayment  # noqa: E501

        Retrieve a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_payment_using_get_with_http_info(invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :param str currency_conversion: USD
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_payment_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_payment_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_payment_id' is set
        if ('invoice_payment_id' not in params or
                params['invoice_payment_id'] is None):
            raise ValueError("Missing the required parameter `invoice_payment_id` when calling `get_invoice_payment_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_payment_id' in params:
            path_params['invoice_payment_id'] = params['invoice_payment_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice_payment/{invoice_payment_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvoicePayment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_using_get(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve a invoice  # noqa: E501

        Retrieve a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_using_get(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: UUID invoice_idd (required)
        :param str currency_conversion: USD
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_invoice_using_get_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_invoice_using_get_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_invoice_using_get_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Retrieve a invoice  # noqa: E501

        Retrieve a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_using_get_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str invoice_id: UUID invoice_idd (required)
        :param str currency_conversion: USD
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id', 'currency_conversion']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_invoice_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoice_id'] = params['invoice_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice/{invoice_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_invoice_payment_using_put(self, invoice_payment, invoice_payment_id, **kwargs):  # noqa: E501
        """Update a invoicePayment  # noqa: E501

        Update a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice_payment_using_put(invoice_payment, invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object invoice_payment: invoice_payment (required)
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_invoice_payment_using_put_with_http_info(invoice_payment, invoice_payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_invoice_payment_using_put_with_http_info(invoice_payment, invoice_payment_id, **kwargs)  # noqa: E501
            return data

    def update_invoice_payment_using_put_with_http_info(self, invoice_payment, invoice_payment_id, **kwargs):  # noqa: E501
        """Update a invoicePayment  # noqa: E501

        Update a invoicePayment.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice_payment_using_put_with_http_info(invoice_payment, invoice_payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object invoice_payment: invoice_payment (required)
        :param str invoice_payment_id: UUID invoice_payment_id (required)
        :return: InvoicePayment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_payment', 'invoice_payment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_invoice_payment_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_payment' is set
        if ('invoice_payment' not in params or
                params['invoice_payment'] is None):
            raise ValueError("Missing the required parameter `invoice_payment` when calling `update_invoice_payment_using_put`")  # noqa: E501
        # verify the required parameter 'invoice_payment_id' is set
        if ('invoice_payment_id' not in params or
                params['invoice_payment_id'] is None):
            raise ValueError("Missing the required parameter `invoice_payment_id` when calling `update_invoice_payment_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_payment_id' in params:
            path_params['invoice_payment_id'] = params['invoice_payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice_payment' in params:
            body_params = params['invoice_payment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice_payment/{invoice_payment_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvoicePayment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_invoice_using_put(self, invoice, invoice_id, **kwargs):  # noqa: E501
        """Update a invoice  # noqa: E501

        Update a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice_using_put(invoice, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object invoice: invoice (required)
        :param str invoice_id: UUID invoice_id (required)
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_invoice_using_put_with_http_info(invoice, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_invoice_using_put_with_http_info(invoice, invoice_id, **kwargs)  # noqa: E501
            return data

    def update_invoice_using_put_with_http_info(self, invoice, invoice_id, **kwargs):  # noqa: E501
        """Update a invoice  # noqa: E501

        Update a invoice.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_invoice_using_put_with_http_info(invoice, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object invoice: invoice (required)
        :param str invoice_id: UUID invoice_id (required)
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice', 'invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_invoice_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice' is set
        if ('invoice' not in params or
                params['invoice'] is None):
            raise ValueError("Missing the required parameter `invoice` when calling `update_invoice_using_put`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `update_invoice_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoice_id'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice' in params:
            body_params = params['invoice']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/invoice/{invoice_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
