# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class GoalApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_goal_track_using_post(self, goal_track, **kwargs):  # noqa: E501
        """Create a goal track record  # noqa: E501

        Create a goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_goal_track_using_post(goal_track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalTrack goal_track: goalTrack (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_goal_track_using_post_with_http_info(goal_track, **kwargs)  # noqa: E501
        else:
            (data) = self.create_goal_track_using_post_with_http_info(goal_track, **kwargs)  # noqa: E501
            return data

    def create_goal_track_using_post_with_http_info(self, goal_track, **kwargs):  # noqa: E501
        """Create a goal track record  # noqa: E501

        Create a goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_goal_track_using_post_with_http_info(goal_track, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GoalTrack goal_track: goalTrack (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_track']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_goal_track_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_track' is set
        if ('goal_track' not in params or
                params['goal_track'] is None):
            raise ValueError("Missing the required parameter `goal_track` when calling `create_goal_track_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'goal_track' in params:
            body_params = params['goal_track']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_track', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_goal_using_post(self, goal_request, **kwargs):  # noqa: E501
        """Create a goal  # noqa: E501

        Create a new goal for your firm that clients can customize for themselves.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_goal_using_post(goal_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Goal goal_request: goalRequest (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_goal_using_post_with_http_info(goal_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_goal_using_post_with_http_info(goal_request, **kwargs)  # noqa: E501
            return data

    def create_goal_using_post_with_http_info(self, goal_request, **kwargs):  # noqa: E501
        """Create a goal  # noqa: E501

        Create a new goal for your firm that clients can customize for themselves.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_goal_using_post_with_http_info(goal_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Goal goal_request: goalRequest (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_goal_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_request' is set
        if ('goal_request' not in params or
                params['goal_request'] is None):
            raise ValueError("Missing the required parameter `goal_request` when calling `create_goal_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'goal_request' in params:
            body_params = params['goal_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Goal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_goal_track_using_delete(self, goal_track_id, **kwargs):  # noqa: E501
        """Delete a goal track record  # noqa: E501

        Permanently delete an goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_goal_track_using_delete(goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_track_id: UUID goal_track_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_goal_track_using_delete_with_http_info(goal_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_goal_track_using_delete_with_http_info(goal_track_id, **kwargs)  # noqa: E501
            return data

    def delete_goal_track_using_delete_with_http_info(self, goal_track_id, **kwargs):  # noqa: E501
        """Delete a goal track record  # noqa: E501

        Permanently delete an goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_goal_track_using_delete_with_http_info(goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_track_id: UUID goal_track_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_goal_track_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_track_id' is set
        if ('goal_track_id' not in params or
                params['goal_track_id'] is None):
            raise ValueError("Missing the required parameter `goal_track_id` when calling `delete_goal_track_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_track_id' in params:
            path_params['goal_track_id'] = params['goal_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_track/{goal_track_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_goal_using_delete(self, goal_id, **kwargs):  # noqa: E501
        """Delete a goal  # noqa: E501

        Permanently delete a goal for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_goal_using_delete(goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_id: UUID goal_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_goal_using_delete_with_http_info(goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_goal_using_delete_with_http_info(goal_id, **kwargs)  # noqa: E501
            return data

    def delete_goal_using_delete_with_http_info(self, goal_id, **kwargs):  # noqa: E501
        """Delete a goal  # noqa: E501

        Permanently delete a goal for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_goal_using_delete_with_http_info(goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_id: UUID goal_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_goal_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `delete_goal_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_all_using_get(self, **kwargs):  # noqa: E501
        """List all goals  # noqa: E501

        Get the details for all goals defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_goal_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all goals  # noqa: E501

        Get the details for all goals defined by your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageGoal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageGoal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_asset_size_all_using_get(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal asset sizes  # noqa: E501

        Get a list of asset sizes per date for a goal for a specified client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_asset_size_all_using_get(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool get_latest: get_latest
        :param bool portfolio_goal: portfolio_goal
        :param str sort_type: sort_type
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_asset_size_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_asset_size_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
            return data

    def get_goal_asset_size_all_using_get_with_http_info(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal asset sizes  # noqa: E501

        Get a list of asset sizes per date for a goal for a specified client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_asset_size_all_using_get_with_http_info(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool get_latest: get_latest
        :param bool portfolio_goal: portfolio_goal
        :param str sort_type: sort_type
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'goal_id', 'currency_conversion', 'end_date', 'get_latest', 'portfolio_goal', 'sort_type', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_asset_size_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_goal_asset_size_all_using_get`")  # noqa: E501
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `get_goal_asset_size_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []
        if 'client_id' in params:
            query_params.append(('client_id', params['client_id']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'portfolio_goal' in params:
            query_params.append(('portfolio_goal', params['portfolio_goal']))  # noqa: E501
        if 'sort_type' in params:
            query_params.append(('sort_type', params['sort_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}/asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableDateDoubleVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_holding_all_using_get(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal holdings  # noqa: E501

        Get the information for all the securities that are currently being held in portfolios associated with a particular goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_holding_all_using_get(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool portfolio_goal: portfolio_goal
        :param date start_date: start date
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_holding_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_holding_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
            return data

    def get_goal_holding_all_using_get_with_http_info(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal holdings  # noqa: E501

        Get the information for all the securities that are currently being held in portfolios associated with a particular goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_holding_all_using_get_with_http_info(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool portfolio_goal: portfolio_goal
        :param date start_date: start date
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'goal_id', 'currency_conversion', 'end_date', 'portfolio_goal', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_holding_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_goal_holding_all_using_get`")  # noqa: E501
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `get_goal_holding_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []
        if 'client_id' in params:
            query_params.append(('client_id', params['client_id']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'portfolio_goal' in params:
            query_params.append(('portfolio_goal', params['portfolio_goal']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}/holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PortfolioHoldingAgg]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_track_all_using_get(self, **kwargs):  # noqa: E501
        """List all goal track records  # noqa: E501

        Get information for all goal track records stored for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_track_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str end_date: end date 
        :param str filter: filter
        :param bool get_latest: true or false
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param str start_date: start date 
        :return: PageGoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_track_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_track_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_goal_track_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all goal track records  # noqa: E501

        Get information for all goal track records stored for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_track_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str end_date: end date 
        :param str filter: filter
        :param bool get_latest: true or false
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param str start_date: start date 
        :return: PageGoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'end_date', 'filter', 'get_latest', 'order_by', 'page', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_track_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_track', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageGoalTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_track_using_get(self, goal_track_id, **kwargs):  # noqa: E501
        """Retrieve a goal track record  # noqa: E501

        Retrieve the information for a specific goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_track_using_get(goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_track_id: UUID goal_track_id (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_track_using_get_with_http_info(goal_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_track_using_get_with_http_info(goal_track_id, **kwargs)  # noqa: E501
            return data

    def get_goal_track_using_get_with_http_info(self, goal_track_id, **kwargs):  # noqa: E501
        """Retrieve a goal track record  # noqa: E501

        Retrieve the information for a specific goal track record for a goal under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_track_using_get_with_http_info(goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_track_id: UUID goal_track_id (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_track_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_track_id' is set
        if ('goal_track_id' not in params or
                params['goal_track_id'] is None):
            raise ValueError("Missing the required parameter `goal_track_id` when calling `get_goal_track_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_track_id' in params:
            path_params['goal_track_id'] = params['goal_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_track/{goal_track_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_transaction_all_using_get(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal transactions  # noqa: E501

        Get the information for all transactions under portfolios associated with a particular goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_transaction_all_using_get(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param bool portfolio_goal: portfolio_goal
        :param int size: size
        :param date start_date: start date
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_transaction_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_transaction_all_using_get_with_http_info(client_id, goal_id, **kwargs)  # noqa: E501
            return data

    def get_goal_transaction_all_using_get_with_http_info(self, client_id, goal_id, **kwargs):  # noqa: E501
        """List goal transactions  # noqa: E501

        Get the information for all transactions under portfolios associated with a particular goal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_transaction_all_using_get_with_http_info(client_id, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: client_id (required)
        :param str goal_id: UUID goal_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param bool portfolio_goal: portfolio_goal
        :param int size: size
        :param date start_date: start date
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'goal_id', 'ascending', 'currency_conversion', 'end_date', 'order_by', 'page', 'portfolio_goal', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_goal_transaction_all_using_get`")  # noqa: E501
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `get_goal_transaction_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'client_id' in params:
            query_params.append(('client_id', params['client_id']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'portfolio_goal' in params:
            query_params.append(('portfolio_goal', params['portfolio_goal']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}/transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_goal_using_get(self, goal_id, **kwargs):  # noqa: E501
        """Retrieve a goal  # noqa: E501

        Retrieve the information for a goal defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_using_get(goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_id: UUID goal_id (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_goal_using_get_with_http_info(goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_goal_using_get_with_http_info(goal_id, **kwargs)  # noqa: E501
            return data

    def get_goal_using_get_with_http_info(self, goal_id, **kwargs):  # noqa: E501
        """Retrieve a goal  # noqa: E501

        Retrieve the information for a goal defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_goal_using_get_with_http_info(goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str goal_id: UUID goal_id (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_goal_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `get_goal_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Goal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_goal_track_using_put(self, goal_track, goal_track_id, **kwargs):  # noqa: E501
        """Update a goal track record  # noqa: E501

        Update the information for a goal track record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_track_using_put(goal_track, goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object goal_track: goal_track (required)
        :param str goal_track_id: UUID goal_track_id (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_goal_track_using_put_with_http_info(goal_track, goal_track_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_goal_track_using_put_with_http_info(goal_track, goal_track_id, **kwargs)  # noqa: E501
            return data

    def update_goal_track_using_put_with_http_info(self, goal_track, goal_track_id, **kwargs):  # noqa: E501
        """Update a goal track record  # noqa: E501

        Update the information for a goal track record.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_track_using_put_with_http_info(goal_track, goal_track_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object goal_track: goal_track (required)
        :param str goal_track_id: UUID goal_track_id (required)
        :return: GoalTrack
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal_track', 'goal_track_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_goal_track_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal_track' is set
        if ('goal_track' not in params or
                params['goal_track'] is None):
            raise ValueError("Missing the required parameter `goal_track` when calling `update_goal_track_using_put`")  # noqa: E501
        # verify the required parameter 'goal_track_id' is set
        if ('goal_track_id' not in params or
                params['goal_track_id'] is None):
            raise ValueError("Missing the required parameter `goal_track_id` when calling `update_goal_track_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_track_id' in params:
            path_params['goal_track_id'] = params['goal_track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'goal_track' in params:
            body_params = params['goal_track']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal_track/{goal_track_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoalTrack',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_goal_using_put(self, goal, goal_id, **kwargs):  # noqa: E501
        """Update a goal  # noqa: E501

        Update a goal defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_using_put(goal, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object goal: goal (required)
        :param str goal_id: UUID goal_id (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_goal_using_put_with_http_info(goal, goal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_goal_using_put_with_http_info(goal, goal_id, **kwargs)  # noqa: E501
            return data

    def update_goal_using_put_with_http_info(self, goal, goal_id, **kwargs):  # noqa: E501
        """Update a goal  # noqa: E501

        Update a goal defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_goal_using_put_with_http_info(goal, goal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object goal: goal (required)
        :param str goal_id: UUID goal_id (required)
        :return: Goal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['goal', 'goal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_goal_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'goal' is set
        if ('goal' not in params or
                params['goal'] is None):
            raise ValueError("Missing the required parameter `goal` when calling `update_goal_using_put`")  # noqa: E501
        # verify the required parameter 'goal_id' is set
        if ('goal_id' not in params or
                params['goal_id'] is None):
            raise ValueError("Missing the required parameter `goal_id` when calling `update_goal_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'goal_id' in params:
            path_params['goal_id'] = params['goal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'goal' in params:
            body_params = params['goal']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/goal/{goal_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Goal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
