# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class DecisionTreeApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_decision_tree_result_using_post(self, decision_tree_co, **kwargs):  # noqa: E501
        """Decision tree result  # noqa: E501

        Decision tree result.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_decision_tree_result_using_post(decision_tree_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DecisionTreeCO decision_tree_co: decisionTreeCO (required)
        :return: DecisionTreeResultVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_decision_tree_result_using_post_with_http_info(decision_tree_co, **kwargs)  # noqa: E501
        else:
            (data) = self.create_decision_tree_result_using_post_with_http_info(decision_tree_co, **kwargs)  # noqa: E501
            return data

    def create_decision_tree_result_using_post_with_http_info(self, decision_tree_co, **kwargs):  # noqa: E501
        """Decision tree result  # noqa: E501

        Decision tree result.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_decision_tree_result_using_post_with_http_info(decision_tree_co, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DecisionTreeCO decision_tree_co: decisionTreeCO (required)
        :return: DecisionTreeResultVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['decision_tree_co']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_decision_tree_result_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'decision_tree_co' is set
        if ('decision_tree_co' not in params or
                params['decision_tree_co'] is None):
            raise ValueError("Missing the required parameter `decision_tree_co` when calling `create_decision_tree_result_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'decision_tree_co' in params:
            body_params = params['decision_tree_co']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree_result', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionTreeResultVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_decision_tree_using_post(self, decision_tree, **kwargs):  # noqa: E501
        """Create a decision tree  # noqa: E501

        Create a new decision tree for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_decision_tree_using_post(decision_tree, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DecisionTree decision_tree: decisionTree (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_decision_tree_using_post_with_http_info(decision_tree, **kwargs)  # noqa: E501
        else:
            (data) = self.create_decision_tree_using_post_with_http_info(decision_tree, **kwargs)  # noqa: E501
            return data

    def create_decision_tree_using_post_with_http_info(self, decision_tree, **kwargs):  # noqa: E501
        """Create a decision tree  # noqa: E501

        Create a new decision tree for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_decision_tree_using_post_with_http_info(decision_tree, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DecisionTree decision_tree: decisionTree (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['decision_tree']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_decision_tree_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'decision_tree' is set
        if ('decision_tree' not in params or
                params['decision_tree'] is None):
            raise ValueError("Missing the required parameter `decision_tree` when calling `create_decision_tree_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'decision_tree' in params:
            body_params = params['decision_tree']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_node_relationship_using_post(self, node, **kwargs):  # noqa: E501
        """Create a node relationship  # noqa: E501

        Create a new node relationship for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_relationship_using_post(node, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRelationship node: node (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_node_relationship_using_post_with_http_info(node, **kwargs)  # noqa: E501
        else:
            (data) = self.create_node_relationship_using_post_with_http_info(node, **kwargs)  # noqa: E501
            return data

    def create_node_relationship_using_post_with_http_info(self, node, **kwargs):  # noqa: E501
        """Create a node relationship  # noqa: E501

        Create a new node relationship for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_relationship_using_post_with_http_info(node, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeRelationship node: node (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node_relationship_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node' is set
        if ('node' not in params or
                params['node'] is None):
            raise ValueError("Missing the required parameter `node` when calling `create_node_relationship_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node' in params:
            body_params = params['node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node_relationship', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_node_using_post(self, node, **kwargs):  # noqa: E501
        """Create a node  # noqa: E501

        Create a new node for your firm that can be used in a decision tree and mapped to other nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_using_post(node, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Node node: node (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_node_using_post_with_http_info(node, **kwargs)  # noqa: E501
        else:
            (data) = self.create_node_using_post_with_http_info(node, **kwargs)  # noqa: E501
            return data

    def create_node_using_post_with_http_info(self, node, **kwargs):  # noqa: E501
        """Create a node  # noqa: E501

        Create a new node for your firm that can be used in a decision tree and mapped to other nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_using_post_with_http_info(node, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Node node: node (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node' is set
        if ('node' not in params or
                params['node'] is None):
            raise ValueError("Missing the required parameter `node` when calling `create_node_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node' in params:
            body_params = params['node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Node',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_decision_tree_using_delete(self, decision_tree_id, **kwargs):  # noqa: E501
        """Delete a decision tree  # noqa: E501

        Permanently delete a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_decision_tree_using_delete(decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_decision_tree_using_delete_with_http_info(decision_tree_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_decision_tree_using_delete_with_http_info(decision_tree_id, **kwargs)  # noqa: E501
            return data

    def delete_decision_tree_using_delete_with_http_info(self, decision_tree_id, **kwargs):  # noqa: E501
        """Delete a decision tree  # noqa: E501

        Permanently delete a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_decision_tree_using_delete_with_http_info(decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['decision_tree_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_decision_tree_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'decision_tree_id' is set
        if ('decision_tree_id' not in params or
                params['decision_tree_id'] is None):
            raise ValueError("Missing the required parameter `decision_tree_id` when calling `delete_decision_tree_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'decision_tree_id' in params:
            path_params['decision_tree_id'] = params['decision_tree_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree/{decision_tree_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_node_relationship_using_delete(self, node_relationship_id, **kwargs):  # noqa: E501
        """Delete a node relationship  # noqa: E501

        Permanently delete a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_relationship_using_delete(node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_node_relationship_using_delete_with_http_info(node_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_node_relationship_using_delete_with_http_info(node_relationship_id, **kwargs)  # noqa: E501
            return data

    def delete_node_relationship_using_delete_with_http_info(self, node_relationship_id, **kwargs):  # noqa: E501
        """Delete a node relationship  # noqa: E501

        Permanently delete a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_relationship_using_delete_with_http_info(node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_node_relationship_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_relationship_id' is set
        if ('node_relationship_id' not in params or
                params['node_relationship_id'] is None):
            raise ValueError("Missing the required parameter `node_relationship_id` when calling `delete_node_relationship_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_relationship_id' in params:
            path_params['node_relationship_id'] = params['node_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node_relationship/{node_relationship_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_node_using_delete(self, node_id, **kwargs):  # noqa: E501
        """Delete a node  # noqa: E501

        Permanently delete a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_using_delete(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_id: UUID node_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_node_using_delete_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_node_using_delete_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def delete_node_using_delete_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Delete a node  # noqa: E501

        Permanently delete a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_node_using_delete_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_id: UUID node_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_node_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `delete_node_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node/{node_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_tree_all_using_get(self, **kwargs):  # noqa: E501
        """List all decision tree  # noqa: E501

        Get the information for all decision trees defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_tree_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageDecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_decision_tree_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_decision_tree_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_decision_tree_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all decision tree  # noqa: E501

        Get the information for all decision trees defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_tree_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageDecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_tree_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageDecisionTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_tree_using_get(self, decision_tree_id, **kwargs):  # noqa: E501
        """Retrieve a decision tree  # noqa: E501

        Retrieve the information for a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_tree_using_get(decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_decision_tree_using_get_with_http_info(decision_tree_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_decision_tree_using_get_with_http_info(decision_tree_id, **kwargs)  # noqa: E501
            return data

    def get_decision_tree_using_get_with_http_info(self, decision_tree_id, **kwargs):  # noqa: E501
        """Retrieve a decision tree  # noqa: E501

        Retrieve the information for a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_tree_using_get_with_http_info(decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['decision_tree_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_tree_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'decision_tree_id' is set
        if ('decision_tree_id' not in params or
                params['decision_tree_id'] is None):
            raise ValueError("Missing the required parameter `decision_tree_id` when calling `get_decision_tree_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'decision_tree_id' in params:
            path_params['decision_tree_id'] = params['decision_tree_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree/{decision_tree_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_all_using_get(self, **kwargs):  # noqa: E501
        """List all nodes  # noqa: E501

        List all nodes that are defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNode
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_node_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_node_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all nodes  # noqa: E501

        List all nodes that are defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNode
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageNode',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_relationship_all_using_get(self, **kwargs):  # noqa: E501
        """List all node relationships  # noqa: E501

        Get the information for all the node relationships defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_relationship_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_relationship_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_node_relationship_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_node_relationship_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all node relationships  # noqa: E501

        Get the information for all the node relationships defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_relationship_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageNodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_relationship_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node_relationship', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageNodeRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_relationship_using_get(self, node_relationship_id, **kwargs):  # noqa: E501
        """Retrieve a node relationship  # noqa: E501

        Retrieve the information for a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_relationship_using_get(node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_relationship_using_get_with_http_info(node_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_relationship_using_get_with_http_info(node_relationship_id, **kwargs)  # noqa: E501
            return data

    def get_node_relationship_using_get_with_http_info(self, node_relationship_id, **kwargs):  # noqa: E501
        """Retrieve a node relationship  # noqa: E501

        Retrieve the information for a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_relationship_using_get_with_http_info(node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_relationship_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_relationship_id' is set
        if ('node_relationship_id' not in params or
                params['node_relationship_id'] is None):
            raise ValueError("Missing the required parameter `node_relationship_id` when calling `get_node_relationship_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_relationship_id' in params:
            path_params['node_relationship_id'] = params['node_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node_relationship/{node_relationship_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_using_get(self, node_id, **kwargs):  # noqa: E501
        """Retrieve a node  # noqa: E501

        Retrieve the information for a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_using_get(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_id: UUID node_id (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_using_get_with_http_info(node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_using_get_with_http_info(node_id, **kwargs)  # noqa: E501
            return data

    def get_node_using_get_with_http_info(self, node_id, **kwargs):  # noqa: E501
        """Retrieve a node  # noqa: E501

        Retrieve the information for a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_using_get_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_id: UUID node_id (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `get_node_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node/{node_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Node',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_decision_tree_using_put(self, decision_tree, decision_tree_id, **kwargs):  # noqa: E501
        """Update a decision tree  # noqa: E501

        Updated the information for a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_decision_tree_using_put(decision_tree, decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object decision_tree: decision_tree (required)
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_decision_tree_using_put_with_http_info(decision_tree, decision_tree_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_decision_tree_using_put_with_http_info(decision_tree, decision_tree_id, **kwargs)  # noqa: E501
            return data

    def update_decision_tree_using_put_with_http_info(self, decision_tree, decision_tree_id, **kwargs):  # noqa: E501
        """Update a decision tree  # noqa: E501

        Updated the information for a decision tree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_decision_tree_using_put_with_http_info(decision_tree, decision_tree_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object decision_tree: decision_tree (required)
        :param str decision_tree_id: UUID decision_tree_id (required)
        :return: DecisionTree
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['decision_tree', 'decision_tree_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_decision_tree_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'decision_tree' is set
        if ('decision_tree' not in params or
                params['decision_tree'] is None):
            raise ValueError("Missing the required parameter `decision_tree` when calling `update_decision_tree_using_put`")  # noqa: E501
        # verify the required parameter 'decision_tree_id' is set
        if ('decision_tree_id' not in params or
                params['decision_tree_id'] is None):
            raise ValueError("Missing the required parameter `decision_tree_id` when calling `update_decision_tree_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'decision_tree_id' in params:
            path_params['decision_tree_id'] = params['decision_tree_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'decision_tree' in params:
            body_params = params['decision_tree']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/decision_tree/{decision_tree_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionTree',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_relationship_using_put(self, json_node, node_relationship_id, **kwargs):  # noqa: E501
        """Update a node relationship  # noqa: E501

        Update the information for a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_relationship_using_put(json_node, node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object json_node: jsonNode (required)
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_relationship_using_put_with_http_info(json_node, node_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_relationship_using_put_with_http_info(json_node, node_relationship_id, **kwargs)  # noqa: E501
            return data

    def update_node_relationship_using_put_with_http_info(self, json_node, node_relationship_id, **kwargs):  # noqa: E501
        """Update a node relationship  # noqa: E501

        Update the information for a node relationship.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_relationship_using_put_with_http_info(json_node, node_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object json_node: jsonNode (required)
        :param str node_relationship_id: UUID node_relationship_id (required)
        :return: NodeRelationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['json_node', 'node_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_relationship_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'json_node' is set
        if ('json_node' not in params or
                params['json_node'] is None):
            raise ValueError("Missing the required parameter `json_node` when calling `update_node_relationship_using_put`")  # noqa: E501
        # verify the required parameter 'node_relationship_id' is set
        if ('node_relationship_id' not in params or
                params['node_relationship_id'] is None):
            raise ValueError("Missing the required parameter `node_relationship_id` when calling `update_node_relationship_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_relationship_id' in params:
            path_params['node_relationship_id'] = params['node_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'json_node' in params:
            body_params = params['json_node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node_relationship/{node_relationship_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeRelationship',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_using_put(self, json_node, node_id, **kwargs):  # noqa: E501
        """Update a node  # noqa: E501

        Updated the information for a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_using_put(json_node, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object json_node: jsonNode (required)
        :param str node_id: UUID node_id (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_using_put_with_http_info(json_node, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_using_put_with_http_info(json_node, node_id, **kwargs)  # noqa: E501
            return data

    def update_node_using_put_with_http_info(self, json_node, node_id, **kwargs):  # noqa: E501
        """Update a node  # noqa: E501

        Updated the information for a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_using_put_with_http_info(json_node, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object json_node: jsonNode (required)
        :param str node_id: UUID node_id (required)
        :return: Node
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['json_node', 'node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'json_node' is set
        if ('json_node' not in params or
                params['json_node'] is None):
            raise ValueError("Missing the required parameter `json_node` when calling `update_node_using_put`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_node_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'json_node' in params:
            body_params = params['json_node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/node/{node_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Node',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
