# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class ClientApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_client_status_using_post(self, client_status_request, **kwargs):  # noqa: E501
        """Create an client status  # noqa: E501

        Create an client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_status_using_post(client_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientStatus client_status_request: clientStatusRequest (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_status_using_post_with_http_info(client_status_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_status_using_post_with_http_info(client_status_request, **kwargs)  # noqa: E501
            return data

    def create_client_status_using_post_with_http_info(self, client_status_request, **kwargs):  # noqa: E501
        """Create an client status  # noqa: E501

        Create an client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_status_using_post_with_http_info(client_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClientStatus client_status_request: clientStatusRequest (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_status_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client_status_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_status_request' is set
        if ('client_status_request' not in params or
                params['client_status_request'] is None):
            raise ValueError("Missing the required parameter `client_status_request` when calling `create_client_status_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_status_request' in params:
            body_params = params['client_status_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client_status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_client_using_post(self, client_request, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        Create a new client, or register a new user, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_using_post(client_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Client client_request: clientRequest (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_client_using_post_with_http_info(client_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_client_using_post_with_http_info(client_request, **kwargs)  # noqa: E501
            return data

    def create_client_using_post_with_http_info(self, client_request, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        Create a new client, or register a new user, with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_client_using_post_with_http_info(client_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Client client_request: clientRequest (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_client_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_request' is set
        if ('client_request' not in params or
                params['client_request'] is None):
            raise ValueError("Missing the required parameter `client_request` when calling `create_client_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_request' in params:
            body_params = params['client_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_client_status_using_delete(self, client_status_id, **kwargs):  # noqa: E501
        """Delete an client status  # noqa: E501

        Permanently delete an client status record from an client’s history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_status_using_delete(client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_status_id: UUID client_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_client_status_using_delete_with_http_info(client_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_client_status_using_delete_with_http_info(client_status_id, **kwargs)  # noqa: E501
            return data

    def delete_client_status_using_delete_with_http_info(self, client_status_id, **kwargs):  # noqa: E501
        """Delete an client status  # noqa: E501

        Permanently delete an client status record from an client’s history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_status_using_delete_with_http_info(client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_status_id: UUID client_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_client_status_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_status_id' is set
        if ('client_status_id' not in params or
                params['client_status_id'] is None):
            raise ValueError("Missing the required parameter `client_status_id` when calling `delete_client_status_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_status_id' in params:
            path_params['client_status_id'] = params['client_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client_status/{client_status_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_client_using_delete(self, client_id, **kwargs):  # noqa: E501
        """Delete a client  # noqa: E501

        Permanently delete a client registered with your firm. Turns the client's is_active  = 0  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_using_delete(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_client_using_delete_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_client_using_delete_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def delete_client_using_delete_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """Delete a client  # noqa: E501

        Permanently delete a client registered with your firm. Turns the client's is_active  = 0  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_client_using_delete_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_client_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `delete_client_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_account_overview_using_get(self, client_id, **kwargs):  # noqa: E501
        """List all client Account overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_account_overview_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool ascending: ascending
        :param str order_by: order_by
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_account_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_account_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_account_overview_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """List all client Account overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_account_overview_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool ascending: ascending
        :param str order_by: order_by
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'ascending', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_account_overview_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_account_overview_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/account_overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_advisor_overview_using_get(self, client_id, **kwargs):  # noqa: E501
        """Advisor overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_advisor_overview_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool show_clients: show_clients
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_advisor_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_advisor_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_advisor_overview_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """Advisor overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_advisor_overview_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool show_clients: show_clients
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'show_clients']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_advisor_overview_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_advisor_overview_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'show_clients' in params:
            query_params.append(('show_clients', params['show_clients']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/advisor_overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_all_using_get(self, **kwargs):  # noqa: E501
        """List all clients  # noqa: E501

        Get details for all clients registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_client_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_client_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all clients  # noqa: E501

        Get details for all clients registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_asset_size_using_get(self, client_id, **kwargs):  # noqa: E501
        """List all client asset sizes  # noqa: E501

        Get a list of asset sizes per date for a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_asset_size_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool exclude_subledger: exclude_subledger
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_asset_size_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_asset_size_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_asset_size_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """List all client asset sizes  # noqa: E501

        Get a list of asset sizes per date for a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_asset_size_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param str currency_conversion: Currency Code
        :param date end_date: end date
        :param bool exclude_subledger: exclude_subledger
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'currency_conversion', 'end_date', 'exclude_subledger', 'get_latest', 'sort_type', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_asset_size_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_asset_size_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'exclude_subledger' in params:
            query_params.append(('exclude_subledger', params['exclude_subledger']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'sort_type' in params:
            query_params.append(('sort_type', params['sort_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableDateDoubleVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_goal_overview_using_get(self, client_id, **kwargs):  # noqa: E501
        """Retrieve client's goal details   # noqa: E501

        Retrieve client's goal details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_goal_overview_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool portfolio_goal: portfolio_goal
        :return: VClientGoalViewData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_goal_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_goal_overview_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_goal_overview_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """Retrieve client's goal details   # noqa: E501

        Retrieve client's goal details  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_goal_overview_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool portfolio_goal: portfolio_goal
        :return: VClientGoalViewData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'portfolio_goal']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_goal_overview_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_goal_overview_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'portfolio_goal' in params:
            query_params.append(('portfolio_goal', params['portfolio_goal']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/goal_overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VClientGoalViewData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_holding_using_get(self, client_id, **kwargs):  # noqa: E501
        """List all client holdings  # noqa: E501

        Get the information for all the securities that are currently being held by a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_holding_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param str currency_conversion: Currency Code
        :param str end_date: end date - yyyy-mm-dd
        :param bool get_latest: true or false
        :param str start_date: start date - yyyy-mm-dd
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_holding_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_holding_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_holding_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """List all client holdings  # noqa: E501

        Get the information for all the securities that are currently being held by a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_holding_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param str currency_conversion: Currency Code
        :param str end_date: end date - yyyy-mm-dd
        :param bool get_latest: true or false
        :param str start_date: start date - yyyy-mm-dd
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'currency_conversion', 'end_date', 'get_latest', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_holding_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_holding_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PortfolioHoldingAgg]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_status_all_using_get(self, **kwargs):  # noqa: E501
        """List all client statuses  # noqa: E501

        Get the client status history information for all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_status_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_client_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_client_status_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all client statuses  # noqa: E501

        Get the client status history information for all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_status_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_status_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client_status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageClientStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_status_using_get(self, client_status_id, **kwargs):  # noqa: E501
        """Retrieve an client status  # noqa: E501

        Retrieve the information for a specific client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_status_using_get(client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_status_id: UUID client_status_id (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_status_using_get_with_http_info(client_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_status_using_get_with_http_info(client_status_id, **kwargs)  # noqa: E501
            return data

    def get_client_status_using_get_with_http_info(self, client_status_id, **kwargs):  # noqa: E501
        """Retrieve an client status  # noqa: E501

        Retrieve the information for a specific client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_status_using_get_with_http_info(client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_status_id: UUID client_status_id (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_status_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_status_id' is set
        if ('client_status_id' not in params or
                params['client_status_id'] is None):
            raise ValueError("Missing the required parameter `client_status_id` when calling `get_client_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_status_id' in params:
            path_params['client_status_id'] = params['client_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client_status/{client_status_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_transaction_all_using_get(self, client_id, **kwargs):  # noqa: E501
        """List all client transactions  # noqa: E501

        Get the information for all transactions under a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_transaction_all_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str end_date: end date - yyyy-mm-dd
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param str start_date: start date - yyyy-mm-dd
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_transaction_all_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_transaction_all_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_transaction_all_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """List all client transactions  # noqa: E501

        Get the information for all transactions under a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_transaction_all_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: currency_conversion
        :param str end_date: end date - yyyy-mm-dd
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param str start_date: start date - yyyy-mm-dd
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'ascending', 'currency_conversion', 'end_date', 'order_by', 'page', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_transaction_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_transaction_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}/transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_client_using_get(self, client_id, **kwargs):  # noqa: E501
        """Retrieve a client  # noqa: E501

        Retrieve the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_using_get(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_client_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_client_using_get_with_http_info(client_id, **kwargs)  # noqa: E501
            return data

    def get_client_using_get_with_http_info(self, client_id, **kwargs):  # noqa: E501
        """Retrieve a client  # noqa: E501

        Retrieve the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_client_using_get_with_http_info(client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_client_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_status_using_put(self, client_status, client_status_id, **kwargs):  # noqa: E501
        """Update an client status  # noqa: E501

        Update an client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_status_using_put(client_status, client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client_status: client_status (required)
        :param str client_status_id: UUID client_status_id (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_status_using_put_with_http_info(client_status, client_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_status_using_put_with_http_info(client_status, client_status_id, **kwargs)  # noqa: E501
            return data

    def update_client_status_using_put_with_http_info(self, client_status, client_status_id, **kwargs):  # noqa: E501
        """Update an client status  # noqa: E501

        Update an client status record for an client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_status_using_put_with_http_info(client_status, client_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client_status: client_status (required)
        :param str client_status_id: UUID client_status_id (required)
        :return: ClientStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_status', 'client_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_status_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_status' is set
        if ('client_status' not in params or
                params['client_status'] is None):
            raise ValueError("Missing the required parameter `client_status` when calling `update_client_status_using_put`")  # noqa: E501
        # verify the required parameter 'client_status_id' is set
        if ('client_status_id' not in params or
                params['client_status_id'] is None):
            raise ValueError("Missing the required parameter `client_status_id` when calling `update_client_status_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_status_id' in params:
            path_params['client_status_id'] = params['client_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_status' in params:
            body_params = params['client_status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client_status/{client_status_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClientStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_using_put(self, client, client_id, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_using_put(client, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client: client (required)
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_using_put_with_http_info(client, client_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_using_put_with_http_info(client, client_id, **kwargs)  # noqa: E501
            return data

    def update_client_using_put_with_http_info(self, client, client_id, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update the information for a client registered with your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_using_put_with_http_info(client, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object client: client (required)
        :param str client_id: UUID client_id (required)
        :return: Client
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client', 'client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client' is set
        if ('client' not in params or
                params['client'] is None):
            raise ValueError("Missing the required parameter `client` when calling `update_client_using_put`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params or
                params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `update_client_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'client_id' in params:
            path_params['client_id'] = params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client' in params:
            body_params = params['client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/client/{client_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Client',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
