# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class CardApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_card_program_using_post(self, card_program_request, **kwargs):  # noqa: E501
        """Create a cardProgram request  # noqa: E501

        Create a new cardProgram request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_program_using_post(card_program_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardProgram card_program_request: cardProgramRequest (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_card_program_using_post_with_http_info(card_program_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_card_program_using_post_with_http_info(card_program_request, **kwargs)  # noqa: E501
            return data

    def create_card_program_using_post_with_http_info(self, card_program_request, **kwargs):  # noqa: E501
        """Create a cardProgram request  # noqa: E501

        Create a new cardProgram request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_program_using_post_with_http_info(card_program_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardProgram card_program_request: cardProgramRequest (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_program_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_card_program_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_program_request' is set
        if ('card_program_request' not in params or
                params['card_program_request'] is None):
            raise ValueError("Missing the required parameter `card_program_request` when calling `create_card_program_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card_program_request' in params:
            body_params = params['card_program_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card_program', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CardProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_card_using_post(self, card_request, **kwargs):  # noqa: E501
        """Create a card request  # noqa: E501

        Create a new card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_using_post(card_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Card card_request: cardRequest (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_card_using_post_with_http_info(card_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_card_using_post_with_http_info(card_request, **kwargs)  # noqa: E501
            return data

    def create_card_using_post_with_http_info(self, card_request, **kwargs):  # noqa: E501
        """Create a card request  # noqa: E501

        Create a new card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_using_post_with_http_info(card_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Card card_request: cardRequest (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_card_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_request' is set
        if ('card_request' not in params or
                params['card_request'] is None):
            raise ValueError("Missing the required parameter `card_request` when calling `create_card_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card_request' in params:
            body_params = params['card_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Card',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_card_program_using_delete(self, card_program_id, **kwargs):  # noqa: E501
        """Delete an cardProgram  # noqa: E501

        Permanently delete an cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_program_using_delete(card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_program_id: UUID card_program_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_card_program_using_delete_with_http_info(card_program_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_card_program_using_delete_with_http_info(card_program_id, **kwargs)  # noqa: E501
            return data

    def delete_card_program_using_delete_with_http_info(self, card_program_id, **kwargs):  # noqa: E501
        """Delete an cardProgram  # noqa: E501

        Permanently delete an cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_program_using_delete_with_http_info(card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_program_id: UUID card_program_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_program_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_card_program_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_program_id' is set
        if ('card_program_id' not in params or
                params['card_program_id'] is None):
            raise ValueError("Missing the required parameter `card_program_id` when calling `delete_card_program_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_program_id' in params:
            path_params['card_program_id'] = params['card_program_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card_program/{card_program_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_card_using_delete(self, card_id, **kwargs):  # noqa: E501
        """Delete a card request  # noqa: E501

        Permanently delete a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_using_delete(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_card_using_delete_with_http_info(card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_card_using_delete_with_http_info(card_id, **kwargs)  # noqa: E501
            return data

    def delete_card_using_delete_with_http_info(self, card_id, **kwargs):  # noqa: E501
        """Delete a card request  # noqa: E501

        Permanently delete a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_using_delete_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_card_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `delete_card_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card/{card_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_all_using_get(self, **kwargs):  # noqa: E501
        """List all card requests  # noqa: E501

        Get the information for all card requests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageCard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_card_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_card_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all card requests  # noqa: E501

        Get the information for all card requests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageCard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageCard',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_asset_size_agg_all_using_get(self, card_id, **kwargs):  # noqa: E501
        """List all card asset sizes  # noqa: E501

        Get a list of asset sizes by date for an card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_asset_size_agg_all_using_get(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: Card Id (required)
        :param str currency_conversion: USD
        :param date end_date: end date
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_asset_size_agg_all_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_asset_size_agg_all_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
            return data

    def get_card_asset_size_agg_all_using_get_with_http_info(self, card_id, **kwargs):  # noqa: E501
        """List all card asset sizes  # noqa: E501

        Get a list of asset sizes by date for an card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_asset_size_agg_all_using_get_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: Card Id (required)
        :param str currency_conversion: USD
        :param date end_date: end date
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id', 'currency_conversion', 'end_date', 'get_latest', 'sort_type', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_asset_size_agg_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `get_card_asset_size_agg_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'sort_type' in params:
            query_params.append(('sort_type', params['sort_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card/{card_id}/asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_program_all_using_get(self, **kwargs):  # noqa: E501
        """List all cardProgram  # noqa: E501

        Get information for all cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_program_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageCardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_program_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_card_program_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_card_program_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all cardProgram  # noqa: E501

        Get information for all cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_program_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageCardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_program_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card_program', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageCardProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_program_using_get(self, card_program_id, **kwargs):  # noqa: E501
        """Retrieve an cardProgram  # noqa: E501

        Retrieve the information for a specific cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_program_using_get(card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_program_id: UUID card_program_id (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_program_using_get_with_http_info(card_program_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_program_using_get_with_http_info(card_program_id, **kwargs)  # noqa: E501
            return data

    def get_card_program_using_get_with_http_info(self, card_program_id, **kwargs):  # noqa: E501
        """Retrieve an cardProgram  # noqa: E501

        Retrieve the information for a specific cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_program_using_get_with_http_info(card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_program_id: UUID card_program_id (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_program_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_program_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_program_id' is set
        if ('card_program_id' not in params or
                params['card_program_id'] is None):
            raise ValueError("Missing the required parameter `card_program_id` when calling `get_card_program_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_program_id' in params:
            path_params['card_program_id'] = params['card_program_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card_program/{card_program_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CardProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_transaction_agg_all_using_get(self, card_id, **kwargs):  # noqa: E501
        """List all card transactions  # noqa: E501

        Get the information for all transactions for an card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_transaction_agg_all_using_get(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: USD
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_transaction_agg_all_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_transaction_agg_all_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
            return data

    def get_card_transaction_agg_all_using_get_with_http_info(self, card_id, **kwargs):  # noqa: E501
        """List all card transactions  # noqa: E501

        Get the information for all transactions for an card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_transaction_agg_all_using_get_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: USD
        :param date end_date: end date
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id', 'ascending', 'currency_conversion', 'end_date', 'order_by', 'page', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_transaction_agg_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `get_card_transaction_agg_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card/{card_id}/transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_using_get(self, card_id, **kwargs):  # noqa: E501
        """Retrieve a card request  # noqa: E501

        Retrieve the information for a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_using_get(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_using_get_with_http_info(card_id, **kwargs)  # noqa: E501
            return data

    def get_card_using_get_with_http_info(self, card_id, **kwargs):  # noqa: E501
        """Retrieve a card request  # noqa: E501

        Retrieve the information for a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_using_get_with_http_info(card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: UUID card_id (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `get_card_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card/{card_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Card',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_card_program_using_put(self, card_program, card_program_id, **kwargs):  # noqa: E501
        """Update an cardProgram  # noqa: E501

        Update the information for an cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_program_using_put(card_program, card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object card_program: card_program (required)
        :param str card_program_id: UUID card_program_id (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_card_program_using_put_with_http_info(card_program, card_program_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_card_program_using_put_with_http_info(card_program, card_program_id, **kwargs)  # noqa: E501
            return data

    def update_card_program_using_put_with_http_info(self, card_program, card_program_id, **kwargs):  # noqa: E501
        """Update an cardProgram  # noqa: E501

        Update the information for an cardProgram.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_program_using_put_with_http_info(card_program, card_program_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object card_program: card_program (required)
        :param str card_program_id: UUID card_program_id (required)
        :return: CardProgram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_program', 'card_program_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_card_program_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_program' is set
        if ('card_program' not in params or
                params['card_program'] is None):
            raise ValueError("Missing the required parameter `card_program` when calling `update_card_program_using_put`")  # noqa: E501
        # verify the required parameter 'card_program_id' is set
        if ('card_program_id' not in params or
                params['card_program_id'] is None):
            raise ValueError("Missing the required parameter `card_program_id` when calling `update_card_program_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_program_id' in params:
            path_params['card_program_id'] = params['card_program_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card_program' in params:
            body_params = params['card_program']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card_program/{card_program_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CardProgram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_card_using_put(self, card, card_id, **kwargs):  # noqa: E501
        """Update a card request  # noqa: E501

        Update the information for a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_using_put(card, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object card: card (required)
        :param str card_id: UUID card_id (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_card_using_put_with_http_info(card, card_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_card_using_put_with_http_info(card, card_id, **kwargs)  # noqa: E501
            return data

    def update_card_using_put_with_http_info(self, card, card_id, **kwargs):  # noqa: E501
        """Update a card request  # noqa: E501

        Update the information for a card request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_using_put_with_http_info(card, card_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object card: card (required)
        :param str card_id: UUID card_id (required)
        :return: Card
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card', 'card_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_card_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card' is set
        if ('card' not in params or
                params['card'] is None):
            raise ValueError("Missing the required parameter `card` when calling `update_card_using_put`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if ('card_id' not in params or
                params['card_id'] is None):
            raise ValueError("Missing the required parameter `card_id` when calling `update_card_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['card_id'] = params['card_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'card' in params:
            body_params = params['card']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/card/{card_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Card',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
