# coding: utf-8

"""
    Hydrogen Nucleus API

    The Hydrogen Nucleus API  # noqa: E501

    OpenAPI spec version: 1.8.0
    Contact: info@hydrogenplatform.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nucleus_api.api_client import ApiClient


class AccountApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_account_allocation_mapping_using_post(self, alloc_request, **kwargs):  # noqa: E501
        """Create an account allocation  # noqa: E501

        Create an account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_allocation_mapping_using_post(alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountAllocationMapping alloc_request: allocRequest (required)
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_allocation_mapping_using_post_with_http_info(alloc_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_allocation_mapping_using_post_with_http_info(alloc_request, **kwargs)  # noqa: E501
            return data

    def create_account_allocation_mapping_using_post_with_http_info(self, alloc_request, **kwargs):  # noqa: E501
        """Create an account allocation  # noqa: E501

        Create an account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_allocation_mapping_using_post_with_http_info(alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountAllocationMapping alloc_request: allocRequest (required)
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alloc_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_allocation_mapping_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alloc_request' is set
        if ('alloc_request' not in params or
                params['alloc_request'] is None):
            raise ValueError("Missing the required parameter `alloc_request` when calling `create_account_allocation_mapping_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'alloc_request' in params:
            body_params = params['alloc_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_allocation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountAllocationMapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_status_using_post(self, account_status_request, **kwargs):  # noqa: E501
        """Create an account status  # noqa: E501

        Create an account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_status_using_post(account_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountStatus account_status_request: accountStatusRequest (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_status_using_post_with_http_info(account_status_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_status_using_post_with_http_info(account_status_request, **kwargs)  # noqa: E501
            return data

    def create_account_status_using_post_with_http_info(self, account_status_request, **kwargs):  # noqa: E501
        """Create an account status  # noqa: E501

        Create an account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_status_using_post_with_http_info(account_status_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountStatus account_status_request: accountStatusRequest (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_status_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_status_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_status_request' is set
        if ('account_status_request' not in params or
                params['account_status_request'] is None):
            raise ValueError("Missing the required parameter `account_status_request` when calling `create_account_status_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_status_request' in params:
            body_params = params['account_status_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_type_using_post(self, account_type_request, **kwargs):  # noqa: E501
        """Create an account type  # noqa: E501

        Create a new account type for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_type_using_post(account_type_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountType account_type_request: accountTypeRequest (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_type_using_post_with_http_info(account_type_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_type_using_post_with_http_info(account_type_request, **kwargs)  # noqa: E501
            return data

    def create_account_type_using_post_with_http_info(self, account_type_request, **kwargs):  # noqa: E501
        """Create an account type  # noqa: E501

        Create a new account type for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_type_using_post_with_http_info(account_type_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountType account_type_request: accountTypeRequest (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_type_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_type_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_type_request' is set
        if ('account_type_request' not in params or
                params['account_type_request'] is None):
            raise ValueError("Missing the required parameter `account_type_request` when calling `create_account_type_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_type_request' in params:
            body_params = params['account_type_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_type', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_using_post(self, client_account_request, **kwargs):  # noqa: E501
        """Create an account  # noqa: E501

        Create an account under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_using_post(client_account_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Account client_account_request: clientAccountRequest (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_using_post_with_http_info(client_account_request, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_using_post_with_http_info(client_account_request, **kwargs)  # noqa: E501
            return data

    def create_account_using_post_with_http_info(self, client_account_request, **kwargs):  # noqa: E501
        """Create an account  # noqa: E501

        Create an account under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_using_post_with_http_info(client_account_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Account client_account_request: clientAccountRequest (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_account_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'client_account_request' is set
        if ('client_account_request' not in params or
                params['client_account_request'] is None):
            raise ValueError("Missing the required parameter `client_account_request` when calling `create_account_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'client_account_request' in params:
            body_params = params['client_account_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Account',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_allocation_mapping_using_delete(self, account_allocation_id, **kwargs):  # noqa: E501
        """Delete an account allocation  # noqa: E501

        Permanently delete an account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_allocation_mapping_using_delete(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_allocation_mapping_using_delete_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_allocation_mapping_using_delete_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
            return data

    def delete_account_allocation_mapping_using_delete_with_http_info(self, account_allocation_id, **kwargs):  # noqa: E501
        """Delete an account allocation  # noqa: E501

        Permanently delete an account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_allocation_mapping_using_delete_with_http_info(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_allocation_mapping_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_allocation_id' is set
        if ('account_allocation_id' not in params or
                params['account_allocation_id'] is None):
            raise ValueError("Missing the required parameter `account_allocation_id` when calling `delete_account_allocation_mapping_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_allocation_id' in params:
            path_params['account_allocation_id'] = params['account_allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_allocation/{account_allocation_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_permission_using_delete(self, account_id, **kwargs):  # noqa: E501
        """Delete an account permission  # noqa: E501

        Delete an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_permission_using_delete(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_permission_using_delete_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_permission_using_delete_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def delete_account_permission_using_delete_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """Delete an account permission  # noqa: E501

        Delete an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_permission_using_delete_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_permission_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_account_permission_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_permission/{account_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountPermissionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_status_using_delete(self, account_status_id, **kwargs):  # noqa: E501
        """Delete an account status  # noqa: E501

        Permanently delete an account status record from an account’s history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_status_using_delete(account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_status_id: UUID account_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_status_using_delete_with_http_info(account_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_status_using_delete_with_http_info(account_status_id, **kwargs)  # noqa: E501
            return data

    def delete_account_status_using_delete_with_http_info(self, account_status_id, **kwargs):  # noqa: E501
        """Delete an account status  # noqa: E501

        Permanently delete an account status record from an account’s history.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_status_using_delete_with_http_info(account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_status_id: UUID account_status_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_status_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_status_id' is set
        if ('account_status_id' not in params or
                params['account_status_id'] is None):
            raise ValueError("Missing the required parameter `account_status_id` when calling `delete_account_status_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_status_id' in params:
            path_params['account_status_id'] = params['account_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_status/{account_status_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_type_using_delete(self, account_type_id, **kwargs):  # noqa: E501
        """Delete an account type  # noqa: E501

        Permanently delete a possible account type defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_type_using_delete(account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_type_id: UUID account_type_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_type_using_delete_with_http_info(account_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_type_using_delete_with_http_info(account_type_id, **kwargs)  # noqa: E501
            return data

    def delete_account_type_using_delete_with_http_info(self, account_type_id, **kwargs):  # noqa: E501
        """Delete an account type  # noqa: E501

        Permanently delete a possible account type defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_type_using_delete_with_http_info(account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_type_id: UUID account_type_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_type_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_type_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_type_id' is set
        if ('account_type_id' not in params or
                params['account_type_id'] is None):
            raise ValueError("Missing the required parameter `account_type_id` when calling `delete_account_type_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_type_id' in params:
            path_params['account_type_id'] = params['account_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_type/{account_type_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_account_using_delete(self, account_id, **kwargs):  # noqa: E501
        """Delete an account  # noqa: E501

        Permanently delete an account under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_using_delete(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_account_using_delete_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_account_using_delete_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def delete_account_using_delete_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """Delete an account  # noqa: E501

        Permanently delete an account under a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_account_using_delete_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_account_using_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_account_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_all_using_get(self, **kwargs):  # noqa: E501
        """List all accounts  # noqa: E501

        Get information for all accounts for all clients defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all accounts  # noqa: E501

        Get information for all accounts for all clients defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAccount',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_allocation_mapping_all_using_get(self, **kwargs):  # noqa: E501
        """List all account allocations  # noqa: E501

        Get information for all account-allocation mappings for all accounts defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_allocation_mapping_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_allocation_mapping_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_allocation_mapping_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_allocation_mapping_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account allocations  # noqa: E501

        Get information for all account-allocation mappings for all accounts defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_allocation_mapping_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_allocation_mapping_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_allocation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAccountAllocationMapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_allocation_mapping_using_get(self, account_allocation_id, **kwargs):  # noqa: E501
        """Retrieve an account allocation  # noqa: E501

        Retrieve the information for a specific account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_allocation_mapping_using_get(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_allocation_mapping_using_get_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_allocation_mapping_using_get_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
            return data

    def get_account_allocation_mapping_using_get_with_http_info(self, account_allocation_id, **kwargs):  # noqa: E501
        """Retrieve an account allocation  # noqa: E501

        Retrieve the information for a specific account-allocation mapping for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_allocation_mapping_using_get_with_http_info(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_allocation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_allocation_mapping_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_allocation_id' is set
        if ('account_allocation_id' not in params or
                params['account_allocation_id'] is None):
            raise ValueError("Missing the required parameter `account_allocation_id` when calling `get_account_allocation_mapping_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_allocation_id' in params:
            path_params['account_allocation_id'] = params['account_allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_allocation/{account_allocation_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountAllocationMapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_asset_size_agg_all_using_get(self, account_id, **kwargs):  # noqa: E501
        """List all account asset sizes  # noqa: E501

        Get a list of asset sizes by date for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_asset_size_agg_all_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Account Id (required)
        :param str currency_conversion: USD
        :param date end_date: end date
        :param bool exclude_subledger: true or false
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_asset_size_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_asset_size_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_account_asset_size_agg_all_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """List all account asset sizes  # noqa: E501

        Get a list of asset sizes by date for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_asset_size_agg_all_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Account Id (required)
        :param str currency_conversion: USD
        :param date end_date: end date
        :param bool exclude_subledger: true or false
        :param bool get_latest: true or false
        :param str sort_type:  Quarter (Q), Monthly (M) , Annually (Y), Daily (D) --caps matter, codes in ()
        :param date start_date: start date
        :return: list[AvailableDateDoubleVO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'currency_conversion', 'end_date', 'exclude_subledger', 'get_latest', 'sort_type', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_asset_size_agg_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_asset_size_agg_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'exclude_subledger' in params:
            query_params.append(('exclude_subledger', params['exclude_subledger']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'sort_type' in params:
            query_params.append(('sort_type', params['sort_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AvailableDateDoubleVO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_asset_size_all_using_get(self, **kwargs):  # noqa: E501
        """List all account asset sizes  # noqa: E501

        Get information for all account asset sizes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_asset_size_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageVAccountAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_asset_size_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_asset_size_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account asset sizes  # noqa: E501

        Get information for all account asset sizes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_asset_size_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageVAccountAssetSize
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_asset_size_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_asset_size', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageVAccountAssetSize',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_overview_using_get(self, account_id, **kwargs):  # noqa: E501
        """List all Account overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_overview_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param bool ascending: ascending
        :param str order_by: order_by
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_overview_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_overview_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_account_overview_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """List all Account overview  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_overview_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param bool ascending: ascending
        :param str order_by: order_by
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'ascending', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_overview_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_overview_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/account_overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_permission_using_get(self, account_id, **kwargs):  # noqa: E501
        """Get an account permission  # noqa: E501

        Get an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_permission_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_permission_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_permission_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_account_permission_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """Get an account permission  # noqa: E501

        Get an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_permission_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_permission_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_permission_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_permission/{account_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountPermissionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_status_all_using_get(self, **kwargs):  # noqa: E501
        """List all account statuses  # noqa: E501

        Get the account status history information for all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_status_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_status_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_status_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account statuses  # noqa: E501

        Get the account status history information for all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_status_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_status_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAccountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_status_using_get(self, account_status_id, **kwargs):  # noqa: E501
        """Retrieve an account status  # noqa: E501

        Retrieve the information for a specific account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_status_using_get(account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_status_id: UUID account_status_id (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_status_using_get_with_http_info(account_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_status_using_get_with_http_info(account_status_id, **kwargs)  # noqa: E501
            return data

    def get_account_status_using_get_with_http_info(self, account_status_id, **kwargs):  # noqa: E501
        """Retrieve an account status  # noqa: E501

        Retrieve the information for a specific account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_status_using_get_with_http_info(account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_status_id: UUID account_status_id (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_status_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_status_id' is set
        if ('account_status_id' not in params or
                params['account_status_id'] is None):
            raise ValueError("Missing the required parameter `account_status_id` when calling `get_account_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_status_id' in params:
            path_params['account_status_id'] = params['account_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_status/{account_status_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_type_all_using_get(self, **kwargs):  # noqa: E501
        """List all account types  # noqa: E501

        List all account types defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_type_all_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_type_all_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_account_type_all_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_account_type_all_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account types  # noqa: E501

        List all account types defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_type_all_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_type_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_type', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAccountType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_type_using_get(self, account_type_id, **kwargs):  # noqa: E501
        """Get an Account Type  # noqa: E501

        Get an account types defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_type_using_get(account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_type_id: UUID account_type_id (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_type_using_get_with_http_info(account_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_type_using_get_with_http_info(account_type_id, **kwargs)  # noqa: E501
            return data

    def get_account_type_using_get_with_http_info(self, account_type_id, **kwargs):  # noqa: E501
        """Get an Account Type  # noqa: E501

        Get an account types defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_type_using_get_with_http_info(account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_type_id: UUID account_type_id (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_type_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_type_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_type_id' is set
        if ('account_type_id' not in params or
                params['account_type_id'] is None):
            raise ValueError("Missing the required parameter `account_type_id` when calling `get_account_type_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_type_id' in params:
            path_params['account_type_id'] = params['account_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_type/{account_type_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_using_get(self, account_id, **kwargs):  # noqa: E501
        """Retrieve an account  # noqa: E501

        Retrieve the information for a specific account associated with a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_account_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """Retrieve an account  # noqa: E501

        Retrieve the information for a specific account associated with a client.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Account',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_account_permission_using_get(self, **kwargs):  # noqa: E501
        """List all account permission  # noqa: E501

        List all account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_account_permission_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_account_permission_using_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_account_permission_using_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_account_permission_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all account permission  # noqa: E501

        List all account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_account_permission_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool ascending: ascending
        :param str filter: filter
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :return: PageAccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ascending', 'filter', 'order_by', 'page', 'size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_account_permission_using_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_permission', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PageAccountPermissionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_holding_agg_all_using_get(self, account_id, **kwargs):  # noqa: E501
        """List all account holdings  # noqa: E501

        Get information for all the securities that are currently being held by an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_agg_all_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param str currency_conversion: USD
        :param date end_date: end date 
        :param bool get_latest: true or false
        :param date start_date: start date 
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_holding_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_holding_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_holding_agg_all_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """List all account holdings  # noqa: E501

        Get information for all the securities that are currently being held by an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_holding_agg_all_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param str currency_conversion: USD
        :param date end_date: end date 
        :param bool get_latest: true or false
        :param date start_date: start date 
        :return: list[PortfolioHoldingAgg]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'currency_conversion', 'end_date', 'get_latest', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_holding_agg_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_portfolio_holding_agg_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'get_latest' in params:
            query_params.append(('get_latest', params['get_latest']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/holding', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PortfolioHoldingAgg]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portfolio_transaction_agg_all_using_get(self, account_id, **kwargs):  # noqa: E501
        """List all account transactions  # noqa: E501

        Get the information for all transactions for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_agg_all_using_get(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: USD
        :param date end_date: end date 
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date 
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_portfolio_transaction_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portfolio_transaction_agg_all_using_get_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def get_portfolio_transaction_agg_all_using_get_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """List all account transactions  # noqa: E501

        Get the information for all transactions for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_portfolio_transaction_agg_all_using_get_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param bool ascending: ascending
        :param str currency_conversion: USD
        :param date end_date: end date 
        :param str order_by: order_by
        :param int page: page
        :param int size: size
        :param date start_date: start date 
        :return: PagePortfolioTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'ascending', 'currency_conversion', 'end_date', 'order_by', 'page', 'size', 'start_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portfolio_transaction_agg_all_using_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_portfolio_transaction_agg_all_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'ascending' in params:
            query_params.append(('ascending', params['ascending']))  # noqa: E501
        if 'currency_conversion' in params:
            query_params.append(('currency_conversion', params['currency_conversion']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/transaction', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagePortfolioTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_account_and_related_permission_using_post(self, acl_client_permission_vo, **kwargs):  # noqa: E501
        """create an account permission  # noqa: E501

        create an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_account_and_related_permission_using_post(acl_client_permission_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AclClientPermissionVO acl_client_permission_vo: aclClientPermissionVO (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_account_and_related_permission_using_post_with_http_info(acl_client_permission_vo, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_account_and_related_permission_using_post_with_http_info(acl_client_permission_vo, **kwargs)  # noqa: E501
            return data

    def insert_account_and_related_permission_using_post_with_http_info(self, acl_client_permission_vo, **kwargs):  # noqa: E501
        """create an account permission  # noqa: E501

        create an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.insert_account_and_related_permission_using_post_with_http_info(acl_client_permission_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AclClientPermissionVO acl_client_permission_vo: aclClientPermissionVO (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['acl_client_permission_vo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_account_and_related_permission_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'acl_client_permission_vo' is set
        if ('acl_client_permission_vo' not in params or
                params['acl_client_permission_vo'] is None):
            raise ValueError("Missing the required parameter `acl_client_permission_vo` when calling `insert_account_and_related_permission_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'acl_client_permission_vo' in params:
            body_params = params['acl_client_permission_vo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_permission', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountPermissionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def subscribe_account_using_post(self, account_id, alloc_request, **kwargs):  # noqa: E501
        """Subscribe an account  # noqa: E501

        After creating an account, you may create portfolios for the account to track a client’s investment, savings, or insurance products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_account_using_post(account_id, alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param AccountAllocationMapping alloc_request: allocRequest (required)
        :return: list[Portfolio]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.subscribe_account_using_post_with_http_info(account_id, alloc_request, **kwargs)  # noqa: E501
        else:
            (data) = self.subscribe_account_using_post_with_http_info(account_id, alloc_request, **kwargs)  # noqa: E501
            return data

    def subscribe_account_using_post_with_http_info(self, account_id, alloc_request, **kwargs):  # noqa: E501
        """Subscribe an account  # noqa: E501

        After creating an account, you may create portfolios for the account to track a client’s investment, savings, or insurance products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.subscribe_account_using_post_with_http_info(account_id, alloc_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: UUID account_id (required)
        :param AccountAllocationMapping alloc_request: allocRequest (required)
        :return: list[Portfolio]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'alloc_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method subscribe_account_using_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `subscribe_account_using_post`")  # noqa: E501
        # verify the required parameter 'alloc_request' is set
        if ('alloc_request' not in params or
                params['alloc_request'] is None):
            raise ValueError("Missing the required parameter `alloc_request` when calling `subscribe_account_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'alloc_request' in params:
            body_params = params['alloc_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}/subscribe', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Portfolio]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_allocation_mapping_using_put(self, account_allocation_id, **kwargs):  # noqa: E501
        """Update an account allocation  # noqa: E501

        Update the information for an account-allocation mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_allocation_mapping_using_put(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :param object account_allocation_mapping: account_allocation_mapping
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_allocation_mapping_using_put_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_allocation_mapping_using_put_with_http_info(account_allocation_id, **kwargs)  # noqa: E501
            return data

    def update_account_allocation_mapping_using_put_with_http_info(self, account_allocation_id, **kwargs):  # noqa: E501
        """Update an account allocation  # noqa: E501

        Update the information for an account-allocation mapping.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_allocation_mapping_using_put_with_http_info(account_allocation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_allocation_id: UUID account_allocation_id (required)
        :param object account_allocation_mapping: account_allocation_mapping
        :return: AccountAllocationMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_allocation_id', 'account_allocation_mapping']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_allocation_mapping_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_allocation_id' is set
        if ('account_allocation_id' not in params or
                params['account_allocation_id'] is None):
            raise ValueError("Missing the required parameter `account_allocation_id` when calling `update_account_allocation_mapping_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_allocation_id' in params:
            path_params['account_allocation_id'] = params['account_allocation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_allocation_mapping' in params:
            body_params = params['account_allocation_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_allocation/{account_allocation_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountAllocationMapping',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_status_using_put(self, account_status, account_status_id, **kwargs):  # noqa: E501
        """Update an account status  # noqa: E501

        Update an account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_status_using_put(account_status, account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account_status: account_status (required)
        :param str account_status_id: UUID account_status_id (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_status_using_put_with_http_info(account_status, account_status_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_status_using_put_with_http_info(account_status, account_status_id, **kwargs)  # noqa: E501
            return data

    def update_account_status_using_put_with_http_info(self, account_status, account_status_id, **kwargs):  # noqa: E501
        """Update an account status  # noqa: E501

        Update an account status record for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_status_using_put_with_http_info(account_status, account_status_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account_status: account_status (required)
        :param str account_status_id: UUID account_status_id (required)
        :return: AccountStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_status', 'account_status_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_status_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_status' is set
        if ('account_status' not in params or
                params['account_status'] is None):
            raise ValueError("Missing the required parameter `account_status` when calling `update_account_status_using_put`")  # noqa: E501
        # verify the required parameter 'account_status_id' is set
        if ('account_status_id' not in params or
                params['account_status_id'] is None):
            raise ValueError("Missing the required parameter `account_status_id` when calling `update_account_status_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_status_id' in params:
            path_params['account_status_id'] = params['account_status_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_status' in params:
            body_params = params['account_status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_status/{account_status_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_type_using_put(self, account_type, account_type_id, **kwargs):  # noqa: E501
        """Update an account type  # noqa: E501

        Update the information for a possible account type defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_type_using_put(account_type, account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account_type: account_type (required)
        :param str account_type_id: UUID account_type_id (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_type_using_put_with_http_info(account_type, account_type_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_type_using_put_with_http_info(account_type, account_type_id, **kwargs)  # noqa: E501
            return data

    def update_account_type_using_put_with_http_info(self, account_type, account_type_id, **kwargs):  # noqa: E501
        """Update an account type  # noqa: E501

        Update the information for a possible account type defined for your firm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_type_using_put_with_http_info(account_type, account_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account_type: account_type (required)
        :param str account_type_id: UUID account_type_id (required)
        :return: AccountType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_type', 'account_type_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_type_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_type' is set
        if ('account_type' not in params or
                params['account_type'] is None):
            raise ValueError("Missing the required parameter `account_type` when calling `update_account_type_using_put`")  # noqa: E501
        # verify the required parameter 'account_type_id' is set
        if ('account_type_id' not in params or
                params['account_type_id'] is None):
            raise ValueError("Missing the required parameter `account_type_id` when calling `update_account_type_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_type_id' in params:
            path_params['account_type_id'] = params['account_type_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_type' in params:
            body_params = params['account_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_type/{account_type_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_using_put(self, account, account_id, **kwargs):  # noqa: E501
        """Update an account  # noqa: E501

        Update the information for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_using_put(account, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account: account (required)
        :param str account_id: UUID account_id (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_using_put_with_http_info(account, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_using_put_with_http_info(account, account_id, **kwargs)  # noqa: E501
            return data

    def update_account_using_put_with_http_info(self, account, account_id, **kwargs):  # noqa: E501
        """Update an account  # noqa: E501

        Update the information for an account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_using_put_with_http_info(account, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object account: account (required)
        :param str account_id: UUID account_id (required)
        :return: Account
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account' is set
        if ('account' not in params or
                params['account'] is None):
            raise ValueError("Missing the required parameter `account` when calling `update_account_using_put`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_account_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account' in params:
            body_params = params['account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account/{account_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Account',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_client_account_permission_using_put(self, account_id, acl_client_permission_vo, **kwargs):  # noqa: E501
        """Update an account permission  # noqa: E501

        Update an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_account_permission_using_put(account_id, acl_client_permission_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param object acl_client_permission_vo: aclClientPermissionVO (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_client_account_permission_using_put_with_http_info(account_id, acl_client_permission_vo, **kwargs)  # noqa: E501
        else:
            (data) = self.update_client_account_permission_using_put_with_http_info(account_id, acl_client_permission_vo, **kwargs)  # noqa: E501
            return data

    def update_client_account_permission_using_put_with_http_info(self, account_id, acl_client_permission_vo, **kwargs):  # noqa: E501
        """Update an account permission  # noqa: E501

        Update an account permission  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_client_account_permission_using_put_with_http_info(account_id, acl_client_permission_vo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: account_id (required)
        :param object acl_client_permission_vo: aclClientPermissionVO (required)
        :return: AccountPermissionVO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'acl_client_permission_vo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_client_account_permission_using_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_client_account_permission_using_put`")  # noqa: E501
        # verify the required parameter 'acl_client_permission_vo' is set
        if ('acl_client_permission_vo' not in params or
                params['acl_client_permission_vo'] is None):
            raise ValueError("Missing the required parameter `acl_client_permission_vo` when calling `update_client_account_permission_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'acl_client_permission_vo' in params:
            body_params = params['acl_client_permission_vo']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/account_permission/{account_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountPermissionVO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
