# nucleus_api
The Hydrogen Nucleus API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.8.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.hydrogenplatform.com/contact](https://www.hydrogenplatform.com/contact)

## Requirements.

Python 2.7 and 3.4+

### Update Base Path
Follow steps to verify the base URL path:
1. Go to configuration.py file located under nucleus_api folder.
2. Search for self.host and change/verify the URL according to the environment.
**Sandbox Base URL**
https://sandbox.hydrogenplatform.com/nucleus/v1
**Production Base URL**
https://api.hydrogenplatform.com/nucleus/v1
3. Search for self.admin_host and change/verify the URL according to the environment.
**Sandbox Base URL**
https://sandbox.hydrogenplatform.com/admin/v1
**Production Base URL**
https://api.hydrogenplatform.com/admin/v1
## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import nucleus_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nucleus_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nucleus_api
from nucleus_api.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: oauth2
configuration = nucleus_api.Configuration()

# create an instance of the API class
api_instance = nucleus_api.AuthApi(nucleus_api.ApiClient(configuration))

#api_token_response = api_instance.create_using_post_client_credentials("client_id", "password")

# OR

#api_token_response = api_instance.create_using_post_password_credentials("client_id","password", "username", "secret" )
# OR

# api_token_response = api_instance.create_client_token_credentials("client_id", "password", "client_token");

configuration.access_token = api_token_response.access_token


# create an instance of the API class
api_instance = nucleus_api.AccountApi(nucleus_api.ApiClient(configuration))
alloc_request = nucleus_api.AccountAllocationMapping() # AccountAllocationMapping | allocRequest

try:
    # Create an account allocation
    api_response = api_instance.create_account_allocation_mapping_using_post(alloc_request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AccountApi->create_account_allocation_mapping_using_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://sandbox.hydrogenplatform.com/nucleus/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountApi* | [**create_account_allocation_mapping_using_post**](docs/AccountApi.md#create_account_allocation_mapping_using_post) | **POST** /account_allocation | Create an account allocation
*AccountApi* | [**create_account_status_using_post**](docs/AccountApi.md#create_account_status_using_post) | **POST** /account_status | Create an account status
*AccountApi* | [**create_account_type_using_post**](docs/AccountApi.md#create_account_type_using_post) | **POST** /account_type | Create an account type
*AccountApi* | [**create_account_using_post**](docs/AccountApi.md#create_account_using_post) | **POST** /account | Create an account
*AccountApi* | [**delete_account_allocation_mapping_using_delete**](docs/AccountApi.md#delete_account_allocation_mapping_using_delete) | **DELETE** /account_allocation/{account_allocation_id} | Delete an account allocation
*AccountApi* | [**delete_account_permission_using_delete**](docs/AccountApi.md#delete_account_permission_using_delete) | **DELETE** /account_permission/{account_id} | Delete an account permission
*AccountApi* | [**delete_account_status_using_delete**](docs/AccountApi.md#delete_account_status_using_delete) | **DELETE** /account_status/{account_status_id} | Delete an account status
*AccountApi* | [**delete_account_type_using_delete**](docs/AccountApi.md#delete_account_type_using_delete) | **DELETE** /account_type/{account_type_id} | Delete an account type
*AccountApi* | [**delete_account_using_delete**](docs/AccountApi.md#delete_account_using_delete) | **DELETE** /account/{account_id} | Delete an account
*AccountApi* | [**get_account_all_using_get**](docs/AccountApi.md#get_account_all_using_get) | **GET** /account | List all accounts
*AccountApi* | [**get_account_allocation_mapping_all_using_get**](docs/AccountApi.md#get_account_allocation_mapping_all_using_get) | **GET** /account_allocation | List all account allocations
*AccountApi* | [**get_account_allocation_mapping_using_get**](docs/AccountApi.md#get_account_allocation_mapping_using_get) | **GET** /account_allocation/{account_allocation_id} | Retrieve an account allocation
*AccountApi* | [**get_account_asset_size_agg_all_using_get**](docs/AccountApi.md#get_account_asset_size_agg_all_using_get) | **GET** /account/{account_id}/asset_size | List all account asset sizes
*AccountApi* | [**get_account_asset_size_all_using_get**](docs/AccountApi.md#get_account_asset_size_all_using_get) | **GET** /account_asset_size | List all account asset sizes
*AccountApi* | [**get_account_overview_using_get**](docs/AccountApi.md#get_account_overview_using_get) | **GET** /account/{account_id}/account_overview | List all Account overview
*AccountApi* | [**get_account_permission_using_get**](docs/AccountApi.md#get_account_permission_using_get) | **GET** /account_permission/{account_id} | Get an account permission
*AccountApi* | [**get_account_status_all_using_get**](docs/AccountApi.md#get_account_status_all_using_get) | **GET** /account_status | List all account statuses
*AccountApi* | [**get_account_status_using_get**](docs/AccountApi.md#get_account_status_using_get) | **GET** /account_status/{account_status_id} | Retrieve an account status
*AccountApi* | [**get_account_type_all_using_get**](docs/AccountApi.md#get_account_type_all_using_get) | **GET** /account_type | List all account types
*AccountApi* | [**get_account_type_using_get**](docs/AccountApi.md#get_account_type_using_get) | **GET** /account_type/{account_type_id} | Get an Account Type
*AccountApi* | [**get_account_using_get**](docs/AccountApi.md#get_account_using_get) | **GET** /account/{account_id} | Retrieve an account
*AccountApi* | [**get_all_account_permission_using_get**](docs/AccountApi.md#get_all_account_permission_using_get) | **GET** /account_permission | List all account permission
*AccountApi* | [**get_portfolio_holding_agg_all_using_get**](docs/AccountApi.md#get_portfolio_holding_agg_all_using_get) | **GET** /account/{account_id}/holding | List all account holdings
*AccountApi* | [**get_portfolio_transaction_agg_all_using_get**](docs/AccountApi.md#get_portfolio_transaction_agg_all_using_get) | **GET** /account/{account_id}/transaction | List all account transactions
*AccountApi* | [**insert_account_and_related_permission_using_post**](docs/AccountApi.md#insert_account_and_related_permission_using_post) | **POST** /account_permission | create an account permission
*AccountApi* | [**subscribe_account_using_post**](docs/AccountApi.md#subscribe_account_using_post) | **POST** /account/{account_id}/subscribe | Subscribe an account
*AccountApi* | [**update_account_allocation_mapping_using_put**](docs/AccountApi.md#update_account_allocation_mapping_using_put) | **PUT** /account_allocation/{account_allocation_id} | Update an account allocation
*AccountApi* | [**update_account_status_using_put**](docs/AccountApi.md#update_account_status_using_put) | **PUT** /account_status/{account_status_id} | Update an account status
*AccountApi* | [**update_account_type_using_put**](docs/AccountApi.md#update_account_type_using_put) | **PUT** /account_type/{account_type_id} | Update an account type
*AccountApi* | [**update_account_using_put**](docs/AccountApi.md#update_account_using_put) | **PUT** /account/{account_id} | Update an account
*AccountApi* | [**update_client_account_permission_using_put**](docs/AccountApi.md#update_client_account_permission_using_put) | **PUT** /account_permission/{account_id} | Update an account permission
*AdminClientApi* | [**create_admin_client_using_post**](docs/AdminClientApi.md#create_admin_client_using_post) | **POST** /client | Create an admin client
*AdminClientApi* | [**delete_admin_client_using_get**](docs/AdminClientApi.md#delete_admin_client_using_get) | **DELETE** /client/{client_id} | Delete an admin client
*AdminClientApi* | [**get_admin_client_using_get**](docs/AdminClientApi.md#get_admin_client_using_get) | **GET** /client/{client_id} | Get an admin client
*AdminClientApi* | [**get_all_admin_client_using_get**](docs/AdminClientApi.md#get_all_admin_client_using_get) | **GET** /client | List all admin clients
*AdminClientApi* | [**update_admin_client_using_put**](docs/AdminClientApi.md#update_admin_client_using_put) | **PUT** /client/{client_id} | Update an admin client
*AggregationAccountApi* | [**create_aggregation_account_balance_bulk_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_balance_bulk_using_post) | **POST** /bulk_aggregation_account_balance | Create a bulk aggregation account balance
*AggregationAccountApi* | [**create_aggregation_account_balance_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_balance_using_post) | **POST** /aggregation_account_balance | Create an aggregation account balance
*AggregationAccountApi* | [**create_aggregation_account_bulk_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_bulk_using_post) | **POST** /bulk_aggregation_account | Create a bulk aggregation account
*AggregationAccountApi* | [**create_aggregation_account_holding_bulk_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_holding_bulk_using_post) | **POST** /bulk_aggregation_account_holding | Create a bulk aggregation account holding
*AggregationAccountApi* | [**create_aggregation_account_holding_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_holding_using_post) | **POST** /aggregation_account_holding | Create an aggregation account holding
*AggregationAccountApi* | [**create_aggregation_account_transaction_bulk_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_transaction_bulk_using_post) | **POST** /bulk_aggregation_account_transaction | Create a bulk aggregation account transaction
*AggregationAccountApi* | [**create_aggregation_account_transaction_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_transaction_using_post) | **POST** /aggregation_account_transaction | Create an aggregation account transaction
*AggregationAccountApi* | [**create_aggregation_account_using_post**](docs/AggregationAccountApi.md#create_aggregation_account_using_post) | **POST** /aggregation_account | Create an aggregation account
*AggregationAccountApi* | [**delete_aggregation_account_balance_using_delete**](docs/AggregationAccountApi.md#delete_aggregation_account_balance_using_delete) | **DELETE** /aggregation_account_balance/{aggregation_account_balance_id} | Delete an aggregation account balance
*AggregationAccountApi* | [**delete_aggregation_account_holding_using_delete**](docs/AggregationAccountApi.md#delete_aggregation_account_holding_using_delete) | **DELETE** /aggregation_account_holding/{aggregation_account_holding_id} | Delete an aggregation account holding
*AggregationAccountApi* | [**delete_aggregation_account_transaction_using_delete**](docs/AggregationAccountApi.md#delete_aggregation_account_transaction_using_delete) | **DELETE** /aggregation_account_transaction/{aggregation_account_transaction_id} | Delete an aggregation account transaction
*AggregationAccountApi* | [**delete_aggregation_account_using_delete**](docs/AggregationAccountApi.md#delete_aggregation_account_using_delete) | **DELETE** /aggregation_account/{aggregation_account_id} | Delete an aggregation account
*AggregationAccountApi* | [**get_aggregation_account_aggregate_data_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_aggregate_data_using_get) | **GET** /aggregation_account/{aggregation_account_id}/aggregate_data | Retrieve an aggregation account aggregate data
*AggregationAccountApi* | [**get_aggregation_account_all_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_all_using_get) | **GET** /aggregation_account | List all aggregation accounts
*AggregationAccountApi* | [**get_aggregation_account_balance_all_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_balance_all_using_get) | **GET** /aggregation_account_balance | List all aggregation account balances
*AggregationAccountApi* | [**get_aggregation_account_balance_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_balance_using_get) | **GET** /aggregation_account_balance/{aggregation_account_balance_id} | Retrieve an aggregation account balance
*AggregationAccountApi* | [**get_aggregation_account_holding_all_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_holding_all_using_get) | **GET** /aggregation_account_holding | List all aggregation account holdings
*AggregationAccountApi* | [**get_aggregation_account_holding_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_holding_using_get) | **GET** /aggregation_account_holding/{aggregation_account_holding_id} | Retrieve an aggregation account holding
*AggregationAccountApi* | [**get_aggregation_account_overview_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_overview_using_get) | **GET** /client/{client_id}/aggregation_account_overview | Retrieve an aggregation account aggregate data
*AggregationAccountApi* | [**get_aggregation_account_transaction_all_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_transaction_all_using_get) | **GET** /aggregation_account_transaction | List all aggregation account transactions
*AggregationAccountApi* | [**get_aggregation_account_transaction_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_transaction_using_get) | **GET** /aggregation_account_transaction/{aggregation_account_transaction_id} | Retrieve an aggregation account transaction
*AggregationAccountApi* | [**get_aggregation_account_using_get**](docs/AggregationAccountApi.md#get_aggregation_account_using_get) | **GET** /aggregation_account/{aggregation_account_id} | Retrieve an aggregation account
*AggregationAccountApi* | [**update_aggregation_account_balance_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_balance_using_put) | **PUT** /aggregation_account_balance/{aggregation_account_balance_id} | Update an aggregation account balance
*AggregationAccountApi* | [**update_aggregation_account_bulk_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_bulk_using_put) | **PUT** /bulk_aggregation_account | Update a bulk aggregation account
*AggregationAccountApi* | [**update_aggregation_account_holding_bulk_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_holding_bulk_using_put) | **PUT** /bulk_aggregation_account_holding | Update an bulk aggregation account holding
*AggregationAccountApi* | [**update_aggregation_account_holding_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_holding_using_put) | **PUT** /aggregation_account_holding/{aggregation_account_holding_id} | Update an aggregation account holding
*AggregationAccountApi* | [**update_aggregation_account_transaction_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_transaction_using_put) | **PUT** /aggregation_account_transaction/{aggregation_account_transaction_id} | Update an aggregation account transaction
*AggregationAccountApi* | [**update_aggregation_account_using_put**](docs/AggregationAccountApi.md#update_aggregation_account_using_put) | **PUT** /aggregation_account/{aggregation_account_id} | Update an aggregation account
*AllocationApi* | [**create_allocation_composition_using_post**](docs/AllocationApi.md#create_allocation_composition_using_post) | **POST** /allocation_composition | Create an allocation composition
*AllocationApi* | [**create_allocation_using_post**](docs/AllocationApi.md#create_allocation_using_post) | **POST** /allocation | Create an allocation
*AllocationApi* | [**delete_allocation_composition_using_delete**](docs/AllocationApi.md#delete_allocation_composition_using_delete) | **DELETE** /allocation_composition/{allocation_composition_id} | Delete an allocation composition
*AllocationApi* | [**delete_allocation_using_delete**](docs/AllocationApi.md#delete_allocation_using_delete) | **DELETE** /allocation/{allocation_id} | Delete an allocation
*AllocationApi* | [**get_allocation_all_aggregate_data_using_get**](docs/AllocationApi.md#get_allocation_all_aggregate_data_using_get) | **GET** /allocation/{allocation_id}/aggregate_data | List all Allocation aggregated data overview
*AllocationApi* | [**get_allocation_all_asset_size_all_using_get**](docs/AllocationApi.md#get_allocation_all_asset_size_all_using_get) | **GET** /allocation/{allocation_id}/asset_size | List all allocation asset sizes
*AllocationApi* | [**get_allocation_all_holding_all_using_get**](docs/AllocationApi.md#get_allocation_all_holding_all_using_get) | **GET** /allocation/{allocation_id}/holding | List all allocation holdings
*AllocationApi* | [**get_allocation_all_transaction_all_using_get**](docs/AllocationApi.md#get_allocation_all_transaction_all_using_get) | **GET** /allocation/{allocation_id}/transaction | List all allocation transactions
*AllocationApi* | [**get_allocation_all_using_get**](docs/AllocationApi.md#get_allocation_all_using_get) | **GET** /allocation | List all allocations
*AllocationApi* | [**get_allocation_composition_all_using_get**](docs/AllocationApi.md#get_allocation_composition_all_using_get) | **GET** /allocation_composition | List all allocations compositions
*AllocationApi* | [**get_allocation_composition_using_get**](docs/AllocationApi.md#get_allocation_composition_using_get) | **GET** /allocation_composition/{allocation_composition_id} | Retrieve an allocation composition
*AllocationApi* | [**get_allocation_using_get**](docs/AllocationApi.md#get_allocation_using_get) | **GET** /allocation/{allocation_id} | Retrieve an allocation
*AllocationApi* | [**update_allocation_composition_using_put**](docs/AllocationApi.md#update_allocation_composition_using_put) | **PUT** /allocation_composition/{allocation_composition_id} | Update an allocation composition
*AllocationApi* | [**update_allocation_using_put**](docs/AllocationApi.md#update_allocation_using_put) | **PUT** /allocation/{allocation_id} | Update an allocation
*ApplicationApi* | [**create_application_using_post**](docs/ApplicationApi.md#create_application_using_post) | **POST** /application | Create an application
*ApplicationApi* | [**delete_application_using_delete**](docs/ApplicationApi.md#delete_application_using_delete) | **DELETE** /application/{application_id} | Delete an Application
*ApplicationApi* | [**get_application_all_using_get**](docs/ApplicationApi.md#get_application_all_using_get) | **GET** /application | List all Application
*ApplicationApi* | [**get_application_using_get**](docs/ApplicationApi.md#get_application_using_get) | **GET** /application/{application_id} | Retrieve an Application
*ApplicationApi* | [**update_application_using_put**](docs/ApplicationApi.md#update_application_using_put) | **PUT** /application/{application_id} | Update an Application
*AuditLogApi* | [**create_audit_log_using_post**](docs/AuditLogApi.md#create_audit_log_using_post) | **POST** /audit_log | Create a audit log
*AuditLogApi* | [**get_audit_log_all_using_get**](docs/AuditLogApi.md#get_audit_log_all_using_get) | **GET** /audit_log | List all audit log
*AuditLogApi* | [**get_audit_log_using_get**](docs/AuditLogApi.md#get_audit_log_using_get) | **GET** /audit_log/{audit_log_id} | Retrieve a audit log
*BenchmarkApi* | [**create_benchmark_using_post**](docs/BenchmarkApi.md#create_benchmark_using_post) | **POST** /benchmark | Create a benchmark
*BenchmarkApi* | [**delete_benchmark_using_delete**](docs/BenchmarkApi.md#delete_benchmark_using_delete) | **DELETE** /benchmark/{benchmark_id} | Delete a benchmark
*BenchmarkApi* | [**get_benchmark_all_using_get**](docs/BenchmarkApi.md#get_benchmark_all_using_get) | **GET** /benchmark | List all benchmarks
*BenchmarkApi* | [**get_benchmark_asset_size_all_using_get**](docs/BenchmarkApi.md#get_benchmark_asset_size_all_using_get) | **GET** /benchmark/{benchmark_id}/asset_size | List all benchmark asset sizes
*BenchmarkApi* | [**get_benchmark_using_get**](docs/BenchmarkApi.md#get_benchmark_using_get) | **GET** /benchmark/{benchmark_id} | Retrieve a benchmark
*BenchmarkApi* | [**update_benchmark_using_put**](docs/BenchmarkApi.md#update_benchmark_using_put) | **PUT** /benchmark/{benchmark_id} | Update a benchmark
*BudgetApi* | [**create_budget_using_post**](docs/BudgetApi.md#create_budget_using_post) | **POST** /budget | Create a budget request
*BudgetApi* | [**delete_budget_using_delete**](docs/BudgetApi.md#delete_budget_using_delete) | **DELETE** /budget/{budget_id} | Delete a budget request
*BudgetApi* | [**get_budget_all_using_get**](docs/BudgetApi.md#get_budget_all_using_get) | **GET** /budget | List all budget requests
*BudgetApi* | [**get_budget_using_get**](docs/BudgetApi.md#get_budget_using_get) | **GET** /budget/{budget_id} | Retrieve a budget request
*BudgetApi* | [**update_budget_using_put**](docs/BudgetApi.md#update_budget_using_put) | **PUT** /budget/{budget_id} | Update a budget request
*BulkApi* | [**create_bulk_using_post**](docs/BulkApi.md#create_bulk_using_post) | **POST** /bulk/{entity_uri} | Create a bulk data
*BulkApi* | [**delete_bulk_using_delete**](docs/BulkApi.md#delete_bulk_using_delete) | **DELETE** /bulk/{entity_uri} | Delete a bulk data
*BulkApi* | [**get_bulk_status_using_get**](docs/BulkApi.md#get_bulk_status_using_get) | **GET** /bulk/status/{id} | Status of bulk transaction
*BulkApi* | [**update_bulk_using_put**](docs/BulkApi.md#update_bulk_using_put) | **PUT** /bulk/{entity_uri} | Update a bulk data
*BusinessApi* | [**create_business_using_post**](docs/BusinessApi.md#create_business_using_post) | **POST** /business | Create a business
*BusinessApi* | [**delete_business_using_delete**](docs/BusinessApi.md#delete_business_using_delete) | **DELETE** /business/{business_id} | Delete a business
*BusinessApi* | [**get_business_all_using_get**](docs/BusinessApi.md#get_business_all_using_get) | **GET** /business | List all business
*BusinessApi* | [**get_business_asset_size_using_get**](docs/BusinessApi.md#get_business_asset_size_using_get) | **GET** /business/{business_id}/asset_size | List all business asset sizes
*BusinessApi* | [**get_business_client_transaction_all_using_get**](docs/BusinessApi.md#get_business_client_transaction_all_using_get) | **GET** /business/{business_id}/transaction | List all business transactions
*BusinessApi* | [**get_business_holding_using_get**](docs/BusinessApi.md#get_business_holding_using_get) | **GET** /business/{business_id}/holding | List all business holdings
*BusinessApi* | [**get_business_using_get**](docs/BusinessApi.md#get_business_using_get) | **GET** /business/{business_id} | Retrieve a business
*BusinessApi* | [**update_business_using_put**](docs/BusinessApi.md#update_business_using_put) | **PUT** /business/{business_id} | Update a business
*CardApi* | [**create_card_program_using_post**](docs/CardApi.md#create_card_program_using_post) | **POST** /card_program | Create a cardProgram request
*CardApi* | [**create_card_using_post**](docs/CardApi.md#create_card_using_post) | **POST** /card | Create a card request
*CardApi* | [**delete_card_program_using_delete**](docs/CardApi.md#delete_card_program_using_delete) | **DELETE** /card_program/{card_program_id} | Delete an cardProgram
*CardApi* | [**delete_card_using_delete**](docs/CardApi.md#delete_card_using_delete) | **DELETE** /card/{card_id} | Delete a card request
*CardApi* | [**get_card_all_using_get**](docs/CardApi.md#get_card_all_using_get) | **GET** /card | List all card requests
*CardApi* | [**get_card_asset_size_agg_all_using_get**](docs/CardApi.md#get_card_asset_size_agg_all_using_get) | **GET** /card/{card_id}/asset_size | List all card asset sizes
*CardApi* | [**get_card_program_all_using_get**](docs/CardApi.md#get_card_program_all_using_get) | **GET** /card_program | List all cardProgram
*CardApi* | [**get_card_program_using_get**](docs/CardApi.md#get_card_program_using_get) | **GET** /card_program/{card_program_id} | Retrieve an cardProgram
*CardApi* | [**get_card_transaction_agg_all_using_get**](docs/CardApi.md#get_card_transaction_agg_all_using_get) | **GET** /card/{card_id}/transaction | List all card transactions
*CardApi* | [**get_card_using_get**](docs/CardApi.md#get_card_using_get) | **GET** /card/{card_id} | Retrieve a card request
*CardApi* | [**update_card_program_using_put**](docs/CardApi.md#update_card_program_using_put) | **PUT** /card_program/{card_program_id} | Update an cardProgram
*CardApi* | [**update_card_using_put**](docs/CardApi.md#update_card_using_put) | **PUT** /card/{card_id} | Update a card request
*ClientApi* | [**create_client_status_using_post**](docs/ClientApi.md#create_client_status_using_post) | **POST** /client_status | Create an client status
*ClientApi* | [**create_client_using_post**](docs/ClientApi.md#create_client_using_post) | **POST** /client | Create a client
*ClientApi* | [**delete_client_status_using_delete**](docs/ClientApi.md#delete_client_status_using_delete) | **DELETE** /client_status/{client_status_id} | Delete an client status
*ClientApi* | [**delete_client_using_delete**](docs/ClientApi.md#delete_client_using_delete) | **DELETE** /client/{client_id} | Delete a client
*ClientApi* | [**get_client_account_overview_using_get**](docs/ClientApi.md#get_client_account_overview_using_get) | **GET** /client/{client_id}/account_overview | List all client Account overview
*ClientApi* | [**get_client_advisor_overview_using_get**](docs/ClientApi.md#get_client_advisor_overview_using_get) | **GET** /client/{client_id}/advisor_overview | Advisor overview
*ClientApi* | [**get_client_all_using_get**](docs/ClientApi.md#get_client_all_using_get) | **GET** /client | List all clients
*ClientApi* | [**get_client_asset_size_using_get**](docs/ClientApi.md#get_client_asset_size_using_get) | **GET** /client/{client_id}/asset_size | List all client asset sizes
*ClientApi* | [**get_client_goal_overview_using_get**](docs/ClientApi.md#get_client_goal_overview_using_get) | **GET** /client/{client_id}/goal_overview | Retrieve client&#39;s goal details 
*ClientApi* | [**get_client_holding_using_get**](docs/ClientApi.md#get_client_holding_using_get) | **GET** /client/{client_id}/holding | List all client holdings
*ClientApi* | [**get_client_status_all_using_get**](docs/ClientApi.md#get_client_status_all_using_get) | **GET** /client_status | List all client statuses
*ClientApi* | [**get_client_status_using_get**](docs/ClientApi.md#get_client_status_using_get) | **GET** /client_status/{client_status_id} | Retrieve an client status
*ClientApi* | [**get_client_transaction_all_using_get**](docs/ClientApi.md#get_client_transaction_all_using_get) | **GET** /client/{client_id}/transaction | List all client transactions
*ClientApi* | [**get_client_using_get**](docs/ClientApi.md#get_client_using_get) | **GET** /client/{client_id} | Retrieve a client
*ClientApi* | [**update_client_status_using_put**](docs/ClientApi.md#update_client_status_using_put) | **PUT** /client_status/{client_status_id} | Update an client status
*ClientApi* | [**update_client_using_put**](docs/ClientApi.md#update_client_using_put) | **PUT** /client/{client_id} | Update a client
*CustomerApi* | [**create_customer_revenue_using_post**](docs/CustomerApi.md#create_customer_revenue_using_post) | **POST** /customer_revenue | Create a customer revenue
*CustomerApi* | [**create_customer_using_post**](docs/CustomerApi.md#create_customer_using_post) | **POST** /customer | Create a customer
*CustomerApi* | [**delete_customer_revenue_using_delete**](docs/CustomerApi.md#delete_customer_revenue_using_delete) | **DELETE** /customer_revenue/{customer_revenue_id} | Delete a customer revenue
*CustomerApi* | [**delete_customer_using_delete**](docs/CustomerApi.md#delete_customer_using_delete) | **DELETE** /customer/{customer_id} | Delete a customer
*CustomerApi* | [**get_customer_all_using_get**](docs/CustomerApi.md#get_customer_all_using_get) | **GET** /customer | List all customer
*CustomerApi* | [**get_customer_revenue_all_using_get**](docs/CustomerApi.md#get_customer_revenue_all_using_get) | **GET** /customer_revenue | List all customer revenue
*CustomerApi* | [**get_customer_revenue_using_get**](docs/CustomerApi.md#get_customer_revenue_using_get) | **GET** /customer_revenue/{customer_revenue_id} | Retrieve a customer revenue
*CustomerApi* | [**get_customer_using_get**](docs/CustomerApi.md#get_customer_using_get) | **GET** /customer/{customer_id} | Retrieve a customer
*CustomerApi* | [**update_customer_revenue_using_put**](docs/CustomerApi.md#update_customer_revenue_using_put) | **PUT** /customer_revenue/{customer_revenue_id} | Update a customer revenue
*CustomerApi* | [**update_customer_using_put**](docs/CustomerApi.md#update_customer_using_put) | **PUT** /customer/{customer_id} | Update a customer
*DecisionTreeApi* | [**create_decision_tree_result_using_post**](docs/DecisionTreeApi.md#create_decision_tree_result_using_post) | **POST** /decision_tree_result | Decision tree result
*DecisionTreeApi* | [**create_decision_tree_using_post**](docs/DecisionTreeApi.md#create_decision_tree_using_post) | **POST** /decision_tree | Create a decision tree
*DecisionTreeApi* | [**create_node_relationship_using_post**](docs/DecisionTreeApi.md#create_node_relationship_using_post) | **POST** /node_relationship | Create a node relationship
*DecisionTreeApi* | [**create_node_using_post**](docs/DecisionTreeApi.md#create_node_using_post) | **POST** /node | Create a node
*DecisionTreeApi* | [**delete_decision_tree_using_delete**](docs/DecisionTreeApi.md#delete_decision_tree_using_delete) | **DELETE** /decision_tree/{decision_tree_id} | Delete a decision tree
*DecisionTreeApi* | [**delete_node_relationship_using_delete**](docs/DecisionTreeApi.md#delete_node_relationship_using_delete) | **DELETE** /node_relationship/{node_relationship_id} | Delete a node relationship
*DecisionTreeApi* | [**delete_node_using_delete**](docs/DecisionTreeApi.md#delete_node_using_delete) | **DELETE** /node/{node_id} | Delete a node
*DecisionTreeApi* | [**get_decision_tree_all_using_get**](docs/DecisionTreeApi.md#get_decision_tree_all_using_get) | **GET** /decision_tree | List all decision tree
*DecisionTreeApi* | [**get_decision_tree_using_get**](docs/DecisionTreeApi.md#get_decision_tree_using_get) | **GET** /decision_tree/{decision_tree_id} | Retrieve a decision tree
*DecisionTreeApi* | [**get_node_all_using_get**](docs/DecisionTreeApi.md#get_node_all_using_get) | **GET** /node | List all nodes
*DecisionTreeApi* | [**get_node_relationship_all_using_get**](docs/DecisionTreeApi.md#get_node_relationship_all_using_get) | **GET** /node_relationship | List all node relationships
*DecisionTreeApi* | [**get_node_relationship_using_get**](docs/DecisionTreeApi.md#get_node_relationship_using_get) | **GET** /node_relationship/{node_relationship_id} | Retrieve a node relationship
*DecisionTreeApi* | [**get_node_using_get**](docs/DecisionTreeApi.md#get_node_using_get) | **GET** /node/{node_id} | Retrieve a node
*DecisionTreeApi* | [**update_decision_tree_using_put**](docs/DecisionTreeApi.md#update_decision_tree_using_put) | **PUT** /decision_tree/{decision_tree_id} | Update a decision tree
*DecisionTreeApi* | [**update_node_relationship_using_put**](docs/DecisionTreeApi.md#update_node_relationship_using_put) | **PUT** /node_relationship/{node_relationship_id} | Update a node relationship
*DecisionTreeApi* | [**update_node_using_put**](docs/DecisionTreeApi.md#update_node_using_put) | **PUT** /node/{node_id} | Update a node
*DocumentApi* | [**create_document_using_post**](docs/DocumentApi.md#create_document_using_post) | **POST** /document | Create a Document
*DocumentApi* | [**delete_document_using_delete**](docs/DocumentApi.md#delete_document_using_delete) | **DELETE** /document/{document_id} | Delete a tenant document by Id
*DocumentApi* | [**get_document_all_using_get**](docs/DocumentApi.md#get_document_all_using_get) | **GET** /document | List all Documents
*DocumentApi* | [**get_document_using_get**](docs/DocumentApi.md#get_document_using_get) | **GET** /document/{document_id} | Retrieve a Tenant Document by Document Id
*DocumentApi* | [**update_document_using_put**](docs/DocumentApi.md#update_document_using_put) | **PUT** /document/{document_id} | Update a Tenant Document
*FeatureApi* | [**create_feature_track_using_post**](docs/FeatureApi.md#create_feature_track_using_post) | **POST** /feature_track | Create a Feature Track
*FeatureApi* | [**create_feature_using_post**](docs/FeatureApi.md#create_feature_using_post) | **POST** /feature | Create a  Feature
*FeatureApi* | [**delete_feature_track_using_delete**](docs/FeatureApi.md#delete_feature_track_using_delete) | **DELETE** /feature_track/{feature_track_id} | Delete a Feature Track
*FeatureApi* | [**delete_feature_using_delete**](docs/FeatureApi.md#delete_feature_using_delete) | **DELETE** /feature/{feature_id} | Delete a Feature
*FeatureApi* | [**get_feature_all_using_get**](docs/FeatureApi.md#get_feature_all_using_get) | **GET** /feature | List all Feature
*FeatureApi* | [**get_feature_track_all_using_get**](docs/FeatureApi.md#get_feature_track_all_using_get) | **GET** /feature_track | List all Feature track
*FeatureApi* | [**get_feature_track_using_get**](docs/FeatureApi.md#get_feature_track_using_get) | **GET** /feature_track/{feature_track_id} | Retrieve a Feature track
*FeatureApi* | [**get_feature_using_get**](docs/FeatureApi.md#get_feature_using_get) | **GET** /feature/{feature_id} | Retrieve a Feature
*FeatureApi* | [**update_feature_track_using_put**](docs/FeatureApi.md#update_feature_track_using_put) | **PUT** /feature_track/{feature_track_id} | Update a Feature Track
*FeatureApi* | [**update_feature_using_put**](docs/FeatureApi.md#update_feature_using_put) | **PUT** /feature/{feature_id} | Update a Feature
*FinancialStatementApi* | [**create_financial_statement_using_post**](docs/FinancialStatementApi.md#create_financial_statement_using_post) | **POST** /financial_statement | Create an financialStatement
*FinancialStatementApi* | [**delete_financial_statement_using_delete**](docs/FinancialStatementApi.md#delete_financial_statement_using_delete) | **DELETE** /financial_statement/{financial_statement_id} | Delete an financialStatement
*FinancialStatementApi* | [**get_financial_statement_all_using_get**](docs/FinancialStatementApi.md#get_financial_statement_all_using_get) | **GET** /financial_statement | List all financialStatement
*FinancialStatementApi* | [**get_financial_statement_using_get**](docs/FinancialStatementApi.md#get_financial_statement_using_get) | **GET** /financial_statement/{financial_statement_id} | Retrieve an financialStatement
*FinancialStatementApi* | [**update_financial_statement_using_put**](docs/FinancialStatementApi.md#update_financial_statement_using_put) | **PUT** /financial_statement/{financial_statement_id} | Update an financialStatement
*FundingApi* | [**create_bank_link_using_post**](docs/FundingApi.md#create_bank_link_using_post) | **POST** /bank_link | Create a bank link
*FundingApi* | [**create_deposit_using_post**](docs/FundingApi.md#create_deposit_using_post) | **POST** /deposit | Create a deposit request
*FundingApi* | [**create_funding_using_post**](docs/FundingApi.md#create_funding_using_post) | **POST** /funding | Create a funding request
*FundingApi* | [**create_transfer_using_post**](docs/FundingApi.md#create_transfer_using_post) | **POST** /transfer | Create a transfer requests
*FundingApi* | [**create_withdrawal_using_post**](docs/FundingApi.md#create_withdrawal_using_post) | **POST** /withdrawal | Create a withdrawal request
*FundingApi* | [**delete_bank_link_using_delete**](docs/FundingApi.md#delete_bank_link_using_delete) | **DELETE** /bank_link/{bank_link_id} | Delete a bank link
*FundingApi* | [**delete_deposit_using_delete**](docs/FundingApi.md#delete_deposit_using_delete) | **DELETE** /deposit/{deposit_id} | Delete a deposit request
*FundingApi* | [**delete_funding_using_delete**](docs/FundingApi.md#delete_funding_using_delete) | **DELETE** /funding/{funding_id} | Delete a funding request
*FundingApi* | [**delete_transfer_using_delete**](docs/FundingApi.md#delete_transfer_using_delete) | **DELETE** /transfer/{transfer_id} | Delete a transfer request
*FundingApi* | [**delete_withdrawal_using_delete**](docs/FundingApi.md#delete_withdrawal_using_delete) | **DELETE** /withdrawal/{withdrawal_id} | Delete a withdrawal request
*FundingApi* | [**get_bank_link_all_using_get**](docs/FundingApi.md#get_bank_link_all_using_get) | **GET** /bank_link | List all bank links
*FundingApi* | [**get_bank_link_using_get**](docs/FundingApi.md#get_bank_link_using_get) | **GET** /bank_link/{bank_link_id} | Retrieve a bank link
*FundingApi* | [**get_deposit_all_using_get**](docs/FundingApi.md#get_deposit_all_using_get) | **GET** /deposit | List all deposit requests
*FundingApi* | [**get_deposit_using_get**](docs/FundingApi.md#get_deposit_using_get) | **GET** /deposit/{deposit_id} | Retrieve a deposit request
*FundingApi* | [**get_funding_all_using_get**](docs/FundingApi.md#get_funding_all_using_get) | **GET** /funding | List all funding requests 
*FundingApi* | [**get_funding_using_get**](docs/FundingApi.md#get_funding_using_get) | **GET** /funding/{funding_id} | Retrieve a funding request
*FundingApi* | [**get_transfer_all_using_get**](docs/FundingApi.md#get_transfer_all_using_get) | **GET** /transfer | List all transfer requests
*FundingApi* | [**get_transfer_using_get**](docs/FundingApi.md#get_transfer_using_get) | **GET** /transfer/{transfer_id} | Retrieve a transfer request
*FundingApi* | [**get_withdrawal_all_using_get**](docs/FundingApi.md#get_withdrawal_all_using_get) | **GET** /withdrawal | List all withdrawal requests
*FundingApi* | [**get_withdrawal_using_get**](docs/FundingApi.md#get_withdrawal_using_get) | **GET** /withdrawal/{withdrawal_id} | Retrieve a withdrawal request
*FundingApi* | [**update_bank_link_bulk_using_put**](docs/FundingApi.md#update_bank_link_bulk_using_put) | **PUT** /bulk_bank_link | Update list of bank link
*FundingApi* | [**update_bank_link_using_put**](docs/FundingApi.md#update_bank_link_using_put) | **PUT** /bank_link/{bank_link_id} | Update a bank link
*FundingApi* | [**update_deposit_using_put**](docs/FundingApi.md#update_deposit_using_put) | **PUT** /deposit/{deposit_id} | Update a deposit request
*FundingApi* | [**update_funding_using_put**](docs/FundingApi.md#update_funding_using_put) | **PUT** /funding/{funding_id} | Update a funding request
*FundingApi* | [**update_transfer_using_put**](docs/FundingApi.md#update_transfer_using_put) | **PUT** /transfer/{transfer_id} | Update a transfer request
*FundingApi* | [**update_withdrawal_using_put**](docs/FundingApi.md#update_withdrawal_using_put) | **PUT** /withdrawal/{withdrawal_id} | Update a withdrawal request
*GoalApi* | [**create_goal_track_using_post**](docs/GoalApi.md#create_goal_track_using_post) | **POST** /goal_track | Create a goal track record
*GoalApi* | [**create_goal_using_post**](docs/GoalApi.md#create_goal_using_post) | **POST** /goal | Create a goal
*GoalApi* | [**delete_goal_track_using_delete**](docs/GoalApi.md#delete_goal_track_using_delete) | **DELETE** /goal_track/{goal_track_id} | Delete a goal track record
*GoalApi* | [**delete_goal_using_delete**](docs/GoalApi.md#delete_goal_using_delete) | **DELETE** /goal/{goal_id} | Delete a goal
*GoalApi* | [**get_goal_all_using_get**](docs/GoalApi.md#get_goal_all_using_get) | **GET** /goal | List all goals
*GoalApi* | [**get_goal_asset_size_all_using_get**](docs/GoalApi.md#get_goal_asset_size_all_using_get) | **GET** /goal/{goal_id}/asset_size | List goal asset sizes
*GoalApi* | [**get_goal_holding_all_using_get**](docs/GoalApi.md#get_goal_holding_all_using_get) | **GET** /goal/{goal_id}/holding | List goal holdings
*GoalApi* | [**get_goal_track_all_using_get**](docs/GoalApi.md#get_goal_track_all_using_get) | **GET** /goal_track | List all goal track records
*GoalApi* | [**get_goal_track_using_get**](docs/GoalApi.md#get_goal_track_using_get) | **GET** /goal_track/{goal_track_id} | Retrieve a goal track record
*GoalApi* | [**get_goal_transaction_all_using_get**](docs/GoalApi.md#get_goal_transaction_all_using_get) | **GET** /goal/{goal_id}/transaction | List goal transactions
*GoalApi* | [**get_goal_using_get**](docs/GoalApi.md#get_goal_using_get) | **GET** /goal/{goal_id} | Retrieve a goal
*GoalApi* | [**update_goal_track_using_put**](docs/GoalApi.md#update_goal_track_using_put) | **PUT** /goal_track/{goal_track_id} | Update a goal track record
*GoalApi* | [**update_goal_using_put**](docs/GoalApi.md#update_goal_using_put) | **PUT** /goal/{goal_id} | Update a goal
*HouseholdApi* | [**create_household_using_post**](docs/HouseholdApi.md#create_household_using_post) | **POST** /household | Create a Household
*HouseholdApi* | [**delete_household_using_delete**](docs/HouseholdApi.md#delete_household_using_delete) | **DELETE** /household/{household_id} | Delete a Household
*HouseholdApi* | [**get_household_all_using_get**](docs/HouseholdApi.md#get_household_all_using_get) | **GET** /household | List all household
*HouseholdApi* | [**get_household_client_asset_size_using_get**](docs/HouseholdApi.md#get_household_client_asset_size_using_get) | **GET** /household/{household_id}/asset_size | List all household client asset sizes
*HouseholdApi* | [**get_household_client_holding_using_get**](docs/HouseholdApi.md#get_household_client_holding_using_get) | **GET** /household/{household_id}/holding | List all household&#39;s clientIds holdings
*HouseholdApi* | [**get_household_client_transaction_using_get**](docs/HouseholdApi.md#get_household_client_transaction_using_get) | **GET** /household/{household_id}/transaction | List all household&#39;s client ids transactions
*HouseholdApi* | [**get_household_using_get**](docs/HouseholdApi.md#get_household_using_get) | **GET** /household/{household_id} | Retrieve a Household
*HouseholdApi* | [**update_household_using_put**](docs/HouseholdApi.md#update_household_using_put) | **PUT** /household/{household_id} | Update a Household
*InvoiceApi* | [**create_invoice_payment_using_post**](docs/InvoiceApi.md#create_invoice_payment_using_post) | **POST** /invoice_payment | Create a invoicePayment
*InvoiceApi* | [**create_invoice_using_post**](docs/InvoiceApi.md#create_invoice_using_post) | **POST** /invoice | Create a invoice
*InvoiceApi* | [**delete_invoice_payment_using_delete**](docs/InvoiceApi.md#delete_invoice_payment_using_delete) | **DELETE** /invoice_payment/{invoice_payment_id} | Delete a invoicePayment
*InvoiceApi* | [**delete_invoice_using_delete**](docs/InvoiceApi.md#delete_invoice_using_delete) | **DELETE** /invoice/{invoice_id} | Delete a invoice
*InvoiceApi* | [**get_invoice_all_using_get**](docs/InvoiceApi.md#get_invoice_all_using_get) | **GET** /invoice | List all invoices
*InvoiceApi* | [**get_invoice_payment_all_using_get**](docs/InvoiceApi.md#get_invoice_payment_all_using_get) | **GET** /invoice_payment | List all invoice payments
*InvoiceApi* | [**get_invoice_payment_using_get**](docs/InvoiceApi.md#get_invoice_payment_using_get) | **GET** /invoice_payment/{invoice_payment_id} | Retrieve a invoicePayment
*InvoiceApi* | [**get_invoice_using_get**](docs/InvoiceApi.md#get_invoice_using_get) | **GET** /invoice/{invoice_id} | Retrieve a invoice
*InvoiceApi* | [**update_invoice_payment_using_put**](docs/InvoiceApi.md#update_invoice_payment_using_put) | **PUT** /invoice_payment/{invoice_payment_id} | Update a invoicePayment
*InvoiceApi* | [**update_invoice_using_put**](docs/InvoiceApi.md#update_invoice_using_put) | **PUT** /invoice/{invoice_id} | Update a invoice
*ModelApi* | [**create_model_asset_size_using_post**](docs/ModelApi.md#create_model_asset_size_using_post) | **POST** /model_asset_size | Create a model asset size
*ModelApi* | [**create_model_change_using_post**](docs/ModelApi.md#create_model_change_using_post) | **POST** /model/{model_id}/model_change | Change a model composition
*ModelApi* | [**create_model_comment_using_post**](docs/ModelApi.md#create_model_comment_using_post) | **POST** /model_comment | Create a model commentary
*ModelApi* | [**create_model_holding_using_post**](docs/ModelApi.md#create_model_holding_using_post) | **POST** /model_holding | Create a model holding
*ModelApi* | [**create_model_transaction_using_post**](docs/ModelApi.md#create_model_transaction_using_post) | **POST** /model_transaction | Create a model transaction
*ModelApi* | [**create_model_using_post**](docs/ModelApi.md#create_model_using_post) | **POST** /model | Create a model
*ModelApi* | [**delete_model_asset_size_using_delete**](docs/ModelApi.md#delete_model_asset_size_using_delete) | **DELETE** /model_asset_size/{model_asset_size_id} | Delete a model asset size
*ModelApi* | [**delete_model_comment_using_delete**](docs/ModelApi.md#delete_model_comment_using_delete) | **DELETE** /model_comment/{model_comment_id} | Delete a model commentary
*ModelApi* | [**delete_model_holding_using_delete**](docs/ModelApi.md#delete_model_holding_using_delete) | **DELETE** /model_holding/{model_holding_id} | Delete a model holding
*ModelApi* | [**delete_model_transaction_using_delete**](docs/ModelApi.md#delete_model_transaction_using_delete) | **DELETE** /model_transaction/{model_transaction_id} | Delete a model transaction
*ModelApi* | [**delete_model_using_delete**](docs/ModelApi.md#delete_model_using_delete) | **DELETE** /model/{model_id} | Delete a model
*ModelApi* | [**get_model_all_using_get**](docs/ModelApi.md#get_model_all_using_get) | **GET** /model | List all models
*ModelApi* | [**get_model_asset_size_all_using_get**](docs/ModelApi.md#get_model_asset_size_all_using_get) | **GET** /model_asset_size | List all model asset sizes
*ModelApi* | [**get_model_asset_size_using_get**](docs/ModelApi.md#get_model_asset_size_using_get) | **GET** /model_asset_size/{model_asset_size_id} | Retrieve a model asset size
*ModelApi* | [**get_model_comment_all_using_get**](docs/ModelApi.md#get_model_comment_all_using_get) | **GET** /model_comment | List all model commentaries
*ModelApi* | [**get_model_comment_using_get**](docs/ModelApi.md#get_model_comment_using_get) | **GET** /model_comment/{model_comment_id} | Retrieve a model commentary
*ModelApi* | [**get_model_holding_all_using_get**](docs/ModelApi.md#get_model_holding_all_using_get) | **GET** /model_holding | List all model holdings
*ModelApi* | [**get_model_holding_using_get**](docs/ModelApi.md#get_model_holding_using_get) | **GET** /model_holding/{model_holding_id} | Retrieve a model holding
*ModelApi* | [**get_model_transaction_all_using_get**](docs/ModelApi.md#get_model_transaction_all_using_get) | **GET** /model_transaction | List all model transactions
*ModelApi* | [**get_model_transaction_using_get**](docs/ModelApi.md#get_model_transaction_using_get) | **GET** /model_transaction/{model_transaction_id} | Retrieve a model transaction
*ModelApi* | [**get_model_using_get**](docs/ModelApi.md#get_model_using_get) | **GET** /model/{model_id} | Retrieve a model
*ModelApi* | [**update_model_asset_size_using_put**](docs/ModelApi.md#update_model_asset_size_using_put) | **PUT** /model_asset_size/{model_asset_size_id} | Update a model asset size
*ModelApi* | [**update_model_comment_using_put**](docs/ModelApi.md#update_model_comment_using_put) | **PUT** /model_comment/{model_comment_id} | Update a model commentary
*ModelApi* | [**update_model_holding_using_put**](docs/ModelApi.md#update_model_holding_using_put) | **PUT** /model_holding/{model_holding_id} | Update a model holding
*ModelApi* | [**update_model_transaction_using_put**](docs/ModelApi.md#update_model_transaction_using_put) | **PUT** /model_transaction/{model_transaction_id} | Update a model transaction
*ModelApi* | [**update_model_using_put**](docs/ModelApi.md#update_model_using_put) | **PUT** /model/{model_id} | Update a model
*NotificationApi* | [**create_notification_client_using_post**](docs/NotificationApi.md#create_notification_client_using_post) | **POST** /notification_client | Create a Notification Client
*NotificationApi* | [**create_notification_setting_using_post**](docs/NotificationApi.md#create_notification_setting_using_post) | **POST** /notification_setting | Create a Notification Setting
*NotificationApi* | [**create_notification_using_post**](docs/NotificationApi.md#create_notification_using_post) | **POST** /notification | Create a Notification
*NotificationApi* | [**delete_notification_client_using_delete**](docs/NotificationApi.md#delete_notification_client_using_delete) | **DELETE** /notification_client/{notification_client_id} | Delete a Notification Client
*NotificationApi* | [**delete_notification_setting_using_delete**](docs/NotificationApi.md#delete_notification_setting_using_delete) | **DELETE** /notification_setting/{notification_setting_id} | Delete a Notification Setting
*NotificationApi* | [**delete_notification_using_delete**](docs/NotificationApi.md#delete_notification_using_delete) | **DELETE** /notification/{notification_id} | Delete a Notification
*NotificationApi* | [**get_notification_all_using_get**](docs/NotificationApi.md#get_notification_all_using_get) | **GET** /notification | Get All Notifications
*NotificationApi* | [**get_notification_client_all_using_get**](docs/NotificationApi.md#get_notification_client_all_using_get) | **GET** /notification_client | List all Notification Client
*NotificationApi* | [**get_notification_client_using_get**](docs/NotificationApi.md#get_notification_client_using_get) | **GET** /notification_client/{notification_client_id} | Retrieve a Notification Client
*NotificationApi* | [**get_notification_setting_all_using_get**](docs/NotificationApi.md#get_notification_setting_all_using_get) | **GET** /notification_setting | List all Notification Setting
*NotificationApi* | [**get_notification_setting_using_get**](docs/NotificationApi.md#get_notification_setting_using_get) | **GET** /notification_setting/{notification_setting_id} | Retrieve a Notification Setting
*NotificationApi* | [**get_notification_using_get**](docs/NotificationApi.md#get_notification_using_get) | **GET** /notification/{notification_id} | Get a Notification
*NotificationApi* | [**update_notification_client_using_put**](docs/NotificationApi.md#update_notification_client_using_put) | **PUT** /notification_client/{notification_client_id} | Update a Notification Client
*NotificationApi* | [**update_notification_setting_using_put**](docs/NotificationApi.md#update_notification_setting_using_put) | **PUT** /notification_setting/{notification_setting_id} | Update a Notification Setting
*NotificationApi* | [**update_notification_using_put**](docs/NotificationApi.md#update_notification_using_put) | **PUT** /notification/{notification_id} | Update a Notification
*OrderApi* | [**create_account_order_bulk_using_post**](docs/OrderApi.md#create_account_order_bulk_using_post) | **POST** /account/{account_id}/order_bulk | Bulk orders for an account
*OrderApi* | [**create_account_order_buy_only_using_post**](docs/OrderApi.md#create_account_order_buy_only_using_post) | **POST** /account/{account_id}/order_buy_only | Create buy-only account rebalance orders
*OrderApi* | [**create_account_order_rebalance_using_post**](docs/OrderApi.md#create_account_order_rebalance_using_post) | **POST** /account/{account_id}/order_rebalance | Create account rebalance orders
*OrderApi* | [**create_account_order_reconciliation**](docs/OrderApi.md#create_account_order_reconciliation) | **POST** /account/{account_id}/order_reconciliation | Create account reconciliation order
*OrderApi* | [**create_account_order_sell_all_using_post**](docs/OrderApi.md#create_account_order_sell_all_using_post) | **POST** /account/{account_id}/order_sell_all | Sell all account order
*OrderApi* | [**create_account_order_sell_only_using_post**](docs/OrderApi.md#create_account_order_sell_only_using_post) | **POST** /account/{account_id}/order_sell_only | Create sell-only account rebalance orders
*OrderApi* | [**create_client_order_bulk_using_post**](docs/OrderApi.md#create_client_order_bulk_using_post) | **POST** /client/{client_id}/order_bulk | Bulk orders for a client
*OrderApi* | [**create_order_bulk_using_post**](docs/OrderApi.md#create_order_bulk_using_post) | **POST** /order_bulk | Bulk orders for your firm
*OrderApi* | [**create_order_status_using_post**](docs/OrderApi.md#create_order_status_using_post) | **POST** /order_status | Create an order status
*OrderApi* | [**create_order_track_using_post**](docs/OrderApi.md#create_order_track_using_post) | **POST** /order_track | Create an order tracking record
*OrderApi* | [**create_order_using_post**](docs/OrderApi.md#create_order_using_post) | **POST** /order | Create an order record
*OrderApi* | [**create_portfolio_order_buy_only_using_post**](docs/OrderApi.md#create_portfolio_order_buy_only_using_post) | **POST** /portfolio/{portfolio_id}/order_buy_only | Create buy-only portfolio rebalance orders
*OrderApi* | [**create_portfolio_order_rebalance_using_post**](docs/OrderApi.md#create_portfolio_order_rebalance_using_post) | **POST** /portfolio/{portfolio_id}/order_rebalance | Create portfolio rebalance orders
*OrderApi* | [**create_portfolio_order_reconciliation**](docs/OrderApi.md#create_portfolio_order_reconciliation) | **POST** /portfolio/{portfolio_id}/order_reconciliation | Create portfolio reconciliation order
*OrderApi* | [**create_portfolio_order_sell_all_using_post**](docs/OrderApi.md#create_portfolio_order_sell_all_using_post) | **POST** /portfolio/{portfolio_id}/order_sell_all | Sell all portfolio order
*OrderApi* | [**create_portfolio_order_sell_only_using_post**](docs/OrderApi.md#create_portfolio_order_sell_only_using_post) | **POST** /portfolio/{portfolio_id}/order_sell_only | Create sell-only portfolio rebalance orders
*OrderApi* | [**delete_order_status_using_delete**](docs/OrderApi.md#delete_order_status_using_delete) | **DELETE** /order_status/{order_status_id} | Delete an order status
*OrderApi* | [**delete_order_track_using_delete**](docs/OrderApi.md#delete_order_track_using_delete) | **DELETE** /order_track/{order_track_id} | Delete an order tracking record
*OrderApi* | [**delete_order_using_delete**](docs/OrderApi.md#delete_order_using_delete) | **DELETE** /order/{order_id} | Delete an order record
*OrderApi* | [**get_order_all_using_get**](docs/OrderApi.md#get_order_all_using_get) | **GET** /order | List all order records
*OrderApi* | [**get_order_bulk_all_using_get**](docs/OrderApi.md#get_order_bulk_all_using_get) | **GET** /order_bulk | List all bulk orders
*OrderApi* | [**get_order_status_all_using_get**](docs/OrderApi.md#get_order_status_all_using_get) | **GET** /order_status | List all order statuses
*OrderApi* | [**get_order_status_using_get**](docs/OrderApi.md#get_order_status_using_get) | **GET** /order_status/{order_status_id} | Retrieve an order status
*OrderApi* | [**get_order_track_all_using_get**](docs/OrderApi.md#get_order_track_all_using_get) | **GET** /order_track | List all order tracking records
*OrderApi* | [**get_order_track_using_get**](docs/OrderApi.md#get_order_track_using_get) | **GET** /order_track/{order_track_id} | Retrieve an order tracking record
*OrderApi* | [**get_order_using_get**](docs/OrderApi.md#get_order_using_get) | **GET** /order/{order_id} | Retrieve an order record
*OrderApi* | [**update_order_status_using_put**](docs/OrderApi.md#update_order_status_using_put) | **PUT** /order_status/{order_status_id} | Update an order status
*OrderApi* | [**update_order_track_using_put**](docs/OrderApi.md#update_order_track_using_put) | **PUT** /order_track/{order_track_id} | Update an order tracking record
*OrderApi* | [**update_order_using_put**](docs/OrderApi.md#update_order_using_put) | **PUT** /order/{order_id} | Update an order record
*OverflowApi* | [**create_overflow_settings_using_post**](docs/OverflowApi.md#create_overflow_settings_using_post) | **POST** /overflow_setting | Create a Overflow Settings request
*OverflowApi* | [**create_overflow_using_post**](docs/OverflowApi.md#create_overflow_using_post) | **POST** /overflow | Create a Overflow request
*OverflowApi* | [**delete_overflow_settings_using_delete**](docs/OverflowApi.md#delete_overflow_settings_using_delete) | **DELETE** /overflow_setting/{overflow_settings_id} | Delete a overflow settings
*OverflowApi* | [**get_overflow_all_using_get**](docs/OverflowApi.md#get_overflow_all_using_get) | **GET** /overflow | List all overflow objects
*OverflowApi* | [**get_overflow_settings_all_using_get**](docs/OverflowApi.md#get_overflow_settings_all_using_get) | **GET** /overflow_setting | List all overflow settings
*OverflowApi* | [**get_overflow_settings_using_get**](docs/OverflowApi.md#get_overflow_settings_using_get) | **GET** /overflow_setting/{overflow_settings_id} | Retrieve a Overflow Setting
*OverflowApi* | [**get_overflow_using_get**](docs/OverflowApi.md#get_overflow_using_get) | **GET** /overflow/{overflow_id} | Retrieve a Overflow object
*OverflowApi* | [**update_overflow_settings_using_put**](docs/OverflowApi.md#update_overflow_settings_using_put) | **PUT** /overflow_setting/{overflow_settings_id} | Update a overflow settings
*PerformanceApi* | [**get_account_performance_using_get**](docs/PerformanceApi.md#get_account_performance_using_get) | **GET** /account/{account_id}/performance | Account Performance
*PerformanceApi* | [**get_allocation_performance_using_get**](docs/PerformanceApi.md#get_allocation_performance_using_get) | **GET** /allocation/{allocation_id}/performance | Allocation Performance
*PerformanceApi* | [**get_benchmark_performance_using_get**](docs/PerformanceApi.md#get_benchmark_performance_using_get) | **GET** /benchmark/{benchmark_id}/performance | Benchmark Performance
*PerformanceApi* | [**get_client_performance_using_get**](docs/PerformanceApi.md#get_client_performance_using_get) | **GET** /client/{client_id}/performance | Client Performance
*PerformanceApi* | [**get_goal_performance_using_get**](docs/PerformanceApi.md#get_goal_performance_using_get) | **GET** /goal/{goal_id}/performance | Goal Performance
*PerformanceApi* | [**get_household_client_performance_using_get**](docs/PerformanceApi.md#get_household_client_performance_using_get) | **GET** /household/{household_id}/performance | Household Performance
*PerformanceApi* | [**get_model_performance_using_get**](docs/PerformanceApi.md#get_model_performance_using_get) | **GET** /model/{model_id}/performance | Model Performance
*PerformanceApi* | [**get_portfolio_performance_using_get**](docs/PerformanceApi.md#get_portfolio_performance_using_get) | **GET** /portfolio/{portfolio_id}/performance | Portfolio Performance
*PerformanceApi* | [**get_security_performance_using_get**](docs/PerformanceApi.md#get_security_performance_using_get) | **GET** /security/{security_id}/performance | Security Performance
*PortfolioApi* | [**create_portfolio_asset_size_using_post**](docs/PortfolioApi.md#create_portfolio_asset_size_using_post) | **POST** /portfolio_asset_size | Create a portfolio asset size
*PortfolioApi* | [**create_portfolio_comment_using_post**](docs/PortfolioApi.md#create_portfolio_comment_using_post) | **POST** /portfolio_comment | Create a portfolio commentary
*PortfolioApi* | [**create_portfolio_goal_using_post**](docs/PortfolioApi.md#create_portfolio_goal_using_post) | **POST** /portfolio_goal | Create an portfolio goal
*PortfolioApi* | [**create_portfolio_holding_using_post**](docs/PortfolioApi.md#create_portfolio_holding_using_post) | **POST** /portfolio_holding | Create a portfolio holding
*PortfolioApi* | [**create_portfolio_transaction_using_post**](docs/PortfolioApi.md#create_portfolio_transaction_using_post) | **POST** /portfolio_transaction | Create a portfolio transaction
*PortfolioApi* | [**create_portfolio_using_post**](docs/PortfolioApi.md#create_portfolio_using_post) | **POST** /portfolio | Create a portfolio
*PortfolioApi* | [**delete_portfolio_asset_size_using_delete**](docs/PortfolioApi.md#delete_portfolio_asset_size_using_delete) | **DELETE** /portfolio_asset_size/{portfolio_asset_size_id} | Delete a portfolio asset size
*PortfolioApi* | [**delete_portfolio_comment_using_delete**](docs/PortfolioApi.md#delete_portfolio_comment_using_delete) | **DELETE** /portfolio_comment/{portfolio_comment_id} | Delete a portfolio commentary
*PortfolioApi* | [**delete_portfolio_goal_using_delete**](docs/PortfolioApi.md#delete_portfolio_goal_using_delete) | **DELETE** /portfolio_goal/{portfolio_goal_id} | Delete an portfolio goal
*PortfolioApi* | [**delete_portfolio_holding_using_delete**](docs/PortfolioApi.md#delete_portfolio_holding_using_delete) | **DELETE** /portfolio_holding/{portfolio_holding_id} | Delete a portfolio holding
*PortfolioApi* | [**delete_portfolio_transaction_using_delete**](docs/PortfolioApi.md#delete_portfolio_transaction_using_delete) | **DELETE** /portfolio_transaction/{portfolio_transaction_id} | Delete a portfolio transaction
*PortfolioApi* | [**delete_portfolio_using_delete**](docs/PortfolioApi.md#delete_portfolio_using_delete) | **DELETE** /portfolio/{portfolio_id} | Delete a portfolio
*PortfolioApi* | [**get_portfolio_aggregated_data_using_get**](docs/PortfolioApi.md#get_portfolio_aggregated_data_using_get) | **GET** /portfolio/{portfolio_id}/aggregate_data | Retrieve an portfolio aggregate data
*PortfolioApi* | [**get_portfolio_all_using_get**](docs/PortfolioApi.md#get_portfolio_all_using_get) | **GET** /portfolio | List all portfolios
*PortfolioApi* | [**get_portfolio_asset_size_all_using_get**](docs/PortfolioApi.md#get_portfolio_asset_size_all_using_get) | **GET** /portfolio_asset_size | Retrieve a portfolio asset size
*PortfolioApi* | [**get_portfolio_asset_size_using_get**](docs/PortfolioApi.md#get_portfolio_asset_size_using_get) | **GET** /portfolio_asset_size/{portfolio_asset_size_id} | Retrieve a portfolio asset size
*PortfolioApi* | [**get_portfolio_comment_all_using_get**](docs/PortfolioApi.md#get_portfolio_comment_all_using_get) | **GET** /portfolio_comment | List all portfolio commentary
*PortfolioApi* | [**get_portfolio_comment_using_get**](docs/PortfolioApi.md#get_portfolio_comment_using_get) | **GET** /portfolio_comment/{portfolio_comment_id} | Retrieve a portfolio commentary
*PortfolioApi* | [**get_portfolio_goal_all_using_get**](docs/PortfolioApi.md#get_portfolio_goal_all_using_get) | **GET** /portfolio_goal | List all portfolio goals
*PortfolioApi* | [**get_portfolio_goal_using_get**](docs/PortfolioApi.md#get_portfolio_goal_using_get) | **GET** /portfolio_goal/{portfolio_goal_id} | Retrieve an portfolio goal
*PortfolioApi* | [**get_portfolio_holding_all_using_get**](docs/PortfolioApi.md#get_portfolio_holding_all_using_get) | **GET** /portfolio_holding | List all portfolio holdings
*PortfolioApi* | [**get_portfolio_holding_using_get**](docs/PortfolioApi.md#get_portfolio_holding_using_get) | **GET** /portfolio_holding/{portfolio_holding_id} | Retrieve a portfolio holding
*PortfolioApi* | [**get_portfolio_transaction_all_using_get**](docs/PortfolioApi.md#get_portfolio_transaction_all_using_get) | **GET** /portfolio_transaction | List all portfolio transactions
*PortfolioApi* | [**get_portfolio_transaction_using_get**](docs/PortfolioApi.md#get_portfolio_transaction_using_get) | **GET** /portfolio_transaction/{portfolio_transaction_id} | Retrieve a portfolio transaction
*PortfolioApi* | [**get_portfolio_using_get**](docs/PortfolioApi.md#get_portfolio_using_get) | **GET** /portfolio/{portfolio_id} | Retrieve a portfolio
*PortfolioApi* | [**update_portfolio_asset_size_using_put**](docs/PortfolioApi.md#update_portfolio_asset_size_using_put) | **PUT** /portfolio_asset_size/{portfolio_asset_size_id} | Update a portfolio asset size
*PortfolioApi* | [**update_portfolio_comment_using_put**](docs/PortfolioApi.md#update_portfolio_comment_using_put) | **PUT** /portfolio_comment/{portfolio_comment_id} | Update a portfolio comment
*PortfolioApi* | [**update_portfolio_goal_using_put**](docs/PortfolioApi.md#update_portfolio_goal_using_put) | **PUT** /portfolio_goal/{portfolio_goal_id} | Update an portfolio goal
*PortfolioApi* | [**update_portfolio_holding_using_put**](docs/PortfolioApi.md#update_portfolio_holding_using_put) | **PUT** /portfolio_holding/{portfolio_holding_id} | Update a portfolio holding
*PortfolioApi* | [**update_portfolio_transaction_using_put**](docs/PortfolioApi.md#update_portfolio_transaction_using_put) | **PUT** /portfolio_transaction/{portfolio_transaction_id} | Update a portfolio transaction
*PortfolioApi* | [**update_portfolio_using_put**](docs/PortfolioApi.md#update_portfolio_using_put) | **PUT** /portfolio/{portfolio_id} | Update a portfolio
*QuestionnaireApi* | [**create_answer_using_post**](docs/QuestionnaireApi.md#create_answer_using_post) | **POST** /answer | Create an answer
*QuestionnaireApi* | [**create_client_response_using_post**](docs/QuestionnaireApi.md#create_client_response_using_post) | **POST** /client_response | Create a client response
*QuestionnaireApi* | [**create_question_using_post**](docs/QuestionnaireApi.md#create_question_using_post) | **POST** /question | Create a question
*QuestionnaireApi* | [**create_questionnaire_using_post**](docs/QuestionnaireApi.md#create_questionnaire_using_post) | **POST** /questionnaire | Create a questionnaire
*QuestionnaireApi* | [**delete_answer_using_delete**](docs/QuestionnaireApi.md#delete_answer_using_delete) | **DELETE** /answer/{answer_id} | Delete an answer
*QuestionnaireApi* | [**delete_client_response_using_delete**](docs/QuestionnaireApi.md#delete_client_response_using_delete) | **DELETE** /client_response/{client_response_id} | Delete a client response
*QuestionnaireApi* | [**delete_question_using_delete**](docs/QuestionnaireApi.md#delete_question_using_delete) | **DELETE** /question/{question_id} | Delete a question
*QuestionnaireApi* | [**delete_questionnaire_using_delete**](docs/QuestionnaireApi.md#delete_questionnaire_using_delete) | **DELETE** /questionnaire/{questionnaire_id} | Delete a questionnaire
*QuestionnaireApi* | [**get_answer_all_using_get**](docs/QuestionnaireApi.md#get_answer_all_using_get) | **GET** /answer | List all Answers
*QuestionnaireApi* | [**get_answer_using_get**](docs/QuestionnaireApi.md#get_answer_using_get) | **GET** /answer/{answer_id} | Retrieve an answer
*QuestionnaireApi* | [**get_client_response_all_using_get**](docs/QuestionnaireApi.md#get_client_response_all_using_get) | **GET** /client_response | List all client responses
*QuestionnaireApi* | [**get_client_response_using_get**](docs/QuestionnaireApi.md#get_client_response_using_get) | **GET** /client_response/{client_response_id} | Retrieve a client response
*QuestionnaireApi* | [**get_question_all_using_get**](docs/QuestionnaireApi.md#get_question_all_using_get) | **GET** /question | List all Questions
*QuestionnaireApi* | [**get_question_using_get**](docs/QuestionnaireApi.md#get_question_using_get) | **GET** /question/{question_id} | Retrieve a question
*QuestionnaireApi* | [**get_questionnaire_all_using_get**](docs/QuestionnaireApi.md#get_questionnaire_all_using_get) | **GET** /questionnaire | List all questionnaires
*QuestionnaireApi* | [**get_questionnaire_using_get**](docs/QuestionnaireApi.md#get_questionnaire_using_get) | **GET** /questionnaire/{questionnaire_id} | Retrieve a questionnaire
*QuestionnaireApi* | [**update_answer_using_put**](docs/QuestionnaireApi.md#update_answer_using_put) | **PUT** /answer/{answer_id} | Update an answer
*QuestionnaireApi* | [**update_client_response_using_put**](docs/QuestionnaireApi.md#update_client_response_using_put) | **PUT** /client_response/{client_response_id} | Update a client response
*QuestionnaireApi* | [**update_question_using_put**](docs/QuestionnaireApi.md#update_question_using_put) | **PUT** /question/{question_id} | Update a question.
*QuestionnaireApi* | [**update_questionnaire_using_put**](docs/QuestionnaireApi.md#update_questionnaire_using_put) | **PUT** /questionnaire/{questionnaire_id} | Update a questionnaire
*ResourceApi* | [**get_aggregation_account_category_mapping_using_get**](docs/ResourceApi.md#get_aggregation_account_category_mapping_using_get) | **GET** /resource/account_category | Get All Aggregation Account Category mapping
*ResourceApi* | [**get_aggregation_account_transaction_category_mapping_using_get**](docs/ResourceApi.md#get_aggregation_account_transaction_category_mapping_using_get) | **GET** /resource/merchant_category | Get All Aggregation Account Transaction Category mapping
*ResourceApi* | [**get_all_country_using_get**](docs/ResourceApi.md#get_all_country_using_get) | **GET** /resource/country | Get All Countries
*ResourceApi* | [**get_all_currency_using_get**](docs/ResourceApi.md#get_all_currency_using_get) | **GET** /resource/currency | Get All Currencies
*ResourceApi* | [**get_all_merchant_category_code_using_get**](docs/ResourceApi.md#get_all_merchant_category_code_using_get) | **GET** /resource/merchant_category_code | Get All Merchant Category Codes
*ResourceApi* | [**get_all_states_using_get**](docs/ResourceApi.md#get_all_states_using_get) | **GET** /resource/state | List all state resource
*ResourceApi* | [**get_all_statistics_using_get**](docs/ResourceApi.md#get_all_statistics_using_get) | **GET** /resource/statistic | List all statistic resource
*ResourceApi* | [**get_currency_exchange_rate_all_using_get**](docs/ResourceApi.md#get_currency_exchange_rate_all_using_get) | **GET** /resource/fx_rate | List all fxRates
*ResourceApi* | [**get_merchants_all_using_get**](docs/ResourceApi.md#get_merchants_all_using_get) | **GET** /resource/merchant | Get all merchants
*RiskProfileApi* | [**create_risk_profile_using_post**](docs/RiskProfileApi.md#create_risk_profile_using_post) | **POST** /risk_profile | Create a Risk Profile
*RiskProfileApi* | [**delete_risk_profile_using_delete**](docs/RiskProfileApi.md#delete_risk_profile_using_delete) | **DELETE** /risk_profile/{risk_profile_id} | Delete a Risk Profile
*RiskProfileApi* | [**get_risk_profile_all_using_get**](docs/RiskProfileApi.md#get_risk_profile_all_using_get) | **GET** /risk_profile | Get All Risk Profile
*RiskProfileApi* | [**get_risk_profile_using_get**](docs/RiskProfileApi.md#get_risk_profile_using_get) | **GET** /risk_profile/{risk_profile_id} | Get a Risk Profile
*RiskProfileApi* | [**update_risk_profile_using_put**](docs/RiskProfileApi.md#update_risk_profile_using_put) | **PUT** /risk_profile/{risk_profile_id} | Update a Risk Profile
*RoundupApi* | [**create_roundup_settings_using_post**](docs/RoundupApi.md#create_roundup_settings_using_post) | **POST** /roundup_setting | Create a Roundup Settings
*RoundupApi* | [**create_roundup_using_post**](docs/RoundupApi.md#create_roundup_using_post) | **POST** /roundup | Create a roundup
*RoundupApi* | [**delete_roundup_settings_using_delete**](docs/RoundupApi.md#delete_roundup_settings_using_delete) | **DELETE** /roundup_setting/{roundup_setting_id} | Delete a roundup settings
*RoundupApi* | [**get_roundup_all_using_get**](docs/RoundupApi.md#get_roundup_all_using_get) | **GET** /roundup | List all roundups
*RoundupApi* | [**get_roundup_settings_all_using_get**](docs/RoundupApi.md#get_roundup_settings_all_using_get) | **GET** /roundup_setting | List all roundup settings
*RoundupApi* | [**get_roundup_settings_using_get**](docs/RoundupApi.md#get_roundup_settings_using_get) | **GET** /roundup_setting/{roundup_setting_id} | Retrieve a Roundup Setting
*RoundupApi* | [**get_roundup_using_get**](docs/RoundupApi.md#get_roundup_using_get) | **GET** /roundup/{roundup_id} | Retrieve a Roundup
*RoundupApi* | [**update_roundup_settings_using_put**](docs/RoundupApi.md#update_roundup_settings_using_put) | **PUT** /roundup_setting/{roundup_setting_id} | Update a roundup settings
*ScoreApi* | [**create_score_using_post**](docs/ScoreApi.md#create_score_using_post) | **POST** /score | Create a score
*ScoreApi* | [**delete_score_using_delete**](docs/ScoreApi.md#delete_score_using_delete) | **DELETE** /score/{score_id} | Delete a score
*ScoreApi* | [**get_score_all_using_get**](docs/ScoreApi.md#get_score_all_using_get) | **GET** /score | List all scores
*ScoreApi* | [**get_score_using_get**](docs/ScoreApi.md#get_score_using_get) | **GET** /score/{score_id} | Retrieve a score
*ScoreApi* | [**update_score_using_put**](docs/ScoreApi.md#update_score_using_put) | **PUT** /score/{score_id} | Update a score
*SecuritiesApi* | [**create_security_exclusion_using_post**](docs/SecuritiesApi.md#create_security_exclusion_using_post) | **POST** /security_exclusion | Create a security exclusion
*SecuritiesApi* | [**create_security_price_using_post**](docs/SecuritiesApi.md#create_security_price_using_post) | **POST** /security_price | Create a security price
*SecuritiesApi* | [**create_security_using_post**](docs/SecuritiesApi.md#create_security_using_post) | **POST** /security | Create a security
*SecuritiesApi* | [**delete_security_exclusion_using_delete**](docs/SecuritiesApi.md#delete_security_exclusion_using_delete) | **DELETE** /security_exclusion/{security_exclusion_id} | Delete a security exclusion
*SecuritiesApi* | [**delete_security_price_using_delete**](docs/SecuritiesApi.md#delete_security_price_using_delete) | **DELETE** /security_price/{security_price_id} | Delete a security price
*SecuritiesApi* | [**delete_security_using_delete**](docs/SecuritiesApi.md#delete_security_using_delete) | **DELETE** /security/{security_id} | Delete a security
*SecuritiesApi* | [**get_security_all_using_get**](docs/SecuritiesApi.md#get_security_all_using_get) | **GET** /security | List all securities
*SecuritiesApi* | [**get_security_exclusion_all_using_get**](docs/SecuritiesApi.md#get_security_exclusion_all_using_get) | **GET** /security_exclusion | List all security exclusions
*SecuritiesApi* | [**get_security_exclusion_using_get**](docs/SecuritiesApi.md#get_security_exclusion_using_get) | **GET** /security_exclusion/{security_exclusion_id} | Retrieve a security exclusion
*SecuritiesApi* | [**get_security_price_all_using_get**](docs/SecuritiesApi.md#get_security_price_all_using_get) | **GET** /security_price | List all security prices
*SecuritiesApi* | [**get_security_price_using_get**](docs/SecuritiesApi.md#get_security_price_using_get) | **GET** /security_price/{security_price_id} | Retrieve a security price
*SecuritiesApi* | [**get_security_using_get**](docs/SecuritiesApi.md#get_security_using_get) | **GET** /security/{security_id} | Retrieve a security
*SecuritiesApi* | [**update_security_exclusion_using_put**](docs/SecuritiesApi.md#update_security_exclusion_using_put) | **PUT** /security_exclusion/{security_exclusion_id} | Update a security exclusion
*SecuritiesApi* | [**update_security_price_using_put**](docs/SecuritiesApi.md#update_security_price_using_put) | **PUT** /security_price/{security_price_id} | Update a security price
*SecuritiesApi* | [**update_security_using_put**](docs/SecuritiesApi.md#update_security_using_put) | **PUT** /security/{security_id} | Update a security
*SpendingControlApi* | [**create_spending_control_using_post**](docs/SpendingControlApi.md#create_spending_control_using_post) | **POST** /spending_control | Create a Spending Control
*SpendingControlApi* | [**delete_spending_control_using_delete**](docs/SpendingControlApi.md#delete_spending_control_using_delete) | **DELETE** /spending_control/{spending_control_id} | Delete a Spending Control
*SpendingControlApi* | [**get_spending_control_all_using_get**](docs/SpendingControlApi.md#get_spending_control_all_using_get) | **GET** /spending_control | List all Spending Control
*SpendingControlApi* | [**get_spending_control_using_get**](docs/SpendingControlApi.md#get_spending_control_using_get) | **GET** /spending_control/{spending_control_id} | Retrieve a Spending Control
*SpendingControlApi* | [**update_spending_control_using_put**](docs/SpendingControlApi.md#update_spending_control_using_put) | **PUT** /spending_control/{spending_control_id} | Update a Spending Control
*UtilsApi* | [**create_reason_code_using_post**](docs/UtilsApi.md#create_reason_code_using_post) | **POST** /reason_code | Create a reason code
*UtilsApi* | [**create_stage_using_post**](docs/UtilsApi.md#create_stage_using_post) | **POST** /stage | Create an account stage
*UtilsApi* | [**create_transaction_code_using_post**](docs/UtilsApi.md#create_transaction_code_using_post) | **POST** /transaction_code | Create a transaction code
*UtilsApi* | [**delete_reason_code_using_delete**](docs/UtilsApi.md#delete_reason_code_using_delete) | **DELETE** /reason_code/{reason_code_id} | Delete a reason code
*UtilsApi* | [**delete_stage_using_delete**](docs/UtilsApi.md#delete_stage_using_delete) | **DELETE** /stage/{stage_id} | Delete an account stage
*UtilsApi* | [**delete_transaction_code_using_delete**](docs/UtilsApi.md#delete_transaction_code_using_delete) | **DELETE** /transaction_code/{transaction_code_id} | Delete a transaction code
*UtilsApi* | [**get_reason_code_all_using_get**](docs/UtilsApi.md#get_reason_code_all_using_get) | **GET** /reason_code | List all reason codes
*UtilsApi* | [**get_reason_code_using_get**](docs/UtilsApi.md#get_reason_code_using_get) | **GET** /reason_code/{reason_code_id} | Retrieve a reason code
*UtilsApi* | [**get_stage_all_using_get**](docs/UtilsApi.md#get_stage_all_using_get) | **GET** /stage | List all account stages
*UtilsApi* | [**get_stage_using_get**](docs/UtilsApi.md#get_stage_using_get) | **GET** /stage/{stage_id} | Retrieve an account stage
*UtilsApi* | [**get_transaction_code_all_using_get**](docs/UtilsApi.md#get_transaction_code_all_using_get) | **GET** /transaction_code | List all transaction codes
*UtilsApi* | [**get_transaction_code_using_get**](docs/UtilsApi.md#get_transaction_code_using_get) | **GET** /transaction_code/{transaction_code_id} | Retrieve a transaction code
*UtilsApi* | [**update_reason_code_using_put**](docs/UtilsApi.md#update_reason_code_using_put) | **PUT** /reason_code/{reason_code_id} | Update a reason code
*UtilsApi* | [**update_stage_using_put**](docs/UtilsApi.md#update_stage_using_put) | **PUT** /stage/{stage_id} | Update an account stage
*UtilsApi* | [**update_transaction_code_using_put**](docs/UtilsApi.md#update_transaction_code_using_put) | **PUT** /transaction_code/{transaction_code_id} | Update a transaction code
*WebhookApi* | [**create_webhook_using_post**](docs/WebhookApi.md#create_webhook_using_post) | **POST** /webhook | Create a webhook
*WebhookApi* | [**delete_webhook_using_delete**](docs/WebhookApi.md#delete_webhook_using_delete) | **DELETE** /webhook/{webhook_id} | Delete a webhook
*WebhookApi* | [**get_webhook_all_using_get**](docs/WebhookApi.md#get_webhook_all_using_get) | **GET** /webhook | List all webhooks
*WebhookApi* | [**get_webhook_using_get**](docs/WebhookApi.md#get_webhook_using_get) | **GET** /webhook/{webhook_id} | Retrieve a webhook
*WebhookApi* | [**update_webhook_using_put**](docs/WebhookApi.md#update_webhook_using_put) | **PUT** /webhook/{webhook_id} | Update a webhook


## Documentation For Models

 - [Account](docs/Account.md)
 - [AccountAllocationMapping](docs/AccountAllocationMapping.md)
 - [AccountMap](docs/AccountMap.md)
 - [AccountPermissionVO](docs/AccountPermissionVO.md)
 - [AccountPortfolioRebalanceRequest](docs/AccountPortfolioRebalanceRequest.md)
 - [AccountStatus](docs/AccountStatus.md)
 - [AccountType](docs/AccountType.md)
 - [AclClientPermissionVO](docs/AclClientPermissionVO.md)
 - [AdminClient](docs/AdminClient.md)
 - [AggregationAccount](docs/AggregationAccount.md)
 - [AggregationAccountBalance](docs/AggregationAccountBalance.md)
 - [AggregationAccountHolding](docs/AggregationAccountHolding.md)
 - [AggregationAccountTransaction](docs/AggregationAccountTransaction.md)
 - [AggregationAccountsMap](docs/AggregationAccountsMap.md)
 - [Allocation](docs/Allocation.md)
 - [AllocationAggregatedVO](docs/AllocationAggregatedVO.md)
 - [AllocationComposition](docs/AllocationComposition.md)
 - [AllocationCompositionAggregatedVO](docs/AllocationCompositionAggregatedVO.md)
 - [AllocationCompositionModelHoldingsVO](docs/AllocationCompositionModelHoldingsVO.md)
 - [AllocationNodeMap](docs/AllocationNodeMap.md)
 - [Answer](docs/Answer.md)
 - [AnswerMap](docs/AnswerMap.md)
 - [Application](docs/Application.md)
 - [AuditLog](docs/AuditLog.md)
 - [AvailableDateDoubleVO](docs/AvailableDateDoubleVO.md)
 - [BankCredit](docs/BankCredit.md)
 - [BankLink](docs/BankLink.md)
 - [BankLinkMap](docs/BankLinkMap.md)
 - [Benchmark](docs/Benchmark.md)
 - [BenchmarkComposition](docs/BenchmarkComposition.md)
 - [Brokers](docs/Brokers.md)
 - [Budget](docs/Budget.md)
 - [BudgetAggregationAccount](docs/BudgetAggregationAccount.md)
 - [BudgetObject](docs/BudgetObject.md)
 - [BulkTransaction](docs/BulkTransaction.md)
 - [BulkTransactionVO](docs/BulkTransactionVO.md)
 - [Business](docs/Business.md)
 - [Card](docs/Card.md)
 - [CardAddress](docs/CardAddress.md)
 - [CardProgram](docs/CardProgram.md)
 - [Cash](docs/Cash.md)
 - [CategoriesMap](docs/CategoriesMap.md)
 - [CategoryInternalResponseVO](docs/CategoryInternalResponseVO.md)
 - [CategoryResponseVO](docs/CategoryResponseVO.md)
 - [Check](docs/Check.md)
 - [CheckImages](docs/CheckImages.md)
 - [Client](docs/Client.md)
 - [ClientAccountMapping](docs/ClientAccountMapping.md)
 - [ClientAddress](docs/ClientAddress.md)
 - [ClientRelationship](docs/ClientRelationship.md)
 - [ClientResponse](docs/ClientResponse.md)
 - [ClientStatus](docs/ClientStatus.md)
 - [ClientViewGoalData](docs/ClientViewGoalData.md)
 - [Country](docs/Country.md)
 - [Currency](docs/Currency.md)
 - [Customer](docs/Customer.md)
 - [CustomerAddress](docs/CustomerAddress.md)
 - [CustomerRevenue](docs/CustomerRevenue.md)
 - [DailyDeposit](docs/DailyDeposit.md)
 - [DailyWithdrawal](docs/DailyWithdrawal.md)
 - [DateDoubleVO](docs/DateDoubleVO.md)
 - [DecisionTree](docs/DecisionTree.md)
 - [DecisionTreeCO](docs/DecisionTreeCO.md)
 - [DecisionTreeResultVO](docs/DecisionTreeResultVO.md)
 - [Document](docs/Document.md)
 - [Employment](docs/Employment.md)
 - [ExternalAccountTransfer](docs/ExternalAccountTransfer.md)
 - [Feature](docs/Feature.md)
 - [FeatureTrack](docs/FeatureTrack.md)
 - [FinancialStatement](docs/FinancialStatement.md)
 - [Funding](docs/Funding.md)
 - [FundingRequestMap](docs/FundingRequestMap.md)
 - [FxRateView](docs/FxRateView.md)
 - [Goal](docs/Goal.md)
 - [GoalAccountMapping](docs/GoalAccountMapping.md)
 - [GoalTrack](docs/GoalTrack.md)
 - [GoalTrackAccounts](docs/GoalTrackAccounts.md)
 - [Household](docs/Household.md)
 - [Investment](docs/Investment.md)
 - [Invoice](docs/Invoice.md)
 - [InvoicePayment](docs/InvoicePayment.md)
 - [JsonNode](docs/JsonNode.md)
 - [LineItems](docs/LineItems.md)
 - [Location](docs/Location.md)
 - [MXMerchantRes](docs/MXMerchantRes.md)
 - [Member](docs/Member.md)
 - [MerchantCategoryCode](docs/MerchantCategoryCode.md)
 - [MerchantsMap](docs/MerchantsMap.md)
 - [Model](docs/Model.md)
 - [ModelAssetSize](docs/ModelAssetSize.md)
 - [ModelComment](docs/ModelComment.md)
 - [ModelHolding](docs/ModelHolding.md)
 - [ModelHoldingVO](docs/ModelHoldingVO.md)
 - [ModelTransaction](docs/ModelTransaction.md)
 - [Node](docs/Node.md)
 - [NodeRelationship](docs/NodeRelationship.md)
 - [Notification](docs/Notification.md)
 - [NotificationClient](docs/NotificationClient.md)
 - [NotificationSetting](docs/NotificationSetting.md)
 - [Order](docs/Order.md)
 - [OrderBulk](docs/OrderBulk.md)
 - [OrderReconcileRequest](docs/OrderReconcileRequest.md)
 - [OrderReconcileReturnObject](docs/OrderReconcileReturnObject.md)
 - [OrderStatus](docs/OrderStatus.md)
 - [OrderTrack](docs/OrderTrack.md)
 - [OrderVoClone](docs/OrderVoClone.md)
 - [Overflow](docs/Overflow.md)
 - [OverflowBankLinkMap](docs/OverflowBankLinkMap.md)
 - [OverflowSettings](docs/OverflowSettings.md)
 - [OverflowVO](docs/OverflowVO.md)
 - [Ownership](docs/Ownership.md)
 - [PageAccount](docs/PageAccount.md)
 - [PageAccountAllocationMapping](docs/PageAccountAllocationMapping.md)
 - [PageAccountPermissionVO](docs/PageAccountPermissionVO.md)
 - [PageAccountStatus](docs/PageAccountStatus.md)
 - [PageAccountType](docs/PageAccountType.md)
 - [PageAdminClient](docs/PageAdminClient.md)
 - [PageAggregationAccount](docs/PageAggregationAccount.md)
 - [PageAggregationAccountBalance](docs/PageAggregationAccountBalance.md)
 - [PageAggregationAccountHolding](docs/PageAggregationAccountHolding.md)
 - [PageAggregationAccountTransaction](docs/PageAggregationAccountTransaction.md)
 - [PageAllocation](docs/PageAllocation.md)
 - [PageAllocationComposition](docs/PageAllocationComposition.md)
 - [PageAnswer](docs/PageAnswer.md)
 - [PageApplication](docs/PageApplication.md)
 - [PageAuditLog](docs/PageAuditLog.md)
 - [PageBankLink](docs/PageBankLink.md)
 - [PageBenchmark](docs/PageBenchmark.md)
 - [PageBudget](docs/PageBudget.md)
 - [PageBusiness](docs/PageBusiness.md)
 - [PageCard](docs/PageCard.md)
 - [PageCardProgram](docs/PageCardProgram.md)
 - [PageClient](docs/PageClient.md)
 - [PageClientResponse](docs/PageClientResponse.md)
 - [PageClientStatus](docs/PageClientStatus.md)
 - [PageCustomer](docs/PageCustomer.md)
 - [PageCustomerRevenue](docs/PageCustomerRevenue.md)
 - [PageDailyDeposit](docs/PageDailyDeposit.md)
 - [PageDailyWithdrawal](docs/PageDailyWithdrawal.md)
 - [PageDecisionTree](docs/PageDecisionTree.md)
 - [PageDocument](docs/PageDocument.md)
 - [PageExternalAccountTransfer](docs/PageExternalAccountTransfer.md)
 - [PageFeature](docs/PageFeature.md)
 - [PageFeatureTrack](docs/PageFeatureTrack.md)
 - [PageFinancialStatement](docs/PageFinancialStatement.md)
 - [PageFunding](docs/PageFunding.md)
 - [PageGoal](docs/PageGoal.md)
 - [PageGoalTrack](docs/PageGoalTrack.md)
 - [PageHousehold](docs/PageHousehold.md)
 - [PageInvoice](docs/PageInvoice.md)
 - [PageInvoicePayment](docs/PageInvoicePayment.md)
 - [PageMXMerchantRes](docs/PageMXMerchantRes.md)
 - [PageModel](docs/PageModel.md)
 - [PageModelAssetSize](docs/PageModelAssetSize.md)
 - [PageModelComment](docs/PageModelComment.md)
 - [PageModelHolding](docs/PageModelHolding.md)
 - [PageModelTransaction](docs/PageModelTransaction.md)
 - [PageNode](docs/PageNode.md)
 - [PageNodeRelationship](docs/PageNodeRelationship.md)
 - [PageNotification](docs/PageNotification.md)
 - [PageNotificationClient](docs/PageNotificationClient.md)
 - [PageNotificationSetting](docs/PageNotificationSetting.md)
 - [PageOrder](docs/PageOrder.md)
 - [PageOrderBulk](docs/PageOrderBulk.md)
 - [PageOrderStatus](docs/PageOrderStatus.md)
 - [PageOrderTrack](docs/PageOrderTrack.md)
 - [PageOverflow](docs/PageOverflow.md)
 - [PageOverflowSettings](docs/PageOverflowSettings.md)
 - [PagePortfolio](docs/PagePortfolio.md)
 - [PagePortfolioAssetSizeLog](docs/PagePortfolioAssetSizeLog.md)
 - [PagePortfolioComment](docs/PagePortfolioComment.md)
 - [PagePortfolioGoal](docs/PagePortfolioGoal.md)
 - [PagePortfolioHoldingLog](docs/PagePortfolioHoldingLog.md)
 - [PagePortfolioTransaction](docs/PagePortfolioTransaction.md)
 - [PageQuestion](docs/PageQuestion.md)
 - [PageQuestionnaire](docs/PageQuestionnaire.md)
 - [PageReasonCode](docs/PageReasonCode.md)
 - [PageRiskProfile](docs/PageRiskProfile.md)
 - [PageRoundup](docs/PageRoundup.md)
 - [PageRoundupSettings](docs/PageRoundupSettings.md)
 - [PageScore](docs/PageScore.md)
 - [PageSecurity](docs/PageSecurity.md)
 - [PageSecurityExclusion](docs/PageSecurityExclusion.md)
 - [PageSecurityPrice](docs/PageSecurityPrice.md)
 - [PageSpendingControl](docs/PageSpendingControl.md)
 - [PageStage](docs/PageStage.md)
 - [PageTransactionCode](docs/PageTransactionCode.md)
 - [PageVAccountAssetSize](docs/PageVAccountAssetSize.md)
 - [PageWebhook](docs/PageWebhook.md)
 - [PermissionVO](docs/PermissionVO.md)
 - [Portfolio](docs/Portfolio.md)
 - [PortfolioAssetSizeLog](docs/PortfolioAssetSizeLog.md)
 - [PortfolioComment](docs/PortfolioComment.md)
 - [PortfolioGoal](docs/PortfolioGoal.md)
 - [PortfolioGoalMap](docs/PortfolioGoalMap.md)
 - [PortfolioHoldingAgg](docs/PortfolioHoldingAgg.md)
 - [PortfolioHoldingLog](docs/PortfolioHoldingLog.md)
 - [PortfolioTransaction](docs/PortfolioTransaction.md)
 - [Question](docs/Question.md)
 - [Questionnaire](docs/Questionnaire.md)
 - [ReasonCode](docs/ReasonCode.md)
 - [RiskProfile](docs/RiskProfile.md)
 - [Roundup](docs/Roundup.md)
 - [RoundupCO](docs/RoundupCO.md)
 - [RoundupSettings](docs/RoundupSettings.md)
 - [Score](docs/Score.md)
 - [SecuritiesComposition](docs/SecuritiesComposition.md)
 - [SecuritiesCountry](docs/SecuritiesCountry.md)
 - [Security](docs/Security.md)
 - [SecurityCompositionVO](docs/SecurityCompositionVO.md)
 - [SecurityCountryVO](docs/SecurityCountryVO.md)
 - [SecurityExclusion](docs/SecurityExclusion.md)
 - [SecurityPrice](docs/SecurityPrice.md)
 - [Sort](docs/Sort.md)
 - [SpendingControl](docs/SpendingControl.md)
 - [Stage](docs/Stage.md)
 - [Stat](docs/Stat.md)
 - [State](docs/State.md)
 - [StatisticResourceVO](docs/StatisticResourceVO.md)
 - [TokenDateRequest](docs/TokenDateRequest.md)
 - [TransactionCode](docs/TransactionCode.md)
 - [VAccountAssetSize](docs/VAccountAssetSize.md)
 - [VAccountVO](docs/VAccountVO.md)
 - [VClientGoalViewData](docs/VClientGoalViewData.md)
 - [VPortfolioVO](docs/VPortfolioVO.md)
 - [Webhook](docs/Webhook.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Author

info@hydrogenplatform.com

