'''
Suncal - Sandia UNcertainty CALculator
Primary Standards Lab - Sandia National Laboratories

Copyright 2019-2023 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
Under the terms of Contract DE-NA0003525 with NTESS, the U.S. Government
retains certain rights in this software.
'''

from .version import __version__, __date__

from .common import ttable, unitmgr
from .common.unitmgr import ureg
from .uncertainty import Model, ModelCallable, ModelComplex
from . import reverse
from . import risk
from . import curvefit
from . import datasets

# Legacy API for backwards compatibility
from .uncertcalc.uncertcalc import UncertCalc
UncertaintyCalc = UncertCalc

__all__ = ['__version__', '__date__', 'ttable', 'unitmgr', 'Model', 'ModelCallable', 'ModelComplex',
           'reverse', 'risk', 'curvefit', 'datasets', 'UncertCalc', 'UncertaintyCalc', 'ureg']
