"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDDEnvVariables = exports.applyEnvVariables = exports.setGitCommitHashEnvironmentVariable = exports.DD_TAGS = exports.DD_VERSION_ENV_VAR = exports.DD_SERVICE_ENV_VAR = exports.DD_ENV_ENV_VAR = exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = exports.ENABLE_DD_LOGS_ENV_VAR = exports.LOG_LEVEL_ENV_VAR = exports.INJECT_LOG_CONTEXT_ENV_VAR = exports.ENABLE_DD_TRACING_ENV_VAR = void 0;
const loglevel_1 = require("loglevel");
exports.ENABLE_DD_TRACING_ENV_VAR = "DD_TRACE_ENABLED";
exports.INJECT_LOG_CONTEXT_ENV_VAR = "DD_LOGS_INJECTION";
exports.LOG_LEVEL_ENV_VAR = "DD_LOG_LEVEL";
exports.ENABLE_DD_LOGS_ENV_VAR = "DD_SERVERLESS_LOGS_ENABLED";
exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR = "DD_CAPTURE_LAMBDA_PAYLOAD";
exports.DD_ENV_ENV_VAR = "DD_ENV";
exports.DD_SERVICE_ENV_VAR = "DD_SERVICE";
exports.DD_VERSION_ENV_VAR = "DD_VERSION";
exports.DD_TAGS = "DD_TAGS";
function setGitCommitHashEnvironmentVariable(lambdas, hash) {
    lambdas.forEach((lambda) => {
        lambda.addEnvironment(exports.DD_TAGS, "git.commit.sha:" + hash);
    });
}
exports.setGitCommitHashEnvironmentVariable = setGitCommitHashEnvironmentVariable;
function applyEnvVariables(lambdas, baseProps) {
    loglevel_1.default.debug(`Setting environment variables...`);
    lambdas.forEach((lam) => {
        lam.addEnvironment(exports.ENABLE_DD_TRACING_ENV_VAR, baseProps.enableDatadogTracing.toString().toLowerCase());
        lam.addEnvironment(exports.INJECT_LOG_CONTEXT_ENV_VAR, baseProps.injectLogContext.toString().toLowerCase());
        lam.addEnvironment(exports.ENABLE_DD_LOGS_ENV_VAR, baseProps.enableDatadogLogs.toString().toLowerCase());
        lam.addEnvironment(exports.CAPTURE_LAMBDA_PAYLOAD_ENV_VAR, baseProps.captureLambdaPayload.toString().toLowerCase());
        if (baseProps.logLevel) {
            lam.addEnvironment(exports.LOG_LEVEL_ENV_VAR, baseProps.logLevel);
        }
    });
}
exports.applyEnvVariables = applyEnvVariables;
function setDDEnvVariables(lambdas, props) {
    lambdas.forEach((lam) => {
        if (props.extensionLayerVersion) {
            if (props.env) {
                lam.addEnvironment(exports.DD_ENV_ENV_VAR, props.env);
            }
            if (props.service) {
                lam.addEnvironment(exports.DD_SERVICE_ENV_VAR, props.service);
            }
            if (props.version) {
                lam.addEnvironment(exports.DD_VERSION_ENV_VAR, props.version);
            }
            if (props.tags) {
                lam.addEnvironment(exports.DD_TAGS, props.tags);
            }
        }
    });
}
exports.setDDEnvVariables = setDDEnvVariables;
//# sourceMappingURL=data:application/json;base64,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