# Generated by Django 3.0.3 on 2020-08-20 14:10

from django.db import migrations

from openwisp_monitoring.db import timeseries_db


def delete_resources_metric_data(apps, schema_editor):
    Metric = apps.get_model('monitoring', 'Metric')
    for metric in Metric.objects.filter(configuration__in=['disk', 'memory', 'cpu']):
        timeseries_db.delete_metric_data(key=metric.key)


class Migration(migrations.Migration):

    dependencies = [('monitoring', '0021_resources_threshold_values')]

    operations = [
        migrations.RunPython(
            delete_resources_metric_data, reverse_code=migrations.RunPython.noop
        )
    ]
