# Generated by Django 3.0.3 on 2020-07-10 08:44

from django.db import migrations


def migrate_data(apps, schema_editor):
    # Migrates data from Graph model to Chart model
    Graph = apps.get_model('monitoring', 'Graph')
    Chart = apps.get_model('monitoring', 'Chart')
    graph_qs = Graph.objects.all()
    Chart.objects.bulk_create(graph_qs)
    # Migrates data from Threshold model to AlertSettings model
    Threshold = apps.get_model('monitoring', 'Threshold')
    AlertSettings = apps.get_model('monitoring', 'AlertSettings')
    threshold_qs = Threshold.objects.all()
    AlertSettings.objects.bulk_create(threshold_qs)


def undo_migrate(apps, schema_editor):
    Graph = apps.get_model('monitoring', 'Graph')
    Chart = apps.get_model('monitoring', 'Chart')
    chart_qs = Chart.objects.all()
    Graph.objects.bulk_create(chart_qs)
    Chart.objects.all().delete()
    Threshold = apps.get_model('monitoring', 'Threshold')
    AlertSettings = apps.get_model('monitoring', 'AlertSettings')
    alertsettings_qs = AlertSettings.objects.all()
    Threshold.objects.bulk_create(alertsettings_qs)
    AlertSettings.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [('monitoring', '0013_create_chart_alertsettings')]

    operations = [migrations.RunPython(migrate_data, undo_migrate)]
