# len8

[![PyPi version](https://img.shields.io/pypi/v/len8.svg)](https://pypi.python.org/pypi/len8/)
[![PyPI pyversions](https://img.shields.io/pypi/pyversions/len8.svg)](https://pypi.python.org/pypi/len8/)
[![PyPI - Implementation](https://img.shields.io/pypi/implementation/len8)](https://pypi.python.org/pypi/len8/)
[![PyPI - Status](https://img.shields.io/pypi/status/len8)](https://pypi.python.org/pypi/len8/)
[![Downloads](https://pepy.tech/badge/len8)](https://pepy.tech/project/len8)

[![Maintenance](https://img.shields.io/maintenance/yes/2021)](https://github.com/parafoxia/len8)
[![GitHub Release Date](https://img.shields.io/github/release-date/parafoxia/len8)](https://github.com/parafoxia/len8)
[![GitHub last commit](https://img.shields.io/github/last-commit/parafoxia/len8)](https://github.com/parafoxia/len8)
[![Read the Docs](https://img.shields.io/readthedocs/len8)](https://len8.readthedocs.io/en/latest/index.html)
[![License](https://img.shields.io/github/license/parafoxia/len8.svg)](https://github.com/parafoxia/len8/blob/main/LICENSE)

A utility for keeping line lengths within [PEP 8](https://www.python.org/dev/peps/pep-0008/#maximum-line-length) standards.

## Features

- An easy-to-use CLI (command-line interface)
- Parse a single file, directory, or multiple directories
- Exclude files and directories from parsing
- Extend acceptable length to 99 chars situationally
- No dependencies!

## Installation

**You need Python 3.2.0 or greater to run len8.**

To install the latest stable version of len8, use the following command:
```sh
pip install len8
```

You can also install the latest development version using the following command:
```sh
pip install git+https://github.com/parafoxia/len8@develop
```

You may need to prefix these commands with a call to the Python interpreter depending on your OS and Python configuration.

## Quickstart

To get started checking your python projects with len8:

```sh
# Parse all files in the cwd
len8 .

# Parse all files in two particular directories
len8 my_package tests

# Excluding file 'config.py' and directory 'secrets'
# By default '.venv', 'venv', and '.nox' are excluded
len8 -x config.py,secrets .

# Parse 'project' dir and increase line length to 99
len8 -l project
len8 -l /home/project

# Parse only one file 'important.py'
len8 -f important.py
len8 -f ./dir/important.py

# Parse using multiple flags at once
len8 -lx ignoreme.py ./project_dir
```

## Contributing

len8 is open to contributions. To find out where to get started, have a look at the [contributing guide](https://github.com/parafoxia/len8/blob/main/CONTRIBUTING.md).

## License

The len8 module for Python is licensed under the [BSD 3-Clause License](https://github.com/parafoxia/len8/blob/main/LICENSE).
