"""
    Foxtail Trainer

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from foxtail_trainer_api.api_client import ApiClient, Endpoint as _Endpoint
from foxtail_trainer_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from foxtail_trainer_api.model.create_ml_models_command import CreateMLModelsCommand
from foxtail_trainer_api.model.created_ml_models_dto import CreatedMLModelsDto
from foxtail_trainer_api.model.deleted_ml_models_dto import DeletedMLModelsDto
from foxtail_trainer_api.model.ml_model_dto import MLModelDto
from foxtail_trainer_api.model.ml_models_guids_list_dto import MLModelsGuidsListDto
from foxtail_trainer_api.model.model_status import ModelStatus
from foxtail_trainer_api.model.update_ml_models_definition_command import UpdateMLModelsDefinitionCommand
from foxtail_trainer_api.model.update_ml_models_status_command import UpdateMLModelsStatusCommand


class MLModelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.api_job_job_id_ml_model_add_post_endpoint = _Endpoint(
            settings={
                'response_type': (CreatedMLModelsDto,),
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/Add',
                'operation_id': 'api_job_job_id_ml_model_add_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'create_ml_models_command',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'create_ml_models_command':
                        (CreateMLModelsCommand,),
                },
                'attribute_map': {
                    'job_id': 'jobId',
                },
                'location_map': {
                    'job_id': 'path',
                    'create_ml_models_command': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.api_job_job_id_ml_model_delete_all_delete_endpoint = _Endpoint(
            settings={
                'response_type': (DeletedMLModelsDto,),
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/DeleteAll',
                'operation_id': 'api_job_job_id_ml_model_delete_all_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'filter_ml_models_by_status',
                    'filter_ml_models_by_guids',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                    'filter_ml_models_by_guids',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'filter_ml_models_by_status':
                        (ModelStatus,),
                    'filter_ml_models_by_guids':
                        ([str], none_type,),
                },
                'attribute_map': {
                    'job_id': 'jobId',
                    'filter_ml_models_by_status': 'filterMLModelsByStatus',
                    'filter_ml_models_by_guids': 'filterMLModelsByGuids',
                },
                'location_map': {
                    'job_id': 'path',
                    'filter_ml_models_by_status': 'query',
                    'filter_ml_models_by_guids': 'query',
                },
                'collection_format_map': {
                    'filter_ml_models_by_guids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.api_job_job_id_ml_model_get_all_get_endpoint = _Endpoint(
            settings={
                'response_type': (MLModelsGuidsListDto,),
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/GetAll',
                'operation_id': 'api_job_job_id_ml_model_get_all_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'filter_ml_models_by_status',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'filter_ml_models_by_status':
                        (ModelStatus,),
                },
                'attribute_map': {
                    'job_id': 'jobId',
                    'filter_ml_models_by_status': 'filterMLModelsByStatus',
                },
                'location_map': {
                    'job_id': 'path',
                    'filter_ml_models_by_status': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.api_job_job_id_ml_model_get_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (MLModelDto,),
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/Get/{id}',
                'operation_id': 'api_job_job_id_ml_model_get_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'id',
                ],
                'required': [
                    'job_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'job_id': 'jobId',
                    'id': 'id',
                },
                'location_map': {
                    'job_id': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'text/plain',
                    'application/json',
                    'text/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.api_job_job_id_ml_model_update_ml_models_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/UpdateMLModels',
                'operation_id': 'api_job_job_id_ml_model_update_ml_models_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'update_ml_models_definition_command',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'update_ml_models_definition_command':
                        (UpdateMLModelsDefinitionCommand,),
                },
                'attribute_map': {
                    'job_id': 'jobId',
                },
                'location_map': {
                    'job_id': 'path',
                    'update_ml_models_definition_command': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )
        self.api_job_job_id_ml_model_update_status_id_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/Job/{jobId}/MLModel/UpdateStatus/{id}',
                'operation_id': 'api_job_job_id_ml_model_update_status_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'job_id',
                    'update_ml_models_status_command',
                ],
                'required': [
                    'id',
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'job_id':
                        (str,),
                    'update_ml_models_status_command':
                        (UpdateMLModelsStatusCommand,),
                },
                'attribute_map': {
                    'id': 'id',
                    'job_id': 'jobId',
                },
                'location_map': {
                    'id': 'path',
                    'job_id': 'path',
                    'update_ml_models_status_command': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

    def api_job_job_id_ml_model_add_post(
        self,
        job_id,
        **kwargs
    ):
        """Add ML models to the job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_add_post(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (str): 

        Keyword Args:
            create_ml_models_command (CreateMLModelsCommand): List of ML models to add. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreatedMLModelsDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['job_id'] = \
            job_id
        return self.api_job_job_id_ml_model_add_post_endpoint.call_with_http_info(**kwargs)

    def api_job_job_id_ml_model_delete_all_delete(
        self,
        job_id,
        **kwargs
    ):
        """Delete ML models from job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_delete_all_delete(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (str): Id of job

        Keyword Args:
            filter_ml_models_by_status (ModelStatus): Optional, filter models for deleting by status. [optional]
            filter_ml_models_by_guids ([str], none_type): Optional, filter models for deleting by guids. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DeletedMLModelsDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['job_id'] = \
            job_id
        return self.api_job_job_id_ml_model_delete_all_delete_endpoint.call_with_http_info(**kwargs)

    def api_job_job_id_ml_model_get_all_get(
        self,
        job_id,
        **kwargs
    ):
        """Get list of model guids for job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_get_all_get(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (str): Job id

        Keyword Args:
            filter_ml_models_by_status (ModelStatus): Optional, filter models by status. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MLModelsGuidsListDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['job_id'] = \
            job_id
        return self.api_job_job_id_ml_model_get_all_get_endpoint.call_with_http_info(**kwargs)

    def api_job_job_id_ml_model_get_id_get(
        self,
        job_id,
        id,
        **kwargs
    ):
        """api_job_job_id_ml_model_get_id_get  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_get_id_get(job_id, id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (str):
            id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            MLModelDto
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['job_id'] = \
            job_id
        kwargs['id'] = \
            id
        return self.api_job_job_id_ml_model_get_id_get_endpoint.call_with_http_info(**kwargs)

    def api_job_job_id_ml_model_update_ml_models_put(
        self,
        job_id,
        **kwargs
    ):
        """api_job_job_id_ml_model_update_ml_models_put  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_update_ml_models_put(job_id, async_req=True)
        >>> result = thread.get()

        Args:
            job_id (str):

        Keyword Args:
            update_ml_models_definition_command (UpdateMLModelsDefinitionCommand): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['job_id'] = \
            job_id
        return self.api_job_job_id_ml_model_update_ml_models_put_endpoint.call_with_http_info(**kwargs)

    def api_job_job_id_ml_model_update_status_id_put(
        self,
        id,
        job_id,
        **kwargs
    ):
        """api_job_job_id_ml_model_update_status_id_put  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_job_job_id_ml_model_update_status_id_put(id, job_id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str):
            job_id (str):

        Keyword Args:
            update_ml_models_status_command (UpdateMLModelsStatusCommand): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['job_id'] = \
            job_id
        return self.api_job_job_id_ml_model_update_status_id_put_endpoint.call_with_http_info(**kwargs)

