"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_kms_1 = require("@aws-cdk/aws-kms");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_stepfunctions_1 = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-stepfunctions-sagemaker');
const encryptionKey = new aws_kms_1.Key(stack, 'EncryptionKey', {
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
const trainingData = new aws_s3_1.Bucket(stack, 'TrainingData', {
    encryption: aws_s3_1.BucketEncryption.KMS,
    encryptionKey,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
new aws_stepfunctions_1.StateMachine(stack, 'StateMachine', {
    definition: new aws_stepfunctions_1.Task(stack, 'TrainTask', {
        task: new lib_1.SagemakerTrainTask({
            algorithmSpecification: {
                algorithmName: 'GRADIENT_ASCENT',
            },
            inputDataConfig: [{ channelName: 'InputData', dataSource: {
                        s3DataSource: {
                            s3Location: lib_1.S3Location.fromBucket(trainingData, 'data/')
                        }
                    } }],
            outputDataConfig: { s3OutputLocation: lib_1.S3Location.fromBucket(trainingData, 'result/') },
            trainingJobName: 'MyTrainingJob',
        })
    })
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc2FnZW1ha2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc2FnZW1ha2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQXVDO0FBQ3ZDLDRDQUEyRDtBQUMzRCxrRUFBZ0U7QUFDaEUsd0NBQTBEO0FBQzFELGdDQUF3RDtBQUV4RCxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSwrQkFBK0IsQ0FBQyxDQUFDO0FBRTlELE1BQU0sYUFBYSxHQUFHLElBQUksYUFBRyxDQUFDLEtBQUssRUFBRSxlQUFlLEVBQUU7SUFDcEQsYUFBYSxFQUFFLG9CQUFhLENBQUMsT0FBTztDQUNyQyxDQUFDLENBQUM7QUFDSCxNQUFNLFlBQVksR0FBRyxJQUFJLGVBQU0sQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQ3JELFVBQVUsRUFBRSx5QkFBZ0IsQ0FBQyxHQUFHO0lBQ2hDLGFBQWE7SUFDYixhQUFhLEVBQUUsb0JBQWEsQ0FBQyxPQUFPO0NBQ3JDLENBQUMsQ0FBQztBQUVILElBQUksZ0NBQVksQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQ3RDLFVBQVUsRUFBRSxJQUFJLHdCQUFJLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtRQUN2QyxJQUFJLEVBQUUsSUFBSSx3QkFBa0IsQ0FBQztZQUMzQixzQkFBc0IsRUFBRTtnQkFDdEIsYUFBYSxFQUFFLGlCQUFpQjthQUNqQztZQUNELGVBQWUsRUFBRSxDQUFDLEVBQUUsV0FBVyxFQUFFLFdBQVcsRUFBRSxVQUFVLEVBQUU7d0JBQ3hELFlBQVksRUFBRTs0QkFDWixVQUFVLEVBQUUsZ0JBQVUsQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFLE9BQU8sQ0FBQzt5QkFDekQ7cUJBQ0YsRUFBRSxDQUFDO1lBQ0osZ0JBQWdCLEVBQUUsRUFBRSxnQkFBZ0IsRUFBRSxnQkFBVSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUUsU0FBUyxDQUFDLEVBQUU7WUFDdEYsZUFBZSxFQUFFLGVBQWU7U0FDakMsQ0FBQztLQUNILENBQUM7Q0FDSCxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBLZXkgfSBmcm9tICdAYXdzLWNkay9hd3Mta21zJztcbmltcG9ydCB7IEJ1Y2tldCwgQnVja2V0RW5jcnlwdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5pbXBvcnQgeyBTdGF0ZU1hY2hpbmUsIFRhc2sgfSBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBBcHAsIFJlbW92YWxQb2xpY3ksIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBTM0xvY2F0aW9uLCBTYWdlbWFrZXJUcmFpblRhc2sgfSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdpbnRlZy1zdGVwZnVuY3Rpb25zLXNhZ2VtYWtlcicpO1xuXG5jb25zdCBlbmNyeXB0aW9uS2V5ID0gbmV3IEtleShzdGFjaywgJ0VuY3J5cHRpb25LZXknLCB7XG4gIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbn0pO1xuY29uc3QgdHJhaW5pbmdEYXRhID0gbmV3IEJ1Y2tldChzdGFjaywgJ1RyYWluaW5nRGF0YScsIHtcbiAgZW5jcnlwdGlvbjogQnVja2V0RW5jcnlwdGlvbi5LTVMsXG4gIGVuY3J5cHRpb25LZXksXG4gIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbn0pO1xuXG5uZXcgU3RhdGVNYWNoaW5lKHN0YWNrLCAnU3RhdGVNYWNoaW5lJywge1xuICBkZWZpbml0aW9uOiBuZXcgVGFzayhzdGFjaywgJ1RyYWluVGFzaycsIHtcbiAgICB0YXNrOiBuZXcgU2FnZW1ha2VyVHJhaW5UYXNrKHtcbiAgICAgIGFsZ29yaXRobVNwZWNpZmljYXRpb246IHtcbiAgICAgICAgYWxnb3JpdGhtTmFtZTogJ0dSQURJRU5UX0FTQ0VOVCcsXG4gICAgICB9LFxuICAgICAgaW5wdXREYXRhQ29uZmlnOiBbeyBjaGFubmVsTmFtZTogJ0lucHV0RGF0YScsIGRhdGFTb3VyY2U6IHtcbiAgICAgICAgczNEYXRhU291cmNlOiB7XG4gICAgICAgICAgczNMb2NhdGlvbjogUzNMb2NhdGlvbi5mcm9tQnVja2V0KHRyYWluaW5nRGF0YSwgJ2RhdGEvJylcbiAgICAgICAgfVxuICAgICAgfSB9XSxcbiAgICAgIG91dHB1dERhdGFDb25maWc6IHsgczNPdXRwdXRMb2NhdGlvbjogUzNMb2NhdGlvbi5mcm9tQnVja2V0KHRyYWluaW5nRGF0YSwgJ3Jlc3VsdC8nKSB9LFxuICAgICAgdHJhaW5pbmdKb2JOYW1lOiAnTXlUcmFpbmluZ0pvYicsXG4gICAgfSlcbiAgfSlcbn0pO1xuIl19