import { Construct } from 'constructs';
/**
 * The type returned from the `bind()` method in {@link IotSql}.
 */
export interface IotSqlConfig {
    /**
     * The version of the SQL rules engine to use when evaluating the rule.
     */
    readonly awsIotSqlVersion: string;
    /**
     * The SQL statement used to query the topic.
     */
    readonly sql: string;
}
/**
 * Defines AWS IoT SQL.
 */
export declare abstract class IotSql {
    /**
     * Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20151008(sql: string): IotSql;
    /**
     * Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20160323(sql: string): IotSql;
    /**
     * Uses the most recent beta SQL version. If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVerNewestUnstable(sql: string): IotSql;
    /**
     * Returns the IoT SQL configuration.
     */
    abstract bind(scope: Construct): IotSqlConfig;
}
