################################################################################
# © Copyright 2021-2022 Zapata Computing Inc.
################################################################################
"""Test cases have been generated using the code in
`orquestra.quantum.testing.generate_cases_for_backend.py`.
"""

import numpy as np

one_qubit_non_parametric_gates_exp_vals_test_set = [
    ["I", "X", [1, 0, 0, -1]],
    ["H", "X", [1, 1, 0, 0]],
    ["I", "Y", [1, 0, 0, -1]],
    ["H", "Y", [1, -1, 0, 0]],
    ["I", "Z", [1, 0, 0, 1]],
    ["H", "Z", [1, -1, 0, 0]],
    ["I", "H", [1, 1, 0, 0]],
    ["H", "H", [1, 0, 0, 1]],
    ["I", "S", [1, 0, 0, 1]],
    ["H", "S", [1, 0, 1, 0]],
    ["I", "T", [1, 0, 0, 1]],
    ["H", "T", [1, np.sqrt(2) / 2, np.sqrt(2) / 2, 0]],
]


one_qubit_parametric_gates_exp_vals_test_set = [
    ["I", "RX", [-np.pi / 2], [1.00000000000000, 0, 1.00000000000000, 0]],
    ["I", "RX", [0], [1, 0, 0, 1]],
    [
        "I",
        "RX",
        [np.pi / 5],
        [
            1.00000000000000,
            0,
            0.125 * (-np.sqrt(10) + np.sqrt(2)) * np.sqrt(np.sqrt(5) + 5),
            0.25 + 0.25 * np.sqrt(5),
        ],
    ],
    ["I", "RX", [np.pi / 2], [1.00000000000000, 0, -1.00000000000000, 0]],
    ["I", "RX", [np.pi], [1.00000000000000, 0, 0, -1.00000000000000]],
    ["H", "RX", [-np.pi / 2], [1.00000000000000, 1.00000000000000, 0, 0]],
    ["H", "RX", [0], [1, 1, 0, 0]],
    ["H", "RX", [np.pi / 5], [1.00000000000000, 1.00000000000000, 0, 0]],
    ["H", "RX", [np.pi / 2], [1.00000000000000, 1.00000000000000, 0, 0]],
    ["H", "RX", [np.pi], [1.00000000000000, 1.00000000000000, 0, 0]],
    ["I", "RY", [-np.pi / 2], [1, -1, 0, 0]],
    ["I", "RY", [0], [1, 0, 0, 1]],
    [
        "I",
        "RY",
        [np.pi / 5],
        [
            1,
            (-np.sqrt(2) + np.sqrt(10)) * np.sqrt(np.sqrt(5) + 5) / 8,
            0,
            1 / 4 + np.sqrt(5) / 4,
        ],
    ],
    ["I", "RY", [np.pi / 2], [1, 1, 0, 0]],
    ["I", "RY", [np.pi], [1, 0, 0, -1]],
    ["H", "RY", [-np.pi / 2], [1, 0, 0, 1]],
    ["H", "RY", [0], [1, 1, 0, 0]],
    [
        "H",
        "RY",
        [np.pi / 5],
        [
            1,
            1 / 4 + np.sqrt(5) / 4,
            0,
            (-np.sqrt(10) + np.sqrt(2)) * np.sqrt(np.sqrt(5) + 5) / 8,
        ],
    ],
    ["H", "RY", [np.pi / 2], [1, 0, 0, -1]],
    ["H", "RY", [np.pi], [1, -1, 0, 0]],
    ["I", "RZ", [-np.pi / 2], [1.00000000000000, 0, 0, 1.00000000000000]],
    ["I", "RZ", [0], [1, 0, 0, 1]],
    ["I", "RZ", [np.pi / 5], [1.00000000000000, 0, 0, 1.00000000000000]],
    ["I", "RZ", [np.pi / 2], [1.00000000000000, 0, 0, 1.00000000000000]],
    ["I", "RZ", [np.pi], [1.00000000000000, 0, 0, 1.00000000000000]],
    ["H", "RZ", [-np.pi / 2], [1.00000000000000, 0, -1.00000000000000, 0]],
    ["H", "RZ", [0], [1, 1, 0, 0]],
    [
        "H",
        "RZ",
        [np.pi / 5],
        [
            1.00000000000000,
            0.25 + 0.25 * np.sqrt(5),
            0.125 * (-np.sqrt(2) + np.sqrt(10)) * np.sqrt(np.sqrt(5) + 5),
            0,
        ],
    ],
    ["H", "RZ", [np.pi / 2], [1.00000000000000, 0, 1.00000000000000, 0]],
    ["H", "RZ", [np.pi], [1.00000000000000, -1.00000000000000, 0, 0]],
    ["I", "PHASE", [-np.pi / 2], [1, 0, 0, 1]],
    ["I", "PHASE", [0], [1, 0, 0, 1]],
    ["I", "PHASE", [np.pi / 5], [1, 0, 0, 1]],
    ["I", "PHASE", [np.pi / 2], [1, 0, 0, 1]],
    ["I", "PHASE", [np.pi], [1, 0, 0, 1]],
    ["H", "PHASE", [-np.pi / 2], [1.00000000000000, 0, -1.00000000000000, 0]],
    ["H", "PHASE", [0], [1, 1, 0, 0]],
    [
        "H",
        "PHASE",
        [np.pi / 5],
        [
            1.00000000000000,
            1 / 4 + np.sqrt(5) / 4,
            0.25 * np.sqrt(10 - 2 * np.sqrt(5)),
            0,
        ],
    ],
    ["H", "PHASE", [np.pi / 2], [1.00000000000000, 0, 1.00000000000000, 0]],
    ["H", "PHASE", [np.pi], [1, -1, 0, 0]],
    [
        "I",
        "RH",
        [-np.pi / 2],
        [1.00000000000000, 0.500000000000000, 0.5 * np.sqrt(2), 0.500000000000000],
    ],
    ["I", "RH", [0], [1, 0, 0, 1]],
    [
        "I",
        "RH",
        [np.pi / 5],
        [
            1.00000000000000,
            0.375 - 0.125 * np.sqrt(5),
            0.125 * (1 - np.sqrt(5)) * np.sqrt(np.sqrt(5) + 5),
            0.125 * np.sqrt(5) + 0.625,
        ],
    ],
    [
        "I",
        "RH",
        [np.pi / 2],
        [1.00000000000000, 0.500000000000000, -0.5 * np.sqrt(2), 0.500000000000000],
    ],
    ["I", "RH", [np.pi], [1.00000000000000, 1.00000000000000, 0, 0]],
    [
        "H",
        "RH",
        [-np.pi / 2],
        [1.00000000000000, 1 / 2, -0.5 * np.sqrt(2), 0.500000000000000],
    ],
    ["H", "RH", [0], [1, 1, 0, 0]],
    [
        "H",
        "RH",
        [np.pi / 5],
        [
            1,
            np.sqrt(5) / 8 + 5 / 8,
            (-1 + np.sqrt(5)) * np.sqrt(np.sqrt(5) + 5) / 8,
            3 / 8 - np.sqrt(5) / 8,
        ],
    ],
    [
        "H",
        "RH",
        [np.pi / 2],
        [1.00000000000000, 1 / 2, 0.5 * np.sqrt(2), 0.500000000000000],
    ],
    ["H", "RH", [np.pi], [1.00000000000000, 0, 0, 1.00000000000000]],
]

two_qubit_non_parametric_gates_exp_vals_test_set = [
    [
        ["I", "I"],
        "CNOT",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CNOT",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["H", "I"],
        "CNOT",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            -1,
            1,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CNOT",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["I", "I"],
        "SWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "SWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "SWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["H", "H"],
        "SWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["I", "I"],
        "ISWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "ISWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ISWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["H", "H"],
        "ISWAP",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "CZ",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CZ",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["H", "I"],
        "CZ",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CZ",
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            1,
            0,
            0,
            0,
        ],
    ],
]

two_qubit_parametric_gates_exp_vals_test_set = [
    [
        ["I", "I"],
        "CPHASE",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "CPHASE",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "CPHASE",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "CPHASE",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "CPHASE",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CPHASE",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CPHASE",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CPHASE",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CPHASE",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "CPHASE",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["H", "I"],
        "CPHASE",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "CPHASE",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "CPHASE",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "CPHASE",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "CPHASE",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CPHASE",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1 / 2,
            1 / 2,
            0,
            1 / 2,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CPHASE",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CPHASE",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            np.sqrt(5) / 8 + 5 / 8,
            3 / 8 - np.sqrt(5) / 8,
            0,
            np.sqrt(5) / 8 + 5 / 8,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CPHASE",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1 / 2,
            1 / 2,
            0,
            1 / 2,
            0,
        ],
    ],
    [
        ["H", "H"],
        "CPHASE",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            1,
            0,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "XX",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "XX",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "XX",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0.25 + 0.25 * np.sqrt(5),
        ],
    ],
    [
        ["I", "I"],
        "XX",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "XX",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            -1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "XX",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["I", "H"],
        "XX",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "XX",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            1.00000000000000,
            0.25 + 0.25 * np.sqrt(5),
        ],
    ],
    [
        ["I", "H"],
        "XX",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["I", "H"],
        "XX",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            1.00000000000000,
            -1.00000000000000,
        ],
    ],
    [
        ["H", "I"],
        "XX",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XX",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XX",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XX",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XX",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
        ],
    ],
    [
        ["I", "I"],
        "YY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "YY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "YY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0.25 + 0.25 * np.sqrt(5),
        ],
    ],
    [
        ["I", "I"],
        "YY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            0,
        ],
    ],
    [
        ["I", "I"],
        "YY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            -1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "YY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["I", "H"],
        "YY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "YY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0.25 + 0.25 * np.sqrt(5),
            0.25 + 0.25 * np.sqrt(5),
        ],
    ],
    [
        ["I", "H"],
        "YY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["I", "H"],
        "YY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            -1.00000000000000,
            -1.00000000000000,
        ],
    ],
    [
        ["H", "I"],
        "YY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "YY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "YY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "YY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "YY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0.25 + 0.25 * np.sqrt(5),
            0,
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            -1.00000000000000,
            0,
        ],
    ],
    [
        ["I", "I"],
        "ZZ",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "I"],
        "ZZ",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "ZZ",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "I"],
        "ZZ",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "I"],
        "ZZ",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            1.00000000000000,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0.25 + 0.25 * np.sqrt(5),
            1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            -1.00000000000000,
            1.00000000000000,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0.25 + 0.25 * np.sqrt(5),
            0,
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            -1.00000000000000,
            0,
        ],
    ],
    [
        ["I", "I"],
        "XY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "XY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "XY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "XY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "I"],
        "XY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            1,
            0,
            1,
        ],
    ],
    [
        ["I", "H"],
        "XY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            np.sqrt(2) / 2,
            0.500000000000000,
        ],
    ],
    [
        ["I", "H"],
        "XY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            1,
            1,
        ],
    ],
    [
        ["I", "H"],
        "XY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            np.sqrt(2 * np.sqrt(5) + 10) / 4,
            0.125 * np.sqrt(5) + 0.625,
        ],
    ],
    [
        ["I", "H"],
        "XY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            np.sqrt(2) / 2,
            0.500000000000000,
        ],
    ],
    [
        ["I", "H"],
        "XY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0.500000000000000,
        ],
    ],
    [
        ["H", "I"],
        "XY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            0,
            0,
            0,
            0,
            0,
        ],
    ],
    [
        ["H", "I"],
        "XY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0.375 - 0.125 * np.sqrt(5),
        ],
    ],
    [
        ["H", "I"],
        "XY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            0.500000000000000,
        ],
    ],
    [
        ["H", "I"],
        "XY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            0,
            0,
            0,
            0,
            1.00000000000000,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [-np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            np.sqrt(2) / 2,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [0],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1,
            1,
            0,
            0,
            1,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [np.pi / 5],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            np.sqrt(2 * np.sqrt(5) + 10) / 4,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [np.pi / 2],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            np.sqrt(2) / 2,
            0,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [np.pi],
        ["I0", "X0*X1", "Y0*Y1", "Z0*Z1", "X1", "Z0"],
        [
            1.00000000000000,
            1.00000000000000,
            0,
            0,
            0,
            0,
        ],
    ],
]

one_qubit_non_parametric_gates_amplitudes_test_set = [
    ["I", "I", [1.0, 0.0]],
    ["H", "I", [1 / np.sqrt(2), 1 / np.sqrt(2)]],
    ["I", "X", [0.0, 1.0]],
    ["H", "X", [1 / np.sqrt(2), 1 / np.sqrt(2)]],
    ["I", "Y", [0.0, 1.0j]],
    ["H", "Y", [-1j / np.sqrt(2), 1j / np.sqrt(2)]],
    ["I", "Z", [1.0, 0.0]],
    ["H", "Z", [1 / np.sqrt(2), -1 / np.sqrt(2)]],
    ["I", "H", [1 / np.sqrt(2), 1 / np.sqrt(2)]],
    ["H", "H", [1.0, 0.0]],
    ["I", "S", [1.0, 0.0]],
    ["H", "S", [1 / np.sqrt(2), 1j / np.sqrt(2)]],
    ["I", "T", [1.0, 0.0]],
    ["H", "T", [1 / np.sqrt(2), 0.5 + 0.5j]],
]

one_qubit_parametric_gates_amplitudes_test_set = [
    ["I", "RX", [-np.pi / 2], [np.sqrt(2) / 2, 0.5 * np.sqrt(2) * 1.0j]],
    ["I", "RX", [0], [1, 0]],
    [
        "I",
        "RX",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8), -1.0j * (-1 / 4 + np.sqrt(5) / 4)],
    ],
    ["I", "RX", [np.pi / 2], [np.sqrt(2) / 2, -0.5 * np.sqrt(2) * 1.0j]],
    ["I", "RX", [np.pi], [0, -1.0j]],
    ["H", "RX", [-np.pi / 2], [1 / 2 + 0.5 * 1.0j, 1 / 2 + 0.5 * 1.0j]],
    ["H", "RX", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    [
        "H",
        "RX",
        [np.pi / 5],
        [
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    ["H", "RX", [np.pi / 2], [1 / 2 - 0.5 * 1.0j, 1 / 2 - 0.5 * 1.0j]],
    ["H", "RX", [np.pi], [-0.5 * np.sqrt(2) * 1.0j, -0.5 * np.sqrt(2) * 1.0j]],
    ["I", "RY", [-np.pi / 2], [np.sqrt(2) / 2, -np.sqrt(2) / 2]],
    ["I", "RY", [0], [1, 0]],
    [
        "I",
        "RY",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8), -1 / 4 + np.sqrt(5) / 4],
    ],
    ["I", "RY", [np.pi / 2], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    ["I", "RY", [np.pi], [0, 1]],
    ["H", "RY", [-np.pi / 2], [1, 0]],
    ["H", "RY", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    [
        "H",
        "RY",
        [np.pi / 5],
        [
            -np.sqrt(2) * (-1 / 4 + np.sqrt(5) / 4) / 2
            + np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            np.sqrt(2) * (-1 / 4 + np.sqrt(5) / 4) / 2
            + np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
        ],
    ],
    ["H", "RY", [np.pi / 2], [0, 1]],
    ["H", "RY", [np.pi], [-np.sqrt(2) / 2, np.sqrt(2) / 2]],
    ["I", "RZ", [-np.pi / 2], [np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j, 0]],
    ["I", "RZ", [0], [1, 0]],
    [
        "I",
        "RZ",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8) - 1.0j * (-1 / 4 + np.sqrt(5) / 4), 0],
    ],
    ["I", "RZ", [np.pi / 2], [np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j, 0]],
    ["I", "RZ", [np.pi], [-1.0j, 0]],
    [
        "H",
        "RZ",
        [-np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
        ],
    ],
    ["H", "RZ", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    [
        "H",
        "RZ",
        [np.pi / 5],
        [
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) - 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) + 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
        ],
    ],
    [
        "H",
        "RZ",
        [np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
        ],
    ],
    ["H", "RZ", [np.pi], [-0.5 * np.sqrt(2) * 1.0j, 0.5 * np.sqrt(2) * 1.0j]],
    ["I", "PHASE", [-np.pi / 2], [1, 0]],
    ["I", "PHASE", [0], [1, 0]],
    ["I", "PHASE", [np.pi / 5], [1, 0]],
    ["I", "PHASE", [np.pi / 2], [1, 0]],
    ["I", "PHASE", [np.pi], [1, 0]],
    ["H", "PHASE", [-np.pi / 2], [np.sqrt(2) / 2, -0.5 * np.sqrt(2) * 1.0j]],
    ["H", "PHASE", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    [
        "H",
        "PHASE",
        [np.pi / 5],
        [
            np.sqrt(2) / 2,
            np.sqrt(2)
            * (1 / 4 + np.sqrt(5) / 4 + 1.0j * np.sqrt(5 / 8 - np.sqrt(5) / 8))
            / 2,
        ],
    ],
    ["H", "PHASE", [np.pi / 2], [np.sqrt(2) / 2, 0.5 * np.sqrt(2) * 1.0j]],
    ["H", "PHASE", [np.pi], [np.sqrt(2) / 2, -np.sqrt(2) / 2]],
    [
        "I",
        "RH",
        [-np.pi / 2],
        [
            (np.sqrt(2) / 2 + 0.5 * 1.0j) * np.exp(-0.25 * 1.0j * np.pi),
            0.5 * 1.0j * np.exp(-0.25 * 1.0j * np.pi),
        ],
    ],
    ["I", "RH", [0], [1, 0]],
    [
        "I",
        "RH",
        [np.pi / 5],
        [
            (
                np.sqrt(np.sqrt(5) / 8 + 5 / 8)
                - 0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4)
            )
            * np.exp(0.1 * 1.0j * np.pi),
            -0.5
            * np.sqrt(2)
            * 1.0j
            * (-1 / 4 + np.sqrt(5) / 4)
            * np.exp(0.1 * 1.0j * np.pi),
        ],
    ],
    [
        "I",
        "RH",
        [np.pi / 2],
        [
            (np.sqrt(2) / 2 - 0.5 * 1.0j) * np.exp(0.25 * 1.0j * np.pi),
            -0.5 * 1.0j * np.exp(0.25 * 1.0j * np.pi),
        ],
    ],
    [
        "I",
        "RH",
        [np.pi],
        [
            -0.5 * np.sqrt(2) * 1.0j * np.exp(0.5 * 1.0j * np.pi),
            -0.5 * np.sqrt(2) * 1.0j * np.exp(0.5 * 1.0j * np.pi),
        ],
    ],
    [
        "H",
        "RH",
        [-np.pi / 2],
        [
            np.sqrt(2)
            * (np.sqrt(2) / 2 + 0.5 * 1.0j)
            * np.exp(-0.25 * 1.0j * np.pi)
            / 2
            + 0.25 * np.sqrt(2) * 1.0j * np.exp(-0.25 * 1.0j * np.pi),
            np.sqrt(2)
            * (np.sqrt(2) / 2 - 0.5 * 1.0j)
            * np.exp(-0.25 * 1.0j * np.pi)
            / 2
            + 0.25 * np.sqrt(2) * 1.0j * np.exp(-0.25 * 1.0j * np.pi),
        ],
    ],
    ["H", "RH", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2]],
    [
        "H",
        "RH",
        [np.pi / 5],
        [
            -0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4) * np.exp(0.1 * 1.0j * np.pi)
            + np.sqrt(2)
            * (
                np.sqrt(np.sqrt(5) / 8 + 5 / 8)
                - 0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4)
            )
            * np.exp(0.1 * 1.0j * np.pi)
            / 2,
            -0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4) * np.exp(0.1 * 1.0j * np.pi)
            + np.sqrt(2)
            * (
                np.sqrt(np.sqrt(5) / 8 + 5 / 8)
                + 0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4)
            )
            * np.exp(0.1 * 1.0j * np.pi)
            / 2,
        ],
    ],
    [
        "H",
        "RH",
        [np.pi / 2],
        [
            -0.25 * np.sqrt(2) * 1.0j * np.exp(0.25 * 1.0j * np.pi)
            + np.sqrt(2)
            * (np.sqrt(2) / 2 - 0.5 * 1.0j)
            * np.exp(0.25 * 1.0j * np.pi)
            / 2,
            -0.25 * np.sqrt(2) * 1.0j * np.exp(0.25 * 1.0j * np.pi)
            + np.sqrt(2)
            * (np.sqrt(2) / 2 + 0.5 * 1.0j)
            * np.exp(0.25 * 1.0j * np.pi)
            / 2,
        ],
    ],
    ["H", "RH", [np.pi], [-1.0j * np.exp(0.5 * 1.0j * np.pi), 0]],
]

two_qubit_non_parametric_gates_amplitudes_test_set = [
    [["I", "I"], "CNOT", [1.0, 0.0, 0.0, 0.0]],
    [["I", "X"], "CNOT", [0.0, 1.0, 0.0, 0.0]],
    [["X", "I"], "CNOT", [0.0, 0.0, 0.0, 1.0]],
    [["X", "X"], "CNOT", [0.0, 0.0, 1.0, 0.0]],
    [["I", "I"], "SWAP", [1.0, 0.0, 0.0, 0.0]],
    [["I", "X"], "SWAP", [0.0, 0.0, 1.0, 0.0]],
    [["X", "I"], "SWAP", [0.0, 1.0, 0.0, 0.0]],
    [["X", "X"], "SWAP", [0.0, 0.0, 0.0, 1.0]],
    [["I", "I"], "ISWAP", [1.0, 0.0, 0.0, 0.0]],
    [["I", "X"], "ISWAP", [0.0, 0.0, 1.0j, 0.0]],
    [["X", "I"], "ISWAP", [0.0, 1.0j, 0.0, 0.0]],
    [["X", "X"], "ISWAP", [0.0, 0.0, 0.0, 1.0]],
    [["I", "I"], "CZ", [1.0, 0.0, 0.0, 0.0]],
    [["I", "X"], "CZ", [0.0, 1.0, 0.0, 0.0]],
    [["X", "I"], "CZ", [0.0, 0.0, 1.0, 0.0]],
    [["X", "X"], "CZ", [0.0, 0.0, 0.0, -1.0]],
]

two_qubit_parametric_gates_amplitudes_test_set = [
    [["I", "I"], "CPHASE", [-np.pi / 2], [1, 0, 0, 0]],
    [["I", "I"], "CPHASE", [0], [1, 0, 0, 0]],
    [["I", "I"], "CPHASE", [np.pi / 5], [1, 0, 0, 0]],
    [["I", "I"], "CPHASE", [np.pi / 2], [1, 0, 0, 0]],
    [["I", "I"], "CPHASE", [np.pi], [1, 0, 0, 0]],
    [["I", "H"], "CPHASE", [-np.pi / 2], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [["I", "H"], "CPHASE", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [["I", "H"], "CPHASE", [np.pi / 5], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [["I", "H"], "CPHASE", [np.pi / 2], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [["I", "H"], "CPHASE", [np.pi], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [["H", "I"], "CPHASE", [-np.pi / 2], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [["H", "I"], "CPHASE", [0], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [["H", "I"], "CPHASE", [np.pi / 5], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [["H", "I"], "CPHASE", [np.pi / 2], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [["H", "I"], "CPHASE", [np.pi], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [["H", "H"], "CPHASE", [-np.pi / 2], [1 / 2, 1 / 2, 1 / 2, -0.5 * 1.0j]],
    [["H", "H"], "CPHASE", [0], [1 / 2, 1 / 2, 1 / 2, 1 / 2]],
    [
        ["H", "H"],
        "CPHASE",
        [np.pi / 5],
        [
            1 / 2,
            1 / 2,
            1 / 2,
            1 / 8 + np.sqrt(5) / 8 + 0.5 * 1.0j * np.sqrt(5 / 8 - np.sqrt(5) / 8),
        ],
    ],
    [["H", "H"], "CPHASE", [np.pi / 2], [1 / 2, 1 / 2, 1 / 2, 0.5 * 1.0j]],
    [["H", "H"], "CPHASE", [np.pi], [1 / 2, 1 / 2, 1 / 2, -1 / 2]],
    [["I", "I"], "XX", [-np.pi / 2], [np.sqrt(2) / 2, 0, 0, 0.5 * np.sqrt(2) * 1.0j]],
    [["I", "I"], "XX", [0], [1, 0, 0, 0]],
    [
        ["I", "I"],
        "XX",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8), 0, 0, -1.0j * (-1 / 4 + np.sqrt(5) / 4)],
    ],
    [["I", "I"], "XX", [np.pi / 2], [np.sqrt(2) / 2, 0, 0, -0.5 * np.sqrt(2) * 1.0j]],
    [["I", "I"], "XX", [np.pi], [0, 0, 0, -1.0j]],
    [["I", "H"], "XX", [-np.pi / 2], [1 / 2, 1 / 2, 0.5 * 1.0j, 0.5 * 1.0j]],
    [["I", "H"], "XX", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [
        ["I", "H"],
        "XX",
        [np.pi / 5],
        [
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [["I", "H"], "XX", [np.pi / 2], [1 / 2, 1 / 2, -0.5 * 1.0j, -0.5 * 1.0j]],
    [
        ["I", "H"],
        "XX",
        [np.pi],
        [0, 0, -0.5 * np.sqrt(2) * 1.0j, -0.5 * np.sqrt(2) * 1.0j],
    ],
    [["H", "I"], "XX", [-np.pi / 2], [1 / 2, 0.5 * 1.0j, 1 / 2, 0.5 * 1.0j]],
    [["H", "I"], "XX", [0], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [
        ["H", "I"],
        "XX",
        [np.pi / 5],
        [
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [["H", "I"], "XX", [np.pi / 2], [1 / 2, -0.5 * 1.0j, 1 / 2, -0.5 * 1.0j]],
    [
        ["H", "I"],
        "XX",
        [np.pi],
        [0, -0.5 * np.sqrt(2) * 1.0j, 0, -0.5 * np.sqrt(2) * 1.0j],
    ],
    [
        ["H", "H"],
        "XX",
        [-np.pi / 2],
        [
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "XX", [0], [1 / 2, 1 / 2, 1 / 2, 1 / 2]],
    [
        ["H", "H"],
        "XX",
        [np.pi / 5],
        [
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [
        ["H", "H"],
        "XX",
        [np.pi / 2],
        [
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "XX", [np.pi], [-0.5 * 1.0j, -0.5 * 1.0j, -0.5 * 1.0j, -0.5 * 1.0j]],
    [["I", "I"], "YY", [-np.pi / 2], [np.sqrt(2) / 2, 0, 0, -0.5 * np.sqrt(2) * 1.0j]],
    [["I", "I"], "YY", [0], [1, 0, 0, 0]],
    [
        ["I", "I"],
        "YY",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8), 0, 0, 1.0j * (-1 / 4 + np.sqrt(5) / 4)],
    ],
    [["I", "I"], "YY", [np.pi / 2], [np.sqrt(2) / 2, 0, 0, 0.5 * np.sqrt(2) * 1.0j]],
    [["I", "I"], "YY", [np.pi], [0, 0, 0, 1.0j]],
    [["I", "H"], "YY", [-np.pi / 2], [1 / 2, 1 / 2, 0.5 * 1.0j, -0.5 * 1.0j]],
    [["I", "H"], "YY", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [
        ["I", "H"],
        "YY",
        [np.pi / 5],
        [
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [["I", "H"], "YY", [np.pi / 2], [1 / 2, 1 / 2, -0.5 * 1.0j, 0.5 * 1.0j]],
    [
        ["I", "H"],
        "YY",
        [np.pi],
        [0, 0, -0.5 * np.sqrt(2) * 1.0j, 0.5 * np.sqrt(2) * 1.0j],
    ],
    [["H", "I"], "YY", [-np.pi / 2], [1 / 2, 0.5 * 1.0j, 1 / 2, -0.5 * 1.0j]],
    [["H", "I"], "YY", [0], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [
        ["H", "I"],
        "YY",
        [np.pi / 5],
        [
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            -0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [["H", "I"], "YY", [np.pi / 2], [1 / 2, -0.5 * 1.0j, 1 / 2, 0.5 * 1.0j]],
    [
        ["H", "I"],
        "YY",
        [np.pi],
        [0, -0.5 * np.sqrt(2) * 1.0j, 0, 0.5 * np.sqrt(2) * 1.0j],
    ],
    [
        ["H", "H"],
        "YY",
        [-np.pi / 2],
        [
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "YY", [0], [1 / 2, 1 / 2, 1 / 2, 1 / 2]],
    [
        ["H", "H"],
        "YY",
        [np.pi / 5],
        [
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [
        ["H", "H"],
        "YY",
        [np.pi / 2],
        [
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "YY", [np.pi], [0.5 * 1.0j, -0.5 * 1.0j, -0.5 * 1.0j, 0.5 * 1.0j]],
    [
        ["I", "I"],
        "ZZ",
        [-np.pi / 2],
        [np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j, 0, 0, 0],
    ],
    [["I", "I"], "ZZ", [0], [1, 0, 0, 0]],
    [
        ["I", "I"],
        "ZZ",
        [np.pi / 5],
        [np.sqrt(np.sqrt(5) / 8 + 5 / 8) - 1.0j * (-1 / 4 + np.sqrt(5) / 4), 0, 0, 0],
    ],
    [
        ["I", "I"],
        "ZZ",
        [np.pi / 2],
        [np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j, 0, 0, 0],
    ],
    [["I", "I"], "ZZ", [np.pi], [-1.0j, 0, 0, 0]],
    [
        ["I", "H"],
        "ZZ",
        [-np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
            0,
        ],
    ],
    [["I", "H"], "ZZ", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [
        ["I", "H"],
        "ZZ",
        [np.pi / 5],
        [
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) - 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) + 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
            0,
            0,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
            0,
        ],
    ],
    [
        ["I", "H"],
        "ZZ",
        [np.pi],
        [-0.5 * np.sqrt(2) * 1.0j, 0.5 * np.sqrt(2) * 1.0j, 0, 0],
    ],
    [
        ["H", "I"],
        "ZZ",
        [-np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
        ],
    ],
    [["H", "I"], "ZZ", [0], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [
        ["H", "I"],
        "ZZ",
        [np.pi / 5],
        [
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) - 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
            0,
            np.sqrt(2)
            * (np.sqrt(np.sqrt(5) / 8 + 5 / 8) + 1.0j * (-1 / 4 + np.sqrt(5) / 4))
            / 2,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [np.pi / 2],
        [
            np.sqrt(2) * (np.sqrt(2) / 2 - 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
            np.sqrt(2) * (np.sqrt(2) / 2 + 0.5 * np.sqrt(2) * 1.0j) / 2,
            0,
        ],
    ],
    [
        ["H", "I"],
        "ZZ",
        [np.pi],
        [-0.5 * np.sqrt(2) * 1.0j, 0, 0.5 * np.sqrt(2) * 1.0j, 0],
    ],
    [
        ["H", "H"],
        "ZZ",
        [-np.pi / 2],
        [
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "ZZ", [0], [1 / 2, 1 / 2, 1 / 2, 1 / 2]],
    [
        ["H", "H"],
        "ZZ",
        [np.pi / 5],
        [
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            - 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
        ],
    ],
    [
        ["H", "H"],
        "ZZ",
        [np.pi / 2],
        [
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
        ],
    ],
    [["H", "H"], "ZZ", [np.pi], [-0.5 * 1.0j, 0.5 * 1.0j, 0.5 * 1.0j, -0.5 * 1.0j]],
    [["I", "I"], "XY", [-np.pi / 2], [1, 0, 0, 0]],
    [["I", "I"], "XY", [0], [1, 0, 0, 0]],
    [["I", "I"], "XY", [np.pi / 5], [1, 0, 0, 0]],
    [["I", "I"], "XY", [np.pi / 2], [1, 0, 0, 0]],
    [["I", "I"], "XY", [np.pi], [1, 0, 0, 0]],
    [["I", "H"], "XY", [-np.pi / 2], [np.sqrt(2) / 2, 1 / 2, -0.5 * 1.0j, 0]],
    [["I", "H"], "XY", [0], [np.sqrt(2) / 2, np.sqrt(2) / 2, 0, 0]],
    [
        ["I", "H"],
        "XY",
        [np.pi / 5],
        [
            np.sqrt(2) / 2,
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            0,
        ],
    ],
    [["I", "H"], "XY", [np.pi / 2], [np.sqrt(2) / 2, 1 / 2, 0.5 * 1.0j, 0]],
    [["I", "H"], "XY", [np.pi], [np.sqrt(2) / 2, 0, 0.5 * np.sqrt(2) * 1.0j, 0]],
    [["H", "I"], "XY", [-np.pi / 2], [np.sqrt(2) / 2, -0.5 * 1.0j, 1 / 2, 0]],
    [["H", "I"], "XY", [0], [np.sqrt(2) / 2, 0, np.sqrt(2) / 2, 0]],
    [
        ["H", "I"],
        "XY",
        [np.pi / 5],
        [
            np.sqrt(2) / 2,
            0.5 * np.sqrt(2) * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(2) * np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2,
            0,
        ],
    ],
    [["H", "I"], "XY", [np.pi / 2], [np.sqrt(2) / 2, 0.5 * 1.0j, 1 / 2, 0]],
    [["H", "I"], "XY", [np.pi], [np.sqrt(2) / 2, 0.5 * np.sqrt(2) * 1.0j, 0, 0]],
    [
        ["H", "H"],
        "XY",
        [-np.pi / 2],
        [
            1 / 2,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 - 0.25 * np.sqrt(2) * 1.0j,
            1 / 2,
        ],
    ],
    [["H", "H"], "XY", [0], [1 / 2, 1 / 2, 1 / 2, 1 / 2]],
    [
        ["H", "H"],
        "XY",
        [np.pi / 5],
        [
            1 / 2,
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            np.sqrt(np.sqrt(5) / 8 + 5 / 8) / 2
            + 0.5 * 1.0j * (-1 / 4 + np.sqrt(5) / 4),
            1 / 2,
        ],
    ],
    [
        ["H", "H"],
        "XY",
        [np.pi / 2],
        [
            1 / 2,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            np.sqrt(2) / 4 + 0.25 * np.sqrt(2) * 1.0j,
            1 / 2,
        ],
    ],
    [["H", "H"], "XY", [np.pi], [1 / 2, 0.5 * 1.0j, 0.5 * 1.0j, 1 / 2]],
]
