from typing import Any, Iterator, List, Optional

from java.io import Writer
from java.lang import Number, Object
from java.lang import String as String

class JSONArray(Object):
    def __init__(self, arg: Any = ...) -> None: ...
    def get(self, index: int) -> Object: ...
    def getBoolean(self, index: int) -> bool: ...
    def getDouble(self, index: int) -> float: ...
    def getInt(self, index: int) -> int: ...
    def getJSONArray(self, index: int) -> JSONArray: ...
    def getJSONObject(self, index: int) -> JSONObject: ...
    def getLong(self, index: int) -> long: ...
    def getString(self, index: int) -> String: ...
    def isNull(self, index: int) -> bool: ...
    def join(self, separator: String) -> String: ...
    def length(self) -> int: ...
    def opt(self, index: int) -> Object: ...
    def optBoolean(self, index: int, defaultValue: Optional[bool] = ...) -> bool: ...
    def optDouble(self, index: int, defaultValue: Optional[float] = ...) -> float: ...
    def optInt(self, index: int, defaultValue: Optional[int] = ...) -> int: ...
    def optJSONArray(self, index: int) -> JSONArray: ...
    def optJSONObject(self, index: int) -> JSONObject: ...
    def optLong(self, index: int, defaultValue: Optional[long] = ...) -> long: ...
    def optString(self, index: int, defaultValue: Optional[String] = ...) -> String: ...
    def put(self, index: int, value: Any) -> JSONArray: ...
    def remove(self, index: int) -> Object: ...
    def toJSONObject(self, names: JSONArray) -> JSONObject: ...
    def toString(self, indentFactor: Optional[int] = ...) -> String: ...
    def write(self, writer: Writer) -> Writer: ...

class JSONObject(Object):
    NULL: Object
    def __init__(self, *args: Any) -> None: ...
    def accumulate(self, key: String, value: Object) -> JSONObject: ...
    def append(self, key: String, value: Object) -> JSONObject: ...
    @staticmethod
    def doubleToString(d: float) -> String: ...
    def get(self, key: String) -> Object: ...
    def getBoolean(self, key: String) -> bool: ...
    def getDouble(self, key: String) -> float: ...
    def getInt(self, key: String) -> int: ...
    def getJSONArray(self, key: String) -> JSONArray: ...
    def getJSONObject(self, key: String) -> JSONObject: ...
    def getLong(self, key: String) -> long: ...
    @staticmethod
    def getNames(arg: JSONObject) -> List[String]: ...
    def getString(self, key: String) -> String: ...
    def has(self, key: String) -> bool: ...
    def increment(self, key: String) -> JSONObject: ...
    def isNull(self, key: String) -> bool: ...
    def keys(self) -> Iterator[String]: ...
    def length(self) -> int: ...
    def names(self) -> JSONArray: ...
    @staticmethod
    def numberToString(n: Number) -> String: ...
    def opt(self, key: String) -> Object: ...
    def optBoolean(self, key: String, defaultValue: Optional[bool] = ...) -> bool: ...
    def optDouble(self, key: String, defaultValue: Optional[float] = ...) -> float: ...
    def optInt(self, key: String, defaultValue: Optional[int] = ...) -> int: ...
    def optJSONArray(self, key: String) -> JSONArray: ...
    def optJSONObject(self, key: String) -> JSONObject: ...
    def optLong(self, key: String, defaultValue: Optional[long] = ...) -> long: ...
    def optString(
        self, key: String, defaultValue: Optional[String] = ...
    ) -> String: ...
    def put(self, key: String, value: Any) -> JSONObject: ...
    def putOnce(self, key: String, value: Object) -> JSONObject: ...
    def putOpt(self, key: String, value: Object) -> JSONObject: ...
    @staticmethod
    def quote(string: String) -> String: ...
    def remove(self, key: String) -> Object: ...
    def sortedKeys(self) -> Iterator[String]: ...
    @staticmethod
    def stringToValue(s: String) -> Object: ...
    def toJSONArray(self, names: JSONArray) -> JSONArray: ...
    def toString(self, indentFactor: Optional[int] = ...) -> String: ...
    @staticmethod
    def valueToString(value: Object) -> String: ...
    @staticmethod
    def wrap(obj: Object) -> Object: ...
    def write(self, writer: Writer) -> Writer: ...
