from typing import Any, Iterable, Optional, TypeVar, Union

from com.inductiveautomation.ignition.common.gson.reflect import TypeToken
from com.inductiveautomation.ignition.common.gson.stream import JsonReader, JsonWriter
from java.io import Reader, Writer
from java.lang import Class, Enum, Object, String

Number = Union[float, int, long]
T = TypeVar("T")

class ExclusionStrategy:
    def shouldSkipClass(self, clazz: Class) -> bool: ...
    def shouldSkipField(self, attributes: FieldAttributes) -> bool: ...

class FieldNamingStrategy:
    def translateName(self, arg: Any) -> String: ...

class TypeAdapterFactory:
    def create(self, gson: Gson, token: TypeToken) -> TypeAdapter: ...

class FieldAttributes(Object):
    def __init__(self, *args: Any) -> None: ...
    def getAnnotation(self, annotation: Class) -> T: ...
    def getAnnotations(self) -> Iterable[Any]: ...
    def getDeclaredClass(self) -> Class: ...
    def getDeclaredType(self) -> Any: ...
    def getDeclaringClass(self) -> Class: ...
    def getName(self) -> String: ...
    def hasModifier(self, modifier: int) -> bool: ...
    def isSynthetic(self) -> bool: ...

class FieldNamingPolicy(Enum, FieldNamingStrategy):
    IDENTITY: String
    UPPER_CAMEL_CASE: String
    UPPER_CAMEL_CASE_WITH_SPACES: String
    LOWER_CASE_WITH_UNDERSCORES: String
    LOWER_CASE_WITH_DASHES: String
    LOWER_CASE_WITH_DOTS: String
    def translateName(self, arg: Any) -> String: ...

class Gson(Object):
    def excluder(self) -> Any: ...
    def fieldNamingStrategy(self) -> FieldNamingStrategy: ...
    def fromJson(self, *args: Any) -> T: ...
    def getAdapter(self, type: TypeToken = ...) -> TypeAdapter: ...
    def getDelegateAdapter(
        self, skipPast: TypeAdapterFactory, type: TypeToken
    ) -> TypeAdapter: ...
    def htmlSafe(self) -> bool: ...
    def newBuilder(self) -> GsonBuilder: ...
    def newJsonReader(self, reader: Reader) -> JsonReader: ...
    def newJsonWriter(self, writer: Writer) -> JsonWriter: ...
    def serializeNulls(self) -> bool: ...
    def toJson(self, *args: Any) -> Optional[String]: ...
    def toJsonTree(self, src: Object, typeOfSrc: Any = ...) -> JsonElement: ...

class GsonBuilder:
    def __init__(self, *args: Any) -> None: ...
    def addDeserializationExclusionStrategy(
        self, strategy: ExclusionStrategy
    ) -> GsonBuilder: ...
    def addSerializationExclusionStrategy(
        self, strategy: ExclusionStrategy
    ) -> GsonBuilder: ...
    def create(self) -> Gson: ...
    def disableHtmlEscaping(self) -> GsonBuilder: ...
    def disableInnerClassSerialization(self) -> GsonBuilder: ...
    def enableComplexMapKeySerialization(self) -> GsonBuilder: ...
    def excludeFieldsWithoutExposeAnnotation(self) -> GsonBuilder: ...
    def excludeFieldsWithModifiers(self, *args: int) -> GsonBuilder: ...
    def generateNonExecutableJson(self) -> GsonBuilder: ...
    def setLenient(self) -> GsonBuilder: ...
    def registerTypeAdapter(self, type: Any, typeAdapter: Object) -> GsonBuilder: ...
    def registerTypeAdapterFactory(
        self, factory: TypeAdapterFactory
    ) -> GsonBuilder: ...
    def registerTypeHierarchyAdapter(
        self, baseType: Class, typeAdapter: Object
    ) -> GsonBuilder: ...
    def serializeNulls(self) -> GsonBuilder: ...
    def serializeSpecialFloatingPointValues(self) -> GsonBuilder: ...
    def setDateFormat(self, *args: Any) -> GsonBuilder: ...
    def setExclusionStrategies(self, *args: ExclusionStrategy) -> GsonBuilder: ...
    def setFieldNamingPolicy(
        self, namingConvention: FieldNamingPolicy
    ) -> GsonBuilder: ...
    def setFieldNamingStrategy(
        self, fieldNamingStrategy: FieldNamingStrategy
    ) -> GsonBuilder: ...
    def setLongSerializationPolicy(
        self, policy: LongSerializationPolicy
    ) -> GsonBuilder: ...
    def setPrettyPrinting(self) -> GsonBuilder: ...
    def setVersion(self, ignoreVersionsAfter: float) -> GsonBuilder: ...

class JsonElement:
    def deepCopy(self) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsJsonArray(self) -> JsonArray: ...
    def getAsJsonObject(self) -> JsonObject: ...
    def getAsJsonPrimitive(self) -> JsonPrimitive: ...
    def getAsJsonNull(self) -> JsonNull: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Number: ...
    def getAsShort(self) -> int: ...
    def isJsonArray(self) -> bool: ...
    def isJsonObject(self) -> bool: ...
    def isJsonPrimitive(self) -> bool: ...
    def isJsonNull(self) -> bool: ...

class JsonArray(JsonElement):
    def __init__(self, capacity: Optional[int] = ...) -> None: ...
    def add(self, arg: Any) -> None: ...
    def addAll(self, array: JsonArray) -> None: ...
    def contains(self, element: JsonElement) -> bool: ...
    def get(self, i: int) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Number: ...
    def getAsShort(self) -> int: ...
    def iterator(self) -> Iterable[JsonElement]: ...
    def remove(self, index: int) -> JsonElement: ...
    def size(self) -> int: ...

class JsonNull(JsonElement):
    def equals(self, other: Object) -> bool: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Number: ...
    def getAsShort(self) -> int: ...
    def hashCode(self) -> int: ...

class JsonObject(JsonElement):
    def add(self, property: String, value: JsonElement) -> None: ...
    def addProperty(self, property: String, value: Any) -> None: ...
    def createJsonElement(self, value: Object) -> JsonElement: ...
    def get(self, memberName: String) -> JsonElement: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Number: ...
    def getAsShort(self) -> int: ...
    def has(self, memberName: String) -> bool: ...
    def remove(self, property: String) -> JsonElement: ...
    def size(self) -> int: ...

class JsonPrimitive(JsonElement):
    def __init__(self, arg: Any) -> None: ...
    def equals(self, other: Object) -> bool: ...
    def getAsBigDecimal(self) -> float: ...
    def getAsBigInteger(self) -> int: ...
    def getAsBoolean(self) -> bool: ...
    def getAsByte(self) -> Any: ...
    def getAsCharacter(self) -> str: ...
    def getAsDouble(self) -> float: ...
    def getAsFloat(self) -> float: ...
    def getAsInt(self) -> int: ...
    def getAsLong(self) -> long: ...
    def getAsNumber(self) -> Number: ...
    def getAsShort(self) -> int: ...
    def hashCode(self) -> int: ...
    def isBoolean(self) -> bool: ...
    @staticmethod
    def isPrimitiveOrString(target: Object) -> bool: ...
    @staticmethod
    def isIntegral(primitive: JsonPrimitive) -> bool: ...
    def isString(self) -> bool: ...

class LongSerializationPolicy:
    DEFAULT: JsonElement
    STRING: JsonElement
    def serialize(self, arg: long) -> JsonElement: ...

class TypeAdapter:
    def fromJson(self, arg: Union[Reader, String]) -> T: ...
    def fromJsonTree(self, jsonTree: JsonElement) -> T: ...
    def nullSafe(self) -> TypeAdapter: ...
    def read(self, reader: JsonReader) -> T: ...
    def toJson(self, out: Writer, value: T) -> Optional[String]: ...
    def toJsonTree(self, value: T) -> JsonElement: ...
    def write(self, *args) -> None: ...
