from typing import Any, Dict, List, Optional, Tuple, Union

from com.inductiveautomation.factorypmi.application import FPMIWindow
from com.inductiveautomation.factorypmi.application.script import PyComponentWrapper
from com.inductiveautomation.ignition.common.model.values import QualityCode
from java.awt import Color, Component, Graphics
from java.awt.event import ActionEvent, ComponentEvent, MouseEvent
from java.awt.image import BufferedImage
from java.awt.print import PageFormat
from java.lang import Number, Object, String
from java.util import EventObject
from javax.swing import JComponent, JFrame, JPopupMenu
from org.python.core import PyObject, PySequence, PyTuple

class INavUtilities:
    def centerWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def getCurrentWindow(self) -> String: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: String, params: Dict[String, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: String, params: Dict[String, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class NavUtilities(INavUtilities):
    def centerWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, String]) -> None: ...
    def getCurrentWindow(self) -> String: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: String, params: Dict[String, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: String, params: Optional[Dict[String, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: String, params: Dict[String, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class PrintUtilities(Object):
    def __init__(self, app: Any) -> None: ...
    def createImage(self, c: Component) -> BufferedImage: ...
    def createPrintJob(self, c: Component) -> PrintUtilities.JythonPrintJob: ...
    def printToImage(self, c: Component, fileName: Optional[str] = ...) -> None: ...

    class ComponentPrinter(Object):
        def __init__(self, c: Component, fit: bool, zoom: float) -> None: ...
        def print(self, g: Graphics, pageFormat: PageFormat, pageIndex: int) -> int: ...

    class JythonPrintJob(Object):
        def __init__(self, c: Component) -> None: ...
        def getBottomMargin(self) -> float: ...
        def getLeftMargin(self) -> float: ...
        def getOrientation(self) -> int: ...
        def getPageHeight(self) -> float: ...
        def getPageWidth(self) -> float: ...
        def getPrinterName(self) -> String: ...
        def getRightMargin(self) -> float: ...
        def getTopMargin(self) -> float: ...
        def getZoomFactor(self) -> float: ...
        def isFitToPage(self) -> bool: ...
        def isShowPrintDialog(self) -> bool: ...
        def setBottomMargin(self, bottomMargin: float) -> None: ...
        def setFitToPage(self, fitToPage: bool) -> None: ...
        def setLeftMargin(self, leftMargin: float) -> None: ...
        def setMargins(self, m: float) -> None: ...
        def setOrientation(self, orientation: int) -> None: ...
        def setPageHeight(self, pageHeight: float) -> None: ...
        def setPageWidth(self, pageWidth: float) -> None: ...
        def setPrinterName(self, printerName: String) -> None: ...
        def setRightMargin(self, rightMargin: float) -> None: ...
        def setShowPrintDialog(self, showPrintDialog: bool) -> None: ...
        def setZoomFactor(self, zoomFactor: float) -> None: ...

class WindowUtilities(Object):
    ACCL_NONE: int
    ACCL_CONSTANT: int
    ACCL_FAST_TO_SLOW: int
    ACCL_SLOW_TO_FAST: int
    ACCL_EASE: int
    COORD_DESIGNER: int
    COORD_SCREEN: int
    def chooseColor(
        self, initialColor: Color, dialogTitle: Optional[String] = ...
    ) -> Color: ...
    def closeDesktop(self, handle: String) -> None: ...
    @staticmethod
    def color(*args: Any) -> Color: ...
    def confirm(
        self, message: String, title: String = ..., allowCancel: bool = ...
    ) -> Optional[bool]: ...
    @staticmethod
    def convertPointToScreen(x: int, y: int, event: EventObject) -> Tuple[int, int]: ...
    @staticmethod
    def createPopupContext() -> WindowUtilities.PopupContext: ...
    @staticmethod
    def createPopupMenu(key: PySequence, functions: PySequence) -> JPopupMenu: ...
    def desktop(self, arg: Union[int, String]) -> WindowUtilities: ...
    def errorBox(self, message: String, title: Optional[String] = ...) -> None: ...
    @staticmethod
    def find(component: JComponent) -> WindowUtilities: ...
    def findWindow(self, path: String) -> List[PyComponentWrapper]: ...
    def getCurrentDesktop(self) -> String: ...
    def getDesktopHandles(self) -> PySequence: ...
    def getOpenedWindowNames(self) -> PyTuple: ...
    def getOpenedWindows(self) -> PyTuple: ...
    @staticmethod
    def getParentWindow(event: EventObject) -> PyObject: ...
    def getQuality(self, comp: JComponent, propertyName: String) -> QualityCode: ...
    def getScreenIndex(self) -> int: ...
    @staticmethod
    def getScreens() -> PySequence: ...
    @staticmethod
    def getSibling(event: EventObject, name: String) -> PyObject: ...
    def getWindow(self, name: String) -> PyObject: ...
    def getWindowNames(self) -> PyTuple: ...
    def inputBox(
        self, message: String, defaultTxt: String = ...
    ) -> Optional[String]: ...
    def isTouchscreenModeEnabled(self) -> bool: ...
    def messageBox(self, message: String, title: String = ...) -> None: ...
    def openDesktop(self, *args: PyObject, **kwargs: String) -> JFrame: ...
    def openDiagnostics(self) -> None: ...
    def passwordBox(
        self, message: String, title: String = ..., echoChar: String = ...
    ) -> Optional[String]: ...
    def setTouchScreenModeEnabled(self, b: bool) -> None: ...
    def showNumericKeyPad(
        self,
        initialValue: Number,
        fontSize: Optional[int] = ...,
        usePasswordMode: bool = ...,
    ) -> Number: ...
    def showTouchscreenKeyboard(
        self,
        initialText: String,
        fontSize: Optional[int] = ...,
        password: Optional[bool] = ...,
    ) -> String: ...
    def transform(self, *args: PyObject, **kwargs: String) -> PyObject: ...
    def warningBox(self, message: String, title: String = ...) -> None: ...

    class JyPopupMenu(JPopupMenu):
        def actionPerformed(self, e: ActionEvent) -> None: ...
        def addJyFunction(self, name: String, fun: PyObject) -> None: ...
        def show(self, me: Union[ComponentEvent, MouseEvent], *args: int) -> None: ...

    class PopupContext(Object):
        def endPopup(self) -> None: ...
        def startPopup(self) -> None: ...
