# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['isocodes']

package_data = \
{'': ['*'],
 'isocodes': ['share/iso-codes/json/*',
              'share/locale/ab/LC_MESSAGES/*',
              'share/locale/ace/LC_MESSAGES/*',
              'share/locale/ach/LC_MESSAGES/*',
              'share/locale/af/LC_MESSAGES/*',
              'share/locale/ak/LC_MESSAGES/*',
              'share/locale/am/LC_MESSAGES/*',
              'share/locale/an/LC_MESSAGES/*',
              'share/locale/ar/LC_MESSAGES/*',
              'share/locale/as/LC_MESSAGES/*',
              'share/locale/ast/LC_MESSAGES/*',
              'share/locale/ay/LC_MESSAGES/*',
              'share/locale/az/LC_MESSAGES/*',
              'share/locale/ba/LC_MESSAGES/*',
              'share/locale/bar/LC_MESSAGES/*',
              'share/locale/be/LC_MESSAGES/*',
              'share/locale/bg/LC_MESSAGES/*',
              'share/locale/bi/LC_MESSAGES/*',
              'share/locale/bn/LC_MESSAGES/*',
              'share/locale/bn_BD/LC_MESSAGES/*',
              'share/locale/bn_IN/LC_MESSAGES/*',
              'share/locale/br/LC_MESSAGES/*',
              'share/locale/bs/LC_MESSAGES/*',
              'share/locale/byn/LC_MESSAGES/*',
              'share/locale/ca/LC_MESSAGES/*',
              'share/locale/ce/LC_MESSAGES/*',
              'share/locale/ch/LC_MESSAGES/*',
              'share/locale/chr/LC_MESSAGES/*',
              'share/locale/ckb/LC_MESSAGES/*',
              'share/locale/crh/LC_MESSAGES/*',
              'share/locale/cs/LC_MESSAGES/*',
              'share/locale/csb/LC_MESSAGES/*',
              'share/locale/cv/LC_MESSAGES/*',
              'share/locale/cy/LC_MESSAGES/*',
              'share/locale/da/LC_MESSAGES/*',
              'share/locale/de/LC_MESSAGES/*',
              'share/locale/dv/LC_MESSAGES/*',
              'share/locale/dz/LC_MESSAGES/*',
              'share/locale/ee/LC_MESSAGES/*',
              'share/locale/el/LC_MESSAGES/*',
              'share/locale/en/LC_MESSAGES/*',
              'share/locale/eo/LC_MESSAGES/*',
              'share/locale/es/LC_MESSAGES/*',
              'share/locale/et/LC_MESSAGES/*',
              'share/locale/eu/LC_MESSAGES/*',
              'share/locale/fa/LC_MESSAGES/*',
              'share/locale/ff/LC_MESSAGES/*',
              'share/locale/fi/LC_MESSAGES/*',
              'share/locale/fil/LC_MESSAGES/*',
              'share/locale/fo/LC_MESSAGES/*',
              'share/locale/fr/LC_MESSAGES/*',
              'share/locale/frp/LC_MESSAGES/*',
              'share/locale/fur/LC_MESSAGES/*',
              'share/locale/fy/LC_MESSAGES/*',
              'share/locale/ga/LC_MESSAGES/*',
              'share/locale/gez/LC_MESSAGES/*',
              'share/locale/gl/LC_MESSAGES/*',
              'share/locale/gn/LC_MESSAGES/*',
              'share/locale/gu/LC_MESSAGES/*',
              'share/locale/gv/LC_MESSAGES/*',
              'share/locale/ha/LC_MESSAGES/*',
              'share/locale/haw/LC_MESSAGES/*',
              'share/locale/he/LC_MESSAGES/*',
              'share/locale/hi/LC_MESSAGES/*',
              'share/locale/hr/LC_MESSAGES/*',
              'share/locale/ht/LC_MESSAGES/*',
              'share/locale/hu/LC_MESSAGES/*',
              'share/locale/hy/LC_MESSAGES/*',
              'share/locale/ia/LC_MESSAGES/*',
              'share/locale/id/LC_MESSAGES/*',
              'share/locale/io/LC_MESSAGES/*',
              'share/locale/is/LC_MESSAGES/*',
              'share/locale/it/LC_MESSAGES/*',
              'share/locale/iu/LC_MESSAGES/*',
              'share/locale/ja/LC_MESSAGES/*',
              'share/locale/jam/LC_MESSAGES/*',
              'share/locale/ka/LC_MESSAGES/*',
              'share/locale/kab/LC_MESSAGES/*',
              'share/locale/ki/LC_MESSAGES/*',
              'share/locale/kk/LC_MESSAGES/*',
              'share/locale/kl/LC_MESSAGES/*',
              'share/locale/km/LC_MESSAGES/*',
              'share/locale/kmr/LC_MESSAGES/*',
              'share/locale/kn/LC_MESSAGES/*',
              'share/locale/ko/LC_MESSAGES/*',
              'share/locale/kok/LC_MESSAGES/*',
              'share/locale/kv/LC_MESSAGES/*',
              'share/locale/kw/LC_MESSAGES/*',
              'share/locale/ky/LC_MESSAGES/*',
              'share/locale/lo/LC_MESSAGES/*',
              'share/locale/lt/LC_MESSAGES/*',
              'share/locale/lv/LC_MESSAGES/*',
              'share/locale/mai/LC_MESSAGES/*',
              'share/locale/mhr/LC_MESSAGES/*',
              'share/locale/mi/LC_MESSAGES/*',
              'share/locale/mk/LC_MESSAGES/*',
              'share/locale/ml/LC_MESSAGES/*',
              'share/locale/mn/LC_MESSAGES/*',
              'share/locale/mo/LC_MESSAGES/*',
              'share/locale/mr/LC_MESSAGES/*',
              'share/locale/ms/LC_MESSAGES/*',
              'share/locale/mt/LC_MESSAGES/*',
              'share/locale/my/LC_MESSAGES/*',
              'share/locale/na/LC_MESSAGES/*',
              'share/locale/nah/LC_MESSAGES/*',
              'share/locale/nb/LC_MESSAGES/*',
              'share/locale/nb_NO/LC_MESSAGES/*',
              'share/locale/ne/LC_MESSAGES/*',
              'share/locale/nl/LC_MESSAGES/*',
              'share/locale/nn/LC_MESSAGES/*',
              'share/locale/nso/LC_MESSAGES/*',
              'share/locale/nv/LC_MESSAGES/*',
              'share/locale/oc/LC_MESSAGES/*',
              'share/locale/or/LC_MESSAGES/*',
              'share/locale/pa/LC_MESSAGES/*',
              'share/locale/pap/LC_MESSAGES/*',
              'share/locale/pi/LC_MESSAGES/*',
              'share/locale/pl/LC_MESSAGES/*',
              'share/locale/ps/LC_MESSAGES/*',
              'share/locale/pt/LC_MESSAGES/*',
              'share/locale/pt_BR/LC_MESSAGES/*',
              'share/locale/ro/LC_MESSAGES/*',
              'share/locale/ru/LC_MESSAGES/*',
              'share/locale/rw/LC_MESSAGES/*',
              'share/locale/sc/LC_MESSAGES/*',
              'share/locale/sd/LC_MESSAGES/*',
              'share/locale/si/LC_MESSAGES/*',
              'share/locale/sk/LC_MESSAGES/*',
              'share/locale/sl/LC_MESSAGES/*',
              'share/locale/so/LC_MESSAGES/*',
              'share/locale/son/LC_MESSAGES/*',
              'share/locale/sq/LC_MESSAGES/*',
              'share/locale/sr/LC_MESSAGES/*',
              'share/locale/sr@latin/LC_MESSAGES/*',
              'share/locale/sv/LC_MESSAGES/*',
              'share/locale/sw/LC_MESSAGES/*',
              'share/locale/ta/LC_MESSAGES/*',
              'share/locale/te/LC_MESSAGES/*',
              'share/locale/tg/LC_MESSAGES/*',
              'share/locale/th/LC_MESSAGES/*',
              'share/locale/ti/LC_MESSAGES/*',
              'share/locale/tig/LC_MESSAGES/*',
              'share/locale/tk/LC_MESSAGES/*',
              'share/locale/tl/LC_MESSAGES/*',
              'share/locale/tr/LC_MESSAGES/*',
              'share/locale/tt/LC_MESSAGES/*',
              'share/locale/tt@iqtelif/LC_MESSAGES/*',
              'share/locale/tzm/LC_MESSAGES/*',
              'share/locale/ug/LC_MESSAGES/*',
              'share/locale/uk/LC_MESSAGES/*',
              'share/locale/ur/LC_MESSAGES/*',
              'share/locale/uz/LC_MESSAGES/*',
              'share/locale/ve/LC_MESSAGES/*',
              'share/locale/vi/LC_MESSAGES/*',
              'share/locale/wa/LC_MESSAGES/*',
              'share/locale/wal/LC_MESSAGES/*',
              'share/locale/wo/LC_MESSAGES/*',
              'share/locale/xh/LC_MESSAGES/*',
              'share/locale/yo/LC_MESSAGES/*',
              'share/locale/zh_CN/LC_MESSAGES/*',
              'share/locale/zh_HK/LC_MESSAGES/*',
              'share/locale/zh_Hans/LC_MESSAGES/*',
              'share/locale/zh_Hant/LC_MESSAGES/*',
              'share/locale/zh_TW/LC_MESSAGES/*',
              'share/locale/zu/LC_MESSAGES/*',
              'share/pkgconfig/*',
              'share/xml/iso-codes/*']}

setup_kwargs = {
    'name': 'isocodes',
    'version': '2022.8.2',
    'description': 'This project provides lists of various ISO standards (e.g. country, language, language scripts, and currency names) in one place',
    'long_description': '# isocodes\n\nisocodes provides you access to lists of various ISO standards (e.g. country, language, language scripts, and currency names).\n\nThe data is coming from https://salsa.debian.org/iso-codes-team/iso-codes, many thanks to them.\n\n# Installation\n\n    pip install isocodes\n\n# Usage\n\n## Countries (ISO 3166)\n\n### Get method\n\nYou can acces one country by using the method get with the parameters being the json keys of the .json files in the share/iso-codes/json folder\n\n#### Example\n\n    >>> from isocodes import countries\n    >>> countries.get(name="Germany")\n    {\'alpha_2\': \'DE\', \'alpha_3\': \'DEU\', \'flag\': \'🇩🇪\', \'name\': \'Germany\', \'numeric\': \'276\', \'official_name\': \'Federal Republic of Germany\'}\n\n### Items property\n\nYou can get a json parsed list from the .json files in the share/iso-codes/json folder with the items property.\n\nThat list contains each countries in the form of the dictionary that you can get with the method get.\n\n#### Example\n\n    >>> from isocodes import countries\n    >>> for country in countries.items:\n    ...     print(country)\n    ...\n    {\'alpha_2\': \'AW\', \'alpha_3\': \'ABW\', \'flag\': \'🇦🇼\', \'name\': \'Aruba\', \'numeric\': \'533\'}\n    {\'alpha_2\': \'AF\', \'alpha_3\': \'AFG\', \'flag\': \'🇦🇫\', \'name\': \'Afghanistan\', \'numeric\': \'004\', \'official_name\': \'Islamic Republic of Afghanistan\'}\n    {\'alpha_2\': \'AO\', \'alpha_3\': \'AGO\', \'flag\': \'🇦🇴\', \'name\': \'Angola\', \'numeric\': \'024\', \'official_name\': \'Republic of Angola\'}\n    {\'alpha_2\': \'AI\', \'alpha_3\': \'AIA\', \'flag\': \'🇦🇮\', \'name\': \'Anguilla\', \'numeric\': \'660\'}\n    {\'alpha_2\': \'AX\', \'alpha_3\': \'ALA\', \'flag\': \'🇦🇽\', \'name\': \'Åland Islands\', \'numeric\': \'248\'}\n\n### by_xxx property\n\nYou can get a list with sorted data by one of the property with the by_xxx property, xxx being one of the data key (alpha_2, name, numeric, etc.).\n\n#### Example\n\n    >>> countries.by_numeric[0]\n    (\'004\', {\'alpha_2\': \'AF\', \'alpha_3\': \'AFG\', \'flag\': \'🇦🇫\', \'name\': \'Afghanistan\', \'numeric\': \'004\', \'official_name\': \'Islamic Republic of Afghanistan\'})\n\n\n## Languages (ISO 639-2)\n\nSame as countries but you replace countries by languages\n\n## Currencies (ISO 4217)\n\nSame as countries but you replace countries by currencies\n\n## Countries and Subdivisions (ISO 3166-2)\n\nSame as countries but you replace countries by subdivisions_countries\n\n## Former countries (ISO 3166-3)\n\nSame as countries but you replace countries by former_countries\n\n## Extended languages (ISO 639-3)\nSame as countries but you replace countries by extendend_languages\n\n## Language families (ISO 639-5)\nSame as countries but you replace countries by language_families\n\n## Script names (ISO 15924)\nSame as countries but you replace countries by script_names\n\n## Translations\n\nTranslations are included in this project with gettext support. The domain names are to be found on https://salsa.debian.org/iso-codes-team/iso-codes\n\n### Example\n\n    >>> import gettext\n    >>> import isocodes\n    >>> french = gettext.translation(\'iso_639-2\', isocodes.LOCALES_DIR, languages=[\'fr\'])\n    >>> french.install()\n    >>> _("French")\n    \'français\'\n\n# Develop\n\nDon\'t forget to clone the submodules as well and execute update.sh to update the debian\'s iso-codes repo.',
    'author': 'Atem18',
    'author_email': 'contact@atemlire.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Atem18/isocodes',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
