"""
Main interface for elb service type definitions.

Usage::

    from mypy_boto3.elb.type_defs import AddAvailabilityZonesOutputTypeDef

    data: AddAvailabilityZonesOutputTypeDef = {...}
"""
from datetime import datetime
import sys
from typing import List

if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "AddAvailabilityZonesOutputTypeDef",
    "ApplySecurityGroupsToLoadBalancerOutputTypeDef",
    "AttachLoadBalancerToSubnetsOutputTypeDef",
    "HealthCheckTypeDef",
    "ConfigureHealthCheckOutputTypeDef",
    "CreateAccessPointOutputTypeDef",
    "InstanceTypeDef",
    "DeregisterEndPointsOutputTypeDef",
    "BackendServerDescriptionTypeDef",
    "ListenerTypeDef",
    "ListenerDescriptionTypeDef",
    "AppCookieStickinessPolicyTypeDef",
    "LBCookieStickinessPolicyTypeDef",
    "PoliciesTypeDef",
    "SourceSecurityGroupTypeDef",
    "LoadBalancerDescriptionTypeDef",
    "DescribeAccessPointsOutputTypeDef",
    "LimitTypeDef",
    "DescribeAccountLimitsOutputTypeDef",
    "InstanceStateTypeDef",
    "DescribeEndPointStateOutputTypeDef",
    "AccessLogTypeDef",
    "AdditionalAttributeTypeDef",
    "ConnectionDrainingTypeDef",
    "ConnectionSettingsTypeDef",
    "CrossZoneLoadBalancingTypeDef",
    "LoadBalancerAttributesTypeDef",
    "DescribeLoadBalancerAttributesOutputTypeDef",
    "PolicyAttributeDescriptionTypeDef",
    "PolicyDescriptionTypeDef",
    "DescribeLoadBalancerPoliciesOutputTypeDef",
    "PolicyAttributeTypeDescriptionTypeDef",
    "PolicyTypeDescriptionTypeDef",
    "DescribeLoadBalancerPolicyTypesOutputTypeDef",
    "TagTypeDef",
    "TagDescriptionTypeDef",
    "DescribeTagsOutputTypeDef",
    "DetachLoadBalancerFromSubnetsOutputTypeDef",
    "ModifyLoadBalancerAttributesOutputTypeDef",
    "PaginatorConfigTypeDef",
    "PolicyAttributeTypeDef",
    "RegisterEndPointsOutputTypeDef",
    "RemoveAvailabilityZonesOutputTypeDef",
    "TagKeyOnlyTypeDef",
    "WaiterConfigTypeDef",
)

AddAvailabilityZonesOutputTypeDef = TypedDict(
    "AddAvailabilityZonesOutputTypeDef", {"AvailabilityZones": List[str]}, total=False
)

ApplySecurityGroupsToLoadBalancerOutputTypeDef = TypedDict(
    "ApplySecurityGroupsToLoadBalancerOutputTypeDef", {"SecurityGroups": List[str]}, total=False
)

AttachLoadBalancerToSubnetsOutputTypeDef = TypedDict(
    "AttachLoadBalancerToSubnetsOutputTypeDef", {"Subnets": List[str]}, total=False
)

HealthCheckTypeDef = TypedDict(
    "HealthCheckTypeDef",
    {
        "Target": str,
        "Interval": int,
        "Timeout": int,
        "UnhealthyThreshold": int,
        "HealthyThreshold": int,
    },
)

ConfigureHealthCheckOutputTypeDef = TypedDict(
    "ConfigureHealthCheckOutputTypeDef", {"HealthCheck": HealthCheckTypeDef}, total=False
)

CreateAccessPointOutputTypeDef = TypedDict(
    "CreateAccessPointOutputTypeDef", {"DNSName": str}, total=False
)

InstanceTypeDef = TypedDict("InstanceTypeDef", {"InstanceId": str}, total=False)

DeregisterEndPointsOutputTypeDef = TypedDict(
    "DeregisterEndPointsOutputTypeDef", {"Instances": List[InstanceTypeDef]}, total=False
)

BackendServerDescriptionTypeDef = TypedDict(
    "BackendServerDescriptionTypeDef", {"InstancePort": int, "PolicyNames": List[str]}, total=False
)

_RequiredListenerTypeDef = TypedDict(
    "_RequiredListenerTypeDef", {"Protocol": str, "LoadBalancerPort": int, "InstancePort": int}
)
_OptionalListenerTypeDef = TypedDict(
    "_OptionalListenerTypeDef", {"InstanceProtocol": str, "SSLCertificateId": str}, total=False
)


class ListenerTypeDef(_RequiredListenerTypeDef, _OptionalListenerTypeDef):
    pass


ListenerDescriptionTypeDef = TypedDict(
    "ListenerDescriptionTypeDef",
    {"Listener": ListenerTypeDef, "PolicyNames": List[str]},
    total=False,
)

AppCookieStickinessPolicyTypeDef = TypedDict(
    "AppCookieStickinessPolicyTypeDef", {"PolicyName": str, "CookieName": str}, total=False
)

LBCookieStickinessPolicyTypeDef = TypedDict(
    "LBCookieStickinessPolicyTypeDef",
    {"PolicyName": str, "CookieExpirationPeriod": int},
    total=False,
)

PoliciesTypeDef = TypedDict(
    "PoliciesTypeDef",
    {
        "AppCookieStickinessPolicies": List[AppCookieStickinessPolicyTypeDef],
        "LBCookieStickinessPolicies": List[LBCookieStickinessPolicyTypeDef],
        "OtherPolicies": List[str],
    },
    total=False,
)

SourceSecurityGroupTypeDef = TypedDict(
    "SourceSecurityGroupTypeDef", {"OwnerAlias": str, "GroupName": str}, total=False
)

LoadBalancerDescriptionTypeDef = TypedDict(
    "LoadBalancerDescriptionTypeDef",
    {
        "LoadBalancerName": str,
        "DNSName": str,
        "CanonicalHostedZoneName": str,
        "CanonicalHostedZoneNameID": str,
        "ListenerDescriptions": List[ListenerDescriptionTypeDef],
        "Policies": PoliciesTypeDef,
        "BackendServerDescriptions": List[BackendServerDescriptionTypeDef],
        "AvailabilityZones": List[str],
        "Subnets": List[str],
        "VPCId": str,
        "Instances": List[InstanceTypeDef],
        "HealthCheck": HealthCheckTypeDef,
        "SourceSecurityGroup": SourceSecurityGroupTypeDef,
        "SecurityGroups": List[str],
        "CreatedTime": datetime,
        "Scheme": str,
    },
    total=False,
)

DescribeAccessPointsOutputTypeDef = TypedDict(
    "DescribeAccessPointsOutputTypeDef",
    {"LoadBalancerDescriptions": List[LoadBalancerDescriptionTypeDef], "NextMarker": str},
    total=False,
)

LimitTypeDef = TypedDict("LimitTypeDef", {"Name": str, "Max": str}, total=False)

DescribeAccountLimitsOutputTypeDef = TypedDict(
    "DescribeAccountLimitsOutputTypeDef",
    {"Limits": List[LimitTypeDef], "NextMarker": str},
    total=False,
)

InstanceStateTypeDef = TypedDict(
    "InstanceStateTypeDef",
    {"InstanceId": str, "State": str, "ReasonCode": str, "Description": str},
    total=False,
)

DescribeEndPointStateOutputTypeDef = TypedDict(
    "DescribeEndPointStateOutputTypeDef",
    {"InstanceStates": List[InstanceStateTypeDef]},
    total=False,
)

_RequiredAccessLogTypeDef = TypedDict("_RequiredAccessLogTypeDef", {"Enabled": bool})
_OptionalAccessLogTypeDef = TypedDict(
    "_OptionalAccessLogTypeDef",
    {"S3BucketName": str, "EmitInterval": int, "S3BucketPrefix": str},
    total=False,
)


class AccessLogTypeDef(_RequiredAccessLogTypeDef, _OptionalAccessLogTypeDef):
    pass


AdditionalAttributeTypeDef = TypedDict(
    "AdditionalAttributeTypeDef", {"Key": str, "Value": str}, total=False
)

_RequiredConnectionDrainingTypeDef = TypedDict(
    "_RequiredConnectionDrainingTypeDef", {"Enabled": bool}
)
_OptionalConnectionDrainingTypeDef = TypedDict(
    "_OptionalConnectionDrainingTypeDef", {"Timeout": int}, total=False
)


class ConnectionDrainingTypeDef(
    _RequiredConnectionDrainingTypeDef, _OptionalConnectionDrainingTypeDef
):
    pass


ConnectionSettingsTypeDef = TypedDict("ConnectionSettingsTypeDef", {"IdleTimeout": int})

CrossZoneLoadBalancingTypeDef = TypedDict("CrossZoneLoadBalancingTypeDef", {"Enabled": bool})

LoadBalancerAttributesTypeDef = TypedDict(
    "LoadBalancerAttributesTypeDef",
    {
        "CrossZoneLoadBalancing": CrossZoneLoadBalancingTypeDef,
        "AccessLog": AccessLogTypeDef,
        "ConnectionDraining": ConnectionDrainingTypeDef,
        "ConnectionSettings": ConnectionSettingsTypeDef,
        "AdditionalAttributes": List[AdditionalAttributeTypeDef],
    },
    total=False,
)

DescribeLoadBalancerAttributesOutputTypeDef = TypedDict(
    "DescribeLoadBalancerAttributesOutputTypeDef",
    {"LoadBalancerAttributes": LoadBalancerAttributesTypeDef},
    total=False,
)

PolicyAttributeDescriptionTypeDef = TypedDict(
    "PolicyAttributeDescriptionTypeDef", {"AttributeName": str, "AttributeValue": str}, total=False
)

PolicyDescriptionTypeDef = TypedDict(
    "PolicyDescriptionTypeDef",
    {
        "PolicyName": str,
        "PolicyTypeName": str,
        "PolicyAttributeDescriptions": List[PolicyAttributeDescriptionTypeDef],
    },
    total=False,
)

DescribeLoadBalancerPoliciesOutputTypeDef = TypedDict(
    "DescribeLoadBalancerPoliciesOutputTypeDef",
    {"PolicyDescriptions": List[PolicyDescriptionTypeDef]},
    total=False,
)

PolicyAttributeTypeDescriptionTypeDef = TypedDict(
    "PolicyAttributeTypeDescriptionTypeDef",
    {
        "AttributeName": str,
        "AttributeType": str,
        "Description": str,
        "DefaultValue": str,
        "Cardinality": str,
    },
    total=False,
)

PolicyTypeDescriptionTypeDef = TypedDict(
    "PolicyTypeDescriptionTypeDef",
    {
        "PolicyTypeName": str,
        "Description": str,
        "PolicyAttributeTypeDescriptions": List[PolicyAttributeTypeDescriptionTypeDef],
    },
    total=False,
)

DescribeLoadBalancerPolicyTypesOutputTypeDef = TypedDict(
    "DescribeLoadBalancerPolicyTypesOutputTypeDef",
    {"PolicyTypeDescriptions": List[PolicyTypeDescriptionTypeDef]},
    total=False,
)

_RequiredTagTypeDef = TypedDict("_RequiredTagTypeDef", {"Key": str})
_OptionalTagTypeDef = TypedDict("_OptionalTagTypeDef", {"Value": str}, total=False)


class TagTypeDef(_RequiredTagTypeDef, _OptionalTagTypeDef):
    pass


TagDescriptionTypeDef = TypedDict(
    "TagDescriptionTypeDef", {"LoadBalancerName": str, "Tags": List[TagTypeDef]}, total=False
)

DescribeTagsOutputTypeDef = TypedDict(
    "DescribeTagsOutputTypeDef", {"TagDescriptions": List[TagDescriptionTypeDef]}, total=False
)

DetachLoadBalancerFromSubnetsOutputTypeDef = TypedDict(
    "DetachLoadBalancerFromSubnetsOutputTypeDef", {"Subnets": List[str]}, total=False
)

ModifyLoadBalancerAttributesOutputTypeDef = TypedDict(
    "ModifyLoadBalancerAttributesOutputTypeDef",
    {"LoadBalancerName": str, "LoadBalancerAttributes": LoadBalancerAttributesTypeDef},
    total=False,
)

PaginatorConfigTypeDef = TypedDict(
    "PaginatorConfigTypeDef", {"MaxItems": int, "PageSize": int, "StartingToken": str}, total=False
)

PolicyAttributeTypeDef = TypedDict(
    "PolicyAttributeTypeDef", {"AttributeName": str, "AttributeValue": str}, total=False
)

RegisterEndPointsOutputTypeDef = TypedDict(
    "RegisterEndPointsOutputTypeDef", {"Instances": List[InstanceTypeDef]}, total=False
)

RemoveAvailabilityZonesOutputTypeDef = TypedDict(
    "RemoveAvailabilityZonesOutputTypeDef", {"AvailabilityZones": List[str]}, total=False
)

TagKeyOnlyTypeDef = TypedDict("TagKeyOnlyTypeDef", {"Key": str}, total=False)

WaiterConfigTypeDef = TypedDict(
    "WaiterConfigTypeDef", {"Delay": int, "MaxAttempts": int}, total=False
)
