"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateAssetBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certificatemanager = require("aws-cdk-lib/aws-certificatemanager");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
const iam = require("aws-cdk-lib/aws-iam");
const route53 = require("aws-cdk-lib/aws-route53");
const route53Targets = require("aws-cdk-lib/aws-route53-targets");
const s3 = require("aws-cdk-lib/aws-s3");
// eslint-disable-next-line import/no-extraneous-dependencies
const cdk_dia_1 = require("cdk-dia");
const constructs_1 = require("constructs");
const nodejs_edge_function_1 = require("./nodejs-edge-function");
let PrivateAssetBucket = class PrivateAssetBucket extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        let assetBucket;
        if (props.assetBucketNameImport) {
            assetBucket = s3.Bucket.fromBucketName(this, 'Resource', props.assetBucketNameImport);
        }
        else {
            assetBucket = new s3.Bucket(this, 'Resource', {
                bucketName: props.assetBucketName,
            });
        }
        this.assetBucketName = assetBucket.bucketName;
        const assetAccessFunction = new nodejs_edge_function_1.NodejsEdgeFunction(this, 'edge');
        assetAccessFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogGroup',
                'logs:CreateLogStream',
                'logs:PutLogEvents',
            ],
            resources: ['arn:aws:logs:*:*:*'],
        }));
        const assetBucketDomainName = (_b = props.customDomain) === null || _b === void 0 ? void 0 : _b.domainName;
        const assetBucketCert = props.customDomain ? new certificatemanager.DnsValidatedCertificate(this, 'assetBucketCert', {
            domainName: assetBucketDomainName !== null && assetBucketDomainName !== void 0 ? assetBucketDomainName : '',
            hostedZone: props.customDomain.zone,
            region: 'us-east-1',
        }) : undefined;
        const assetCloudfront = new cloudfront.Distribution(this, 'assetCloudfront', {
            certificate: assetBucketCert,
            domainNames: assetBucketDomainName ? [assetBucketDomainName] : undefined,
            defaultBehavior: {
                originRequestPolicy: new cloudfront.OriginRequestPolicy(this, 'originRequestPolicy', {
                    cookieBehavior: cloudfront.OriginRequestCookieBehavior.all(),
                }),
                origin: new origins.S3Origin(assetBucket, {
                    customHeaders: {
                        // Need to ingest the userpool infor through headers as enviornment variables aren't supported for Lambda@Edge
                        'x-env-userpoolid': props.userPoolId,
                        'x-env-clientid': props.userPoolClientId,
                        'x-env-tokenuse': props.tokenUse || 'null',
                    },
                }),
                edgeLambdas: [
                    {
                        functionVersion: assetAccessFunction.currentVersion,
                        eventType: cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
                    },
                ],
            },
        });
        this.assetBucketCloudfrontUrl = assetCloudfront.distributionDomainName;
        const assetBucketRecord = props.customDomain ? new route53.ARecord(this, 'assetBucketRecord', {
            recordName: props.customDomain.domainName.split('.')[0],
            target: route53.RecordTarget.fromAlias(new route53Targets.CloudFrontTarget(assetCloudfront)),
            zone: props.customDomain.zone,
        }) : undefined;
        this.assetBucketRecordDomainName = assetBucketRecord === null || assetBucketRecord === void 0 ? void 0 : assetBucketRecord.domainName;
    }
};
_a = JSII_RTTI_SYMBOL_1;
PrivateAssetBucket[_a] = { fqn: "cdk-private-asset-bucket.PrivateAssetBucket", version: "2.22.0" };
PrivateAssetBucket = __decorate([
    cdk_dia_1.DiagramOptions({ collapse: cdk_dia_1.CollapseTypes.FORCE_NON_COLLAPSE })
], PrivateAssetBucket);
exports.PrivateAssetBucket = PrivateAssetBucket;
//# sourceMappingURL=data:application/json;base64,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